/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jan 23 01:38:50 EST 1994 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#define MISC

#ifdef MISC

#define MISC_C

#include "wafe.h"
#include <time.h>
#define ref(a) &(a)

/* 
 * ******* begin required file <misc.inc> *******
 */
/* das ist ein -*- C -*- Programm */

/* this definition is from tclInt.h 
 * the first FOUR entries match EXACT the Interp struct from 
 * tclInt.h; we can't include tclInt.h, since it conflicts with
 * Xt' Arg structure.
 */
typedef struct Interp {
    /*
     * Note:  the first three fields must match exactly the fields in
     * a Tcl_Interp struct (see tcl.h).  If you change one, be sure to
     * change the other.
     */

    char *result;               /* Points to result returned by last
                                 * command. */
    Tcl_FreeProc *freeProc;     /* Zero means result is statically allocated.
                                 * If non-zero, gives address of procedure
                                 * to invoke to free the result.  Must be
                                 * freed by Tcl_Eval before executing next
                                 * command. */
    int errorLine;              /* When TCL_ERROR is returned, this gives
                                 * the line number within the command where
                                 * the error occurred (1 means first line). */
    Tcl_HashTable commandTable; /* Contains all of the commands currently
                                 * registered in this interpreter.  Indexed
                                 * by strings; values have type (Command *). */
    } Interp;

int
alias(newCmd,oldCmd)
char *newCmd;
char *oldCmd;
    {
    XtPointer cmdPtr;
    Interp *iPtr = (Interp *) wafeInterpreter;
    Tcl_HashEntry *hPtr;
    int new;    

    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, newCmd)) != NULL)
	{
	fprintf(stderr,
		"Wafe(alias): can't alias to '%s': command already exists\n",
		newCmd);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias to \"", newCmd,
                "\": command already exists", (char *) NULL); */
        return 0;
	}
    
    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, oldCmd)) == NULL)
	{
	fprintf(stderr,
		"Wafe(alias): can't alias '%s': command doesn't exist\n",
		oldCmd);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias \"", oldCmd,
                "\":  command doesn't exist", (char *) NULL); */
        return 0;
	}

    cmdPtr = (XtPointer) Tcl_GetHashValue(hPtr);
    hPtr = Tcl_CreateHashEntry(&iPtr->commandTable, newCmd, &new);
    Tcl_SetHashValue(hPtr, cmdPtr);
    return 1;
}

/* 
 * ******* end required file <misc.inc> *******
 */
/* 
 * String
 * ctime
 * 	in: ref(time_t)			# clock value
 */

int 
com_ctime(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     time_t localVar1;
     String returnVar;

     DBUG_ENTER("ctime");  

     if (argc != 2) 
	 {
	 argcError("ctime","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%ld", &localVar1)))
          {
          convError("ctime","1",argv[1],"time_t");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = ctime(ref(localVar1));

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define echo(x) {write(wafeToClient,x,strlen(x)); if (count+1 != argc) write(wafeToClient," ",1);}

/* 
 * void
 * echo
 * 	callmultiple
 * 	in: String			# strings 
 * 	post: write(wafeToClient, "\n",1);
 */

int 
com_echo(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;
     int count;

     DBUG_ENTER("echo");  

     if (argc < 2) 
	 {
	 argcError("echo","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
          {
         localVar1 = argv[count];
         echo(localVar1);
          }
     write(wafeToClient, "\n",1);

     DBUG_RETURN (TCL_OK);
     }     


#define getChannel() wafeExtraClient

/* 
 * int
 * getChannel
 * 	const:				# None
 */

int 
com_getChannel(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getChannel");  

     if (argc != 1) 
	 {
	 argcError("getChannel","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     returnVar = getChannel();

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <signal.h>

/* 
 * void 
 * kill vulgo quit 
 * 	const: wafeClientPid	
 * 	const: SIGTERM
 * 	pre: if (wafeClientPid)		# None
 * 	post: exit(0);
 */

int 
com_quit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("quit");  

     if (argc != 1) 
	 {
	 argcError("quit","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (wafeClientPid)
     kill(wafeClientPid,SIGTERM);
     exit(0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * kill
 *     pre: localVar2 -= HANDLERMAX;
 *     in: int                      		# process id
 *     in: (int) signalType	         	# signalType
 */

int 
com_kill(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     int localVar2;

     DBUG_ENTER("kill");  

     if (argc != 3) 
	 {
	 argcError("kill","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%d", &localVar1)))
          {
          convError("kill","1",argv[1],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "term")) 
         localVar2 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[2], "quit")) 
         localVar2 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[2], "int")) 
         localVar2 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[2], "hup")) 
         localVar2 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[2], "pipe")) 
         localVar2 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[2], "usr1")) 
         localVar2 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[2], "usr2")) 
         localVar2 = HANDLERMAX+SIGUSR2;
     else
         {
         convError("kill","2",argv[2],"signalType");
         DBUG_RETURN (TCL_ERROR);
        }


     localVar2 -= HANDLERMAX;
     kill(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * doregister vulgo register
 * 	in: (int)handlerType	# stdin | stdout | stderr | xioerr | ..signal..
 * 	in: String		# tcl-command
 */

int 
com_register(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;

     DBUG_ENTER("register");  

     if (argc != 3) 
	 {
	 argcError("register","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "stdin")) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], "stdout")) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], "stderr")) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
     if (!strcmp(argv[1], "htmlVisited")) 
         localVar1 = HTMLVISITED;
     else
     if (!strcmp(argv[1], "term")) 
         localVar1 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[1], "quit")) 
         localVar1 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[1], "int")) 
         localVar1 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[1], "hup")) 
         localVar1 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[1], "pipe")) 
         localVar1 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[1], "usr1")) 
         localVar1 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[1], "usr2")) 
         localVar1 = HANDLERMAX+SIGUSR2;
     else
         {
         convError("register","1",argv[1],"handlerType");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign  << localVar2 = argv[2] >>  */ 

     doregister(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * setCommunicationVariable
 * 	in: XtNewString(String)		# variable name
 * 	in: int				# length
 * 	in: XtNewString(String)		# tcl command to be executed
 */

int 
com_setCommunicationVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar2;

     DBUG_ENTER("setCommunicationVariable");  

     if (argc != 4) 
	 {
	 argcError("setCommunicationVariable","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("setCommunicationVariable","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     setCommunicationVariable(XtNewString(argv[1]),localVar2,XtNewString(argv[3]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * unregister
 * 	in: (int)handlerType		# stdin | stdout | stderr | xioerr
 */

int 
com_unregister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;

     DBUG_ENTER("unregister");  

     if (argc != 2) 
	 {
	 argcError("unregister","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "stdin")) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], "stdout")) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], "stderr")) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
     if (!strcmp(argv[1], "htmlVisited")) 
         localVar1 = HTMLVISITED;
     else
     if (!strcmp(argv[1], "term")) 
         localVar1 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[1], "quit")) 
         localVar1 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[1], "int")) 
         localVar1 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[1], "hup")) 
         localVar1 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[1], "pipe")) 
         localVar1 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[1], "usr1")) 
         localVar1 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[1], "usr2")) 
         localVar1 = HANDLERMAX+SIGUSR2;
     else
         {
         convError("unregister","1",argv[1],"handlerType");
         DBUG_RETURN (TCL_ERROR);
        }


     unregister(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XtInputId
 * addInput 
 * 	in: int				# fileno
 * 	in: (XtPointer)SourceInputMask	# read | write | except | none
 * 	in: String    			# TclVariable 
 * 	in: String 			# TclCommand
 */

int 
com_addInput(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     XtPointer localVar2;
     XtInputId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("addInput");  

     if (argc != 5) 
	 {
	 argcError("addInput","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%d", &localVar1)))
          {
          convError("addInput","1",argv[1],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "read")) 
         localVar2 = (XtPointer)XtInputReadMask;
     else
     if (!strcmp(argv[2], "write")) 
         localVar2 = (XtPointer)XtInputWriteMask;
     else
     if (!strcmp(argv[2], "except")) 
         localVar2 = (XtPointer)XtInputExceptMask;
     else
     if (!strcmp(argv[2], "none")) 
         localVar2 = (XtPointer)XtInputNoneMask;
     else
         {
         convError("addInput","2",argv[2],"SourceInputMask");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign  << localVar3 = argv[3] >>  */ 

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     returnVar = addInput(localVar1,localVar2,argv[3],argv[4]);

     sprintf(conversionBuffer, "%lu", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * removeInput
 * 	in: XtInputId			# input id
 */

int 
com_removeInput(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtInputId localVar1;

     DBUG_ENTER("removeInput");  

     if (argc != 2) 
	 {
	 argcError("removeInput","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
          {
          convError("removeInput","1",argv[1],"XtInputId");
          DBUG_RETURN (TCL_ERROR);
          }

     removeInput(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#define fileNo(s,w) ((Tcl_GetOpenFile(wafeInterpreter, (s), w, 1, &f) != TCL_OK) ? -1 : fileno(f))

/* 
 * int
 * fileNo vulgo fileno
 * 	pre: { FILE* f;
 * 	in: String			# string identifying file
 * 	in: (int)FileNoReadWrite 	# read | write
 * 	post: }
 */

int 
com_fileno(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("fileno");  

     if (argc != 3) 
	 {
	 argcError("fileno","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!strcmp(argv[2], "read")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "write")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "r")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "w")) 
         localVar2 = 1;
     else
         {
         convError("fileno","2",argv[2],"FileNoReadWrite");
         DBUG_RETURN (TCL_ERROR);
        }


     { FILE* f;
     returnVar = fileNo(argv[1],localVar2);
     }

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int 
 * alias
 * 	in: String			# new command
 * 	in: String			# old command
 */

int 
com_alias(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("alias");  

     if (argc != 3) 
	 {
	 argcError("alias","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = alias(argv[1],argv[2]);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_MiscGen()
{
#ifdef MISC
 Tcl_CreateCommand(wafeInterpreter, "ctime", com_ctime, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "echo", com_echo, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "getChannel", com_getChannel, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "quit", com_quit, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "kill", com_kill, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "register", com_register, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "setCommunicationVariable", com_setCommunicationVariable, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "unregister", com_unregister, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "addInput", com_addInput, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "removeInput", com_removeInput, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "fileno", com_fileno, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "alias", com_alias, NULL, NULL);

#else
#endif
}
