#!/usr/local/bin/tclsh
#
# This file was generated mechanically from the `wafe'
# specification files.
#
# The generating program `spec.tcl' was written by W. Heidrich.
#

preProc {#define XT}



package {XT}

handle {XPM} {LAYOUT}

preProc {#include "wafe.h"}
preProc {#include <X11/Shell.h>}
preProc {#include <X11/Xatom.h>}


require Xt.inc\
	{converter { XtRString XtRWidget None CvtStringToWidget None}}\
	{converter { XtRString XtRCallback None CvtStringToCallback None}}\
	{converter { XtRString XtRPointer None CvtStringToPointer None}}\
	{converter { XtRString XtRWidgetList None CvtStringToWidgetList None}}\
	{initCode {#ifndef PRER5;}}\
	{converter { XtRString XtRCardinal None XtCvtStringToInt None}}\
	{initCode {#endif;}}

command {void} {addTimeOut}\
	{in {{unsigned long}}}\
	{in {{String}}}\
	{cmdCode {XtAppAddTimeOut(appContext, localVar1, timerProc, XtNewString(localVar2));}}

command {void} {action}\
	{in {{Widget}}}\
	{in {{int}} {TranslationModifier}}\
	{in {{XtTranslations}}}\
	{cmdCode {action(localVar1, localVar2, localVar3);}}

widgetClass {applicationShell}\
	{createCommand {XtAppCreateShell}}

command {void} {XBell}\
	{in {{Widget}}}\
	{in {{int}}}\
	{cmdCode {XBell(XtDisplay(localVar1), localVar2);}}

command {void} {callActionProc}\
	{in {{Widget}}}\
	{in {{String}}}\
	{in {{String}}}\
	{varArg optional}\
	{cmdCode {callActionProc(localVar1, localVar2, localVar3, varArgc, varArgv);}}

command {void} {callCallbacks}\
	{in {{Widget}}}\
	{in {{String}}}\
	{varArg optional}\
	{cmdCode {callCallbacks(localVar1, localVar2, varArgc, varArgv);}}

externalVar {positionCallbackProc();}
externalVar {positionCursorCallbackProc();}


command {void} {callback}\
	{in {{Widget}}}\
	{in {{String}}}\
	{in {{XtCallbackProc}}}\
	{in {{String}}}\
	{cmdCode {callback(localVar1, localVar2, localVar3, XtNewString(localVar4));}}

command {void} {XtDestroyWidget}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtDestroyWidget(MMfreeGarbage(localVar1));}}

preProc {#include <X11/IntrinsicP.h>}
preProc {#define getClass(widget) (XtClass(widget)->core_class.class_name)}


command {String} {getClass}\
	{in {{Widget}}}\
	{cmdCode {returnVar= getClass(localVar1);}}

command {int} {getResourceList}\
	{in {{Widget}}}\
	{out {String *}}\
	{cmdCode {returnVar= getResourceList(localVar1, &localVar2);}}\
	{cleanUp {XtFree((String)localVar2);}}

command {XrmQuark} {getTypeOfAttribute}\
	{in {{Widget}}}\
	{in {{String}}}\
	{cmdCode {returnVar= getQTypeOfAttribute(XtClass(localVar1), ParentWidget(localVar1), XrmStringToQuark(localVar2));}}

command {String} {getValue}\
	{in {{Widget}}}\
	{in {{XrmQuark}}}\
	{freeProc {freeProc}}\
	{cmdCode {returnVar= getValue(localVar1, localVar2, &localVar3);}}

command {{int} {GrabReturns}} {XtGrabPointer}\
	{in {{Widget}}}\
	{in {{Boolean}}}\
	{in {{int}} {SyncAsync}}\
	{in {{int}} {SyncAsync}}\
	{in {{Widget} None}}\
	{cmdCode {returnVar= XtGrabPointer(localVar1, localVar2, NoEventMask, localVar3, localVar4, XtWindow(localVar5), None, CurrentTime);}}

command {{int} {GrabReturns}} {XtGrabKeyboard}\
	{in {{Widget}}}\
	{in {{Boolean}}}\
	{in {{int}} {SyncAsync}}\
	{in {{int}} {SyncAsync}}\
	{cmdCode {returnVar= XtGrabKeyboard(localVar1, localVar2, localVar3, localVar4, CurrentTime);}}

preProc {#define installAccelerators(destination,source,table) \{ XtVaSetValues(source, XtNaccelerators, table, NULL); XtInstallAccelerators(destination, source);\}}


command {void} {installAccelerators}\
	{in {{Widget}}}\
	{in {{Widget}}}\
	{in {{XtAccelerators}}}\
	{cmdCode {installAccelerators(localVar1, localVar2, localVar3);}}

command {void} {XtManageChild}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtManageChild(localVar1);}}

command {void} {XtMapWidget}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtMapWidget(localVar1);}}

preProc {#define mergeResources(localVar1,argc,argv) \{ XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2) XrmPutStringResource(&newDb, v[i], v[i+1]); XrmMergeDatabases(newDb, &dispDb);\}}


command {void} {mergeResources}\
	{in {{Widget}}}\
	{varArg string}\
	{cmdCode {mergeResources(localVar1, varArgc, varArgv);}}

widgetClass {overrideShell}\
	{createCommand {XtCreatePopupShell}}\
	{callback  {}\
		{ createsShell}\
		{createsShell}}

command {void} {XtPopdown}\
	{in {{ShellWidget}}}\
	{cmdCode {XtPopdown(localVar1);}}

command {void} {XtPopup}\
	{in {{ShellWidget}}}\
	{in {{XtGrabKind}}}\
	{cmdCode {XtPopup(localVar1, localVar2);}}

command {void} {XtPopupSpringLoaded}\
	{in {{ShellWidget}}}\
	{cmdCode {XtPopupSpringLoaded(localVar1);}}

command {void} {realize}\
	{cmdCode {realizeWidgets();}}

command {void} {XtRemoveAllCallbacks}\
	{in {{Widget}}}\
	{in {{String}}}\
	{cmdCode {XtRemoveAllCallbacks(localVar1, localVar2);}}

command {void} {XtSetKeyboardFocus}\
	{in {{Widget}}}\
	{in {{Widget} None}}\
	{cmdCode {XtSetKeyboardFocus(localVar1, localVar2);}}

preProc {#define setValues(w,argc,argv) \{ ArgList           args; int               numArgs; if (convert(ParentWidget(w), XtClass(w), argv, &argc, &args, &numArgs, w)) { XtSetValues(w, args, numArgs); currentAttribList = NULL; XtFree((String)args); \} }}


command {void} {setValues}\
	{in {{Widget}}}\
	{varArg string}\
	{cmdCode {setValues(localVar1, varArgc, varArgv);}}

preProc {#define ptr(w) &(w)}


command {Boolean} {XSetWMProtocols}\
	{in {{ShellWidget}}}\
	{in {{Atom}} {WM_PROTOCOLS}}\
	{cmdCode {returnVar= XSetWMProtocols(XtDisplay(localVar1), XtWindow(localVar1), ptr(localVar2), 1);}}

widgetClass {topLevelShell}\
	{createCommand {XtCreatePopupShell}}\
	{callback  {}\
		{ createsShell}\
		{createsShell}}

widgetClass {transientShell}\
	{createCommand {XtCreatePopupShell}}\
	{callback  {}\
		{ createsShell}\
		{createsShell}}

command {void} {XtTranslateCoords}\
	{in {{Widget}}}\
	{in {{Position}}}\
	{in {{Position}}}\
	{out {Position}}\
	{out {Position}}\
	{cmdCode {XtTranslateCoords(localVar1, localVar2, localVar3, &localVar4, &localVar5);}}

command {void} {XtUngrabPointer}\
	{in {{Widget}}}\
	{cmdCode {XtUngrabPointer(localVar1, CurrentTime);}}

command {void} {XtUngrabKeyboard}\
	{in {{Widget}}}\
	{cmdCode {XtUngrabKeyboard(localVar1, CurrentTime);}}

command {void} {XtUnmanageChild}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtUnmanageChild(localVar1);}}

command {void} {XtUnmapWidget}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtUnmapWidget(localVar1);}}

command {void} {XtUnrealizeWidget}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtUnrealizeWidget(localVar1);}}

command {void} {XtRealizeWidget}\
	{multiple}\
	{in {{Widget}}}\
	{cmdCode {XtRealizeWidget(localVar1);}}


#####  selection handling #####



command {void} {XtDisownSelection}\
	{cmdCode {XtDisownSelection(topLevel, XA_PRIMARY, CurrentTime);}}

externalVar {void getSelectionValueProc();}


command {void} {XtGetSelectionValue}\
	{in {{String}}}\
	{cmdCode {XtGetSelectionValue(topLevel, XA_PRIMARY, XA_STRING, getSelectionValueProc, XtNewString(localVar1), CurrentTime);}}

command {Boolean} {ownSelection}\
	{in {{String}}}\
	{in {{String} NULL}}\
	{in {{String} NULL}}\
	{cmdCode {returnVar= ownSelection(XtNewString(localVar1), localVar2, localVar3);}}


# get the PRIMARY selection, put it into Cut Buffer 0 and fetch it ...



command {String} {XFetchBytes}\
	{in {{Widget}}}\
	{cmdCode {\{ int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime); returnVar= XFetchBytes(XtDisplay(localVar1), &bytes); \}}}\
	{cleanUp {XtFree(returnVar);}}

command {void} {XConvertSelection}\
	{in {{Widget}}}\
	{in {{Atom}}}\
	{cmdCode {XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, localVar2, DefaultRootWindow(XtDisplay(topLevel)), CurrentTime);}}

command {void} {XStoreBuffer}\
	{in {{Widget}}}\
	{in {{String}}}\
	{in {{int}}}\
	{cmdCode {XStoreBuffer(XtDisplay(localVar1), localVar2, strlen(argv[2]), localVar3);}}

command {String} {XFetchBuffer}\
	{in {{Widget}}}\
	{in {{int}}}\
	{cmdCode {\{int nbytes; returnVar= XFetchBuffer(XtDisplay(localVar1), &nbytes, localVar2); \}}}\
	{cleanUp {XtFree(returnVar);}}

alias {sV setValues} {gV getValue}


#####  XPM related commands #####



need {XPM}
require xpm.inc\
	{initCode {xpmRegisterTypeConverter(XtRBitmap, False);;}}\
	{initCode {xpmRegisterTypeConverter(XtRPixmap, True);;}}

need {XPM}
command {void} {setIconPixmap}\
	{in {{ShellWidget}}}\
	{in {{String}}}\
	{cmdCode {setIconPixmap(localVar1, localVar2);}}

need {XPM}
command {void} {changePixmap}\
	{in {{Widget}}}\
	{in {{String}}}\
	{in {{String}}}\
	{cmdCode {changePixmap(localVar1, localVar2, localVar3);}}

command {{int }} {isWidget}\
	{in {{String}}}\
	{cmdCode {returnVar= (int)name2WidgetId(localVar1);}}

need {LAYOUT}
widgetClass {layout}\
	{include {"Layout.h"}}

command {Widget} {parent}\
	{in {{Widget}}}\
	{cmdCode {returnVar= ParentWidget(localVar1);}}

command {int} {WidthOfScreen}\
	{in {{Widget}}}\
	{cmdCode {returnVar= WidthOfScreen(XtScreen(localVar1));}}

command {int} {HeightOfScreen}\
	{in {{Widget}}}\
	{cmdCode {returnVar= HeightOfScreen(XtScreen(localVar1));}}

command {{char *}} {XtResolvePathname}\
	{in {{Widget}}}\
	{in {{String} NULL}}\
	{in {{String} NULL}}\
	{in {{String} NULL}}\
	{in {{String} NULL}}\
	{cmdCode {returnVar= XtResolvePathname(XtDisplay(localVar1), localVar2, localVar3, localVar4, localVar5, NULL, 0, NULL);}}

command {void} {XtSetSensitive}\
	{in {{Widget}}}\
	{in {{Boolean}}}\
	{cmdCode {XtSetSensitive(localVar1, localVar2);}}

command {void} {setBusy}\
	{in {{Widget}}}\
	{in {{Boolean}}}\
	{cmdCode {setBusy(localVar1, localVar2);}}

preProc {#define WAFEtextWidth(w,resource,string) XTextWidth(font, string, strlen(string))}


command {int} {textWidth}\
	{in {{Widget}}}\
	{in {{String}}}\
	{in {{String}}}\
	{cmdCode {\{XFontStruct  *font; XtVaGetValues(localVar1, argv[2], &font, NULL); returnVar= WAFEtextWidth(localVar1, localVar2, localVar3); \}}}

command {void} {wafeEval}\
	{in {{String}}}\
	{cmdCode {wafeEval(interpreter, localVar1, "wafeEval");}}

command {void} {XRaiseWindow}\
	{in {{Widget}}}\
	{cmdCode {XRaiseWindow(XtDisplay(localVar1), XtWindow(localVar1));}}

command {void} {XLowerWindow}\
	{in {{Widget}}}\
	{cmdCode {XLowerWindow(XtDisplay(localVar1), XtWindow(localVar1));}}

