/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Fri Dec  3 21:45:15 EST 1993 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef MOTIF11

#define MOTIF11_C

#include "wafe.h"
#include <Xm/Xm.h>
#include <X11/Shell.h>

/* 
 * ******* begin required file <motif.inc> *******
 */
/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50



XmStringCharSet    defaultCharSet;

/*
#define defaultCharSet XmSTRING_DEFAULT_CHARSET
*/

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}


/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmString          dummy;
    XmStringContext   strContext;
    char              *text;
    XmStringCharSet   tmpCharSet;
    XmStringDirection dummyDir;
    Boolean           dummySep;
    dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	exit(-1);
	}

    XmStringGetNextSegment(strContext, &text, &tmpCharSet, 
			   &dummyDir, &dummySep);

    defaultCharSet = XtNewString(tmpCharSet);

    XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(strContext);
    
/*
    fprintf(stderr, "Setting defaultCharSet to %s default <%s> (XmSTRING_DEFAULT_CHARSET)\n", 
	    defaultCharSet, XmSTRING_DEFAULT_CHARSET);
*/
    /* xpmRegisterTypeConverter(XmCPixmap, True);*/
    xpmRegisterTypeConverter("XmBackgroundPixmap", True);
    }



/*
 * Utility function: Creates a new compound string segment, appends it 
 * to an existing XmString. Does NOT create a segement if the string is empty!
 */

XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;
    
    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString    
stringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET; 
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;
    
/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	    
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		fprintf(stderr, 
		    "Wafe(XmString Conversion): Cannot handle trailing '^'\n");
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		    
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf, 
					      charSet, dir, False);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr) 
			    || (*ptr == '-') 
			    || (*ptr == '_')) 
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		    
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	    
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	    
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);
    return result;
    }


XmStringTable
stringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = stringToXmString(argv[i])))
	    {
	    convError("stringToXmStringTable","n",argv[i],"XmString");
	    return NULL;
	    }
    *t = NULL;

    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

char *
xmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet, 
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir, 
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    Boolean            sep;
    Boolean            fontChange;
    char               *returnString, *ptr;

    DBUG_ENTER("xmString2String");
    
    if (!XmStringInitContext(&strContext, compStr))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	return(NULL);
	}

    if (!buffer) 
	{
	ptr = returnString = XtMalloc(XmStringLength(compStr)+100); /* hack  for now */
/*	fprintf(stderr, "buffer new allocated %p, size=%d\n", 
		ptr,XmStringLength(compStr));
 */
	}
    else
	{
	fprintf(stderr, "using provided buffer %p\n", buffer);
	ptr = returnString = buffer;	
	}


    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	fontChange = strcmp(charSet, lastCharSet);

	/* This means: If there are no changes in charSet or direction, 
	 * just make a newline but don't do it, if this is the first segment 
	 */
	if (   (!fontChange)
	    && (dir == lastDir) 
	    && (returnString != ptr))
	    *ptr++ = '\n'; 

	if (fontChange 
#ifdef XmFONTLIST_DEFAULT_TAG
	    /* Motif 1.2 seems to want it that way ... */
	    && strcmp(charSet,XmFONTLIST_DEFAULT_TAG)
#endif
	    ) 
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir) 
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	    

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
/*
    fprintf(stderr,"xmString2String returns <%s> size=%d\n",
	    returnString,strlen(returnString));
*/
    DBUG_RETURN(returnString);
    }

void
exmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    char *p = xmString2String(NULL,compStr);
    estrcpy(buffer,p);
    XtFree(p);
    }


/*
char *
exmStringTable2String(buffer,count,strTable)
char          * buffer;
int           count;
XmStringTable strTable;
    {
    char *p = xmStringTable2String(count,strTable)
    estrcpy(buffer,p);
    XtFree(p);
    }
*/


char *
xmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char    **temp, **cPtr;
    XmString  *ptr = strTable;
    char      *result;
    int        i;

    DBUG_ENTER("xmStringTable2String");
    
    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--) 
	{
	*cPtr = xmString2String(NULL,*ptr);
	}

    result = Tcl_Merge(count, temp);
    
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);
  
    XtFree((char *)temp);
    DBUG_RETURN (result); 
    }

/*
 * Two converter function wrappers for the *2String functions, which are 
 * called by getValues
 */

Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringToString");
    result = xmString2String(NULL,(XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    DBUG_RETURN(True);
    }


Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = xmStringTable2String(0,(XmStringTable)(fromVal->addr));

    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


void
freeStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *) table);
    }	    
    


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv) 
	!= TCL_OK)
	{
	fprintf(stderr, "Wafe(XmStringTableConversion): %s\n", 
		wafeInterpreter->result);
	return False;
	}


    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++) 
	if ((*ptr = stringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					     "XmString");
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
    XtFree((char *)argv);

    if (toVal->addr) 
	{
	fprintf(stderr,"somebody else called CvtStringToXmStrings! size=%d\n",
		toVal->size);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

	
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
	      (char *)result, freeStringTable);

    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

/*    fprintf(stderr, "CvtStringToXmString: <%s> %p\n", 
	    fromVal->addr, toVal->addr);
 */

    if ((result = stringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	DBUG_RETURN(False);
	}
    
    if (toVal->addr) 
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}
    
    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;
    
    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
	      (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static long result;
    
    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1) 
	{
	Done(long, (long)&result);
	}
    else
	return False;
    }

/* 
 * ******* end required file <motif.inc> *******
 */
/* 
 * Boolean
 * XmProcessTraversal
 * 	in: Widget		# Widget for which to traverse hierarchie
 * 	in: (int) XmTravDir	# direction in which to traverse widget hierarchie
 */

int 
com_XmProcessTraversal(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmProcessTraversal");  

     if (argc != 3) 
	 {
	 argcError("XmProcessTraversal","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmProcessTraversal","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "TRAVERSE_CURRENT")) 
         localVar2 = XmTRAVERSE_CURRENT;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT")) 
         localVar2 = XmTRAVERSE_NEXT;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV")) 
         localVar2 = XmTRAVERSE_PREV;
     else
     if (!strcmp(argv[2], "TRAVERSE_HOME")) 
         localVar2 = XmTRAVERSE_HOME;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_NEXT_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_PREV_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_UP")) 
         localVar2 = XmTRAVERSE_UP;
     else
     if (!strcmp(argv[2], "TRAVERSE_DOWN")) 
         localVar2 = XmTRAVERSE_DOWN;
     else
     if (!strcmp(argv[2], "TRAVERSE_LEFT")) 
         localVar2 = XmTRAVERSE_LEFT;
     else
     if (!strcmp(argv[2], "TRAVERSE_RIGHT")) 
         localVar2 = XmTRAVERSE_RIGHT;
     else
         {
         convError("XmProcessTraversal","2",argv[2],"XmTravDir");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmProcessTraversal(localVar1,localVar2);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

int 
com_XmCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmCascadeButtonGadgetHighlight");  

     if (argc != 3) 
	 {
	 argcError("XmCascadeButtonGadgetHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          convError("XmCascadeButtonGadgetHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmCascadeButtonGadgetHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: XmCascadeButtonGadget   	# widget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

int 
com_XmCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmCascadeButtonHighlight");  

     if (argc != 3) 
	 {
	 argcError("XmCascadeButtonHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          convError("XmCascadeButtonHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmCascadeButtonHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Command.h>
/* 
 * void
 * XmCommandAppendValue
 * 	in: XmCommandWidget          	# command widget 
 * 	in: XmString         		# command string
 */

int 
com_XmCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmCommandAppendValue");  

     if (argc != 3) 
	 {
	 argcError("XmCommandAppendValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          convError("XmCommandAppendValue","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmCommandAppendValue","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmCommandError
 * 	in: XmCommandWidget           	# command widget 
 * 	in: XmString         		# error message
 */

int 
com_XmCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmCommandError");  

     if (argc != 3) 
	 {
	 argcError("XmCommandError","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          convError("XmCommandError","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmCommandError","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
/* 
 * Widget
 * XmFileSelectionBoxGetChild
 * 	in: XmFileSelectionBoxWidget		# file selection box widget
 * 	in: (unsigned char)XmChild 		# child reference
 */

int 
com_XmFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmFileSelectionBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("XmFileSelectionBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          convError("XmFileSelectionBoxGetChild","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("XmFileSelectionBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmFileSelectionBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: XmFileSelectionBoxWidget		# file selection box
 * 	in: XmString				# directory mask
 */

int 
com_XmFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmFileSelectionDoSearch");  

     if (argc != 3) 
	 {
	 argcError("XmFileSelectionDoSearch","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          convError("XmFileSelectionDoSearch","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmFileSelectionDoSearch","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmFileSelectionDoSearch(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
/* 
 * void
 * XmListAddItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

int 
com_XmListAddItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("XmListAddItem");  

     if (argc != 4) 
	 {
	 argcError("XmListAddItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListAddItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListAddItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListAddItem","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 * 	in: int			# position
 */

int 
com_XmListAddItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("XmListAddItems");  

     if (argc != 5) 
	 {
	 argcError("XmListAddItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListAddItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("XmListAddItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListAddItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("XmListAddItems","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItems(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItemUnselected
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

int 
com_XmListAddItemUnselected(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("XmListAddItemUnselected");  

     if (argc != 4) 
	 {
	 argcError("XmListAddItemUnselected","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListAddItemUnselected","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListAddItemUnselected","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListAddItemUnselected","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItemUnselected(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteAllItems
 * 	in: XmListWidget	# List Widget
 */

int 
com_XmListDeleteAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmListDeleteAllItems");  

     if (argc != 2) 
	 {
	 argcError("XmListDeleteAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeleteAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to delete
 */

int 
com_XmListDeleteItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListDeleteItem");  

     if (argc != 3) 
	 {
	 argcError("XmListDeleteItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeleteItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListDeleteItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 */

int 
com_XmListDeleteItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;

     DBUG_ENTER("XmListDeleteItems");  

     if (argc != 4) 
	 {
	 argcError("XmListDeleteItems","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeleteItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("XmListDeleteItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListDeleteItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItems(localVar1,localVar2,localVar3);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItemsPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# number of items
 * 	in: int			# position of first item to be deleted
 */

int 
com_XmListDeleteItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("XmListDeleteItemsPos");  

     if (argc != 4) 
	 {
	 argcError("XmListDeleteItemsPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeleteItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListDeleteItemsPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListDeleteItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItemsPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeletePos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

int 
com_XmListDeletePos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListDeletePos");  

     if (argc != 3) 
	 {
	 argcError("XmListDeletePos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeletePos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListDeletePos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeletePos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectAllItems
 * 	in: XmListWidget	# List Widget
 */

int 
com_XmListDeselectAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmListDeselectAllItems");  

     if (argc != 2) 
	 {
	 argcError("XmListDeselectAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeselectAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectItem
 * 	in: XmListWidget	# List Widget	
 * 	in: XmString		# item
 */

int 
com_XmListDeselectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListDeselectItem");  

     if (argc != 3) 
	 {
	 argcError("XmListDeselectItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeselectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListDeselectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

int 
com_XmListDeselectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListDeselectPos");  

     if (argc != 3) 
	 {
	 argcError("XmListDeselectPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListDeselectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListDeselectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean                          
 * XmListGetMatchPos
 * 	in: XmListWidget	# List Widget   
 * 	in: XmString		# item
 * 	out: list(int*,int)	# list of positions
 */

int 
com_XmListGetMatchPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int* localVar3list;
     int localVar3count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListGetMatchPos");  

     if (argc != 4) 
	 {
	 argcError("XmListGetMatchPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListGetMatchPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListGetMatchPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetMatchPos(localVar1,localVar2,&localVar3list, &localVar3count);
     XmStringFree(localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[3], intsToTcl(localVar3count,localVar3list), 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListGetSelectedPos
 * 	in: XmListWidget	# List Widget
 * 	out: list(int*,int)     # list of highlighted items
 */

int 
com_XmListGetSelectedPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int* localVar2list;
     int localVar2count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListGetSelectedPos");  

     if (argc != 3) 
	 {
	 argcError("XmListGetSelectedPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListGetSelectedPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetSelectedPos(localVar1,&localVar2list, &localVar2count);

     
     Tcl_SetVar(wafeInterpreter, argv[2], intsToTcl(localVar2count,localVar2list), 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListItemExists
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

int 
com_XmListItemExists(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListItemExists");  

     if (argc != 3) 
	 {
	 argcError("XmListItemExists","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListItemExists","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListItemExists","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemExists(localVar1,localVar2);
     XmStringFree(localVar2);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmListItemPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

int 
com_XmListItemPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmListItemPos");  

     if (argc != 3) 
	 {
	 argcError("XmListItemPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListItemPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListItemPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemPos(localVar1,localVar2);
     XmStringFree(localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# Items to be replaced
 * 	in: int			# number of items to be replaced
 * 	in: XmStringTable	# new items
 */

int 
com_XmListReplaceItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     XmStringTable localVar4;

     DBUG_ENTER("XmListReplaceItems");  

     if (argc != 5) 
	 {
	 argcError("XmListReplaceItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListReplaceItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("XmListReplaceItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListReplaceItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar4 = (XmStringTable) stringToXmStringTable(argv[4])))
          {
          convError("XmListReplaceItems","4",argv[4],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItems(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);
     freeStringTable(localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItemsPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# New items
 * 	in: int			# number of items to be replaced
 * 	in: int 		# first Pos of items to be replaced
 */

int 
com_XmListReplaceItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("XmListReplaceItemsPos");  

     if (argc != 5) 
	 {
	 argcError("XmListReplaceItemsPos","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListReplaceItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("XmListReplaceItemsPos","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmListReplaceItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("XmListReplaceItemsPos","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItemsPos(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# item to highlight
 * 	in: Boolean		# Invoke callback yes/no
 */

int 
com_XmListSelectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmListSelectItem");  

     if (argc != 4) 
	 {
	 argcError("XmListSelectItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSelectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListSelectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("XmListSelectItem","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectPos
 * 	in: XmListWidget	# List Widget
 * 	in: int			# Position of item 
 * 	in: Boolean		# Invoke callback yes/no
 */

int 
com_XmListSelectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmListSelectPos");  

     if (argc != 4) 
	 {
	 argcError("XmListSelectPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSelectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListSelectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("XmListSelectPos","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetAddMode
 * 	in: XmListWidget 	# List Widget
 * 	in: Boolean		# Use Add Mode yes/no
 */

int 
com_XmListSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmListSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("XmListSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetAddMode","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmListSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomItem	
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item to be displayed as last item
 */

int 
com_XmListSetBottomItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListSetBottomItem");  

     if (argc != 3) 
	 {
	 argcError("XmListSetBottomItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetBottomItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListSetBottomItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# item to be displayed as last item
 */

int 
com_XmListSetBottomPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetBottomPos");  

     if (argc != 3) 
	 {
	 argcError("XmListSetBottomPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetBottomPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListSetBottomPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetHorizPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# horizontal Position
 */

int 
com_XmListSetHorizPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetHorizPos");  

     if (argc != 3) 
	 {
	 argcError("XmListSetHorizPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetHorizPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListSetHorizPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetHorizPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetItem
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item
 */

int 
com_XmListSetItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("XmListSetItem");  

     if (argc != 3) 
	 {
	 argcError("XmListSetItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("XmListSetItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# Position
 */

int 
com_XmListSetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmListSetPos");  

     if (argc != 3) 
	 {
	 argcError("XmListSetPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("XmListSetPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmListSetPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MainW.h>
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

int 
com_XmMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER("XmMainWindowSetAreas");  

     if (argc != 7) 
	 {
	 argcError("XmMainWindowSetAreas","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "NULL")) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmMainWindowSetAreas","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("XmMainWindowSetAreas","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("XmMainWindowSetAreas","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
          {
          convError("XmMainWindowSetAreas","4",argv[4],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("XmMainWindowSetAreas","5",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "NULL")) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
          {
          convError("XmMainWindowSetAreas","6",argv[6],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
/* 
 * Widget
 * XmMessageBoxGetChild
 * 	in: XmMessageBoxWidget		# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

int 
com_XmMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmMessageBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("XmMessageBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmMessageBoxWidgetClass,"XmMessageBox")))
          {
          convError("XmMessageBoxGetChild","1",argv[1],"XmMessageBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("XmMessageBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmMessageBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
/* 
 * void
 * XmScrollBarGetValues 
 * 	in: XmScrollBarWidget		# scrollbar widget
 * 	out: int	      		# value (slider position)
 *         out: int              		# slider size
 * 	out: int              		# increment (smallest movement)
 * 	out: int              		# page increment
 */

int 
com_XmScrollBarGetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("XmScrollBarGetValues");  

     if (argc != 6) 
	 {
	 argcError("XmScrollBarGetValues","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          convError("XmScrollBarGetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmScrollBarGetValues(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar5);
     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmScrollBarSetValues 
 * 	in: XmScrollBarWidget 		# scrollbar widget
 * 	in: int	              		# value (slider position)
 *         in: int               		# slider size
 * 	in: int               		# increment (smallest movement)
 * 	in: int               		# page increment 
 * 	in: Boolean           		# notify
 */

int 
com_XmScrollBarSetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     Boolean localVar6;

     DBUG_ENTER("XmScrollBarSetValues");  

     if (argc != 7) 
	 {
	 argcError("XmScrollBarSetValues","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          convError("XmScrollBarSetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmScrollBarSetValues","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XmScrollBarSetValues","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("XmScrollBarSetValues","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("XmScrollBarSetValues","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
         {
         convError("XmScrollBarSetValues","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmScrollBarSetValues(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
/* 
 * void
 * XmTextClearSelection
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_XmTextClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextClearSelection");  

     if (argc != 2) 
	 {
	 argcError("XmTextClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextClearSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCopy
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_XmTextCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextCopy");  

     if (argc != 2) 
	 {
	 argcError("XmTextCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextCopy","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCut
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_XmTextCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextCut");  

     if (argc != 2) 
	 {
	 argcError("XmTextCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextCut","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/TextF.h>
/* 
 * void
 * XmTextFieldClearSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	const: time(NULL)
 */

int 
com_XmTextFieldClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldClearSelection");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldClearSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCopy
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

int 
com_XmTextFieldCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldCopy");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldCopy","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCut
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

int 
com_XmTextFieldCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldCut");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldCut","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextFieldGetBaseline
 * 	in: XmTextFieldWidget 		# Text field widget
 */

int 
com_XmTextFieldGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetBaseline");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldGetBaseline","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextFieldGetLastPosition
 * 	in: XmTextFieldWidget 		# Text field widget
 */

int 
com_XmTextFieldGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetLastPosition");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldGetLastPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextFieldGetSelection
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

int 
com_XmTextFieldGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XmTextFieldGetSelection");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldGetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldGetSelectionPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

int 
com_XmTextFieldGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldGetSelectionPosition");  

     if (argc != 4) 
	 {
	 argcError("XmTextFieldGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldGetSelectionPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldInsert
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

int 
com_XmTextFieldInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextFieldInsert");  

     if (argc != 4) 
	 {
	 argcError("XmTextFieldInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldInsert","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextFieldInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldPaste
 * 	in: XmTextFieldWidget 	# Text field widget
 */

int 
com_XmTextFieldPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextFieldPaste");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldPaste","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldPosToXY
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

int 
com_XmTextFieldPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldPosToXY");  

     if (argc != 5) 
	 {
	 argcError("XmTextFieldPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldPosToXY","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldRemove
 * 	in: XmTextFieldWidget 	# Text field widget
 */

int 
com_XmTextFieldRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextFieldRemove");  

     if (argc != 2) 
	 {
	 argcError("XmTextFieldRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldRemove","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldRemove(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldReplace
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

int 
com_XmTextFieldReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextFieldReplace");  

     if (argc != 5) 
	 {
	 argcError("XmTextFieldReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldReplace","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextFieldReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextFieldReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetAddMode
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Boolean		# true | false
 */

int 
com_XmTextFieldSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmTextFieldSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("XmTextFieldSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldSetAddMode","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmTextFieldSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetHighlight
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

int 
com_XmTextFieldSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("XmTextFieldSetHighlight");  

     if (argc != 5) 
	 {
	 argcError("XmTextFieldSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldSetHighlight","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextFieldSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         convError("XmTextFieldSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

int 
com_XmTextFieldSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextFieldSetSelection");  

     if (argc != 4) 
	 {
	 argcError("XmTextFieldSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldSetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextFieldSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldShowPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position to display
 */

int 
com_XmTextFieldShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextFieldShowPosition");  

     if (argc != 3) 
	 {
	 argcError("XmTextFieldShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldShowPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextFieldShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldXYToPos
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

int 
com_XmTextFieldXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("XmTextFieldXYToPos");  

     if (argc != 4) 
	 {
	 argcError("XmTextFieldXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("XmTextFieldXYToPos","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("XmTextFieldXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("XmTextFieldXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextGetBaseline
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_XmTextGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetBaseline");  

     if (argc != 2) 
	 {
	 argcError("XmTextGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextGetBaseline","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextGetLastPosition
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_XmTextGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetLastPosition");  

     if (argc != 2) 
	 {
	 argcError("XmTextGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextGetLastPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextGetSelection
 * 	in: XmTextWidget 	# Text widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

int 
com_XmTextGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XmTextGetSelection");  

     if (argc != 2) 
	 {
	 argcError("XmTextGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextGetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextGetSelectionPosition
 * 	in: XmTextWidget 	# Text widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

int 
com_XmTextGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextGetSelectionPosition");  

     if (argc != 4) 
	 {
	 argcError("XmTextGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextGetSelectionPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextInsert
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

int 
com_XmTextInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextInsert");  

     if (argc != 4) 
	 {
	 argcError("XmTextInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextInsert","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextPaste
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_XmTextPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmTextPaste");  

     if (argc != 2) 
	 {
	 argcError("XmTextPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextPaste","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextPosToXY
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

int 
com_XmTextPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextPosToXY");  

     if (argc != 5) 
	 {
	 argcError("XmTextPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextPosToXY","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextRemove
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_XmTextRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmTextRemove");  

     if (argc != 2) 
	 {
	 argcError("XmTextRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextRemove","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextRemove(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextReplace
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

int 
com_XmTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextReplace");  

     if (argc != 5) 
	 {
	 argcError("XmTextReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextReplace","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextScroll
 * 	in: XmTextWidget 	# Text widget
 * 	in: int			# number of lines to scroll
 */

int 
com_XmTextScroll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XmTextScroll");  

     if (argc != 3) 
	 {
	 argcError("XmTextScroll","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextScroll","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XmTextScroll","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextScroll(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetAddMode
 * 	in: XmTextWidget 	# Text widget
 * 	in: Boolean		# true | false
 */

int 
com_XmTextSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XmTextSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("XmTextSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextSetAddMode","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmTextSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetHighlight
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

int 
com_XmTextSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("XmTextSetHighlight");  

     if (argc != 5) 
	 {
	 argcError("XmTextSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextSetHighlight","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         convError("XmTextSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetSelection
 * 	in: XmTextWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

int 
com_XmTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("XmTextSetSelection");  

     if (argc != 4) 
	 {
	 argcError("XmTextSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextSetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XmTextSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextShowPosition
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position to display
 */

int 
com_XmTextShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("XmTextShowPosition");  

     if (argc != 3) 
	 {
	 argcError("XmTextShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextShowPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XmTextShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextXYToPos
 * 	in: XmTextWidget 	# Text widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

int 
com_XmTextXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("XmTextXYToPos");  

     if (argc != 4) 
	 {
	 argcError("XmTextXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("XmTextXYToPos","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("XmTextXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("XmTextXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleB.h>
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 */

int 
com_XmToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmToggleButtonGetState");  

     if (argc != 2) 
	 {
	 argcError("XmToggleButtonGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          convError("XmToggleButtonGetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonSetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

int 
com_XmToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmToggleButtonSetState");  

     if (argc != 4) 
	 {
	 argcError("XmToggleButtonSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          convError("XmToggleButtonSetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmToggleButtonSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("XmToggleButtonSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleBG.h>
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: XmToggleButtonGadget	# toggle button widget
 */

int 
com_XmToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XmToggleButtonGadgetGetState");  

     if (argc != 2) 
	 {
	 argcError("XmToggleButtonGadgetGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          convError("XmToggleButtonGadgetGetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGadgetGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

int 
com_XmToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("XmToggleButtonGadgetSetState");  

     if (argc != 4) 
	 {
	 argcError("XmToggleButtonGadgetSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          convError("XmToggleButtonGadgetSetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XmToggleButtonGadgetSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("XmToggleButtonGadgetSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmAddTabGroup
 * 	in: Widget        		# widget to be added
 */

int 
com_XmAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XmAddTabGroup");  

     if (argc != 2) 
	 {
	 argcError("XmAddTabGroup","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("XmAddTabGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XmGen()
{
#ifdef MOTIF11
 createWidgetCommand("XmArrowButton",xmArrowButtonWidgetClass,NULL,False);
 createWidgetCommand("XmArrowButtonGadget",xmArrowButtonGadgetClass,NULL,False);
 createWidgetCommand("XmBulletinBoard",xmBulletinBoardWidgetClass,NULL,False);
 createWidgetCommand("XmBulletinBoardDialog",xmBulletinBoardWidgetClass,XmCreateBulletinBoardDialog,True);
 createWidgetCommand("XmCascadeButton",xmCascadeButtonWidgetClass,NULL,False);
 createWidgetCommand("XmCascadeButtonGadget",xmCascadeButtonGadgetClass,NULL,False);
 createWidgetCommand("XmCommand",xmCommandWidgetClass,NULL,False);
 createWidgetCommand("XmDialogShell",xmDialogShellWidgetClass,NULL,True);
 createWidgetCommand("XmDrawingArea",xmDrawingAreaWidgetClass,NULL,False);
 createWidgetCommand("XmDrawnButton",xmDrawnButtonWidgetClass,NULL,False);
 createWidgetCommand("XmFileSelectionBox",xmFileSelectionBoxWidgetClass,NULL,False);
 createWidgetCommand("XmFileSelectionDialog",xmFileSelectionBoxWidgetClass,XmCreateFileSelectionDialog,True);
 createWidgetCommand("XmForm",xmFormWidgetClass,NULL,False);
 createWidgetCommand("XmFormDialog",xmFormWidgetClass,XmCreateFormDialog,True);
 createWidgetCommand("XmFrame",xmFrameWidgetClass,NULL,False);
 createWidgetCommand("XmInformationDialog",xmMessageBoxWidgetClass,XmCreateInformationDialog,True);
 createWidgetCommand("XmLabel",xmLabelWidgetClass,NULL,False);
 createWidgetCommand("XmLabelGadget",xmLabelGadgetClass,NULL,False);
 createWidgetCommand("XmList",xmListWidgetClass,NULL,False);
 createWidgetCommand("XmMainWindow",xmMainWindowWidgetClass,NULL,False);
 createWidgetCommand("XmMenuBar",xmRowColumnWidgetClass,XmCreateMenuBar,False);
 createWidgetCommand("XmMenuShell",xmMenuShellWidgetClass,NULL,True);
 createWidgetCommand("XmMessageBox",xmMessageBoxWidgetClass,NULL,False);
 createWidgetCommand("XmMessageDialog",xmMessageBoxWidgetClass,XmCreateMessageDialog,True);
 createWidgetCommand("XmOptionMenu",xmRowColumnWidgetClass,XmCreateOptionMenu,False);
 createWidgetCommand("XmPanedWindow",xmPanedWindowWidgetClass,NULL,False);
 createWidgetCommand("XmPopupMenu",xmRowColumnWidgetClass,XmCreatePopupMenu,False);
 createWidgetCommand("XmPromptDialog",xmSelectionBoxWidgetClass,XmCreatePromptDialog,True);
 createWidgetCommand("XmPulldownMenu",xmRowColumnWidgetClass,XmCreatePulldownMenu,False);
 createWidgetCommand("XmPushButton",xmPushButtonWidgetClass,NULL,False);
 createWidgetCommand("XmPushButtonGadget",xmPushButtonGadgetClass,NULL,False);
 createWidgetCommand("XmQuestionDialog",xmMessageBoxWidgetClass,XmCreateQuestionDialog,True);
 createWidgetCommand("XmRadioBox",xmRowColumnWidgetClass,XmCreateRadioBox,False);
 createWidgetCommand("XmRowColumn",xmRowColumnWidgetClass,NULL,False);
 createWidgetCommand("XmScale",xmScaleWidgetClass,NULL,False);
 createWidgetCommand("XmScrollBar",xmScrollBarWidgetClass,NULL,False);
 createWidgetCommand("XmScrolledList",xmListWidgetClass,XmCreateScrolledList,False);
 createWidgetCommand("XmScrolledText",xmTextWidgetClass,XmCreateScrolledText,False);
 createWidgetCommand("XmScrolledWindow",xmScrolledWindowWidgetClass,NULL,False);
 createWidgetCommand("XmSelectionBox",xmSelectionBoxWidgetClass,NULL,False);
 createWidgetCommand("XmSelectionDialog",xmSelectionBoxWidgetClass,XmCreateSelectionDialog,True);
 createWidgetCommand("XmSeparator",xmSeparatorWidgetClass,NULL,False);
 createWidgetCommand("XmSeparatorGadget",xmSeparatorGadgetClass,NULL,False);
 createWidgetCommand("XmSimpleCheckBox",xmRowColumnWidgetClass,XmCreateSimpleCheckBox,False);
 createWidgetCommand("XmSimpleMenuBar",xmRowColumnWidgetClass,XmCreateSimpleMenuBar,False);
 createWidgetCommand("XmSimpleOptionMenu",xmRowColumnWidgetClass,XmCreateSimpleOptionMenu,False);
 createWidgetCommand("XmSimplePopupMenu",xmRowColumnWidgetClass,XmCreateSimplePopupMenu,False);
 createWidgetCommand("XmSimplePulldownMenu",xmRowColumnWidgetClass,XmCreateSimplePulldownMenu,False);
 createWidgetCommand("XmSimpleRadioBox",xmRowColumnWidgetClass,XmCreateSimpleRadioBox,False);
 createWidgetCommand("XmText",xmTextWidgetClass,NULL,False);
 createWidgetCommand("XmTextField",xmTextFieldWidgetClass,NULL,False);
 createWidgetCommand("XmToggleButton",xmToggleButtonWidgetClass,NULL,False);
 createWidgetCommand("XmToggleButtonGadget",xmToggleButtonGadgetClass,NULL,False);
 createWidgetCommand("XmWarningDialog",xmMessageBoxWidgetClass,XmCreateWarningDialog,True);
 createWidgetCommand("XmWorkingDialog",xmMessageBoxWidgetClass,XmCreateWorkingDialog,True);
#ifdef MOTIF11
 strcat(wafePackages,"MOTIF11 ");
#endif
 XtSetTypeConverter(XtRString, "XmString",
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "XmStringTable",
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "Window",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "MenuWidget",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmString", XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmStringTable", XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "TextPosition",
	(XtTypeConverter)CvtStringToLong, 
	NULL, 0, XtCacheNone, NULL);
 wafeMotifInit();
 qXmString = WafePermStringToQuark("XmString");
 qXmStringTable = WafePermStringToQuark("XmStringTable");
 qWindow = WafePermStringToQuark("Window");
 qHorizontalDimension = WafePermStringToQuark("HorizontalDimension");
 qVerticalDimension = WafePermStringToQuark("VerticalDimension");
 qTextPosition = WafePermStringToQuark("TextPosition");
 qVerticalPosition = WafePermStringToQuark("VerticalPosition");
 qHorizontalPosition = WafePermStringToQuark("HorizontalPosition");
 qPrimForegroundPixmap = WafePermStringToQuark("PrimForegroundPixmap");
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);
 Tcl_CreateCommand(wafeInterpreter, "XmProcessTraversal", com_XmProcessTraversal, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonGadgetHighlight", com_XmCascadeButtonGadgetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonHighlight", com_XmCascadeButtonHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandAppendValue", com_XmCommandAppendValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandError", com_XmCommandError, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionBoxGetChild", com_XmFileSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionDoSearch", com_XmFileSelectionDoSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItem", com_XmListAddItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItems", com_XmListAddItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItemUnselected", com_XmListAddItemUnselected, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteAllItems", com_XmListDeleteAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItem", com_XmListDeleteItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItems", com_XmListDeleteItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItemsPos", com_XmListDeleteItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeletePos", com_XmListDeletePos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectAllItems", com_XmListDeselectAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectItem", com_XmListDeselectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectPos", com_XmListDeselectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetMatchPos", com_XmListGetMatchPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetSelectedPos", com_XmListGetSelectedPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemExists", com_XmListItemExists, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemPos", com_XmListItemPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItems", com_XmListReplaceItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItemsPos", com_XmListReplaceItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectItem", com_XmListSelectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectPos", com_XmListSelectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetAddMode", com_XmListSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomItem", com_XmListSetBottomItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomPos", com_XmListSetBottomPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetHorizPos", com_XmListSetHorizPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetItem", com_XmListSetItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetPos", com_XmListSetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMainWindowSetAreas", com_XmMainWindowSetAreas, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMessageBoxGetChild", com_XmMessageBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarGetValues", com_XmScrollBarGetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarSetValues", com_XmScrollBarSetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextClearSelection", com_XmTextClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCopy", com_XmTextCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCut", com_XmTextCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldClearSelection", com_XmTextFieldClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCopy", com_XmTextFieldCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCut", com_XmTextFieldCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetBaseline", com_XmTextFieldGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetLastPosition", com_XmTextFieldGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelection", com_XmTextFieldGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelectionPosition", com_XmTextFieldGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldInsert", com_XmTextFieldInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPaste", com_XmTextFieldPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPosToXY", com_XmTextFieldPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldRemove", com_XmTextFieldRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldReplace", com_XmTextFieldReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetAddMode", com_XmTextFieldSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetHighlight", com_XmTextFieldSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetSelection", com_XmTextFieldSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldShowPosition", com_XmTextFieldShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldXYToPos", com_XmTextFieldXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetBaseline", com_XmTextGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetLastPosition", com_XmTextGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelection", com_XmTextGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelectionPosition", com_XmTextGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextInsert", com_XmTextInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPaste", com_XmTextPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPosToXY", com_XmTextPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextRemove", com_XmTextRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextReplace", com_XmTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextScroll", com_XmTextScroll, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetAddMode", com_XmTextSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetHighlight", com_XmTextSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetSelection", com_XmTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextShowPosition", com_XmTextShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextXYToPos", com_XmTextXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGetState", com_XmToggleButtonGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonSetState", com_XmToggleButtonSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetGetState", com_XmToggleButtonGadgetGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetSetState", com_XmToggleButtonGadgetSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmAddTabGroup", com_XmAddTabGroup, NULL, NULL);

#else
#endif
}
