/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Thu Dec  2 21:58:47 EST 1993 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef ATHENA

#define ATHENA_C

#include "wafe.h"

/* 
 * ******* begin required file <athena.inc> *******
 */
/* treat me like a -*- c -*- program */

#define MAX_ITEM_LENGTH 200

/* KLUDGE KLUDGE KLUDGE for callbacks provided via resource mechanisms */
#define setQuark(resName,quark) \
    XtVaGetValues(new, (resName), &callbackList, NULL); \
    if (callbackList && \
	callbackList->callback == (XtCallbackProc)execCallbackProc) \
	*(XrmQuark *)callbackList->closure = (quark)

XrmQuark qcallback;
XrmQuark qjumpProc;
XrmQuark qscrollProc;



/****************************************************************************
 *    FUNCTION:  name2Sink, name2Source
 *                                                                          
 *    Arguments: string containing an instance's name
 *    Returns:   source/sink widget of named text widget
 *                                                                          
 *****************************************************************************/

static Widget 
name2Sink(string)
char * string;
    {
    Widget localVar1, sink = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	convError("name2Sink","1",string,"Widget");
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSink, &sink, NULL);
    return(sink);
    }

static Widget 
name2Source(string)
char * string;
    {
    Widget localVar1, source = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	convError("name2Source","1",string,"Widget");
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSource, &source, NULL);
    return(source);
    }




/************** list widget support routines ******/
#include <X11/Xaw/List.h>

static int
listChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      index, size=0;
    char   **list, **count, *offset;
    char     buffer [MAX_ITEM_LENGTH] ;         

    DBUG_ENTER("listChange");
    
    if (!strcmp(argv[0], "List"))
	{
	  if (argc != 2)
	      {
	      fprintf(stderr, "Wafe(listChange): Wrong # of Args");
	      DBUG_RETURN(TCL_ERROR);
	      }

	  if (Tcl_SplitList(wafeInterpreter,argv[1], &nitems, &list) != TCL_OK)
	      {
	      fprintf(stderr, "Wafe(listChange): %s\n", 
		      wafeInterpreter->result);
	      DBUG_RETURN(TCL_ERROR);
	      }
	  }
    else 
    if (!strcmp(argv[0], "Arg"))
	{
        for (index = 1; index < argc; index ++) 
	    {
	    size += strlen(argv[index])+1;
	    }
	
	list = count = (char **)XtMalloc((argc)*sizeof(char *)+size); 
	offset = (char *)list + (argc)*sizeof(char *);

	for (index = 1; index < argc; index++)
	    {
	    *count = offset;
	    strcpy(offset,argv[index]);
	    offset += strlen(argv[index])+1;
	    count++;
	    }

	*count = NULL;
	}
    else
    if (!strcmp(argv[0], "File"))
	{
	char **tmpList, **saveStart;

	if (argc != 2)
	    {
	    fprintf(stderr, "Wafe(listChange): Wrong # of Args");
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    fprintf(stderr, "Wafe(listChange): Couldn't open File %s",
		    argv[1]);
	    DBUG_RETURN(TCL_ERROR);
	    }

	saveStart = tmpList = count = (char **)XtMalloc(10*sizeof(char *));
	index = 0;

	while (fgets(buffer, 200, fp))
	    {
	    *count = XtNewString(buffer);
	    size += strlen(buffer)+1;
	    *(*count + strlen(buffer)-1) = '\0';
	    count++; index++;
	    if (!(index % 10))
		{
		DBUG_PRINT("list", ("Realloc"));
		saveStart = tmpList = (char**)XtRealloc((char *)tmpList,
						(index + 10)* sizeof(char *));
		count = tmpList + index;
		}
	    }
	*count = NULL;

	/* make it the list a single memory chunk to be 
         * compatible with the rest 
         */
	list = count = (char **)XtMalloc((index+1)*sizeof(char *)+size); 
	offset = (char *)list + (index+1)*sizeof(char *);

	while (*tmpList)
	    {
	    *count = offset;
	    strcpy(offset,*tmpList);
	    offset += strlen(*tmpList)+1;
	    XtFree(*tmpList);
	    tmpList++;
	    count++;
	    }
	*count = NULL;

        XtFree((char*)saveStart);
	}

    XawListChange(w, list, nitems, longest, resize);
    MMreplace(MMgetAttribList(w), qPointer, (char *)list,XtFree);

    DBUG_RETURN(TCL_OK);
    }

  
static void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("list", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("list", ("Copied: >%s<\n", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("list", ("Added: >%s<", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }


static Widget
listCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget new = XtCreateWidget(name, listWidgetClass, 
				father, args, numArgs);

    setQuark("callback",qcallback);

    return(new);
    }

/******************** strip chart specific code ***************/
#include <X11/Xaw/StripChart.h>

typedef struct _scInfo
     {
     double            value;
     Widget            widget;
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;

static scInfoPtr scBegin = NULL;

static void 
stripChartSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scBegin)         /* No Stripchart widgets exists yet*/
          {
          fprintf(stderr, "Wafe(scSet): No stripChart widget exists yet!\n");
          return;
          }

     for (countPtr = scBegin; 
          countPtr->widget != sCWidget && countPtr->next != NULL;
          countPtr = countPtr->next);

     if ((countPtr->next == NULL) && countPtr->widget != sCWidget)
          {
          fprintf(stderr, "Wafe(scSet): stripChart widget %s unknown\n", 
		  XtName(sCWidget));
          return;
          }

     DBUG_PRINT("sc",("Setting = %s to %f\n", 
		      XtName(countPtr->widget),value));

     countPtr->value = value;
     }


static void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;

     DBUG_ENTER("Query");

     for (countPtr = scBegin; countPtr->widget != w;
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = %s, value = %f", 
		      XtName(countPtr->widget), countPtr->value));
/*
      fprintf(stderr,"float = %f\n",countPtr->value);
 */
     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

static Widget
stripChartCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    Widget new;
    
    scInfoPtr  countPtr = (scInfoPtr)XtNew(scInfo);
    countPtr->next   = scBegin;
    countPtr->value  = 0.0;  /* default value */
    countPtr->widget = new = XtCreateWidget(name, stripChartWidgetClass, 
					    father, args, numArgs);
    scBegin = countPtr;
    XtAddCallback(new, "getValue", scQueryProc, NULL);  

    return(new);
    }


/************** scrollbar widget support routines ******/
#include <X11/Xaw/Scrollbar.h>

static Widget
scrollbarCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget new = XtCreateWidget(name, scrollbarWidgetClass, 
				father, args, numArgs);

    setQuark("jumpProc",qjumpProc);
    setQuark("scrollProc",qscrollProc);

    return(new);
    }

/* 
 * ******* end required file <athena.inc> *******
 */
#include <X11/Xaw/AsciiText.h>
/* 
 * Boolean
 * XawAsciiSave
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

int 
com_XawAsciiSave(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawAsciiSave");  

     if (argc != 2) 
	 {
	 argcError("XawAsciiSave","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawAsciiSave","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSave(XawTextGetSource(localVar1));

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int 
 * XawAsciiSaveAsFile
 *         in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 *         in: String			        # file name
 */

int 
com_XawAsciiSaveAsFile(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawAsciiSaveAsFile");  

     if (argc != 3) 
	 {
	 argcError("XawAsciiSaveAsFile","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawAsciiSaveAsFile","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XawAsciiSaveAsFile(XawTextGetSource(localVar1),argv[2]);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSourceChanged 
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

int 
com_XawAsciiSourceChanged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawAsciiSourceChanged");  

     if (argc != 2) 
	 {
	 argcError("XawAsciiSourceChanged","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawAsciiSourceChanged","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSourceChanged(XawTextGetSource(localVar1));

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawAsciiSourceFreeString
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text wiget
 */

int 
com_XawAsciiSourceFreeString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawAsciiSourceFreeString");  

     if (argc != 2) 
	 {
	 argcError("XawAsciiSourceFreeString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawAsciiSourceFreeString","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawAsciiSourceFreeString(XawTextGetSource(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Box.h>
#include <X11/Xaw/Clock.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
/* 
 * String
 * XawDialogGetValueString
 * 	in: DialogWidget		# dialog widget
 */

int 
com_XawDialogGetValueString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XawDialogGetValueString");  

     if (argc != 2) 
	 {
	 argcError("XawDialogGetValueString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],dialogWidgetClass,"Dialog")))
          {
          convError("XawDialogGetValueString","1",argv[1],"DialogWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawDialogGetValueString(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Form.h>
/* 
 * void
 * XawFormDoLayout
 * 	in: FormWidget			# form widget
 * 	in: Boolean			# boolean
 */

int 
com_XawFormDoLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XawFormDoLayout");  

     if (argc != 3) 
	 {
	 argcError("XawFormDoLayout","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],formWidgetClass,"Form")))
          {
          convError("XawFormDoLayout","1",argv[1],"FormWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XawFormDoLayout","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawFormDoLayout(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
/* 
 * void
 * listAppend vulgo XawListAppend
 * 	in: ListWidget			# list widget
 * 	in: [args]			# items
 */

int 
com_XawListAppend(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawListAppend");  

     if (argc < 3) 
	 {
	 argcError("XawListAppend","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
          {
          convError("XawListAppend","1",argv[1],"ListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     listAppend(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * listChange vulgo XawListChange
 * 	in: ListWidget			# list widget
 * 	const: argv[1]
 * 	in: int				# number of items
 * 	in: int				# longest
 * 	in: int				# resize
 * 	in: [args]			# Arg items | File filename
 */

int 
com_XawListChange(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("XawListChange");  

     if (argc < 6) 
	 {
	 argcError("XawListChange","at least ",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
          {
          convError("XawListChange","1",argv[1],"ListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XawListChange","3",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XawListChange","4",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("XawListChange","5",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 5;
     listChange(localVar1,argv[1],localVar2,localVar3,localVar4,argc,&argv[5]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListHighlight
 * 	in: ListWidget			# list widget
 * 	in: int				# item number
 */

int 
com_XawListHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("XawListHighlight");  

     if (argc != 3) 
	 {
	 argcError("XawListHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
          {
          convError("XawListHighlight","1",argv[1],"ListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XawListHighlight","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawListReturnStruct *
 * XawListShowCurrent
 * 	in: ListWidget			# list widget
 */

int 
com_XawListShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawListShowCurrent");  

     if (argc != 2) 
	 {
	 argcError("XawListShowCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
          {
          convError("XawListShowCurrent","1",argv[1],"ListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawListShowCurrent(localVar1);

     if (returnVar == NULL) { DBUG_RETURN (TCL_ERROR); }
     
     Tcl_SetVar2(wafeInterpreter,"returnVar","string", returnVar->string,0);
     sprintf(conversionBuffer, "%d", returnVar->list_index);
     Tcl_SetVar2(wafeInterpreter,"returnVar","list_index", conversionBuffer,0);

     Tcl_SetResult(comInterpreter, "returnVar", TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListUnhighlight
 * 	in: ListWidget			# list widget
 */

int 
com_XawListUnhighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawListUnhighlight");  

     if (argc != 2) 
	 {
	 argcError("XawListUnhighlight","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass,"List")))
          {
          convError("XawListUnhighlight","1",argv[1],"ListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListUnhighlight(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Logo.h>
#include <X11/Xaw/Mailbox.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
/* 
 * void
 * XawPanedAllowResize
 * 	in: PanedWidget			# paned widget
 * 	in: Boolean			# boolean
 */

int 
com_XawPanedAllowResize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XawPanedAllowResize");  

     if (argc != 3) 
	 {
	 argcError("XawPanedAllowResize","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
          {
          convError("XawPanedAllowResize","1",argv[1],"PanedWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XawPanedAllowResize","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedAllowResize(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedGetMinMax
 * 	in: PanedWidget			# paned widget
 * 	out: int			# min
 * 	out: int			# max
 */

int 
com_XawPanedGetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("XawPanedGetMinMax");  

     if (argc != 4) 
	 {
	 argcError("XawPanedGetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
          {
          convError("XawPanedGetMinMax","1",argv[1],"PanedWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedGetMinMax(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawPanedGetNumSub
 * 	in: PanedWidget			# paned widget
 */

int 
com_XawPanedGetNumSub(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawPanedGetNumSub");  

     if (argc != 2) 
	 {
	 argcError("XawPanedGetNumSub","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
          {
          convError("XawPanedGetNumSub","1",argv[1],"PanedWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawPanedGetNumSub(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedSetMinMax
 * 	in: PanedWidget			# paned widget
 * 	in: int				# min
 * 	in: int				# max
 */

int 
com_XawPanedSetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("XawPanedSetMinMax");  

     if (argc != 4) 
	 {
	 argcError("XawPanedSetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
          {
          convError("XawPanedSetMinMax","1",argv[1],"PanedWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XawPanedSetMinMax","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("XawPanedSetMinMax","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedSetMinMax(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawPanedSetRefigureMode
 * 	in: PanedWidget			# paned widget
 * 	in: Boolean			# boolean
 */

int 
com_XawPanedSetRefigureMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XawPanedSetRefigureMode");  

     if (argc != 3) 
	 {
	 argcError("XawPanedSetRefigureMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass,"Paned")))
          {
          convError("XawPanedSetRefigureMode","1",argv[1],"PanedWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XawPanedSetRefigureMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedSetRefigureMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Scrollbar.h>
/* 
 * void
 * XawScrollbarSetThumb
 * 	in: ScrollbarWidget		# scrollbar widget
 * 	in: float			# top
 * 	in: float			# shown
 */

int 
com_XawScrollbarSetThumb(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;
     float localVar3;

     DBUG_ENTER("XawScrollbarSetThumb");  

     if (argc != 4) 
	 {
	 argcError("XawScrollbarSetThumb","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],scrollbarWidgetClass,"Scrollbar")))
          {
          convError("XawScrollbarSetThumb","1",argv[1],"ScrollbarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%f", &localVar2)))
          {
          convError("XawScrollbarSetThumb","2",argv[2],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%f", &localVar3)))
          {
          convError("XawScrollbarSetThumb","3",argv[3],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     XawScrollbarSetThumb(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/SimpleMenu.h>
/* 
 * void 
 * XawSimpleMenuClearActiveEntry
 * 	in: SimpleMenuWidget		# widget
 */

int 
com_XawSimpleMenuClearActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawSimpleMenuClearActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("XawSimpleMenuClearActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass,"SimpleMenu")))
          {
          convError("XawSimpleMenuClearActiveEntry","1",argv[1],"SimpleMenuWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawSimpleMenuClearActiveEntry(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Widget
 * XawSimpleMenuGetActiveEntry
 * 	in:SimpleMenuWidget		# widget
 */

int 
com_XawSimpleMenuGetActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawSimpleMenuGetActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("XawSimpleMenuGetActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass,"SimpleMenu")))
          {
          convError("XawSimpleMenuGetActiveEntry","1",argv[1],"SimpleMenuWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawSimpleMenuGetActiveEntry(localVar1);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
/* 
 * void
 * stripChartSet vulgo XawStripChartSet
 * 	in: StripChartWidget		# strip chart widget
 * 	in: double			# value
 */

int 
com_XawStripChartSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;

     DBUG_ENTER("XawStripChartSet");  

     if (argc != 3) 
	 {
	 argcError("XawStripChartSet","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],stripChartWidgetClass,"StripChart")))
          {
          convError("XawStripChartSet","1",argv[1],"StripChartWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
          {
          convError("XawStripChartSet","2",argv[2],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     stripChartSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisableRedisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

int 
com_XawTextDisableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawTextDisableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("XawTextDisableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextDisableRedisplay","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

int 
com_XawTextDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawTextDisplay");  

     if (argc != 2) 
	 {
	 argcError("XawTextDisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextDisplay","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplayCaret
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: Boolean			# boolean
 */

int 
com_XawTextDisplayCaret(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("XawTextDisplayCaret");  

     if (argc != 3) 
	 {
	 argcError("XawTextDisplayCaret","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextDisplayCaret","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("XawTextDisplayCaret","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawTextDisplayCaret(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextEnableRedisplay
 * 	in: AsciiTextWidget		# ascii text wiget
 */

int 
com_XawTextEnableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawTextEnableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("XawTextEnableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextEnableRedisplay","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextEnableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextGetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text wiget
 */

int 
com_XawTextGetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextGetInsertionPoint");  

     if (argc != 2) 
	 {
	 argcError("XawTextGetInsertionPoint","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextGetInsertionPoint","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextGetInsertionPoint(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextGetSelectionPos
 *         in: AsciiTextWidget 		# ascii text wiget
 *         out: XawTextPosition		# varname for from position
 *         out: XawTextPosition 		# varname for to position
 */

int 
com_XawTextGetSelectionPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextGetSelectionPos");  

     if (argc != 4) 
	 {
	 argcError("XawTextGetSelectionPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextGetSelectionPos","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextGetSelectionPos(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextInvalidate
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextPosition		# from postion
 * 	in: XawTextPosition		# to postion
 */

int 
com_XawTextInvalidate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("XawTextInvalidate");  

     if (argc != 4) 
	 {
	 argcError("XawTextInvalidate","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextInvalidate","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextInvalidate","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XawTextInvalidate","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextInvalidate(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSearch
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextScanDirection	# scan direction
 * 	in: XawTextBlock		# text block
 */

int 
com_XawTextSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextScanDirection localVar2;
     XawTextBlock localVar3;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextSearch");  

     if (argc != 4) 
	 {
	 argcError("XawTextSearch","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextSearch","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "right")) 
         localVar2 = XawsdRight;
     else
     if (!strcmp(argv[2], "Left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "Right")) 
         localVar2 = XawsdRight;
     else
         {
         convError("XawTextSearch","2",argv[2],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"firstPos", 0)))
               {
               noVarCompError("XawTextSearch",argv[3],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.firstPos)))
              {
              convError("XawTextSearch","3.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"length", 0)))
               {
               noVarCompError("XawTextSearch",argv[3],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.length)))
              {
              convError("XawTextSearch","3.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"ptr", 0)))
               {
               noVarCompError("XawTextSearch",argv[3],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar3.ptr = charp;
     }

     returnVar = XawTextSearch(localVar1,localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: XawTextPosition		# position
 */

int 
com_XawTextSetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;

     DBUG_ENTER("XawTextSetInsertionPoint");  

     if (argc != 3) 
	 {
	 argcError("XawTextSetInsertionPoint","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextSetInsertionPoint","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextSetInsertionPoint","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetInsertionPoint(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextSetSelection
 *         in: AsciiTextWidget 		# ascii text wiget
 *         in: XawTextPosition		# from position
 *         in: XawTextPosition 		# to position
 */

int 
com_XawTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("XawTextSetSelection");  

     if (argc != 4) 
	 {
	 argcError("XawTextSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextSetSelection","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextSetSelection","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XawTextSetSelection","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetSelection(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetSelectionArray
 * 	in: AsciiTextWidget		# ascii text wiget
 * 	in: [XawTextSelectType]		# selction array
 */

int 
com_XawTextSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextSelectType * localVar2;

     DBUG_ENTER("XawTextSetSelectionArray");  

     if (argc < 3) 
	 {
	 argcError("XawTextSetSelectionArray","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextSetSelectionArray","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    XawTextSelectType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XawTextSelectType *)XtMalloc((argc-2)*sizeof(XawTextSelectType));

          while (*argv)
             {
             if (!strcmp(*argv, "selectAll")) 
                 *ptr = XawselectAll;
             else
             if (!strcmp(*argv, "selectChar")) 
                 *ptr = XawselectChar;
             else
             if (!strcmp(*argv, "selectLine")) 
                 *ptr = XawselectLine;
             else
             if (!strcmp(*argv, "selectNull")) 
                 *ptr = XawselectNull;
             else
             if (!strcmp(*argv, "selectParagraph")) 
                 *ptr = XawselectParagraph;
             else
             if (!strcmp(*argv, "selectPosition")) 
                 *ptr = XawselectPosition;
             else
             if (!strcmp(*argv, "selectWord")) 
                 *ptr = XawselectWord;
             else
                 {
                 convError("XawTextSetSelectionArray","2",*argv,"XawTextSelectType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     XawTextSetSelectionArray(localVar1,localVar2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("XawTextSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxHeight
 * 	in: (Widget)TextSink 		# ascii text wiget
 * 	in: int				# height
 */

int 
com_XawTextSinkMaxHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextSinkMaxHeight");  

     if (argc != 3) 
	 {
	 argcError("XawTextSinkMaxHeight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("XawTextSinkMaxHeight","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("XawTextSinkMaxHeight","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxHeight(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxLines
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	in: Dimension			# height
 */

int 
com_XawTextSinkMaxLines(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextSinkMaxLines");  

     if (argc != 3) 
	 {
	 argcError("XawTextSinkMaxLines","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("XawTextSinkMaxLines","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hu", &localVar2)))
          {
          convError("XawTextSinkMaxLines","2",argv[2],"Dimension");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxLines(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSinkSetTabs
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	const: argc-2
 * 	in: [int]			# tabs
 */

int 
com_XawTextSinkSetTabs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int * localVar2;

     DBUG_ENTER("XawTextSinkSetTabs");  

     if (argc < 3) 
	 {
	 argcError("XawTextSinkSetTabs","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("XawTextSinkSetTabs","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     {    int *ptr;
          argv += 2;
          localVar2 = ptr =
             (int *)XtMalloc((argc-2)*sizeof(int));

          while (*argv)
             {
             if (!(sscanf(*argv, "%d", &*ptr)))
                  {
                  convError("XawTextSinkSetTabs","2",*argv,"int");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XawTextSinkSetTabs(localVar1,argc-2,localVar2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("XawTextSinkSetTabs"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceRead 
 * 	in: (Widget)TextSource		# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	out: XawTextBlock		# varname for text block
 * 	in: int				# length
 */

int 
com_XawTextSourceRead(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextBlock localVar3;
     int localVar4;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextSourceRead");  

     if (argc != 5) 
	 {
	 argcError("XawTextSourceRead","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Source(argv[1])))
          {
          convError("XawTextSourceRead","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextSourceRead","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("XawTextSourceRead","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSourceRead(localVar1,localVar2,&localVar3,localVar4);

          sprintf(conversionBuffer, "%d", localVar3.firstPos);
     Tcl_SetVar2(wafeInterpreter,argv[3],"firstPos", conversionBuffer,0);
     sprintf(conversionBuffer, "%d", localVar3.length);
     Tcl_SetVar2(wafeInterpreter,argv[3],"length", conversionBuffer,0);
     
     Tcl_SetVar2(wafeInterpreter,argv[3],"ptr", localVar3.ptr,0);


     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceScan
 * 	in: (Widget)TextSource		# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	in: XawTextScanType		# scan type
 * 	in: XawTextScanDirection	# scan direction
 * 	in: int				# count
 * 	in: Boolean			# include (boolean)
 */

int 
com_XawTextSourceScan(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextScanType localVar3;
     XawTextScanDirection localVar4;
     int localVar5;
     Boolean localVar6;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextSourceScan");  

     if (argc != 7) 
	 {
	 argcError("XawTextSourceScan","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Source(argv[1])))
          {
          convError("XawTextSourceScan","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextSourceScan","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "position")) 
         localVar3 = XawstPositions;
     else
     if (!strcmp(argv[3], "whiteSpace")) 
         localVar3 = XawstWhiteSpace;
     else
     if (!strcmp(argv[3], "EOL")) 
         localVar3 = XawstEOL;
     else
     if (!strcmp(argv[3], "paragraph")) 
         localVar3 = XawstParagraph;
     else
     if (!strcmp(argv[3], "all")) 
         localVar3 = XawstAll;
     else
         {
         convError("XawTextSourceScan","3",argv[3],"XawTextScanType");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "right")) 
         localVar4 = XawsdRight;
     else
     if (!strcmp(argv[4], "Left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "Right")) 
         localVar4 = XawsdRight;
     else
         {
         convError("XawTextSourceScan","4",argv[4],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("XawTextSourceScan","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
         {
         convError("XawTextSourceScan","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XawTextSourceScan(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextTopPosition
 * 	in: AsciiTextWidget		# ascii text wiget
 */

int 
com_XawTextTopPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextTopPosition");  

     if (argc != 2) 
	 {
	 argcError("XawTextTopPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextTopPosition","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextTopPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) ReplaceVal 
 * XawTextReplace
 *         in: AsciiTextWidget		# ascii text wiget
 *         in: XawTextPosition 		# from position
 *         in: XawTextPosition 		# to position
 *         in: XawTextBlock		# text block
 */

int 
com_XawTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     XawTextBlock localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("XawTextReplace");  

     if (argc != 5) 
	 {
	 argcError("XawTextReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextReplace","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("XawTextReplace","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("XawTextReplace","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"firstPos", 0)))
               {
               noVarCompError("XawTextReplace",argv[4],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.firstPos)))
              {
              convError("XawTextReplace","4.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"length", 0)))
               {
               noVarCompError("XawTextReplace",argv[4],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.length)))
              {
              convError("XawTextReplace","4.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"ptr", 0)))
               {
               noVarCompError("XawTextReplace",argv[4],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar4.ptr = charp;
     }

     returnVar = XawTextReplace(localVar1,localVar2,localVar3,&localVar4);

          if (returnVar == XawEditDone) 
          strcpy(conversionBuffer, "editDone");
     else
     if (returnVar == XawPositionError) 
          strcpy(conversionBuffer, "positionError");
     else
     if (returnVar == XawEditError) 
          strcpy(conversionBuffer, "editError");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextUnsetSelection
 *         in: AsciiTextWidget 		# ascii text wiget
 */

int 
com_XawTextUnsetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawTextUnsetSelection");  

     if (argc != 2) 
	 {
	 argcError("XawTextUnsetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass,"AsciiText")))
          {
          convError("XawTextUnsetSelection","1",argv[1],"AsciiTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextUnsetSelection(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Toggle.h>
/* 
 * void
 * XawToggleChangeRadioGroup
 * 	in: ToggleWidget		# toggle widget
 * 	in: NULL | ToggleWidget		# NULL | toggle widget
 */

int 
com_XawToggleChangeRadioGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("XawToggleChangeRadioGroup");  

     if (argc != 3) 
	 {
	 argcError("XawToggleChangeRadioGroup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleChangeRadioGroup","1",argv[1],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 =  name2WidgetOfClass(argv[2],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleChangeRadioGroup","2",argv[2],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleChangeRadioGroup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XawToggleGetCurrent
 * 	in: ToggleWidget		# toggle widget
 */

int 
com_XawToggleGetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("XawToggleGetCurrent");  

     if (argc != 2) 
	 {
	 argcError("XawToggleGetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleGetCurrent","1",argv[1],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawToggleGetCurrent(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleSetCurrent
 * 	in: ToggleWidget		# toggle widget
 * 	in: String			# radio data
 */

int 
com_XawToggleSetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawToggleSetCurrent");  

     if (argc != 3) 
	 {
	 argcError("XawToggleSetCurrent","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleSetCurrent","1",argv[1],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XawToggleSetCurrent(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#define toggleSetRadioData(w, string) XtVaSetValues(w, XtNradioData, string, NULL)

/* 
 * void
 * toggleSetRadioData vulgo XawToggleSetRadioData
 * 	in: ToggleWidget		# toggle widget
 *         in: XtNewString(String)		# radio data
 */

int 
com_XawToggleSetRadioData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawToggleSetRadioData");  

     if (argc != 3) 
	 {
	 argcError("XawToggleSetRadioData","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleSetRadioData","1",argv[1],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     toggleSetRadioData(localVar1,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleUnsetCurrent
 * 	in: ToggleWidget		# toggle widget
 */

int 
com_XawToggleUnsetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawToggleUnsetCurrent");  

     if (argc != 2) 
	 {
	 argcError("XawToggleUnsetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass,"Toggle")))
          {
          convError("XawToggleUnsetCurrent","1",argv[1],"ToggleWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleUnsetCurrent(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Viewport.h>
/* 
 * hint: R5
 * void
 * XawViewportSetCoordinates
 * 	in: ViewportWidget		# viewport Widget
 * 	in: Position			# x position
 * 	in: Position			# y position
 */
#ifndef PRER5

int 
com_XawViewportSetCoordinates(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("XawViewportSetCoordinates");  

     if (argc != 4) 
	 {
	 argcError("XawViewportSetCoordinates","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass,"Viewport")))
          {
          convError("XawViewportSetCoordinates","1",argv[1],"ViewportWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("XawViewportSetCoordinates","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("XawViewportSetCoordinates","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XawViewportSetCoordinates(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: R5
 * void
 * XawViewportSetLocation
 * 	in: ViewportWidget		# viewport Widget
 * 	in: double			# xoffset 
 * 	in: double			# yoffset

 */
#ifndef PRER5

int 
com_XawViewportSetLocation(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;
     double localVar3;

     DBUG_ENTER("XawViewportSetLocation");  

     if (argc != 4) 
	 {
	 argcError("XawViewportSetLocation","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass,"Viewport")))
          {
          convError("XawViewportSetLocation","1",argv[1],"ViewportWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
          {
          convError("XawViewportSetLocation","2",argv[2],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%lf", &localVar3)))
          {
          convError("XawViewportSetLocation","3",argv[3],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     XawViewportSetLocation(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#else
#include "wafe.h"
#endif

void
Initialize_XawGen()
{
#ifdef ATHENA
 createWidgetCommand("Text",asciiTextWidgetClass,NULL,False);
 createWidgetCommand("Box",boxWidgetClass,NULL,False);
 createWidgetCommand("Clock",clockWidgetClass,NULL,False);
 createWidgetCommand("Command",commandWidgetClass,NULL,False);
 createWidgetCommand("Dialog",dialogWidgetClass,NULL,False);
 createWidgetCommand("Form",formWidgetClass,NULL,False);
 createWidgetCommand("Grip",gripWidgetClass,NULL,False);
 createWidgetCommand("Label",labelWidgetClass,NULL,False);
 createWidgetCommand("List",listWidgetClass,listCreate,False);
 createWidgetCommand("Logo",logoWidgetClass,NULL,False);
 createWidgetCommand("Mailbox",mailboxWidgetClass,NULL,False);
 createWidgetCommand("MenuButton",menuButtonWidgetClass,NULL,False);
 createWidgetCommand("Paned",panedWidgetClass,NULL,False);
 createWidgetCommand("Scrollbar",scrollbarWidgetClass,scrollbarCreate,False);
 createWidgetCommand("SimpleMenu",simpleMenuWidgetClass,XtCreatePopupShell,True);
 createWidgetCommand("Sme",smeObjectClass,NULL,False);
 createWidgetCommand("SmeBSB",smeBSBObjectClass,NULL,False);
 createWidgetCommand("SmeLine",smeLineObjectClass,NULL,False);
 createWidgetCommand("StripChart",stripChartWidgetClass,stripChartCreate,False);
 createWidgetCommand("Toggle",toggleWidgetClass,NULL,False);
 createWidgetCommand("Viewport",viewportWidgetClass,NULL,False);
#ifdef ATHENA
 strcat(wafePackages,"ATHENA ");
#endif
#ifdef XAW3D
 strcat(wafePackages,"XAW3D ");
#endif
 qcallback = WafePermStringToQuark("callback");
 qjumpProc = WafePermStringToQuark("jumpProc");
 qscrollProc = WafePermStringToQuark("scrollProc");
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSave", com_XawAsciiSave, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSaveAsFile", com_XawAsciiSaveAsFile, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSourceChanged", com_XawAsciiSourceChanged, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawAsciiSourceFreeString", com_XawAsciiSourceFreeString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawDialogGetValueString", com_XawDialogGetValueString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawFormDoLayout", com_XawFormDoLayout, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListAppend", com_XawListAppend, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListChange", com_XawListChange, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListHighlight", com_XawListHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListShowCurrent", com_XawListShowCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawListUnhighlight", com_XawListUnhighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedAllowResize", com_XawPanedAllowResize, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedGetMinMax", com_XawPanedGetMinMax, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedGetNumSub", com_XawPanedGetNumSub, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedSetMinMax", com_XawPanedSetMinMax, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawPanedSetRefigureMode", com_XawPanedSetRefigureMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawScrollbarSetThumb", com_XawScrollbarSetThumb, NULL, NULL);
 /* alias */  Tcl_CreateCommand(wafeInterpreter,"scSet",com_XawStripChartSet, NULL,NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawSimpleMenuClearActiveEntry", com_XawSimpleMenuClearActiveEntry, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawSimpleMenuGetActiveEntry", com_XawSimpleMenuGetActiveEntry, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawStripChartSet", com_XawStripChartSet, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisableRedisplay", com_XawTextDisableRedisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisplay", com_XawTextDisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextDisplayCaret", com_XawTextDisplayCaret, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextEnableRedisplay", com_XawTextEnableRedisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextGetInsertionPoint", com_XawTextGetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextGetSelectionPos", com_XawTextGetSelectionPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextInvalidate", com_XawTextInvalidate, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSearch", com_XawTextSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetInsertionPoint", com_XawTextSetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetSelection", com_XawTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSetSelectionArray", com_XawTextSetSelectionArray, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkMaxHeight", com_XawTextSinkMaxHeight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkMaxLines", com_XawTextSinkMaxLines, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSinkSetTabs", com_XawTextSinkSetTabs, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSourceRead", com_XawTextSourceRead, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextSourceScan", com_XawTextSourceScan, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextTopPosition", com_XawTextTopPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextReplace", com_XawTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTextUnsetSelection", com_XawTextUnsetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleChangeRadioGroup", com_XawToggleChangeRadioGroup, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleGetCurrent", com_XawToggleGetCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleSetCurrent", com_XawToggleSetCurrent, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleSetRadioData", com_XawToggleSetRadioData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawToggleUnsetCurrent", com_XawToggleUnsetCurrent, NULL, NULL);
#ifndef PRER5
 Tcl_CreateCommand(wafeInterpreter, "XawViewportSetCoordinates", com_XawViewportSetCoordinates, NULL, NULL);
#endif
#ifndef PRER5
 Tcl_CreateCommand(wafeInterpreter, "XawViewportSetLocation", com_XawViewportSetLocation, NULL, NULL);
#endif

#else
#endif
}
