#define XT

$PACKAGE = "XT";

~handles
	XPM
	LAYOUT

#include "wafe.h"                             
#include <X11/Shell.h>
#include <X11/Xatom.h>

~require 
	Xt.inc
	pseudoAttrib busyWindow None
	quark String
	quark Callback
	quark Pointer
	quark Int
	quark Dimension
	quark Cardinal
	quark Position
	quark Float
	quark Double
	quark Pixel
	quark Boolean
	quark WidgetList
	quark Widget
	conv XtRString XtRWidget     None CvtStringToWidget     None
	conv XtRString XtRCallback   None CvtStringToCallback   None
	conv XtRString XtRPointer    None CvtStringToPointer    None
	conv XtRString XtRWidgetList None CvtStringToWidgetList None
	init #ifndef PRER5
	conv XtRString XtRCardinal   None XtCvtStringToInt      None
	init #endif

void
XtAppAddTimeOut vulgo addTimeOut
	const: wafeAppContext 
	in: unsigned long		# time interval in ms
	const: timerProc
	in: XtNewString(String)		# tcl command

void
action
	in: Widget			# widget
	in: (int)TranslationModifier	# override | augment | replace
        in: XtTranslations		# translatontable

~widgetClass
applicationShell
	createCmd XtAppCreateShell

void
XBell
	in: XtDisplay(Widget)		# widget to determine display
	in: int				# percent (-100 = off, 0 .. 100)

void
callActionProc
	in: Widget			# widget
	in: String			# event type
	in: String			# action
	in: [args opt]			# args

void
callCallbacks
	in: Widget			# widget
	in: String			# callback
	in: [args opt]			# optional float and value 

extern positionCallbackProc();
extern positionCursorCallbackProc();

void
callback
	in: Widget			# widget
	in: String			# callback resource
        in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
        in: XtNewString(String)		# string


void
XtDestroyWidget
	callmultiple
		in: MMfreeGarbage(Widget)	# widgets

#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

String
getClass
	in: Widget			# widget | None

int
getResourceList
	in: Widget			# widget
	out: String *			# varname for output of reslist
	end: XtFree((String)localVar2);

XrmQuark
getQTypeOfAttribute vulgo getTypeOfAttribute
	in: XtClass(Widget)		# widget
	const: ParentWidget(localVar1)
	in: XrmStringToQuark(String)	# attribute

String
getValue
	in: Widget			# widget
	in: XrmQuark			# attribute
	free: freeProc

(int) GrabReturns
XtGrabPointer
	in: Widget			# widget
	in: Boolean			# true | false
        const: NoEventMask
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync             # keyboard mode (sync | async)
	in: None | XtWindow(Widget)	# None | confine widget
	const: None
	const: CurrentTime

(int) GrabReturns
XtGrabKeyboard
	in: Widget			# widget
	in: Boolean			# true | false
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync		# keyboard mode (sync | async)
	const: CurrentTime


#define installAccelerators(destination,source,table) \
	{ XtVaSetValues(source, XtNaccelerators, table, NULL); \
          XtInstallAccelerators(destination, source);}

void
installAccelerators
	in: Widget			# destination
	in: Widget			# source
	in: XtAccelerators		# table

void
XtManageChildren vulgo manageChild
	in: [Widget]		        # widgets
	const: argc -1

void
XtMapWidget
	callmultiple
		in: Widget		# widgets

#define mergeResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2)  \
          XrmPutStringResource(&newDb, v[i], v[i+1]); \
     XrmMergeDatabases(newDb, &dispDb);}


void 
mergeResources
	in: Widget			# widget to determine display
	in: [args avp] 			# resource value pairs

~widgetClass
overrideShell
	createCmd XtCreatePopupShell
	createsShell

void
XtPopdown
        in: ShellWidget			# shell widget

void
XtPopup
        in: ShellWidget			# widget
        in: XtGrabKind			# none | nonexclusive | exclusive

void
XtPopupSpringLoaded
        in: ShellWidget			# shell widget

void
realizeWidgets vulgo realize

void
XtRemoveAllCallbacks
	in: Widget			# widget
	in: String			# callback name

void
XtSetKeyboardFocus
	in: Widget			# from widget tree
	in: None|Widget			# to widget | None

#define setValues(w,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    if (convert(ParentWidget(w), XtClass(w), \
		argv, &argc, &args, &numArgs, w)) { \
	XtSetValues(w, args, numArgs); \
	wafeCurrentAttribList = NULL; \
	XtFree((String)args); \
	} \
    } 

void
setValues
	in: Widget			# widget
	in: [args avp]			# resource value pairs

#define ptr(w) &(w)

Boolean 
XSetWMProtocols
	const: XtDisplay(localVar1)
	in: XtWindow(ShellWidget)	# Shell Widget
	in: ptr((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
	const: 1

~widgetClass
topLevelShell
	createCmd XtCreatePopupShell
	createsShell

~widgetClass
transientShell
	createCmd XtCreatePopupShell
	createsShell

void
XtTranslateCoords
	in: Widget			# widget
	in: Position    		# widget x
	in: Position    		# widget y
	out: Position   		# variable name for root x
	out: Position   		# variable name for root y

void
XtUngrabPointer
	in: Widget			# widget with active pointer grab
	const: CurrentTime

void
XtUngrabKeyboard
	in: Widget			# widget with active keyboard grab
	const: CurrentTime

void
XtUnmanageChildren vulgo unmanageChild
	in: [Widget]		# widgets
	const: argc -1

void
XtUnmapWidget
	callmultiple
		in: Widget		# widgets

void
XtUnrealizeWidget
	callmultiple
		in: Widget		# widgets

void
XtRealizeWidget
	callmultiple
		in: Widget		# widgets










#####  selection handling #####

void
XtDisownSelection
	const: wafeTopLevel
	const: XA_PRIMARY
	const: CurrentTime

extern void getSelectionValueProc();

void
XtGetSelectionValue
	const: wafeTopLevel
	const: XA_PRIMARY
	const: XA_STRING
	const: getSelectionValueProc
	in: XtNewString(String)		# Tcl command
	const: CurrentTime


Boolean
ownSelection
	in: XtNewString(String) # string to be put into selection
	in: NULL | String 	# NULL | loseSelection TCL-command
	in: NULL | String 	# NULL | doneSelection TCL-command


# get the PRIMARY selection, put it into Cut Buffer 0 and fetch it ...

String
XFetchBytes
	pre: { int bytes; \
		XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, \
			XA_STRING, XA_CUT_BUFFER0, \
			DefaultRootWindow(XtDisplay(localVar1)), \
			CurrentTime); 
	in: XtDisplay(Widget) 		# widget to determine display
        const:  &bytes
	post: }
	end: XtFree(returnVar);

void
XConvertSelection
	in: XtDisplay(Widget)		# widget to determine display
	const: XA_PRIMARY
	const: XA_STRING
	in: Atom			# target buffer number
	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
	const: CurrentTime


void
XStoreBuffer
	in: XtDisplay(Widget)		# widget to determine display
	in: String			# String
	const: strlen(argv[2])
	in: int				# buffer number (1-7)


String
XFetchBuffer
	in: XtDisplay(Widget)		# widget to determine display
	const: &nbytes
	in: int				# buffer number (1-7)
	pre: {int nbytes;
	post: }
	end: XtFree(returnVar);



~alias 
	sV setValues
	gV getValue

#####  XPM related commands #####

hint: XPM
~require 
xpm.inc
	init xpmRegisterTypeConverter(XtRBitmap, False);
	init xpmRegisterTypeConverter(XtRPixmap, True);

hint: XPM
void
setIconPixmap
	in: ShellWidget			# Shell Widget (eg topLevel)
	in: String			# pixmap file

hint: XPM
void
changePixmap
	in: Widget			# widget
	in: String			# resource
	in: String			# pixmap file

int (int)
name2WidgetId vulgo isWidget
	in: String			# widget name 

hint: LAYOUT
~widgetClass 
layout
	include "Layout.h"

Widget
ParentWidget vulgo parent
	in: Widget	# child widget

int
WidthOfScreen
	in: XtScreen(Widget)     # widget to determine screen

int
HeightOfScreen
	in: XtScreen(Widget)     # widget to determine screen


char *
XtResolvePathname
	in: XtDisplay(Widget)
	in: NULL | String               # Type
	in: NULL | String               # File
	in: NULL | String               # Suffix
	in: NULL | String               # Path
	const: NULL                     # Substitutions
	const: 0                        # Number of Substitutions
	const: NULL                     # XtFilePredicate

void
XtSetSensitive 
	in: Widget			# widget 
	in: Boolean			# sensitive true | false

void
setBusy
	in: Widget			# shell widget 
	in: Boolean			# sensitive true | false


#define WAFEtextWidth(w,resource,string) \
         XTextWidth(font, string, strlen(string))

int
WAFEtextWidth vulgo textWidth
	pre: {XFontStruct  *font; \
              XtVaGetValues(localVar1, argv[2], &font, NULL);
	in: Widget			# Widget
	in: String			# fontResource
	in: String			# String
        post: }

void
XRaiseWindow
	in: XtDisplay(Widget)		# widget to be raised
	const: XtWindow(localVar1)

void
XLowerWindow
	in: XtDisplay(Widget)           # Widget to be lowered
	const: XtWindow(localVar1)
