/****************************************************************************
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 ****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#ifdef MOTIF
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#else
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#endif
#include "HTMLP.h"


#define	W_TEXTFIELD	0
#define	W_CHECKBOX	1
#define	W_PUSHBUTTON	2


extern char *ParseMarkTag();


void
AddNewForm(hw, fptr)
	HTMLWidget hw;
	FormInfo *fptr;
{
	FormInfo *ptr;

	ptr = hw->html.form_list;
	if (ptr == NULL)
	{
		hw->html.form_list = fptr;
		fptr->next = NULL;
	}
	else
	{
		while (ptr->next != NULL)
		{
			ptr = ptr->next;
		}
		ptr->next = fptr;
		fptr->next = NULL;
	}
}


void
CBSubmitForm(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	FormInfo *fptr = (FormInfo *)client_data;
#ifdef MOTIF
	XmPushButtonCallbackStruct *pb =
		(XmPushButtonCallbackStruct *)call_data;
#else
	Boolean state;
#endif
	HTMLWidget hw = (HTMLWidget)(fptr->hw);
	WbFormCallbackData cbdata;
	WidgetInfo *wptr;
	int cnt;

#ifdef MOTIF
	cbdata.event = pb->event;
#else
	/******* WE HAVE NO EVENT in ATHENA *******/
#endif
	cbdata.href = fptr->action;
	if (fptr->end == -1)  /* unterminated FORM tag */
	{
		wptr = hw->html.widget_list;
		cnt = 0;
		while (wptr != NULL)
		{
			cnt++;
			wptr = wptr->next;
		}
		cbdata.attribute_count = cnt;
	}
	else
	{
		cbdata.attribute_count = fptr->end - fptr->start;
	}
	cbdata.attribute_names = (char **)malloc(cbdata.attribute_count *
		sizeof(char *));
	cbdata.attribute_values = (char **)malloc(cbdata.attribute_count *
		sizeof(char *));

	if (fptr->start == 0)
	{
		wptr = hw->html.widget_list;
	}
	else
	{
		wptr = hw->html.widget_list;
		while (wptr != NULL)
		{
			if (wptr->id == fptr->start)
			{
				wptr = wptr->next;
				break;
			}
			wptr = wptr->next;
		}
	}

	cnt = 0;

	while ((wptr != NULL)&&(cnt < cbdata.attribute_count))
	{
	    if ((wptr->name)&&(wptr->type != W_PUSHBUTTON))
	    {
		cbdata.attribute_names[cnt] = wptr->name;
		switch(wptr->type)
		{
			case W_TEXTFIELD:
#ifdef MOTIF
				cbdata.attribute_values[cnt] =
					XmTextFieldGetString(wptr->w);
#else
				XtVaGetValues(wptr->w,XtNstring,
					      &(cbdata.attribute_values[cnt]), NULL);
#endif
				if ((cbdata.attribute_values[cnt] != NULL)&&
				    (cbdata.attribute_values[cnt][0] == '\0'))
				{
					cbdata.attribute_values[cnt] = NULL;
				}
				break;
			case W_CHECKBOX:
#ifdef MOTIF
				if (XmToggleButtonGetState(wptr->w) == True)
#else
				XtVaGetValues(wptr->w,XtNstate,&state,NULL);
				if (state)
#endif
				{
				    cbdata.attribute_values[cnt] = wptr->value;
				}
				else
				{
				    cnt--;
				    cbdata.attribute_count--;
				}
				break;
			default:
				cbdata.attribute_values[cnt] = NULL;
				break;
		}
		cnt++;
	    }
	    else
	    {
		cbdata.attribute_count--;
	    }
	    wptr = wptr->next;
	}
	cbdata.attribute_count = cnt;

	XtCallCallbackList ((Widget)hw, hw->html.form_callback,
		(XtPointer)&cbdata);
}


/*
 * RETURN was hit in a textfield in a form.
 * If this is the only textfield in this form, submit the form.
 */
void
CBActivateField(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	FormInfo *fptr = (FormInfo *)client_data;
#ifdef MOTIF
	XmAnyCallbackStruct *cb = (XmAnyCallbackStruct *)call_data;
#endif
	HTMLWidget hw = (HTMLWidget)(fptr->hw);
	WidgetInfo *wptr;
	int cnt, count;

	/*
	 * Terminate the form if it was never properly terminated.
	 */
	if (fptr->end == -1)  /* unterminated FORM tag */
	{
		wptr = hw->html.widget_list;
		cnt = 0;
		while (wptr != NULL)
		{
			cnt++;
			wptr = wptr->next;
		}
		count = cnt;
	}
	else
	{
		count = fptr->end - fptr->start;
	}

	/*
	 * Locate the start of the form.
	 */
	if (fptr->start == 0)
	{
		wptr = hw->html.widget_list;
	}
	else
	{
		wptr = hw->html.widget_list;
		while (wptr != NULL)
		{
			if (wptr->id == fptr->start)
			{
				wptr = wptr->next;
				break;
			}
			wptr = wptr->next;
		}
	}

	/*
	 * Count the textfields in this form.
	 */
	cnt = 0;
	while ((wptr != NULL)&&(cnt < count))
	{
		if (wptr->type == W_TEXTFIELD)
		{
			cnt++;
		}
		wptr = wptr->next;
	}

	/*
	 * If this is the only textfield in this form, submit the form.
	 */
	if (cnt == 1)
	{
		CBSubmitForm(w, client_data, call_data);
	}
}


void
CBResetForm(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	FormInfo *fptr = (FormInfo *)client_data;
#ifdef MOTIF
	XmPushButtonCallbackStruct *pb =
		(XmPushButtonCallbackStruct *)call_data;
#endif
	HTMLWidget hw = (HTMLWidget)(fptr->hw);
	WidgetInfo *wptr;
	int widget_count, cnt;

	if (fptr->end == -1)  /* unterminated FORM tag */
	{
		wptr = hw->html.widget_list;
		cnt = 0;
		while (wptr != NULL)
		{
			cnt++;
			wptr = wptr->next;
		}
		widget_count = cnt;
	}
	else
	{
		widget_count = fptr->end - fptr->start;
	}

	if (fptr->start == 0)
	{
		wptr = hw->html.widget_list;
	}
	else
	{
		wptr = hw->html.widget_list;
		while (wptr != NULL)
		{
			if (wptr->id == fptr->start)
			{
				wptr = wptr->next;
				break;
			}
			wptr = wptr->next;
		}
	}

	cnt = 0;
	while ((wptr != NULL)&&(cnt < widget_count))
	{
		switch(wptr->type)
		{
			case W_TEXTFIELD:
				if (wptr->value == NULL)
				{
#ifdef MOTIF
				    XmTextFieldSetString(wptr->w, "");
#else
				    XtVaSetValues(wptr->w, XtNstring, "", NULL);
#endif
				}
				else
				{
#ifdef MOTIF
				    XmTextFieldSetString(wptr->w, wptr->value);
#else
				    XtVaSetValues(wptr->w, XtNstring, wptr->value, NULL);
#endif
				}
				break;
			case W_CHECKBOX:
#ifdef MOTIF
				XmToggleButtonSetState(wptr->w, wptr->checked, False);
#else
				XtVaSetValues(wptr->w,XtNstate,wptr->checked,NULL);
#endif
				break;
			default:
				break;
		}
		cnt++;
		wptr = wptr->next;
	}
}


void
PrepareFormEnd(hw, w, fptr)
	HTMLWidget hw;
	Widget w;
	FormInfo *fptr;
{
#ifdef MOTIF
	XtAddCallback(w, XmNactivateCallback, CBSubmitForm, (caddr_t)fptr);
#else
	XtAddCallback(w, XtNcallback, CBSubmitForm, (caddr_t)fptr);
#endif
}


void
PrepareFormReset(hw, w, fptr)
	HTMLWidget hw;
	Widget w;
	FormInfo *fptr;
{
#ifdef MOTIF
	XtAddCallback(w, XmNactivateCallback, CBResetForm, (caddr_t)fptr);
#else
	XtAddCallback(w, XtNcallback, CBResetForm, (caddr_t)fptr);
#endif
}


void
HideWidgets(hw)
	HTMLWidget hw;
{
	WidgetInfo *wptr;

	wptr = hw->html.widget_list;
	while (wptr != NULL)
	{
		if (wptr->w != NULL)
		{
			XtUnmanageChild(wptr->w);
		}
		wptr = wptr->next;
	}
}


void
AddNewWidget(hw, w, type, id, x, y, width, height, name, value, checked)
	HTMLWidget hw;
	Widget w;
	int type;
	int id;
	int x, y;
	int width, height;
	char *name;
	char *value;
	Boolean checked;
{
	WidgetInfo *wptr;

	wptr = hw->html.widget_list;
	if (wptr == NULL)
	{
		wptr = (WidgetInfo *)malloc(sizeof(WidgetInfo));
		wptr->w = w;
		wptr->type = type;
		wptr->id = id;
		wptr->x = x;
		wptr->y = y;
		wptr->width = width;
		wptr->height = height;
		wptr->name = name;
		wptr->value = value;
		wptr->checked = checked;
		wptr->next = NULL;
		hw->html.widget_list = wptr;
	}
	else
	{
		while (wptr->next != NULL)
		{
			wptr = wptr->next;
		}
		wptr->next = (WidgetInfo *)malloc(sizeof(WidgetInfo));
		wptr = wptr->next;
		wptr->w = w;
		wptr->type = type;
		wptr->id = id;
		wptr->x = x;
		wptr->y = y;
		wptr->width = width;
		wptr->height = height;
		wptr->name = name;
		wptr->value = value;
		wptr->checked = checked;
		wptr->next = NULL;
	}
}


XFontStruct *
GetWidgetFont(hw, iptr)
	HTMLWidget hw;
	ImageInfo *iptr;
{
	Boolean ret;
	Cardinal argcnt = 0;
	Arg arg[5];
	XFontStruct *font;
#ifdef MOTIF
	XmFontList font_list = (XmFontList)NULL;
	XmFontContext font_context;
	XmStringCharSet charset;

	XtSetArg(arg[argcnt], XmNfontList, &font_list); argcnt++;
	XtGetValues((Widget)(iptr->image_data), arg, argcnt);

	if (font_list == (XmFontList)NULL)
	{
		return((XFontStruct *)NULL);
	}

	ret = XmFontListInitFontContext(&font_context, font_list);
	if (ret == False)
	{
		return((XFontStruct *)NULL);
	}

	ret = XmFontListGetNextFont(font_context, &charset, &font);
	if (ret == False)
	{
		return((XFontStruct *)NULL);
	}
	else
	{
		XmFontListFreeFontContext(font_context);
		free((char *)charset);
		return(font);
	}
#else
	return NULL;
#endif
}


ImageInfo *
MakeWidget(hw, text, x, y, id, fptr)
	HTMLWidget hw;
	char *text;
	int x, y;
	int id;
	FormInfo *fptr;
{
	Arg arg[30];
	Cardinal argcnt;
	Widget w;
	WidgetInfo *wptr;
	ImageInfo *iptr;
	Dimension width, height;

	iptr = (ImageInfo *)malloc(sizeof(ImageInfo));

	wptr = hw->html.widget_list;
	while (wptr != NULL)
	{
		if (wptr->id == id)
		{
			break;
		}
		wptr = wptr->next;
	}

	if (wptr == NULL)
	{
		char *tptr;
		char *value;
		char *name;
		char *type_str;
		int type;
		short size;
		int maxlength;
		Boolean checked;

		checked = False;
		name = ParseMarkTag(text, MT_INPUT, "NAME");

		type_str = ParseMarkTag(text, MT_INPUT, "TYPE");
/*fprintf(stderr, "makeWidget type=%s\n", type_str);*/
		if ((type_str != NULL)&&(strcmp(type_str, "checkbox") == 0))
		{
			type = W_CHECKBOX;
			value = ParseMarkTag(text, MT_INPUT, "VALUE");
			if (value == NULL)
			{
				value = (char *)malloc(strlen("on") + 1);
				strcpy(value, "on");
			}

			tptr = ParseMarkTag(text, MT_INPUT, "CHECKED");

			argcnt = 0;
			XtSetArg(arg[argcnt], XxNx, x); argcnt++;
			XtSetArg(arg[argcnt], XxNy, y); argcnt++;
			if (tptr != NULL)
			{
				XtSetArg(arg[argcnt], XxNset, True); argcnt++;
				checked = True;
				free(tptr);
			}
#ifdef MOTIF
			w = XmCreateToggleButton(hw->html.view, "",
				arg, argcnt);
			XtManageChild(w);
#else
			XtSetArg(arg[argcnt], XtNlabel, ""); argcnt++;
			w = XtCreateManagedWidget(name, toggleWidgetClass,
						  hw->html.view, arg, argcnt);
#endif
		}
		else if ((type_str != NULL)&&(strcmp(type_str, "submit") == 0))
		{
#ifdef MOTIF
			XmString label = NULL;
#endif

			type = W_PUSHBUTTON;
			value = ParseMarkTag(text, MT_INPUT, "VALUE");
			if ((value == NULL)||(*value == '\0'))
			{
				value = (char *)malloc(strlen("Submit Query") +	1);
				strcpy(value, "Submit Query");
			}

			argcnt = 0;
			XtSetArg(arg[argcnt], XxNx, x); argcnt++;
			XtSetArg(arg[argcnt], XxNy, y); argcnt++;

			if (value != NULL)
			{
#ifdef MOTIF
				label = XmStringCreateSimple(value);
				XtSetArg(arg[argcnt], XmNlabelString, label);
#else
				XtSetArg(arg[argcnt], XtNlabel, value);
#endif
				argcnt++;
			}
#ifdef MOTIF
			w = XmCreatePushButton(hw->html.view, "Button",
				arg, argcnt);
			XtManageChild(w);
			if (label != NULL)
			{
				XmStringFree(label);
			}
#else
			w = XtCreateManagedWidget(name,commandWidgetClass,
						  hw->html.view, arg, argcnt);
#endif
			PrepareFormEnd(hw, w, fptr);
		}
		else if ((type_str != NULL)&&(strcmp(type_str, "reset") == 0))
		{
#ifdef MOTIF
			XmString label = NULL;
#endif

			type = W_PUSHBUTTON;
			value = ParseMarkTag(text, MT_INPUT, "VALUE");
			if ((value == NULL)||(*value == '\0'))
			{
				value = (char *)malloc(strlen("Reset") + 1);
				strcpy(value, "Reset");
			}

			argcnt = 0;
			XtSetArg(arg[argcnt], XxNx, x); argcnt++;
			XtSetArg(arg[argcnt], XxNy, y); argcnt++;
			if (value != NULL)
			{
#ifdef MOTIF
				label = XmStringCreateSimple(value);
				XtSetArg(arg[argcnt], XmNlabelString, label);
#else
				XtSetArg(arg[argcnt], XtNlabel, value);
#endif
				argcnt++;
			}
#ifdef MOTIF
			w = XmCreatePushButton(hw->html.view, "Button",
				arg, argcnt);
			XtManageChild(w);
			if (label != NULL)
			{
				XmStringFree(label);
			}
#else
			w = XtCreateManagedWidget(name,commandWidgetClass,
						  hw->html.view, arg, argcnt);
#endif
			PrepareFormReset(hw, w, fptr);
		}
		else if ((type_str != NULL)&&(strcmp(type_str, "button") == 0))
		{
#ifdef MOTIF
			XmString label = NULL;
#endif
			type = W_PUSHBUTTON;
			value = ParseMarkTag(text, MT_INPUT, "VALUE");

			argcnt = 0;
			XtSetArg(arg[argcnt], XxNx, x); argcnt++;
			XtSetArg(arg[argcnt], XxNy, y); argcnt++;
			if (value != NULL)
			{
#ifdef MOTIF
				label = XmStringCreateSimple(value);
				XtSetArg(arg[argcnt], XmNlabelString, label);
#else
				XtSetArg(arg[argcnt], XtNlabel, value);
#endif
				argcnt++;
			}
#ifdef MOTIF
			w = XmCreatePushButton(hw->html.view, "Button",
				arg, argcnt);
			XtManageChild(w);
			if (label != NULL)
			{
				XmStringFree(label);
			}
#else
			w = XtCreateManagedWidget("Button",commandWidgetClass,
						  hw->html.view, arg, argcnt);
#endif
		}
		else
		{
			type = W_TEXTFIELD;
			value = ParseMarkTag(text, MT_INPUT, "VALUE");

			size = -1;
			maxlength = -1;

			tptr = ParseMarkTag(text, MT_INPUT, "SIZE");
			if (tptr != NULL)
			{
				size = atoi(tptr);
				free(tptr);
			}

			tptr = ParseMarkTag(text, MT_INPUT, "MAXLENGTH");
			if (tptr != NULL)
			{
				maxlength = atoi(tptr);
				free(tptr);
			}

			argcnt = 0;
			XtSetArg(arg[argcnt], XxNx, x); argcnt++;
			XtSetArg(arg[argcnt], XxNy, y); argcnt++;
#ifdef MOTIF
			if (size > 0)
			{
				XtSetArg(arg[argcnt], XmNcolumns, size);
				argcnt++;
			}
			if ((maxlength > 0)&&(maxlength >= (int)size))
			{
				XtSetArg(arg[argcnt], XmNmaxLength, maxlength);
				argcnt++;
			}
#else
			XtSetArg(arg[argcnt], XtNeditType, XawtextEdit); argcnt++;

			if (( (maxlength > 0) && (maxlength >= (int) size)))
			    {
			    if (value)
				value = realloc(value, maxlength);
			    else 
			      {
				value = malloc(maxlength);
				*value = '\0';
			      }

			    XtSetArg(arg[argcnt], XtNuseStringInPlace, 1); argcnt++;
			    XtSetArg(arg[argcnt], XtNlength, maxlength); argcnt++;
			    }
#endif
			if (value != NULL)
			{
				XtSetArg(arg[argcnt], XxNvalue, value);	
				argcnt++;
			}
#ifdef MOTIF
			w = XmCreateTextField(hw->html.view, "Child",
				arg, argcnt);
			XtManageChild(w);
			XtAddCallback(w, XmNactivateCallback,
				CBActivateField, (caddr_t)fptr);
#else
			w = XtCreateManagedWidget(name, asciiTextWidgetClass, 
						  hw->html.view, arg, argcnt);

			XtOverrideTranslations(w, 
			     XtParseTranslationTable("<Key>Return: no-op(RingBell)"));

			if (size < 0)
			    size = 200;
			else
			    {
			    XFontStruct  *font;
			    Position lm,rm;

			    XtVaGetValues(w, XtNfont, &font, 
					     XtNleftMargin,&lm,
					     XtNrightMargin,&rm,
					     NULL);
			    size = rm + lm + 
			           size*XTextWidth(font, "0", 1);
			    }			    

			XtVaSetValues(w, XtNwidth, size, NULL);
#endif
		}
		if (type_str != NULL)
		{
			free(type_str);
		}

		argcnt = 0;
		XtSetArg(arg[argcnt], XxNwidth, &width); argcnt++;
		XtSetArg(arg[argcnt], XxNheight, &height); argcnt++;
		XtGetValues(w, arg, argcnt);

		AddNewWidget(hw, w, type, id, x, y, width, height, name,
			value, checked);
	}
	else
	{
		w = wptr->w;
		width = (Dimension)wptr->width;
		height = (Dimension)wptr->height;
		wptr->x = x;
		wptr->y = y;

		argcnt = 0;
		XtSetArg(arg[argcnt], XxNx, x); argcnt++;
		XtSetArg(arg[argcnt], XxNy, y); argcnt++;
		XtSetValues(w, arg, argcnt);

		XtManageChild(wptr->w);
	}

	iptr->ismap = 0;
	iptr->width = (int)width;
	iptr->height = (int)height;
	iptr->num_colors = 0;
	iptr->reds = NULL;
	iptr->greens = NULL;
	iptr->blues = NULL;
	iptr->image_data = (unsigned char *)w;
	iptr->image = (Pixmap)NULL;

	return(iptr);
}


void
WidgetRefresh(hw, eptr)
        HTMLWidget hw;
        struct ele_rec *eptr;
{
#if 0
        if (eptr->pic_data != NULL)
        {
                int x, y, extra;

                x = eptr->x;
                y = eptr->y + eptr->y_offset;

                if ((hw->html.border_images == True)||
                        (eptr->anchorHRef != NULL))
                {
                        extra = IMAGE_BORDER;
                }
                else
                {
                        extra = 0;
                }

                x = x - hw->html.scroll_x;
                y = y - hw->html.scroll_y;
                XSetForeground(XtDisplay(hw), hw->html.drawGC, eptr->fg);
                XSetBackground(XtDisplay(hw), hw->html.drawGC, eptr->bg);
                XFillRectangle(XtDisplay(hw->html.view),
                        XtWindow(hw->html.view), hw->html.drawGC,
                        x, y,
                        (eptr->pic_data->width + (2 * extra)),
                        extra);
                XFillRectangle(XtDisplay(hw->html.view),
                        XtWindow(hw->html.view), hw->html.drawGC,
                        x,
                        (y + eptr->pic_data->height + extra),
                        (eptr->pic_data->width + (2 * extra)),
                        extra);
                XFillRectangle(XtDisplay(hw->html.view),
                        XtWindow(hw->html.view), hw->html.drawGC,
                        x, y,
                        extra,
                        (eptr->pic_data->height + (2 * extra)));
                XFillRectangle(XtDisplay(hw->html.view),
                        XtWindow(hw->html.view), hw->html.drawGC,
                        (x + eptr->pic_data->width + extra),
                        y,
                        extra,
                        (eptr->pic_data->height + (2 * extra)));

                if (eptr->pic_data->image == (Pixmap)NULL)
                {
                        if (eptr->pic_data->image_data != NULL)
                        {
                                eptr->pic_data->image = InfoToImage(hw,
                                        eptr->pic_data);
                        }
                        else
                        {
                                eptr->pic_data->image = NoImage(hw);
                        }
                }

                if (eptr->pic_data->image != (Pixmap)NULL)
                {
                        XCopyArea(XtDisplay(hw->html.view),
                                eptr->pic_data->image,
                                XtWindow(hw->html.view), hw->html.drawGC, 0, 0,
                                eptr->pic_data->width, eptr->pic_data->height,
                                (x + extra),
                                (y + extra));
                }
        }
#endif
}

