$PACKAGE = "ATHENA";

~handles
	ATHENA
	XAW3D
	XEDW 

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"                             


~widgetClass 
asciiText
	include <X11/Xaw/AsciiText.h>

#define asciiTextAppend(w,text) { String string, newString;\
     XtVaGetValues(w, XtNstring, &string, NULL); \
     if (string) { \
          newString = XtMalloc(strlen(string) + strlen(text) +2);\
          strcpy(newString, string); \
          strcat(newString, text);  \
     } else newString = XtNewString(text); \
     XtVaSetValues(w, XtNstring, newString, NULL); \
     XtFree(newString);}

Boolean
XawAsciiSave
	in: XawTextGetSource(Widget)	# ascii text wiget

int 
XawAsciiSaveAsFile
        in: XawTextGetSource(Widget)	# ascii text wiget
        in: String			# file name

Boolean
XawAsciiSourceChanged 
	in: XawTextGetSource(Widget)	# ascii text wiget

void
XawAsciiSourceFreeString
	in: XawTextGetSource(Widget)	# ascii text wiget

void
asciiTextAppend
	in: Widget			# ascii text widget
	in: String			# string to append

~widgetClass 
box
	include <X11/Xaw/Box.h>

~widgetClass 
clock
	include <X11/Xaw/Clock.h>

~widgetClass 
command
	include <X11/Xaw/Command.h>

~widgetClass 
dialog
	include <X11/Xaw/Dialog.h>

String
XawDialogGetValueString
	in: Widget			# dialog widget

~widgetClass 
form
	include <X11/Xaw/Form.h>

#ifdef XEDW

#include "Xedw/XedwList.h"

hint: XEDW
~require
	edwlist.inc

hint: XEDW,noDoc
~widgetClass
xedwList vulgo edwList

hint: XEDW,noDoc
void
edwListChange
	in: Widget			# list widget
	const: argv[1]
	in: int				# number of items
	in: int				# longest
	in: int				# resize
	in: [args odd]			# Arg items 

hint: XEDW,noDoc
XedwListReturnStruct *
XedwListShowCurrent
	in: Widget			# edw list widget

#endif

void
XawFormDoLayout
	in: Widget			# form widget
	in: Boolean			# boolean

~widgetClass 
grip
	include <X11/Xaw/Grip.h>

~widgetClass 
label
	include <X11/Xaw/Label.h>

~widgetClass 
list
	include <X11/Xaw/List.h>
	callback i int: ((XawListReturnStruct *)callData)->list_index \
		# index
	callback s EscapedString: ((XawListReturnStruct *)callData)->string  \
		# selection

~require
list.inc

void
listAppend
	in: Widget			# list widget
	in: [args]			# items 

void
listChange
	in: Widget			# list widget
	const: argv[1]
	in: int				# number of items
	in: int				# longest
	in: int				# resize
	in: [args]			# Arg items | File filename

void
XawListHighlight
	in: Widget			# list widget
	in: int				# item number

XawListReturnStruct *
XawListShowCurrent
	in: Widget			# list widget


void
XawListUnhighlight
	in: Widget			# list widget

~widgetClass 
logo
	include <X11/Xaw/Logo.h>

~widgetClass 
mailbox
	include <X11/Xaw/Mailbox.h>

~widgetClass 
menuButton
	include <X11/Xaw/MenuButton.h>

~widgetClass 
paned
	include <X11/Xaw/Paned.h>

void
XawPanedAllowResize
	in: Widget			# paned widget
	in: Boolean			# boolean

void
XawPanedGetMinMax
	in: Widget			# paned widget
	out: int			# min
	out: int			# max

int
XawPanedGetNumSub
	in: Widget			# paned widget

void
XawPanedSetMinMax
	in: Widget			# paned widget
	in: int				# min
	in: int				# max

void 
XawPanedSetRefigureMode
	in: Widget			# paned widget
	in: Boolean			# boolean

~widgetClass 
scrollbar
	include <X11/Xaw/Scrollbar.h>
	scrollProc p int: (int)callData		# position of thumb (in pixel)
	jumpProc p float: *(float *)callData	# floating position (0.0-1.0)

void
XawScrollbarSetThumb
	in: Widget			# scrollbar widget
	in: float			# top
	in: float			# shown

~alias
	scSet stripChartSet

~widgetClass 
simple
	include <X11/Xaw/Simple.h>

~widgetClass 
simpleMenu
	include <X11/Xaw/SimpleMenu.h>
	createCmd XtCreatePopupShell

void 
XawSimpleMenuClearActiveEntry
	in: Widget			# widget

Widget
XawSimpleMenuGetActiveEntry
	in: Widget			# widget

~objectClass 
sme
	include <X11/Xaw/Sme.h>

~objectClass 
smeBSB
	include <X11/Xaw/SmeBSB.h>

~objectClass 
smeLine
	include <X11/Xaw/SmeLine.h>

~widgetClass 
stripChart
	include <X11/Xaw/StripChart.h>
	createCmd stripChartCreate

~require 
stripChart.inc

void
stripChartSet
	in: Widget			# strip chart widget
	in: double			# value

void
XawTextDisableRedisplay
	in: Widget			# ascii text wiget

void
XawTextDisplay
	in: Widget			# ascii text wiget

void
XawTextDisplayCaret
	in: Widget			# ascii text wiget
	in: Boolean			# boolean

void
XawTextEnableRedisplay
	in: Widget			# ascii text wiget

XawTextPosition
XawTextGetInsertionPoint
	in: Widget			# ascii text wiget

void 
XawTextGetSelectionPos
        in: Widget 			# ascii text wiget
        out: XawTextPosition		# varname for from position
        out: XawTextPosition 		# varname for to position

void
XawTextInvalidate
	in: Widget			# ascii text wiget
	in: XawTextPosition		# from postion
	in: XawTextPosition		# to postion

XawTextPosition
XawTextSearch
	in: Widget			# ascii text wiget
	in: XawTextScanDirection	# scan direction
	in: XawTextBlock		# text block

void
XawTextSetInsertionPoint
	in: Widget			# ascii text wiget
	in: XawTextPosition		# position

void 
XawTextSetSelection
        in: Widget 			# ascii text wiget
        in: XawTextPosition		# from position
        in: XawTextPosition 		# to position

void
XawTextSetSelectionArray
	in: Widget			# ascii text wiget
	in: [XawTextSelectType]		# selction array


int
XawTextSinkMaxHeight
	in: (Widget)TextSink 		# ascii text wiget
	in: int				# height

int
XawTextSinkMaxLines
	in: (Widget)TextSink		# ascii text wiget
	in: Dimension			# height

void
XawTextSinkSetTabs
	in: (Widget)TextSink		# ascii text wiget
	const: argc-2
	in: [int]			# tabs

XawTextPosition
XawTextSourceRead 
	in: (Widget)TextSource		# ascii text wiget
	in: XawTextPosition		# position
	out: XawTextBlock		# varname for text block
	in: int				# length

XawTextPosition
XawTextSourceScan
	in: (Widget)TextSource		# ascii text wiget
	in: XawTextPosition		# position
	in: XawTextScanType		# scan type
	in: XawTextScanDirection	# scan direction
	in: int				# count
	in: Boolean			# include (boolean)

XawTextPosition
XawTextTopPosition
	in: Widget			# ascii text wiget

(int) ReplaceVal 
XawTextReplace
        in: Widget			# ascii text wiget
        in: XawTextPosition 		# from position
        in: XawTextPosition 		# to position
        in: XawTextBlock		# text block

void 
XawTextUnsetSelection
        in: Widget 			# ascii text wiget

~widgetClass 
toggle
	include <X11/Xaw/Toggle.h>

void
XawToggleChangeRadioGroup
	in: Widget			# toggle widget
	in: NULL | Widget		# NULL | toggle widget

String
XawToggleGetCurrent
	in: Widget			# toggle widget

void
XawToggleSetCurrent
	in: Widget			# toggle widget
	in: String			# radio data

#define toggleSetRadioData(w, string) \
	XtVaSetValues(w, XtNradioData, string, NULL)

void
toggleSetRadioData
	in: Widget			# toggle widget
        in: XtNewString(String)		# radio data

void
XawToggleUnsetCurrent
	in: Widget			# toggle widget

~widgetClass 
viewport
	include <X11/Xaw/Viewport.h>

hint: R5
void
XawViewportSetCoordinates
	in: Widget			# viewport Widget
	in: Position			# x position
	in: Position			# y position

hint: R5
void
XawViewportSetLocation
	in: Widget			# viewport Widget
	in: double			# xoffset 
	in: double			# yoffset

