/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include "wafe.h"

/*
 * The following struct is used to pass information to the widget gernerating tcl-command:
 * Which WidgetClass to use and which function to generate the instance!
 */


typedef struct 
    {
    WidgetClass  wClass;
    Widget       (*fptr)();
    } wComInfo, *wComInfoPtr;


int
tclWidgetCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
    {
    int            i = 0;
    Widget         father, new;
    WidgetClass    wClass;
    Widget         (*fptr)();
    char          *name;
    char          *widgetTyp;
    ArgList        args;
    int            numArgs;
    Boolean        managed = True;
    char           *displayString = NULL;

    DBUG_ENTER("tclWidgetCommand");

    widgetTyp = *argv;
    name = *(++argv);

    wClass = ((wComInfoPtr)clientData)->wClass;
    fptr = ((wComInfoPtr)clientData)->fptr;
    argv++;
    

    /* will open shell on a different display */
    if (fptr == XtAppCreateShell)
	{
	displayString = *argv;
	}
    else
    if (!(father = name2Widget(*argv)))
	DBUG_RETURN(TCL_ERROR);
        
    argc-=3;    
    argv++;

    if (argc)
	{
	/* Enter if creation of unmanaged widget... */ 
	if (!strcmp(*argv, "unmanaged"))
	    {
	    argv++; argc--;
	    managed = False;
	    }
	
	/* Creation of managed or unmanaged widget or shell */
	/* argc must now be even  */
	if (argc % 2)
	    {
	    fprintf(stderr, "wafe(%s): Wrong # of args, %s widget %s\n", 
		    widgetTyp, managed? "managed": "unmanaged", name);
	    DBUG_RETURN (TCL_ERROR);
	    }
	}
    
    if (convert(father, wClass, argv, argc, &args, &numArgs, NULL))
	{
	if (fptr == NULL)
	    new = (managed ? XtCreateManagedWidget : XtCreateWidget)
		(name, wClass, father, args, numArgs);
	else 
	if (fptr == XtCreatePopupShell) 
	    {
	    new = XtCreatePopupShell(name, wClass, father, args, numArgs);
	    if (!managed)
		fprintf(stderr, "wafe(%s): Warning: can't create unmanaged shell; shell is managed\n", widgetTyp);
	    }
        else
	if (fptr == XtAppCreateShell) 
	    {
	    Display *dpy;
	    Cardinal null = 0;
	    Cardinal *argc = &null;
/*	    
	    fprintf(stderr,"trying to open display = <%s>\n",displayString);
*/
	    dpy = XtOpenDisplay(appContext,displayString, 
				    Nil(char), Nil(char), 
				    Nil(XrmOptionDescRec), 0, 
				    argc, Nil(String));
	    if (dpy == NULL) 
		{
		fprintf(stderr, "wafe(%s): cannot open display <%s>\n",
			widgetTyp,displayString);
		DBUG_RETURN (TCL_ERROR);
		}
	    new = XtAppCreateShell(application, appClass, wClass, dpy, 
				   args, numArgs);
	    addToEndOfWidgetList(&widgetTrees,new,XtNewString(name));
	    if (!managed)
		fprintf(stderr, "wafe(%s): Warning: cannot create unmanaged shell; shell is managed\n", widgetTyp);
	    }
	else
	    {
	    /* Use function pointer */
	    new = (*fptr)(father, name, args, numArgs);
	    if (managed) XtManageChild(new);
	    }

	MMsetAttribList(new,currentStrInfo);
/* 
    the only place where we could hide the attribListptr in
    the widget structure is the name 
 
	    {static int dummy;
             char *p;	     
	     dummy= ((strlen(new -> core.name)+5) / 4)*4;

	     fprintf(stderr,"w= <%s> len = %d, pos = %d\n",
		     new->core.name, strlen(new->core.name), dummy);
	     p = XtMalloc(dummy+sizeof(XtPointer));
	     strcpy(p,new->core.name);
	     new->core.name = p;
	     *(p+dummy) = (char *)currentStrInfo;
	    }
*/

    

#ifdef WIDGETLISTTRACE
	fprintf(stderr,"----------------------------\n");
	printWidgetList(MMwidgetListHead);
#endif

	DBUG_PRINT("widgets", ("Created %s %s widget <%s> [%p]", 
			       managed? "managed": "unmanaged",
			       widgetTyp, name, new));
	XtFree((char*)args);
	DBUG_RETURN(TCL_OK);
	}
	
    fprintf(stderr, "Couldn't create %s %s widget named <%s>\n", 
	    managed? "managed": "unmanaged",
	    widgetTyp, name);

    XtFree((char*)args);
    DBUG_RETURN(TCL_OK);
    }
       
int
warningCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
    {
    DBUG_ENTER("warningCommand");

    fprintf(stderr, 
            "Wafe(%s): This command is not available in your configuration, aborting!\n", 
	    (char *)clientData);
    exit(-1);
    }

void 
createWidgetCommand(command, wClass, fptr)
char *command;
WidgetClass wClass;
Widget (*fptr)();
    {
    wComInfoPtr  wInfoPtr;

    DBUG_ENTER("createWidgetCommand");

    if (!wClass)
	{
	Tcl_CreateCommand(interpreter, command, 
			  warningCommand, (ClientData) command, NULL);
	DBUG_PRINT("widgets",("Warning command %s created", command));
	DBUG_VOID_RETURN;
	}

    XtInitializeWidgetClass(wClass); 

    wInfoPtr = (wComInfoPtr)XtMalloc(sizeof(wComInfo));
    wInfoPtr->wClass = wClass;
    wInfoPtr->fptr = fptr;

    Tcl_CreateCommand(interpreter, command, 
		      tclWidgetCommand, (ClientData)wInfoPtr, NULL);

    DBUG_PRINT("widgets",("Command %s created", command));
    DBUG_VOID_RETURN;
    }
