#! ../wafe --f
# small example script to demonstrate 
# a form with asciiText widgets
# Gustaf Neumann  March 8, 1993

mergeResources topLevel \
	*Text*editType edit \
	*Text*displayCaret false \
	*Text*cursor top_left_arrow \
	*Form.background gray75 \
	*Label.background gainsboro \
	*Command.background gainsboro \
	*left chainLeft \
	*right chainLeft \
	*Text.right chainRight \
	*Form.right chainRight \
	*Label.width  100 \
	*Label.justify right \
	*Label.borderWidth 0

form f topLevel
  form f1 f background gainsboro 
     label     l_name f1 label "Name:"
     asciiText   name f1 fromHoriz l_name

     label     l_telephone f1 label "Telephone:" fromVert name
     asciiText   telephone f1 fromHoriz l_telephone fromVert name

     label     l_department f1 label "Department:" fromVert telephone
     asciiText   department f1 fromHoriz l_department fromVert telephone

  command quit   f callback quit fromVert f1
  command report f callback reportValues fromHoriz quit fromVert f1
realize

# initialze the field list
set fields {name telephone department}

# set field inactive or active
proc turnOff {f} { sV $f displayCaret false }
proc turnOn  {f} { sV $f displayCaret true; setKeyboardFocus f $f }

# jump to the next field from the field list
proc nextField {} { global currentField fields;
    turnOff [lindex $fields $currentField];
    set currentField [expr ($currentField+1)%[llength $fields]];
    turnOn [lindex $fields $currentField]
}

# jump to the next field from the field list
proc gotoField {f} { global currentField fields;
    turnOff [lindex $fields $currentField];
    set currentField [lsearch $fields $f];
    turnOn $f;
}

# echo all entered fields 
proc reportValues {} { global fields;
   foreach f $fields { echo value of $f is <[gV $f string]> };
   echo done;
}

# FocusIn and FocusOut are not reliable enough to set caret
# correctly if you move with the mouse pointer fast over the fields.
foreach f $fields {
   action $f override "<Key>Return: exec(nextField)";
   action $f override "<Key>Tab: exec(nextField)";
   action $f override "<Btn1Down>: exec(gotoField $f)";
   # action $f override "<FocusIn>: exec(sV $f displayCaret true)";
   # action $f override "<FocusOut>: exec(sV $f displayCaret false)";
}

# do not resize vertically
sV topLevel \
	minHeight [gV topLevel height] \
	maxHeight [gV topLevel height]

# initialze the field pointer and mark current field as active
set currentField 0
turnOn [lindex $fields $currentField]


