/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon Jan 18 04:00:58 MET 1993 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#define XT

#ifdef XT
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

#include <X11/Shell.h>
#include <X11/Xatom.h>

/* it is -*- c -*- ! */


/* used by addTimeOut */

void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");

    if (Tcl_Eval(interpreter, (char *)command, 0, NULL) == TCL_ERROR)
	fprintf(stderr, "%s\n", interpreter->result);     

    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }




char *
cvtToString(clientData, quarkOfType, freeFuncPtr)
XtPointer     clientData;
XrmQuark      quarkOfType;
freeProc      *freeFuncPtr;
    {
    char     *result;

    DBUG_PRINT("cvtToString", ("Converting to <%s>", 
			       XrmQuarkToString(quarkOfType)));

    if (quarkOfType == qString)
	{
	*freeFuncPtr = TCL_VOLATILE;
	return (char *)clientData;
	}
	
    if (quarkOfType == qInt) 
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(INT_AS_STRING);
	sprintf(result, "%d", (int)clientData);        	
	return result;
	}
    
    if (quarkOfType == qDimension)
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(INT_AS_STRING);
	sprintf(result, "%hu", (Dimension)(unsigned long)clientData);	
	return result;
	}

    if (quarkOfType == qCardinal)
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(INT_AS_STRING);
	sprintf(result, "%lu", (Cardinal)(unsigned long)clientData);	
	return result;
	}
	
    if (quarkOfType == qPosition)
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(INT_AS_STRING);
	sprintf(result, "%hd", (Position)(long)clientData);        	
	return result;
	}
/*    
    if (quarkOfType == qFloat)
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(FLOAT_AS_STRING);

	if (sizeof(float)>sizeof(XtPointer)) {
	fprintf(stderr,"groesser\n");
	    sprintf(result, "%f", (*(float *)clientData));
}
	else 
	  {
	  fprintf(stderr,"kleiner,gleich %p %f\n", 
	          clientData, (float)(long)clientData);
	  sprintf(result, "%f", (float)(long)clientData); 
	  }

	return result;
	}

    if (quarkOfType == qDouble)	
	{
	*freeFuncPtr = XtFree;
	result = XtMalloc(FLOAT_AS_STRING);

	if (sizeof(double)>sizeof(XtPointer))
	    sprintf(result, "%f", (*(double *)clientData));
	else 
	    sprintf(result, "%f", clientData);
	return result;
	}
*/
    if (quarkOfType == qBoolean)
	{
	*freeFuncPtr = TCL_STATIC;
	return (Boolean)(int)clientData ? "true" : "false";   
	}
    

        /* last ressort: if nothing helps, try "real" converter */

        {
	XrmValue          input,output;
   
	input.addr =   clientData;  /* ??? */
	input.size =   sizeof(XtPointer);     /* ??? */
	output.addr =  NULL;

	IFCONVERTANDSTORE(topLevel, 
			  XrmQuarkToString(quarkOfType),input, 
			  "String", output)
	  {
	    *freeFuncPtr = XtFree;
	    return output.addr;
	  }
       else
	 return NULL;
       }
    }


String
getValue(w, Qname, freeFuncPtr)
Widget        w;
XrmQuark      Qname;
freeProc     *freeFuncPtr;
    {
    char      *result;
    XrmQuark   Qtype;
    XtPointer  value;
    Arg        arg;

    DBUG_PRINT("getValue", ("widget is %p resource is <%s>",
			    w,XrmQuarkToString(Qname))); 

    if (!(Qtype = getQTypeOfAttribute(XtClass(w), ParentWidget(w), Qname)))
	{
	fprintf(stderr, "Wafe(getValues): Unknown Attribute %s",
		XrmQuarkToString(Qname));
	*freeFuncPtr = TCL_STATIC;
	return NULL;
	}


     /* Callbacks sind ... anders: die String-Information 
	       kommt aus wafe's privatem Memory-Management und nicht 
	       ber getValues!
	     */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *MMgetAttribList(w);
	
	*freeFuncPtr = TCL_STATIC;
	result = "";
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	}
    else
    if (Qtype == qFloat) 
	{
	float    valueFloat;
	*freeFuncPtr = XtFree;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	}
    else
    if (Qtype == qDouble) 
	{
	double    valueDouble;
	*freeFuncPtr = XtFree;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	}
    else
    if (Qtype == qWidgetList) 
        {
	Widget    *children, *wPtr;
        int        numChildren;
        int        i, length=0;
	char   *ptr;

        XtVaGetValues(w, XtNnumChildren, &numChildren,
                            XtNchildren,    &children,    NULL);
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	   {
	   length += strlen(XtName(*wPtr)) + 2;
	   }
	result = XtMalloc(length);
	*result = '\0';
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	    {
            strcat(result,XtName(*wPtr));
            strcat(result," ");
            }

        *freeFuncPtr = XtFree;  
        }
    else 
	{
/*
	XtVaGetValues(w, XrmQuarkToString(Qname), &value, NULL);
*/
	XtSetArg(arg, XrmQuarkToString(Qname), &value);
	XtGetValues(w, &arg, (Cardinal)1);

	if (!(result = cvtToString(value, Qtype, freeFuncPtr)))
	    {
	      fprintf(stderr, "Wafe(getValues): Couldn't convert value\n");
	      *freeFuncPtr = TCL_STATIC;
	      return NULL;
	    }

	DBUG_PRINT("cvtToString", ("returns <%s>",result)); 
	}
    return result;
    }


int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = getResOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  getConOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       


    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }





/* das ist ein -*- C -*- Programm */

void
realizeWidgets()
    {
    WidgetListPtr ptr = widgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    float   f;
    if (argc == 0)
	XtCallCallbacks(w, callback, NULL);
    else
	{
	if (!strcmp(argv[0], "float"))
	    {
	    sscanf(argv[1], "%f", &f);
	    XtCallCallbacks(w, callback, (XtPointer)&f);
	    }
	else
	    {
	    fprintf(stderr, "Wafe(callCallbacks): Wrong type: %s\n", argv[1]);
	    }
	}
    }


void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display;
    Window         win, root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;

    display = XtDisplay(topLevel);
    win = XtWindow(w);

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): Missing type, aborting\n");
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    fprintf(stderr, 
			    "Wafe(callActionProc): Unknown Button, %s\n", 
			    token);
		    return;
		    }
		}
	    else
		{
		fprintf(stderr, 
			"Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		fprintf(stderr, "Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): This event type can't be specified\n");
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }
 

/* 
 * void
 * XtAppAddTimeOut vulgo addTimeOut
 * 	const: appContext 
 * 	in: unsigned long		# time interval in ms
 * 	const: timerProc
 * 	in: XtNewString(String)		# tcl command
 */

int 
com_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     unsigned long localVar1;
     String localVar2;

     DBUG_ENTER("addTimeOut");  

     if (argc != 3) 
	 {
	 argcError("addTimeOut","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%lu", &localVar1)))
          {
          convError("addTimeOut","2",argv[1],"unsigned long");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtAppAddTimeOut(appContext,localVar1,timerProc,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * action
 * 	in: Widget			# widget
 * 	in: (int)TranslationModifier	# override | augment | replace
 *         in: XtTranslations		# translatontable
 */

int 
com_action(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     XtTranslations localVar3;

     DBUG_ENTER("action");  

     if (argc != 4) 
	 {
	 argcError("action","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("action","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "override")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "augment")) 
         localVar2 = 2;
     else
     if (!strcmp(argv[2], "replace")) 
         localVar2 = 3;
     else
         {
         convError("action","2",argv[2],"TranslationModifier");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(localVar3 = (XtTranslations) XtParseTranslationTable(argv[3])))
          {
          convError("action","3",argv[3],"XtTranslations");
          DBUG_RETURN (TCL_ERROR);
          }

     action(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XBell
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: int				# percent (-100 = off, 0 .. 100)
 */

int 
com_bell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("bell");  

     if (argc != 3) 
	 {
	 argcError("bell","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("bell","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("bell","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XBell(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callActionProc
 * 	in: Widget			# widget
 * 	in: String			# event type
 * 	in: String			# action
 * 	in: [args opt]			# args
 */

int 
com_callActionProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     String localVar3;

     DBUG_ENTER("callActionProc");  

     if (argc < 4) 
	 {
	 argcError("callActionProc","at least ",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callActionProc","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     argc -= 4;
     callActionProc(localVar1,argv[2],argv[3],argc,&argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * callCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback
 * 	in: [args]			# optional float and value
 */

int 
com_callCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("callCallbacks");  

     if (argc < 4) 
	 {
	 argcError("callCallbacks","at least ",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callCallbacks","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     argc -= 3;
     callCallbacks(localVar1,argv[2],argc,&argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


extern positionCallbackProc();
extern positionCursorCallbackProc();

/* 
 * void
 * callback
 * 	in: Widget			# widget
 * 	in: String			# callback resource
 *         in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
 *         in: XtNewString(String)		# string
 */

int 
com_callback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     XtCallbackProc localVar3;
     String localVar4;

     DBUG_ENTER("callback");  

     if (argc != 5) 
	 {
	 argcError("callback","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callback","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], "exec")) 
         localVar3 = (XtCallbackProc)execCallbackProc;
     else
     if (!strcmp(argv[3], "none")) 
         localVar3 = XtCallbackNone;
     else
     if (!strcmp(argv[3], "exclusive")) 
         localVar3 = XtCallbackExclusive;
     else
     if (!strcmp(argv[3], "nonexclusive")) 
         localVar3 = XtCallbackNonexclusive;
     else
     if (!strcmp(argv[3], "popdown")) 
         localVar3 = XtCallbackPopdown;
     else
     if (!strcmp(argv[3], "position")) 
         localVar3 = (XtCallbackProc)positionCallbackProc;
     else
     if (!strcmp(argv[3], "positionCursor")) 
         localVar3 = (XtCallbackProc)positionCursorCallbackProc;
     else
         {
         convError("callback","3",argv[3],"XtCallbackProc");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign  << localVar4 = argv[4] >>  */ 

     callback(localVar1,argv[2],localVar3,XtNewString(argv[4]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDestroyWidget
 * 	callmultiple
 * 		in: MMfreeGarbage(Widget)	# widgets
 */

int 
com_destroyWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("destroyWidget");  

     if (argc < 2) 
	 {
	 argcError("destroyWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("destroyWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtDestroyWidget(MMfreeGarbage(localVar1));
          }

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

/* 
 * String
 * getClass
 * 	in: Widget				# widget
 */

int 
com_getClass(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("getClass");  

     if (argc != 2) 
	 {
	 argcError("getClass","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getClass","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getClass(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * getResourceList
 * 	in: Widget				# widget
 * 	out: String *				# varname for output of reslist
 * 	end: XtFree((String)localVar2);
 */

int 
com_getResourceList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String * localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getResourceList");  

     if (argc != 3) 
	 {
	 argcError("getResourceList","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getResourceList","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getResourceList(localVar1,&localVar2);

     
     Tcl_SetVar(interpreter, argv[2], Tcl_Merge(returnVar,localVar2), 0);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     XtFree((String)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XrmQuark
 * getQTypeOfAttribute vulgo getTypeOfAttribute
 * 	in: XtClass(Widget)			# widget
 * 	const: ParentWidget(localVar1)
 * 	in: XrmStringToQuark(String)		# attribute
 */

int 
com_getTypeOfAttribute(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     XrmQuark returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getTypeOfAttribute");  

     if (argc != 3) 
	 {
	 argcError("getTypeOfAttribute","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getTypeOfAttribute","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = getQTypeOfAttribute(XtClass(localVar1),ParentWidget(localVar1),XrmStringToQuark(argv[2]));

     
     Tcl_SetResult(comInterpreter, XrmQuarkToString(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * getValue
 * 	in: Widget			# widget
 * 	in: XrmQuark			# attribute
 * 	free: freeProc
 */

int 
com_getValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark localVar2;
     freeProc localVar3;
     String returnVar;

     DBUG_ENTER("getValue");  

     if (argc != 3) 
	 {
	 argcError("getValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getValue","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XrmQuark) XrmStringToQuark(argv[2])))
          {
          convError("getValue","2",argv[2],"XrmQuark");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getValue(localVar1,localVar2,&localVar3);

     
     Tcl_SetResult(comInterpreter, returnVar, localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabPointer
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 *         const: NoEventMask
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync             # keyboard mode (sync | async)
 * 	in: None | XtWindow(Widget)	# None | confine widget
 * 	const: None
 * 	const: CurrentTime
 */

int 
com_grabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     Widget localVar5;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabPointer");  

     if (argc != 6) 
	 {
	 argcError("grabPointer","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabPointer","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabPointer","4",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabPointer","5",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[5], "None")) 
         localVar5 = None;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("grabPointer","6",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XtGrabPointer(localVar1,localVar2,NoEventMask,localVar3,localVar4,XtWindow(localVar5),None,CurrentTime);

          if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabKeyboard
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync		# keyboard mode (sync | async)
 * 	const: CurrentTime
 */

int 
com_grabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabKeyboard");  

     if (argc != 5) 
	 {
	 argcError("grabKeyboard","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabKeyboard","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","3",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","4",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XtGrabKeyboard(localVar1,localVar2,localVar3,localVar4,CurrentTime);

          if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define installAccelerators(destination,source,table) { XtVaSetValues(source, XtNaccelerators, table, NULL); XtInstallAccelerators(destination, source);}

/* 
 * void
 * installAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 * 	in: XtAccelerators		# table
 */

int 
com_installAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     XtAccelerators localVar3;

     DBUG_ENTER("installAccelerators");  

     if (argc != 4) 
	 {
	 argcError("installAccelerators","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("installAccelerators","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("installAccelerators","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = (XtAccelerators) XtParseAcceleratorTable(argv[3])))
          {
          convError("installAccelerators","3",argv[3],"XtAccelerators");
          DBUG_RETURN (TCL_ERROR);
          }

     installAccelerators(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtManageChild
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_manageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("manageChild");  

     if (argc < 2) 
	 {
	 argcError("manageChild","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("manageChild","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtManageChild(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtMapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_mapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("mapWidget");  

     if (argc < 2) 
	 {
	 argcError("mapWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("mapWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtMapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


#define mergeResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2) XrmPutStringResource(&newDb, v[i], v[i+1]); XrmMergeDatabases(newDb, &dispDb);}

/* 
 * void 
 * mergeResources
 * 	in: Widget			# widget to determine display
 * 	in: [args even] 		# resource value pairs
 */

int 
com_mergeResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mergeResources");  

     if (argc < 3 && (argc-2) % 2) 
	 {
	 argcError("mergeResources","even number of arguments and at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mergeResources","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     mergeResources(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopdown
 *         in: Widget			# shell widget
 */

int 
com_popdown(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popdown");  

     if (argc != 2) 
	 {
	 argcError("popdown","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popdown","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopdown(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopup
 *         in: Widget			# widget
 *         in: XtGrabKind			# none | nonexclusive | exclusive
 */

int 
com_popup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtGrabKind localVar2;

     DBUG_ENTER("popup");  

     if (argc != 3) 
	 {
	 argcError("popup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "none")) 
         localVar2 = XtGrabNone;
     else
     if (!strcmp(argv[2], "nonexclusive")) 
         localVar2 = XtGrabNonexclusive;
     else
     if (!strcmp(argv[2], "exclusive")) 
         localVar2 = XtGrabExclusive;
     else
         {
         convError("popup","2",argv[2],"XtGrabKind");
         DBUG_RETURN (TCL_ERROR);
        }


     XtPopup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopupSpringLoaded
 *         in: Widget			# shell widget
 */

int 
com_popupSpringLoaded(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popupSpringLoaded");  

     if (argc != 2) 
	 {
	 argcError("popupSpringLoaded","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popupSpringLoaded","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopupSpringLoaded(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * realizeWidgets vulgo realize
 */

int 
com_realize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("realize");  

     if (argc != 1) 
	 {
	 argcError("realize","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     realizeWidgets();

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRemoveAllCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback name
 */

int 
com_removeAllCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("removeAllCallbacks");  

     if (argc != 3) 
	 {
	 argcError("removeAllCallbacks","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("removeAllCallbacks","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtRemoveAllCallbacks(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetKeyboardFocus
 * 	in: Widget			# from widget tree
 * 	in: None|Widget			# to widget | None
 */

int 
com_setKeyboardFocus(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("setKeyboardFocus");  

     if (argc != 3) 
	 {
	 argcError("setKeyboardFocus","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setKeyboardFocus","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "None")) 
         localVar2 = None;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("setKeyboardFocus","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtSetKeyboardFocus(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define setValues(w,argc,argv) {ArgList           args; int               numArgs; if (convert(ParentWidget(w), XtClass(w), argv, argc, &args, &numArgs, w)) { XtSetValues(w, args, numArgs); XtFree((String)args); } }

/* 
 * void
 * setValues
 * 	in: Widget			# widget
 * 	in: [args even]			# resource value pairs
 */

int 
com_setValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("setValues");  

     if (argc < 3 && (argc-2) % 2) 
	 {
	 argcError("setValues","even number of arguments and at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setValues","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     setValues(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#define ptr(w) &(w)

/* 
 * Boolean 
 * XSetWMProtocols
 * 	const: XtDisplay(localVar1)
 * 	in: XtWindow(Widget)		# Shell Widget
 * 	in: ptr((Atom)WM_PROTOCOLS)	# WM\_TAKE\_FOCUS | WM\_SAVE\_YOURSELF | WM\_DELETE\_WINDOW
 * 	const: 1
 */

int 
com_setWMProtocols(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("setWMProtocols");  

     if (argc != 3) 
	 {
	 argcError("setWMProtocols","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setWMProtocols","2",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "WM_TAKE_FOCUS")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_TAKE_FOCUS",False);
     else
     if (!strcmp(argv[2], "WM_SAVE_YOURSELF")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_SAVE_YOURSELF",False);
     else
     if (!strcmp(argv[2], "WM_DELETE_WINDOW")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_DELETE_WINDOW",False);
     else
         {
         convError("setWMProtocols","3",argv[2],"WM_PROTOCOLS");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XSetWMProtocols(XtDisplay(localVar1),XtWindow(localVar1),ptr(localVar2),1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtTranslateCoords
 * 	in: Widget			# widget
 * 	in: Position    		# widget x
 * 	in: Position    		# widget y
 * 	out: Position   		# variable name for root x
 * 	out: Position   		# variable name for root y
 */

int 
com_translateCoords(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("translateCoords");  

     if (argc != 6) 
	 {
	 argcError("translateCoords","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("translateCoords","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("translateCoords","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("translateCoords","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XtTranslateCoords(localVar1,localVar2,localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(interpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);
     Tcl_SetVar(interpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabPointer
 * 	in: Widget			# widget with active pointer grab
 * 	const: CurrentTime
 */

int 
com_ungrabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabPointer");  

     if (argc != 2) 
	 {
	 argcError("ungrabPointer","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabPointer(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabKeyboard
 * 	in: Widget			# widget with active keyboard grab
 * 	const: CurrentTime
 */

int 
com_ungrabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabKeyboard");  

     if (argc != 2) 
	 {
	 argcError("ungrabKeyboard","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabKeyboard(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmanageChild
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_unmanageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unmanageChild");  

     if (argc < 2) 
	 {
	 argcError("unmanageChild","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unmanageChild","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnmanageChild(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnmapWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_unmapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unmapWidget");  

     if (argc < 2) 
	 {
	 argcError("unmapWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unmapWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnmapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnrealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

int 
com_unrealizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unrealizeWidget");  

     if (argc < 2) 
	 {
	 argcError("unrealizeWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unrealizeWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnrealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDisownSelection
 * 	const: topLevel
 * 	const: XA_PRIMARY
 * 	const: CurrentTime
 */

int 
com_disownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("disownSelection");  

     if (argc != 1) 
	 {
	 argcError("disownSelection","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     XtDisownSelection(topLevel,XA_PRIMARY,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


extern void getSelectionValueProc();

/* 
 * void
 * XtGetSelectionValue
 * 	const: topLevel
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	const: getSelectionValueProc
 * 	in: XtNewString(String)		# Tcl command
 * 	const: CurrentTime
 */

int 
com_getSelectionValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;

     DBUG_ENTER("getSelectionValue");  

     if (argc != 2) 
	 {
	 argcError("getSelectionValue","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     XtGetSelectionValue(topLevel,XA_PRIMARY,XA_STRING,getSelectionValueProc,XtNewString(argv[1]),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * ownSelection
 * 	in: XtNewString(String) # string to be put into selection
 * 	in: NULL | String 	# NULL | loseSelection TCL-command
 * 	in: NULL | String 	# NULL | doneSelection TCL-command
 */

int 
com_ownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;
     String localVar2;
     String localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("ownSelection");  

     if (argc != 4) 
	 {
	 argcError("ownSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         localVar2 = argv[2];
     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     returnVar = ownSelection(XtNewString(argv[1]),localVar2,localVar3);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XFetchBytes
 * 	pre: { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime); 
 * 	in: XtDisplay(Widget) 		# widget to determine display
 *         const:  &bytes
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBytes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("fetchBytes");  

     if (argc != 2) 
	 {
	 argcError("fetchBytes","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("fetchBytes","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime);
     returnVar = XFetchBytes(XtDisplay(localVar1),&bytes);
     }

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XConvertSelection
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	in: Atom			# target buffer number
 * 	const: DefaultRootWindow(XtDisplay(topLevel))
 * 	const: CurrentTime
 */

int 
com_convertSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;

     DBUG_ENTER("convertSelection");  

     if (argc != 3) 
	 {
	 argcError("convertSelection","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("convertSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "0")) 
         localVar2 = XA_CUT_BUFFER0;
     else
     if (!strcmp(argv[2], "1")) 
         localVar2 = XA_CUT_BUFFER1;
     else
     if (!strcmp(argv[2], "2")) 
         localVar2 = XA_CUT_BUFFER2;
     else
     if (!strcmp(argv[2], "3")) 
         localVar2 = XA_CUT_BUFFER3;
     else
     if (!strcmp(argv[2], "4")) 
         localVar2 = XA_CUT_BUFFER4;
     else
     if (!strcmp(argv[2], "5")) 
         localVar2 = XA_CUT_BUFFER5;
     else
     if (!strcmp(argv[2], "6")) 
         localVar2 = XA_CUT_BUFFER6;
     else
         {
         convError("convertSelection","4",argv[2],"Atom");
         DBUG_RETURN (TCL_ERROR);
        }


     XConvertSelection(XtDisplay(localVar1),XA_PRIMARY,XA_STRING,localVar2,DefaultRootWindow(XtDisplay(topLevel)),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XStoreBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	in: String			# String
 * 	const: strlen(argv[1])
 * 	in: int				# buffer number (1-7)
 */

int 
com_storeBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     int localVar3;

     DBUG_ENTER("storeBuffer");  

     if (argc != 4) 
	 {
	 argcError("storeBuffer","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("storeBuffer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("storeBuffer","4",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XStoreBuffer(XtDisplay(localVar1),argv[2],strlen(argv[1]),localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XFetchBuffer
 * 	in: XtDisplay(Widget)		# widget to determine display
 * 	const: &nbytes
 * 	in: int				# buffer number (1-7)
 * 	pre: {int nbytes;
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     String returnVar;

     DBUG_ENTER("fetchBuffer");  

     if (argc != 3) 
	 {
	 argcError("fetchBuffer","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("fetchBuffer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("fetchBuffer","3",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     {int nbytes;
     returnVar = XFetchBuffer(XtDisplay(localVar1),&nbytes,localVar2);
     }

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* yes buddy, it is a -*- c -*- program! */

 /*
    * This file contains a new converter procedure and xpm support procedures:
    *
    *    A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    */ 


#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>

 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual!
  * Note that setting a pixmap with setValues therefore implies loosing these 
  * colorcells for the application's lifetime!
  */

typedef struct _PixmapInfo
     {
     Pixmap                pm;              /* Pixmap              */
     Widget                widget;          /* Widget              */
     XpmAttributes         *attribPtr;      /* Colorcells, etc     */
     char                 *pmName;          /* The filename..      */
     struct _PixmapInfo   *next;
     }  PIXMAPINFO, *PIXMAPINFOPTR;

PIXMAPINFOPTR  pixmapListHead = NULL;



void
changePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap        cmap;
    Pixmap          death, pixmap, mask;
    Screen         *screen;
    Display        *dpy;
    int             screenNum;
    int             returnVal;
    unsigned int    depth;
    XpmAttributes  *attribPtr;
    PIXMAPINFOPTR   pptr, cptr;
    
    dpy = XtDisplay(w);
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    depth = DefaultDepth(dpy, DefaultScreen(dpy));

    /* Get pixmap adress and colormap of the pixmap, which will be destroyed  */
    
    XtVaGetValues(w, resource,     &death, 
		  XtNcolormap, &cmap, NULL);

  /* Search the list of pixmaps to find out wether the specified pixmap's 
      * resources are to be freed - which is the case when it was created by
      * this procedure.
      */

    if (pixmapListHead)
	{
	for (pptr = pixmapListHead; pptr != NULL; pptr = pptr->next)
	    {
	    if ((pptr->pm == death) && (pptr->widget == w))
		{
		if (!strcmp(pptr->pmName, fname))
		    {
		    DBUG_PRINT("pixmap",
			       ("You are about to set the same pixmap!"));
		    return;
		    }

		/* Set pixmap to "None" => destroying will be save */
		XtVaSetValues(w, resource, None, NULL);

		/* Take destroyed Pixmap from pixmaplist and deallocate memory */
		DBUG_PRINT("pixmap",
			   ("found pixmap %s of widget %s, %d colors freed", 
			    resource, XtName(w), pptr->attribPtr->npixels));

		XFreePixmap(XtDisplay(w), death);
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(XtDisplay(w), cmap, pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);

		XpmFreeAttributes(pptr->attribPtr);

		DBUG_PRINT("pixmap", ("Managing the List"));
		if (pptr == pixmapListHead)
		    {
		    XtFree((char *)pixmapListHead);
		    pixmapListHead = NULL;
		    }
		else
		    {
		    for(cptr = pixmapListHead; 
			cptr->next != pptr; 
			cptr = cptr->next);
		    
		    if (pptr->next == NULL)     /* last Pixmap in list */
			cptr->next = NULL;
		    else                        /* not last Pixmap in list */
			cptr->next = pptr->next;

		    XtFree((char *)pptr);
		    }
		}
	    }
	}

    /* If the new pixmap's filename is None, => don't create new entry. */

    if (!strcmp(fname, "None"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to None", XtName(w), resource));
	XtVaSetValues(w, resource, None, NULL);
	return;
	}
    if (!strcmp(fname, "Unspecified"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to Unspecified", XtName(w), resource));
	XtVaSetValues(w, resource, XtUnspecifiedPixmap, NULL);
	return;
	}
    if (!strcmp(fname, "ParentRelative"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to ParentRelative", XtName(w), resource));
	XtVaSetValues(w, resource, ParentRelative, NULL);
	return;
	}

    /* Now convert the new Pixmap-File, create a new element of the list 
         * and fill it with information.
         */

    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attribPtr->depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(XtDisplay(w)));

    returnVal = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
				    fname, &pixmap, &mask, attribPtr); 

    if (returnVal == XpmSuccess)
	{
	if (!pixmapListHead)   /* First Pixmap */
	    {
	    cptr = 
		pixmapListHead = 
		    (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    pixmapListHead->next = NULL;
	    }
	else
	    {
	    for(cptr = pixmapListHead; cptr->next != NULL; cptr = cptr->next);
	    cptr->next = (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    cptr = cptr->next;
	    cptr->next = NULL;
	    }

	cptr->widget = w;
	cptr->pm = pixmap;
	cptr->pmName = XtNewString(fname);
	cptr->attribPtr = attribPtr;

	DBUG_PRINT("pixmap", 
		   ("%d colorcells are used for %s\n", 
		    cptr->attribPtr->npixels, cptr->pmName));
     
	XtVaSetValues(w, resource, pixmap, NULL);

	if XtWindow(w) 
	      XShapeCombineMask(XtDisplay(w), XtWindow(w), ShapeBounding,
			      0, 0, mask, ShapeSet);

	DBUG_PRINT("pixmap", ("Conversion OK, new Pixmap was set"));
	return;
	}
    else
	{
	fprintf(stderr, "Wafe(changePixmap): Couldn't convert\n");
	XpmFreeAttributes(attribPtr);
	return;
	}
    }     

void
setIconPixmap(w,fname)
Widget   w;
String   fname;
    {
    Window        iconWindow;
    Pixmap        pixmap, mask;
    int           iconWidth, iconHeight;
    XpmAttributes attrib;
    Window        root;
    Display      *dpy;
    Pixel         bpix;

    dpy = XtDisplay(w);
    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));
    attrib.valuemask = XpmReturnInfos;

    if (XpmReadFileToPixmap(dpy, root, fname, &pixmap, &mask, &attrib) 
	!= XpmSuccess)
	{
	fprintf(stderr, "Wafe(setIconPixmap): couldn't convert %s to pixmap\n",
		fname);
	return;
	}
    
    iconWidth = attrib.width;
    iconHeight = attrib.height;
    iconWindow = XCreateSimpleWindow(dpy, root, 0, 0, 
				     iconWidth, iconHeight, 1, bpix, bpix);

    XSetWindowBackgroundPixmap(dpy, iconWindow, pixmap);
    XShapeCombineMask(dpy, iconWindow, ShapeBounding,
			  0, 0, mask, ShapeSet);
    
    XtVaSetValues(w, XtNiconWindow, iconWindow, NULL);
    return;
    }


#define done(address, type) \
        { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }
               

Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    Pixmap           dummy;
    char            *name;
    Screen          *screen;
    int              screenNum;
    XrmDatabase      db;
    String           fn;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    XpmAttributes   *attributePtr;
    int              returnValue;
    PIXMAPINFOPTR    pptr, cptr;
    Boolean          toPixmap = *num_args>0;

    pixmap = NULL;
    name   = (char *)fromVal->addr;
/*    
    fprintf(stderr,"i am converting <%s> to %s\n",   
	  name, toPixmap ? "Pixmap" : "Bitmap");
 */
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    
    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        done(&pixmap, Pixmap);
        return True;
        }

    if (strcmp(name, "ParentRelative") == 0 && toPixmap) 
        {
        pixmap = ParentRelative;
        done(&pixmap, Pixmap);
        return True;
        }

    if (strcmp(name, "Unspecified") == 0 && toPixmap) 
        {
        pixmap = XtUnspecifiedPixmap;
        done(&pixmap, Pixmap);
        return True;
        }

    if (!toPixmap)
	pixmap = XmuLocateBitmapFile(screen, name,
				     NULL, 0, NULL, NULL, NULL, NULL);

#ifndef PRER5

    if (pixmap == None) 
        {
        db = XrmGetDatabase(dpy);
        XrmSetDatabase(dpy, XtScreenDatabase(screen));
        fn = XtResolvePathname(dpy, "bitmaps", name, "", NULL, NULL, 0, NULL);
        if (!fn)
            fn = XtResolvePathname(dpy, "", name, ".xbm", NULL, NULL, 0, NULL);
	/* fprintf(stderr,"read bitmap from <%s>  <%s>\n",fn,name); */
	XrmSetDatabase(dpy, db);
	/* fprintf(stderr,"read bitmap from <%s>  <%s>\n",fn,name); */
	if (fn &&
	    XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess) 
	    {
	    pixmap = XCreatePixmapFromBitmapData(dpy,
				 RootWindowOfScreen(screen),
				 (char *) data, width, height, 1, 0, 
				 DefaultDepth(dpy, DefaultScreen(dpy)));
	    XFree((char *)data);
            XtFree(fn);
	    }
        }
#endif

    if (pixmap != None) 
        {
	/* fprintf(stderr,"must be a bitmap x%p\n", pixmap); */
        done (&pixmap, Pixmap);
	return True;
        } 
    else 
        {
        if ((returnValue = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum),
				name, &pixmap, &dummy, NULL)) != XpmSuccess)
	    {
	    XtStringConversionWarning(name, "Pixmap");
	    fprintf(stderr, "Wafe(convertPixmap): XPM-Error-Code: %d\n", 
		    returnValue);
	    return False;
	    }
        else 
	    {
/*	    fprintf(stderr, "the pixmap is... %p\n", pixmap);*/
	    done (&pixmap, Pixmap);
	    return True;
	    }
	}
#endif
    }





/* 
 * hint: XPM
 * void
 * setIconPixmap
 * 	in: Widget			# Shell Widget (eg topLevel)
 * 	in: String			# pixmap file
 */
#ifdef XPM

int 
com_setIconPixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("setIconPixmap");  

     if (argc != 3) 
	 {
	 argcError("setIconPixmap","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setIconPixmap","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     setIconPixmap(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: XPM
 * void
 * changePixmap
 * 	in: Widget			# widget
 * 	in: String			# resource
 * 	in: String			# pixmap file

 */
#ifdef XPM

int 
com_changePixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     String localVar3;

     DBUG_ENTER("changePixmap");  

     if (argc != 4) 
	 {
	 argcError("changePixmap","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("changePixmap","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     changePixmap(localVar1,argv[2],argv[3]);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#else
#include <string.h>
#endif

void
Initialize_XtGen()
{
#ifdef XT
 createWidgetCommand("applicationShell",applicationShellWidgetClass,XtAppCreateShell);
 createWidgetCommand("overrideShell",overrideShellWidgetClass,XtCreatePopupShell);
 createWidgetCommand("topLevelShell",topLevelShellWidgetClass,XtCreatePopupShell);
 createWidgetCommand("transientShell",transientShellWidgetClass,XtCreatePopupShell);
#ifdef XPM
 strcat(packages,"XPM ");
#endif
 Tcl_CreateCommand(interpreter, "addTimeOut", com_addTimeOut, NULL, NULL);
 Tcl_CreateCommand(interpreter, "action", com_action, NULL, NULL);
 Tcl_CreateCommand(interpreter, "bell", com_bell, NULL, NULL);
 Tcl_CreateCommand(interpreter, "callActionProc", com_callActionProc, NULL, NULL);
 Tcl_CreateCommand(interpreter, "callCallbacks", com_callCallbacks, NULL, NULL);
 Tcl_CreateCommand(interpreter, "callback", com_callback, NULL, NULL);
 Tcl_CreateCommand(interpreter, "destroyWidget", com_destroyWidget, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getClass", com_getClass, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getResourceList", com_getResourceList, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getTypeOfAttribute", com_getTypeOfAttribute, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getValue", com_getValue, NULL, NULL);
 Tcl_CreateCommand(interpreter, "grabPointer", com_grabPointer, NULL, NULL);
 Tcl_CreateCommand(interpreter, "grabKeyboard", com_grabKeyboard, NULL, NULL);
 Tcl_CreateCommand(interpreter, "installAccelerators", com_installAccelerators, NULL, NULL);
 Tcl_CreateCommand(interpreter, "manageChild", com_manageChild, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mapWidget", com_mapWidget, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mergeResources", com_mergeResources, NULL, NULL);
 Tcl_CreateCommand(interpreter, "popdown", com_popdown, NULL, NULL);
 Tcl_CreateCommand(interpreter, "popup", com_popup, NULL, NULL);
 Tcl_CreateCommand(interpreter, "popupSpringLoaded", com_popupSpringLoaded, NULL, NULL);
 Tcl_CreateCommand(interpreter, "realize", com_realize, NULL, NULL);
 Tcl_CreateCommand(interpreter, "removeAllCallbacks", com_removeAllCallbacks, NULL, NULL);
 Tcl_CreateCommand(interpreter, "setKeyboardFocus", com_setKeyboardFocus, NULL, NULL);
 Tcl_CreateCommand(interpreter, "setValues", com_setValues, NULL, NULL);
 Tcl_CreateCommand(interpreter, "setWMProtocols", com_setWMProtocols, NULL, NULL);
 Tcl_CreateCommand(interpreter, "translateCoords", com_translateCoords, NULL, NULL);
 Tcl_CreateCommand(interpreter, "ungrabPointer", com_ungrabPointer, NULL, NULL);
 Tcl_CreateCommand(interpreter, "ungrabKeyboard", com_ungrabKeyboard, NULL, NULL);
 Tcl_CreateCommand(interpreter, "unmanageChild", com_unmanageChild, NULL, NULL);
 Tcl_CreateCommand(interpreter, "unmapWidget", com_unmapWidget, NULL, NULL);
 Tcl_CreateCommand(interpreter, "unrealizeWidget", com_unrealizeWidget, NULL, NULL);
 Tcl_CreateCommand(interpreter, "disownSelection", com_disownSelection, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getSelectionValue", com_getSelectionValue, NULL, NULL);
 Tcl_CreateCommand(interpreter, "ownSelection", com_ownSelection, NULL, NULL);
 Tcl_CreateCommand(interpreter, "fetchBytes", com_fetchBytes, NULL, NULL);
 Tcl_CreateCommand(interpreter, "convertSelection", com_convertSelection, NULL, NULL);
 Tcl_CreateCommand(interpreter, "storeBuffer", com_storeBuffer, NULL, NULL);
 Tcl_CreateCommand(interpreter, "fetchBuffer", com_fetchBuffer, NULL, NULL);
 /* alias */  Tcl_CreateCommand(interpreter,"sV",com_setValues, NULL,NULL);
 /* alias */  Tcl_CreateCommand(interpreter,"gV",com_getValue, NULL,NULL);
#ifdef XPM
 { static XtConvertArgRec argRec = 
	{XtImmediate,(XtPointer)True,sizeof(Boolean)};

 XtSetTypeConverter(XtRString, XtRPixmap,
	(XtTypeConverter)CvtStringToPixmapOrBitmap, 
	&argRec, 1, XtCacheByDisplay, NULL);
 }
#endif
#ifdef XPM
 XtSetTypeConverter(XtRString, XtRBitmap,
	(XtTypeConverter)CvtStringToPixmapOrBitmap, 
	NULL, 0, XtCacheByDisplay, NULL);
#endif
#ifdef XPM
 Tcl_CreateCommand(interpreter, "setIconPixmap", com_setIconPixmap, NULL, NULL);
#endif
#ifdef XPM
 Tcl_CreateCommand(interpreter, "changePixmap", com_changePixmap, NULL, NULL);
#endif

#else
#endif
}
