/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon Jan 18 04:01:50 MET 1993 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef XMGRAPH
#include <stdio.h>

#include <X11/StringDefs.h>
#include <Xm/Xm.h>

#include "wafe.h"

#include <Graph.h>
#include <Arc.h>
/* 
 * void
 * XmArcGetPos
 * 	in: Widget		# name of arc Widget
 * 	out: Position		# out: x1
 * 	out: Position		# out: y1
 * 	out: Position		# out: x2
 * 	out: Position		# out: y2
 */

int 
com_mArcGetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("mArcGetPos");  

     if (argc != 6) 
	 {
	 argcError("mArcGetPos","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mArcGetPos","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmArcGetPos(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar2);
     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(interpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(interpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);
     Tcl_SetVar(interpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


#include <Graph.h>
#else
#include <string.h>
#endif

void
Initialize_XmGraphGen()
{
#ifdef XMGRAPH
 createWidgetCommand("mArc",xmArcWidgetClass,NULL);
 createWidgetCommand("mGraph",xmGraphWidgetClass,NULL);
 createWidgetCommand("mScrolledGraph",xmGraphWidgetClass,XmCreateScrolledGraph);
#ifdef XMGRAPH
 strcat(packages,"XMGRAPH ");
#endif
 Tcl_CreateCommand(interpreter, "mArcGetPos", com_mArcGetPos, NULL, NULL);

#else
#endif
}
