/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Mon Jan 18 04:01:28 MET 1993 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef ATHENAR5
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Repeater.h>

extern void portholeCallbackProc();
extern void pannerCallbackProc();

#define talk(pa, po, ch) XtAddCallback(po, XtNreportCallback, portholeCallbackProc, (XtPointer) pa); XtAddCallback(pa, XtNreportCallback, pannerCallbackProc, (XtPointer) ch)

/* 
 * void
 * talk
 * 	in: Widget		# panner
 * 	in: Widget		# porthole
 * 	in: Widget		# managed widget
 */

int 
com_talk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER("talk");  

     if (argc != 4) 
	 {
	 argcError("talk","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("talk","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("talk","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("talk","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     talk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTreeForceLayout
 * 	in: Widget		# tree Widget

 */

int 
com_treeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("treeForceLayout");  

     if (argc != 2) 
	 {
	 argcError("treeForceLayout","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("treeForceLayout","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_XawR5Gen()
{
#ifdef ATHENAR5
 createWidgetCommand("panner",pannerWidgetClass,NULL);
 createWidgetCommand("porthole",portholeWidgetClass,NULL);
 createWidgetCommand("repeater",repeaterWidgetClass,NULL);
 createWidgetCommand("tree",treeWidgetClass,NULL);
#ifdef XAWR5
 strcat(packages,"XAWR5 ");
#endif
 Tcl_CreateCommand(interpreter, "talk", com_talk, NULL, NULL);
 Tcl_CreateCommand(interpreter, "treeForceLayout", com_treeForceLayout, NULL, NULL);

#else
createWidgetCommand("panner",NULL,NULL);
createWidgetCommand("porthole",NULL,NULL);
createWidgetCommand("repeater",NULL,NULL);
createWidgetCommand("tree",NULL,NULL);
#endif
}
