/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sat Oct  3 22:26:43 MET 1992 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#define MISC

#ifdef MISC
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "wafe.h"

/*   this is also -*- C -*- */

#include "rdd.h"

char              *communicationHandlerVarname = NULL;
char              *communicationHandlerCommand = NULL;
int                communicationHandlerLength = 0;
int                communicationCount = 0;

char               inputBuffer[BUF_SIZE+1];
int                leftBytes = 0;      


void
getInput(client_data, fid, xid)
XtPointer   client_data;          /* PromptMode True oder False  */
int         *fid;
XtInputId   *xid;
    {
    char   *bufferPtr = inputBuffer + leftBytes;
    char   *firstPtr = inputBuffer;
    char   *secondPtr = inputBuffer;
    int     readBytes;
    Boolean overFlowFlag = True;

    DBUG_ENTER("getInput");

    if ((readBytes = read(*fid, bufferPtr, BUF_SIZE - leftBytes)) == -1)
	perror("Wafe: Communication error: ");

    *(bufferPtr + readBytes) = '\0';
    leftBytes = 0;

    DBUG_PRINT("socketAll", 
               ("BufferContents are:\n>>%s<<", bufferPtr));     

    if (!readBytes)
	{
	fprintf(stderr, "Wafe: EOF-Condition on fromClient - Channel\n");
	exit(1);
	}    
 
    do
	{
	while ((*firstPtr != '\n') && (*firstPtr != '\0'))
	    *firstPtr++;

	if (*firstPtr == '\n')
	    {
	    *firstPtr = '\0';     /* One tcl-command is ready */
	    
	    overFlowFlag = False;

	    DBUG_PRINT("socket", 
		       ("Parsed Command >%s<", secondPtr));

	    if (client_data)      /* Standard Mode - prompt character is checked */
		{               
		if (*secondPtr == promptChar) 
		    {
		    if(Tcl_Eval(interpreter,secondPtr+1,0,NULL) == TCL_ERROR)
			fprintf(stderr, "%s\n", interpreter->result);
		    }
		else 
		    {
		    if (tclHandlers[STDOUT])
			{                    
			Tcl_SetVar(interpreter, "STDOUT", secondPtr, 
				   TCL_GLOBAL_ONLY);

			if (Tcl_Eval(interpreter, tclHandlers[STDOUT], 
				     0, NULL) == TCL_ERROR)
			    fprintf(stderr, "%s\n", interpreter->result);
			}
		    else
			fprintf(stdout, "%s\n", secondPtr);	 
		    }
		} 
	    else                  /* Don't look for Prompt character */  
		{                 
		if (Tcl_Eval(interpreter, secondPtr, 0, NULL) == TCL_ERROR)
		    fprintf(stderr, "%s\n", interpreter->result);
		}
	    
	    firstPtr++;
	    
	    if (*firstPtr == '\0')      
		{
		DBUG_VOID_RETURN;
		}
	    else
		secondPtr = firstPtr;                  
	    }
	} while (*firstPtr != '\0');

    if (overFlowFlag)
	{
	fprintf(stderr, "Wafe(main): Uncomplete command or communication buffer overflow, >%s<\n", secondPtr);
	exit(-1);
	}

     /* if this one is the last command in the buffer and
      * it is not terminated with a \n => do buffering 
      */

    DBUG_PRINT("socket", ("uncomplete command : %s", secondPtr)); 

    strcpy(inputBuffer, secondPtr);
    leftBytes = strlen(secondPtr);

    DBUG_VOID_RETURN;
    }


void
stdinHandlerProc(client_data, fid, xid)
XtPointer   client_data; /* Prompt-Mode: True oder False */
int         *fid;
XtInputId   *xid;
    {
    int     readBytes;
    char    stdinBuffer[STDIN_BUF_SIZE];

    DBUG_ENTER("getInputFromStdin");

    if ((readBytes = read(*fid, stdinBuffer, STDIN_BUF_SIZE)) == -1)
	perror("getInput");

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		   ("EOF - condition on stdin"));
	DBUG_VOID_RETURN;
	}

    if (tclHandlers[STDIN])
	{
	Tcl_SetVar(interpreter, "STDIN", stdinBuffer, TCL_GLOBAL_ONLY);
	
	if (Tcl_Eval(interpreter, tclHandlers[STDIN], 0, NULL) 
	    == TCL_ERROR)
	    fprintf(stderr, "%s\n", interpreter->result);
	}
    else
	write(toClient, stdinBuffer, readBytes);

    DBUG_VOID_RETURN;
    }


void
stderrHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
    {   
    int     readBytes;
    char    stderrBuffer[STDERR_BUF_SIZE];

    DBUG_ENTER("stderrHandlerProc");

    if ((readBytes = read(*fid, stderrBuffer, STDERR_BUF_SIZE)) == -1)
	perror("stderrHandlerProc");

    *(stderrBuffer + readBytes) = '\0';

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		   ("EOF - condition on stderr"));
	DBUG_VOID_RETURN;
	}

    if (tclHandlers[STDERR])
	{
	Tcl_SetVar(interpreter, "STDERR", stderrBuffer, TCL_GLOBAL_ONLY);
	
	if (Tcl_Eval(interpreter, tclHandlers[STDERR],
		     0, NULL) == TCL_ERROR)
	    fprintf(stderr, "%s\n", interpreter->result);
	}
    else
	fprintf(stderr, "%s", stderrBuffer);

    DBUG_VOID_RETURN;
    }



void
communicationHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
    {   
    int     readBytes;
    char    localComBuffer[COMBUFSIZE+1];

    DBUG_ENTER("communicationHandlerProc");
    
    if ((readBytes = read(*fid, localComBuffer, COMBUFSIZE)) == -1)
	perror("communicationHandlerProc");

#ifdef TUNNELDEBUG
    fprintf(stderr, "HandlerProc: I read %d Bytes\n", readBytes); 
#endif

    *(localComBuffer + readBytes) = '\0';

    communicationCount += readBytes;

#ifdef TUNNELDEBUG
    fprintf(stderr, "HandlerProc: This makes now %d Bytes total\n", 
	    communicationCount); 
#endif

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		     ("EOF - condition on communication channel"));
	DBUG_VOID_RETURN;
	}

    if (!comBuffer)
	{
	comBuffer = XtNewString(localComBuffer);
	}
    else
	{
	comBuffer = XtRealloc(comBuffer, strlen(comBuffer) + readBytes + 1);
	strcat(comBuffer, localComBuffer);
	}
    
    if ((communicationHandlerCommand) && (communicationHandlerLength <= communicationCount))
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "HandlerProc: we got it %d <= %d, executing %s\n", 
		communicationHandlerLength, communicationCount,
		communicationHandlerCommand); 
#endif
	if (!comBuffer)
	    Tcl_SetVar(interpreter, communicationHandlerVarname, "", TCL_GLOBAL_ONLY);
	else
	    {
	    (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
	    Tcl_SetVar(interpreter, communicationHandlerVarname, comBuffer, 
		       TCL_GLOBAL_ONLY);
	    XtFree(comBuffer);
	    comBuffer = NULL;
	       }

          if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) 
	      == TCL_ERROR)
	      fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", 
		      interpreter->result);
          
	XtFree(communicationHandlerVarname);
	XtFree(communicationHandlerCommand);
	communicationCount = 0;
	communicationHandlerLength = 0;
	communicationHandlerCommand = NULL;
	}
    else
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "HandlerProc: I do nothing, Data is not complete %d <= %d!\n",
		communicationHandlerLength,communicationCount);
#endif
	}
    DBUG_VOID_RETURN;
     }


#ifdef NEVER
int
com_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
    {
    unsigned long   timeoutVal;
     
    DBUG_ENTER("addTimeOut");

    if (argc != 3)
	{
	fprintf(stderr, "Wafe(addTimeOut): Wrong # of Args");
	DBUG_RETURN(TCL_ERROR);
	}

    sscanf(argv[1],"%lu", &timeoutVal);
    (void)XtAppAddTimeOut(appContext, timeoutVal, timerProc, 
			  (XtPointer)XtNewString(argv[2]));

    DBUG_RETURN(TCL_OK);
    }
#endif      

#ifdef NEVER
int
com_getChannel(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
    {
     int        i;
     char       buffer[20];       

     DBUG_ENTER("getChannel");
     
     if (argc != 1)
          {
          fprintf(stderr, "getChannel: Wrong # of args");
          DBUG_RETURN (TCL_ERROR);
	  }

     sprintf(buffer, "%d", comClient);

     Tcl_SetResult(comInterpreter, buffer, TCL_VOLATILE);
     DBUG_RETURN(TCL_OK);
     }
#endif



void
setCommunicationVariable(varName,length,command)
String   varName;
int      length;
String   command;
    {

    communicationHandlerVarname = varName;
    communicationHandlerLength = length;
    communicationHandlerCommand = command;

#ifdef TUNNELDEBUG
    fprintf(stderr, "Command: setting communicationHandlerLength = %d\n",
	    communicationHandlerLength);

    fprintf(stderr, "Command: communicationHandlerLength %d <= communicationCount(global): %d\n", 
	    communicationHandlerLength, communicationCount);
#endif

    if (communicationHandlerLength <= communicationCount)
	{ 
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: data available, executing <%s>\n", 
		communicationHandlerCommand); 
#endif
	if (!comBuffer)
	    Tcl_SetVar(interpreter, communicationHandlerVarname, 
		       "", TCL_GLOBAL_ONLY);
	else
	    {
	    (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
	    if (communicationHandlerLength < communicationCount) 
		{
		char saveChar;

		saveChar = comBuffer[communicationHandlerLength+1];
#ifdef TUNNELDEBUG
		fprintf(stderr, "Command: MORE THAN WE NEED! c=<%d>\n",
			(int)saveChar);
#endif
		comBuffer[communicationHandlerLength+1] = '\0';
		Tcl_SetVar(interpreter, communicationHandlerVarname, 
			   comBuffer, TCL_GLOBAL_ONLY);
		comBuffer[communicationHandlerLength+1] = saveChar;

		memcpy(comBuffer,&comBuffer[communicationHandlerLength],
		       communicationCount-communicationHandlerLength);
		communicationCount = communicationCount - 
		    communicationHandlerLength;
		} 
	    else 
		{
		Tcl_SetVar(interpreter, communicationHandlerVarname, 
			   comBuffer, TCL_GLOBAL_ONLY);
		communicationCount = 0;
		XtFree(comBuffer);
		comBuffer = NULL;
		}
	    }  

	if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) == 
	    TCL_ERROR)
	    fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", 
		    interpreter->result);
          
	XtFree(communicationHandlerVarname);
	XtFree(communicationHandlerCommand);
	communicationHandlerLength = 0;
	communicationHandlerCommand = NULL;
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: setting command and length to NULL\n"); 
#endif
	}
    else
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: I do nothing, because Data is not yet complete!\n");
#endif
	}
    }


/*
 *  The following command is used to access the Drag'n Drop library 
 */

void
rddDropCallbackProc(w, command, info)
Widget   w;
char     *command;
RddCallbackStruct   *info;
     {
     char *message;

     message = (char *)XtMalloc(info->len + 1);
     strncpy(message, info->data, info->len);
     *(message + info->len) = '\0';

     Tcl_SetVar(interpreter, "DROP", message, TCL_GLOBAL_ONLY);
     XtFree(message);

     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "Wafe(rddDropCallback): %s\n", interpreter->result);
    }
     


/*
 @handlerType = (
	    "stdin", STDIN,
	    "stdout", STDOUT,
	    "stderr", STDERR,
	    "xioerr", XIOERR,
		  );
*/

void 
doregister(handlerType,string)
int handlerType;
char *string;
    {

    switch(handlerType)
	{
    case STDIN: 
	if (directMode)
	    {
	    fprintf(stderr, "Warning: No input-handler in this mode!");
	    return;
	    }
	break;
	
    case STDOUT:
	if (directMode)
	    {
	    fprintf(stderr, "Warning: No output-handler in this mode!");
	    return;
	    }
	break;

    case STDERR:
	if ((directMode) || (fileMode))
	    {
	    fprintf(stderr, "Warning: No error-handler in this mode!");
	    return;
	    }
	break;

    default:
	break;
	}

    if (tclHandlers[handlerType]) 
	XtFree(tclHandlers[handlerType]);

    tclHandlers[handlerType] = XtNewString(string);
    } 



void 
unregister(handlerType)
int handlerType;
    {
    if (!tclHandlers[handlerType]) 
	fprintf(stderr, "Wafe(unregister): Warning, no handler registered!\n");
    else 
	XtFree(tclHandlers[handlerType]);
    }
     


#define echo(x) {write(toClient,x,strlen(x)); if (count+1 != argc) write(toClient," ",1);}

/* 
 * void
 * echo
 * 	callmultiple
 * 	in: String			# strings 
 * 	post: write(toClient, "\n",1);
 */

int 
com_echo(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;
     int count;

     DBUG_ENTER("echo");  

     if (argc < 2) 
	 {
	 argcError("echo","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         localVar1 = argv[count];
         echo(localVar1);
          }
     write(toClient, "\n",1);

     DBUG_RETURN (TCL_OK);
     }     


#include <time.h>
#define ref(a) &(a)

/* 
 * String
 * ctime
 * 	in: ref(long)			# clock value
 */

int 
com_ctime(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     long localVar1;
     String returnVar;

     DBUG_ENTER("ctime");  

     if (argc != 2) 
	 {
	 argcError("ctime","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%ld", &localVar1)))
          {
          convError("ctime","1",argv[1],"long");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = ctime(ref(localVar1));

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define getChannel() comClient

/* 
 * int
 * getChannel
 * 	const:				# None
 */

int 
com_getChannel(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("getChannel");  

     if (argc != 1) 
	 {
	 argcError("getChannel","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     returnVar = getChannel();

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <signal.h>

/* 
 * void 
 * kill vulgo quit 
 * 	const: pid			
 * 	const: SIGTERM
 * 	pre: if (pid)			# None
 * 	post: exit(0);
 */

int 
com_quit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("quit");  

     if (argc != 1) 
	 {
	 argcError("quit","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (pid)
     kill(pid,SIGTERM);
     exit(0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * doregister vulgo register
 * 	in: (int)handlerType		# stdin | stdout| stderr | xioerr
 * 	in: char *			# tcl-command
 */

int 
com_register(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     char * localVar2;

     DBUG_ENTER("register");  

     if (argc != 3) 
	 {
	 argcError("register","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "stdin")) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], "stdout")) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], "stderr")) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
         {
         convError("register","1",argv[1],"handlerType");
         DBUG_RETURN (TCL_ERROR);
        }


    /* no need to assign to localVar2 = argv[2]  */ 

     doregister(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * setCommunicationVariable
 * 	in: XtNewString(String)		# variable name
 * 	in: int				# length
 * 	in: XtNewString(String)		# tcl command to be executed
 */

int 
com_setCommunicationVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;
     int localVar2;
     String localVar3;

     DBUG_ENTER("setCommunicationVariable");  

     if (argc != 4) 
	 {
	 argcError("setCommunicationVariable","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign to localVar1 = argv[1]  */ 

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("setCommunicationVariable","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign to localVar3 = argv[3]  */ 

     setCommunicationVariable(XtNewString(argv[1]),localVar2,XtNewString(argv[3]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * unregister
 * 	in: (int)handlerType		# stdin | stdout| stderr | xioerr

 */

int 
com_unregister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;

     DBUG_ENTER("unregister");  

     if (argc != 2) 
	 {
	 argcError("unregister","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "stdin")) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], "stdout")) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], "stderr")) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
         {
         convError("unregister","1",argv[1],"handlerType");
         DBUG_RETURN (TCL_ERROR);
        }


     unregister(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_MiscGen()
{
#ifdef MISC
 Tcl_CreateCommand(interpreter, "echo", com_echo, NULL, NULL);
 Tcl_CreateCommand(interpreter, "ctime", com_ctime, NULL, NULL);
 Tcl_CreateCommand(interpreter, "getChannel", com_getChannel, NULL, NULL);
 Tcl_CreateCommand(interpreter, "quit", com_quit, NULL, NULL);
 Tcl_CreateCommand(interpreter, "register", com_register, NULL, NULL);
 Tcl_CreateCommand(interpreter, "setCommunicationVariable", com_setCommunicationVariable, NULL, NULL);
 Tcl_CreateCommand(interpreter, "unregister", com_unregister, NULL, NULL);

#else
#endif
}
