.TH xwafenews 1
.SH NAME
.PP
xwafenews \- an x-based NNTP news reader 

.SH SYNOPSIS
.PP
\f3xwafenews\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1] 
[\f3-C\f1] 
[\f3-f \f2 name of newsrc file\f1] 
[\f3-h\f1] 
[\f3-N\f2 NNTP server\f1] 
[\f3-p\f1 \f2print command\f1] 
[\f3-s \f2 name of signature file\f1]

.SH DESCRIPTION
.PP

\fIxwafenews\fP is an x-based news reader which accesses a remote news
server via NNTP (net news transfer protocol). xwafenews is a
\fIwafe\fP application (see manual page wafeapp) written in Perl. In
short, xwafenews allows a user to subscribe to newsgroups, to read news,
to reply to the author, to forward articles to other people via mail,
to post followup articles or to start new discussion threads, to save
and to print articles.

.SH OPTIONS
.PP
In addition to the standard toolkit options 
such as -display, -name, -geometry, -iconic, -xrm etc. (see manual
page X) xwafenews accepts the following options:
.TP
\f3-c \f2colormode\f1
start xwafenews using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.TP
\f3-C\f1
prefer files for the communication between front end and application
program. This option can reduce the memory consumption, but increases
disk-IO and might lead to locking problems.

.TP
\f3-f \f2name of newsrc file\f1
use an alternate newsrc file. Per default \fI.newsrc\fP in the login
directory of the current user is used.

.TP
\f3-h\f1
show a short usage message.

.TP
\f3-N\f2 NNTP server\f1] 
use an non-default NNTP server. Ask you network administrator for advice.
If \f3-N\f1 is specified and the \f3-f\f1 option was not used, 
the name of the specified NNTP server is appended to the standard
newsrc file name.

.TP
\f3-p \f2print command\f1
specify a non-default print command (for example: 'mp -a | lpr
-Pmyps') the quotes are NOT optional.

.TP
\f3-s \f2name of signature file\f1
use a non-default signature file. In the configuration of the
distribution the name of the signature file is $HOME/.elm/signature.
The signature file is appended to postings, forwarded articles or
replies. A stupid example: \fI-s $HOME/.login\fP.

.SH "LAYOUT and INTERACTION" 

.PP 
When xwafenews is started the user will see an X front end with
three main sections: these sections are (from top to bottom): the
\fIgroup\fP section, the \fIsubject\fP section and the \fIarticle\fP
section.  The top most line of the application is an information line,
where the user is informed about the actions the program takes. 


The \fIgroup\fP section has a header part and a larger window
containing names of newsgroups and information about its contents. In
the header part of the group section the \fIGroups\fP and the
\fISort\fP menu are located, which can be activated by pressing the
left mouse button on the bold label. If all available newsgroups are
chosen from the Groups menu the operation will slow down. The
\fIGrep\fP field can be used to restrict the group listing to matching
lines. The \fIConfig\fP button may be used to change certain settings
(such as print command) for a single session.

Newsgroups may be \fIselected\fP with the middle mouse button.
Once newsgroup are selected, the buttons \fIsubscribe-first\fP,
\fIsubscribe-last\fP and \fIunsubscribe\fP will become sensitive. By
pressing the left mouse button in a line of the groups listing, the
newsgroup is opened and article-numbers, authors, length of article
(when specified in the Lines: field) and the subject line are
displayed in the second section of the application.  The button
\fIsave-newsrc\fP can be used to save the current state of the newsrc.

Articles, which are not in the newsrc file (see also option -f) will
be marked with "(new)" in the group listing. If a new newsgroup is
opened, it will be automatically subscribed.  If the program is
terminated without opening a new newsgroup it will be treated as
unsubscribed. When the newsrc file does not exist, a new newsrc file
is created, the user is subscribed automatically to the newsgroups
"news.announce.newusers", "news.announce.important" and
"news.newusers.questions".


The \fIsubject\fP section contains information about the current
selected newsgroup. This section also has a header part and a list
part. The header part contains the \fIArticles\fP and the \fISort\fP
menu.  In the Articles menu the user can choose whether he/she wants
to see unread articles, recent articles (i.e. 100 newest articles, if
available) or all articles. In the sort menu it is possible to choose
between chronological order or alphabetic order of the subject lines.
The latter mode is useful for example for saving multi part (binary)
postings. The \fIGrep\fP field can be used to restrict the subject
listing to matching lines. Note that differently to the \fIGrep\fP field in
the group section an \fIincremental grep\fP is used here.  

Under the \fIGrep\fP field the buttons \fIcatchup\fP, \fIsave\fP,
\fImark\fP and \fIthread\fP are located. The \fIcatchup\fP button can
be used to mark all articles in the current newsgroup as read. In the
subject linsting the middle mouse button (Btn2) can be used to
\fIselect\fP one or several subject lines. As soon as subject lines
are selected the buttons \fIsave\fP and \fImark\fP become sensitive.

If articles are selected and the save button is pressed (or the
character "s" is typed in the window containing the subject listing),
a \fIsave window\fP pops up. If \fIcancel\fP is pressed with the left
mouse button, nothing is saved and the dialog window pops down.  If
nothing is typed in the dialog window and the return key is pressed,
the selected articles will be saved in the $HOME/News directory and
appended to a file with the name of the current news group. If a name
is specified, which does not start with "~", "/" or "|", the selected
articles will be saved in the $HOME/News/ directory under the given
name. If the name starts with "~" or "/", the name will be interpreted
as a full path name. If the name starts with "|" the name will be
interpreted as a pipe. Note that the folders generated by saving
articles  may be read using the program \fIxwafemail\fP.

The \fImark\fP button can be used to mark read articles as unread or
vice versa. If the left mouse button is pressed in a line of the
subject listing, the article is retrieved from the NNTP server and
displayed in the article window. The cursor keys up and down may be
used to read the next or previous article by scrolling the listing one
line up or down and reading the article under the mouse cursor.

If an article is displayed the \fIthread\fP button may be used to
display only the articles to which the current article refers (marked
by "<" and the articles which are referring to the current articles
(marked by ">"). If the right mous button (Btn3) is pressed in the
subject listing, the thread mode is terminated and the full subject
listing is displayed again.

The \fIarticle\fP section displays the current article. The bottom
line of the application contains several buttons. The \fIquit\fP
button terminates xwafenews AND updates the newsrc file (see also -f
option). \fIabort\fP is used to terminate without saving or to abort
writing of an article or mail. \fIpost\fP is used to post an article
to the current news group, \fIfollowup\fP is used to post an article
as a response to the current article adressed to the current
newsgroup. The \fIreply\fP button allows to send mail to the author of
the current article, \fIforward\fP is used to forward the current
article via mail to another user. \fIpost\fP, \fIfollowup\fP,
\fIreply\fP and \fIforward\fP may be terminated by the \fIsend\fP
button or aborted by \fIabort\fP. The \fIheader\fP button shows/hides
the full header of an article, \fIprint\fP (\fIsave\fP) can be used to
print (or save) the current article.

For alias resolving see the manual page of \fIxwafemail\fP.

.SH "NNTP HOST"
.PP
Resolving rules for determining the NNTP-server:
(a) command line option -N, (b)  $defaultNntpHost from system.waferc,
(c) environment variable NNTPSERVER, (d) contents of the file 
"\fI/usr/local/lib/news/nntpserver\fP".

.SH "KEY BINDINGS"
\fIKey bindings in group listing:\fP
.TP 13
<Btn1>
read newsgroup
.TP
<Btn2> 
select newsgroups
.TP
<Key>f
subscribe to selected newsgroups on top of the listing
.TP
<Key>l
subscribe to selected newsgroups on bottom of the listing
.TP
<Key>u
unsubscribe from selected newsgroups

.PP
\fIKey bindings in subject listing:\fP
.TP 13
<Btn1>
read article
.TP
<Btn2> 
select articles
.TP
<Btn3>
refresh subject listing (terminates thread)
.TP
<Key>Up
read previous article
.TP
<Key>Down
read next article
.TP
<Key>Prior
previous page
.TP
<Key>Next
next page
.TP
<Key>c
mark all articles in current newsgroup as read and leave newsgroup
.TP
<Key>s
save selected articles
.TP
<Key>t
display thread of current article
.TP
<Key>u
unsubscribe from current newsgroup

.PP
\fIKey bindings in article text:\fP
.TP 13
Ctrl<Key>f
use a fixed spaced font
.TP
Ctrl<Key>q
reflow text
.TP
Ctrl<Key>v
use a variable spaced font
.TP
Ctrl<Key>w
set read-only buffer writable (useful in combination with Ctrl<Key>q
to reflow text that does not fit in the current line with)

.PP
\fIKey bindings on buttons in the bottom button row:\fP
.TP 13
<Btn3> 
clicking <Btn3> on <reply> or <forward> send urgent mail

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)
.TP
NNTPSERVER
name of the NNTP server (see section NNTP host above)
.TP
HOME
login directory of the current user
.TP
HOST
fully qualified host name (including domain)
.TP
USER
login name of the current user
.TP
TMPDIR
directory for temporary files. If  not specified, /tmp is used

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$boldFont
typically used for bold labels
.TP
$normalFont
typically used for labels or proportional text
.TP
$buttonFont
typically used as font for buttons
.TP
$textFont
fixed spaced text font
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
$roColors
attributes for non emphasized text (typically colors)
.TP
$infoColors
attributes of the info line (typically colors)
.TP
$menueAtts 
attributes of pull down menues (typically colors)
.TP
%textResources
default resources for text widgets
.TP
@textActions
default actions for text widgets
.TP
$mailIncludePrefix
prefix for included text-portions for reply or followups
.TP
$signatureFile
full path leading to the signature file
.TP
$printCommand
command used to print articles
.TP 
$elmAliases
full path leading to an alias file used to resolve addresses in
outgoing mails.
.TP
$defaultNntpHost
name of the default NNTP host (see section NNTP host above)
.TP
$defaultNntpOrganization
name used for the organization for outgoing postings
.TP
$defaultNntpDistribution
default distribution for outgoing postings

.SH FILES 
.PP
.EX 0
$HOME/News
$HOME/Mail
$HOME/.elm/signature
$HOME/.elm/aliases.text
/usr/local/lib/news/nntpserver
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
