.TH xwafedesign 1
.SH NAME
.PP
xwafedesign \- a design tool for wafe applications

.SH SYNOPSIS
.PP
\f3xwafedesign\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1] 

.SH DESCRIPTION
.PP

\fIxwafedesign\fP is an interactive design tool for 
\fIwafe\fP applications (see manual page wafeapp) written in Perl. In
short, xwafedesign allows a user to develop wafe applications in
tcl or Perl interactively. The user can select widgets from a list
and insert it into the widget tree of an application. Resources
can be set interactively, widget (sub)trees can be inserted, duplicated
of deleted, and an according tcl or perl program can be created.

.SH OPTIONS
.PP
In addition to the standard toolkit options 
such as -display, -name, -geometry, -iconic, -xrm etc. (see manual
page X) xwafedesign accepts the following options:
.TP
\f3-c \f2colormode\f1
start xwafedesign using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.SH "LAYOUT and INTERACTION" 

.PP 
When xwafedesign is started two window shells will pop up: the
\fIxwafedesign window\fP and the \fIpreview window\fP. On the left hand side of
the xwafedesign window a list of widgets is presented, which depends
on the version of X Window (R4 or R5) and the packages compiled into
Wafe (eg. the plotter widget set). When a button of this list is
pressed the corresponding widget will be created and inserted into the
widget tree displayed at the right half of the xwafedesign window. The
widget insert rules will be described below. We will assume the user
pressed the label button to create a label widget as son of form1. The
newly created label label1 will be displayed in the preview window as
well.

A widget can be selected or unselected. A selected widget is displayed
inverted in the widget tree. A widget can be selected either by
pressing the left mouse button <Btn1> on the widget name in the widget tree
or by pressing shift<Btn3> in the widget in the preview window.

When one ore more widgets are selected the user set-able resource
names are displayed in the middle part of the xwafedesign window.  If
more than one widget was selected the intersection of the resource
names is presented. When the left mouse button is pressed on a
resource name (eg. background) a dialog pops up where a new value of
the resource can be entered. Note, that also Perl-variables from the
wafe configuration can be used here. If for instance "$backGround" is
inserted the background color of an application created by xwafedesign
will inherit the color of the -C option. Other useful Perl variables
to be entered in such dialog boxes are fontnames such as "$boldFont"
or the value of shadowWith "$threeD" (if wafe was compiled with the
libXaw3d).

The insertion rule for widgets is defined as follows: If the widget to
be inserted can be child of a selected widget, the last selected
widget will be used as father. This is particulary easy, if only one
widget is selected. If no widget is selected, the fist created widget
suitable as parent widget will be chosen. This will be typically the
top form widget.

Children widgets of the form widget can be moved by pressing
shift<Btn1> in the preview window and moving with the mouse while
holding the shift and mouse button pressed. However, to obtain more
flexible layouts when resources like fonts are changed it is
recommended to use fromHoriz and fromVert instead.

The buttons \fIDuplicate\fP and \fIDelete\fP in the preview windows
can be used to duplicate or delete the current selected widgets. If a 
composite widget is selected the operation is performed on the 
complete widget tree under the widget.

If the \fIGenerate\fP button in the xwafedesign window is pressed 
another window pops up which shows a program corresponding to the
application displayed in the preview window. The user can switch
between \fITcl\fP and \fIPerl\fP as the output language. If \fITcl\fP
is used, the perl variables specified as resource values are resolved.

The \fILoad\fP button of the xwafedesign window can be used to edit or
to incorporate programs developed with xwafedesign. The user has the
options (a) to insert a complete widget tree into the current
application (button \fIInsert\fP), (b) to insert the widget tree
without the top level widget (to avoid unnecessary deep nestings of
form widgets) or (c) to load a new application (button \fILoad
new\fP). When widgets are inserted the insert rules of above apply.
\fILoad new\fP deletes all children of the top form widget and inserts the
named file without top widget.

Note that xwafedesign tries to preserve the user code of applications
developed with xwafedesign. A user can design the interface of an
application using xwafedesign, use his favorite editor to insert the
application semantics to the created file and modify the program at a
later time using xwafedesign. The user is encouraged not to touch the
generated code between "### BEGIN wafedesign" and "### END wafedesign".


.SH "KEY BINDINGS"
\fIKey bindings in xwafedesign window:\fP
.TP 13
<Btn1>
in widget list: create a widget, in widget tree: select/unselect a widget

.TP
\fIKey bindings in preview window:\fP
.TP 13
shift<Btn1>
move a widget
.TP 13
shift<Btn3>
select/unselect a widget

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$boldFont
typically used for bold labels
.TP
$normalFont
typically used for labels or proportional text
.TP
$buttonFont
typically used as font for buttons
.TP
$textFont
fixed spaced text font
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
$infoColors
attributes of the info line (typically colors)
.TP
$menueAtts 
attributes of pull down menues (typically colors)
.TP
@textActions
default actions for text widgets

.SH FILES 
.PP
.EX 0
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
