'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/TraceVar.man,v 1.8 92/05/22 08:19:50 ouster Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_TraceVar tcl
.VS
.BS
.SH NAME
Tcl_TraceVar, Tcl_TraceVar2, Tcl_UntraceVar, Tcl_UntraceVar2, Tcl_VarTraceInfo, Tcl_VarTraceInfo2 \- monitor accesses to a variable
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_TraceVar(\fIinterp, varName, flags, proc, clientData\fB)\fR
.sp
int
\fBTcl_TraceVar2(\fIinterp, name1, name2, flags, proc, clientData\fB)\fR
.sp
\fBTcl_UnTraceVar(\fIinterp, varName, flags, proc, clientData\fB)\fR
.sp
\fBTcl_UnTraceVar2(\fIinterp, name1, name2, flags, proc, clientData\fB)\fR
.sp
ClientData
\fBTcl_VarTraceInfo(\fIinterp, varName, flags, proc, prevClientData\fB)\fR
.sp
ClientData
\fBTcl_VarTraceInfo2(\fIinterp, name1, name2, flags, proc, prevClientData\fB)\fR
.SH ARGUMENTS
.AS Tcl_VarTraceProc prevClientData
.AP Tcl_Interp *interp in
Interpreter containing variable.
.AP char *varName in
Name of variable.  May refer to a scalar variable, to
an array variable with no index, or to an array variable
with a parenthesized index.
.AP int flags in
OR-ed combination of the values TCL_TRACE_READS, TCL_TRACE_WRITES, and
TCL_TRACE_UNSETS, and TCL_GLOBAL_ONLY.  Not all flags are used by all
procedures.  See below for more information.
.AP Tcl_VarTraceProc *proc in
Procedure to invoke whenever one of the traced operations occurs.
.AP ClientData clientData in
Arbitrary one-word value to pass to \fIproc\fR.
.AP char *name1 in
Name of scalar or array variable (without array index).
.AP char *name2 in
For a trace on an element of an array, gives the index of the
element.  For traces on scalar variables or on whole arrays,
is NULL.
.AP ClientData prevClientData in
If non-NULL, gives last value returned by \fBTcl_VarTraceInfo\fR or
\fBTcl_VarTraceInfo2\fR, so this call will return information about
next trace.  If NULL, this call will return information about first
trace.
.BE

.SH DESCRIPTION
.PP
\fBTcl_TraceVar\fR allows a C procedure to monitor and control
access to a Tcl variable, so that the C procedure is invoked
whenever the variable is read or written or unset.
If the trace is created successfully then \fBTcl_TraceVar\fR returns
TCL_OK.  If an error occurred (e.g. \fIvarName\fR specifies an element
of an array, but the actual variable isn't an array) then TCL_ERROR
is returned and an error message is left in \fIinterp->result\fR.
.PP
The \fIflags\fR argument to \fBTcl_TraceVar\fR indicates when the
trace procedure is to be invoked and provides information
for setting up the trace.  It consists of an OR-ed combination
of any of the following values:
.TP
\fBTCL_GLOBAL_ONLY\fR
Normally, the variable will be looked up at the current level of
procedure call;  if this bit is set then the variable will be looked
up at global level, ignoring any active procedures.
.TP
\fBTCL_TRACE_READS\fR
Invoke \fIproc\fR whenever an attempt is made to read the variable.
.TP
\fBTCL_TRACE_WRITES\fR
Invoke \fIproc\fR whenever an attempt is made to modify the variable.
.TP
\fBTCL_TRACE_UNSETS\fR
Invoke \fIproc\fR whenever the variable is unset.
A variable may be unset either explicitly by an \fBunset\fR command,
or implicitly when a procedure returns (its local variables are
automatically unset) or when the interpreter is deleted (all
variables are automatically unset).
.PP
Whenever one of the specified operations occurs on the variable,
\fIproc\fR will be invoked.
It should have arguments and result that match the type
\fBTcl_VarTraceProc\fR:
.nf
.RS
typedef char *Tcl_VarTraceProc(
.RS
ClientData \fIclientData\fR,
Tcl_Interp *\fIinterp\fR,
char *\fIname1\fR,
char *\fIname2\fR,
int \fIflags\fR);
.RE
.RE
.fi
The \fIclientData\fP and \fIinterp\fP parameters will
have the same values as those passed to \fBTcl_TraceVar\fR when the
trace was created.
\fIClientData\fR typically points to an application-specific
data structure that describes what to do when \fIproc\fR
is invoked.
\fIName1\fR and \fIname2\fR give the name of the traced variable
in the normal two-part form (see the description of \fBTcl_TraceVar2\fR
below for details).
\fIFlags\fR is an OR-ed combination of bits providing several
pieces of information.
One of the bits TCL_TRACE_READS, TCL_TRACE_WRITES, or TCL_TRACE_UNSETS
will be set in \fIflags\fR to indicate which operation is being performed
on the variable.
The bit TCL_GLOBAL_ONLY will be set whenever the variable being
accessed is a global one not accessible from the current level of
procedure call:  the trace procedure will need to pass this flag
back to variable-related procedures like \fBTcl_GetVar\fR if it
attempts to access the variable.
The bit TCL_TRACE_DESTROYED will be set in \fIflags\fR if the trace is
about to be destroyed;  this information may be useful to \fIproc\fR
so that it can clean up its own internal data structures (see
the section TCL_TRACE_DESTROYED below for more details).
Lastly, the bit TCL_INTERP_DESTROYED will be set if the entire
interpreter is being destroyed.
When this bit is set, \fIproc\fR must be especially careful in
the things it does (see the section TCL_INTERP_DESTROYED below).
The trace procedure's return value should normally be NULL;  see
ERROR RETURNS below for information on other possibilities.
.PP
\fBTcl_UntraceVar\fR may be used to remove a trace.
If the variable specified by \fIinterp\fR, \fIvarName\fR, and \fIflags\fR
has a trace set with \fIflags\fR, \fIproc\fR, and
\fIclientData\fR, then the corresponding trace is removed.
If no such trace exists, then the call to \fBTcl_UntraceVar\fR
has no effect.
The same bits are valid for \fIflags\fR as for calls to \fBTcl_TraceVars\fR.
.PP
\fBTcl_VarTraceInfo\fR may be used to retrieve information about
traces set on a given variable.
The return value from \fBTcl_VarTraceInfo\fR is the \fIclientData\fR
associated with a particular trace.
The trace must be on the variable specified by the \fIinterp\fR,
\fIvarName\fR, and \fIflags\fR arguments (only the TCL_GLOBAL_ONLY
bit from \fIflags\fR is used;  other bits are ignored) and its trace procedure
must the same as the \fIproc\fR argument.
If the \fIprevClientData\fR argument is NULL then the return
value corresponds to the first (most recently created) matching
trace, or NULL if there are no matching traces.
If the \fIprevClientData\fR argument isn't NULL, then it should
be the return value from a previous call to \fBTcl_VarTraceInfo\fR.
In this case, the new return value will correspond to the next
matching trace after the one whose \fIclientData\fR matches
\fIprevClientData\fR, or NULL if no trace matches \fIprevClientData\fR
or if there are no more matching traces after it.
This mechanism makes it possible to step through all of the
traces for a given variable that have the same \fIproc\fR.

.SH "TWO-PART NAMES"
.PP
The procedures \fBTcl_TraceVar2\fR, \fBTcl_UntraceVar2\fR, and
\fBTcl_VarTraceInfo2\fR are identical to \fBTcl_TraceVar\fR,
\fBTcl_UntraceVar\fR, and \fBTcl_VarTraceInfo\fR, respectively,
except that the name of the variable has already been
separated by the caller into two parts.
\fIName1\fR gives the name of a scalar variable or array,
and \fIname2\fR gives the name of an element within an
array.
If \fIname2\fR is NULL it means that either the variable is
a scalar or the trace is to be set on the entire array rather
than an individual element (see WHOLE-ARRAY TRACES below for
more information).

.SH "ACCESSING VARIABLES DURING TRACES"
.PP
During read and write traces, the
trace procedure can read or write the value of the traced
variable using \fBTcl_GetVar2\fR, \fBTcl_SetVar2\fR, and
other procedures.
While \fIproc\fR is executing, traces are temporarily disabled
for the variable, so that calls to \fBTcl_GetVar2\fR and
\fBTcl_SetVar2\fR will not cause \fIproc\fR or other trace procedures
to be invoked again.
Disabling only occurs for the variable whose trace procedure
is active;  accesses to other variables will still be traced.
.PP
During unset traces the variable has already been completely
expunged.
It is possible for the trace procedure to read or write the
variable, but this will be a new version of the variable.
Traces are not disabled during unset traces as they are for
read and write traces, but existing traces have been removed
from the variable before any trace procedures are invoked.
If new traces are set by unset trace procedures, these traces
will be invoked on accesses to the variable by the trace
procedures.

.SH "CALLBACK TIMING"
.PP
When read tracing has been specified for a variable, the trace
procedure will be invoked whenever the variable's value is
read.  This includes \fBset\fR Tcl commands, \fB$\fR-notation
in Tcl commands, and invocations of the \fBTcl_GetVar\fR
and \fBTcl_GetVar2\fR procedures.
\fIProc\fR is invoked just before the variable's value is
returned.
It may modify the value of the variable to affect what
is returned by the traced access.
.PP
When write tracing has been specified for a variable, the
trace procedure will be invoked whenever the variable's value
is modified.  This includes \fBset\fR commands\fR,
commands that modify variables as side effects (such as
\fBcatch\fR and \fBscan\fR), and calls to the \fBTcl_SetVar\fR
and \fBTcl_SetVar2\fR procedures).
\fIProc\fR will be invoked after the variable's value has been
modified, but before the new value of the variable has been
returned.
It may modify the value of the variable to override the change
and to determine the value actually returned by the traced
access.
.PP
When unset tracing has been specified, the trace procedure
will be invoked whenever the variable is destroyed.
The traces will be called after the variable has been
completely unset.

.SH "WHOLE-ARRAY TRACES"
.PP
If a call to \fBTcl_TraceVar\fR or \fBTcl_TraceVar2\fR specifies
the name of an array variable without an index into the array,
then the trace will be set on the array as a whole.
This means that \fIproc\fR will be invoked whenever any
element of the array is accessed in the ways specified by
\fIflags\fR.
When an array is unset, a whole-array trace will be invoked
just once, with \fIname1\fR equal to the name of the array
and \fIname2\fR NULL;  it will not be invoked once for each
element.

.SH "MULTIPLE TRACES"
.PP
It is possible for multiple traces to exist on the same variable.
When this happens, all of the trace procedures will be invoked on each
access, in order from most-recently-created to least-recently-created.
When there exist whole-array traces for an array as well as
traces on individual elements, the whole-array traces are invoked
before the individual-element traces.

.SH "ERROR RETURNS"
.PP
Under normal conditions trace procedures should return NULL, indicating
successful completion.
If \fIproc\fR returns a non-NULL value it signifies that an
error occurred.
The return value must be a pointer to a static character string
containing an error message.
If a trace procedure returns an error, no further traces are
invoked for the access and the traced access aborts with the
given message.
Trace procedures can use this facility to make variables
read-only, for example (but note that the value of the variable
will already have been modified before the trace procedure is
called, so the trace procedure will have to restore the correct
value).
.PP
The return value from \fIproc\fR is only used during read and
write tracing.
During unset traces, the return value is ignored and all relevant
trace procedures will always be invoked.

.SH "RESTRICTIONS"
.PP
It is not legal to delete a variable while a trace procedure
is active for the variable.

.SH "UNDEFINED VARIABLES"
.PP
It is legal to set a trace on an undefined variable.
The variable will still appear to be undefined until the
first time its value is set.
If an undefined variable is traced and then unset, the unset will fail
with an error (``no such variable''), but the trace
procedure will still be invoked.

.SH "TCL_TRACE_DELETED FLAG"
.PP
In an unset callback to \fIproc\fR, the TCL_TRACE_DELETED bit
is set in \fIflags\fR if the trace is being removed as part
of the deletion.
Traces on a variable are always removed whenever the variable
is deleted;  the only time TCL_TRACE_DELETED isn't set is for
a whole-array trace invoked when only a single element of an
array is unset.

.SH "TCL_INTERP_DESTROYED"
.PP
When an interpreter is destroyed, unset traces are called for
all of its variables.
The TCL_INTERP_DESTROYED bit will be set in the \fIflags\fR
argument passed to the trace procedures.
Trace procedures must be extremely careful in what they do if
the TCL_INTERP_DESTROYED bit is set.
It is not safe for the procedures to invoke any Tcl procedures
on the interpreter, since its state is partially deleted.
All that trace procedures should do under these circumstances is
to clean up and free their own internal data structures.

.SH BUGS
.PP
Tcl doesn't do any error checking to prevent trace procedures
from misusing the interpreter during traces with TCL_INTERP_DESTROYED
set.

.SH KEYWORDS
clientData, trace, variable
.VE
