/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/* 
 *            Code fuer StripChart Widget
 *
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/StripChart.h>

#include "wafe.h"


typedef struct _scInfo
     {
     double            value;
     char              name[30];
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;


scInfoPtr  scbegin = NULL;

void 
scSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scbegin)         /* No Stripchart widgets exists yet*/
          {
          fprintf(stderr, "Wafe(scSet): No stripchart widget exists yet!\n");
          return;
          }

     for (countPtr = scbegin; 
          strcmp(countPtr->name, XtName(sCWidget)) && countPtr->next != NULL;
          countPtr = countPtr->next);


     if ((countPtr->next == NULL) && strcmp(countPtr->name, XtName(sCWidget)))
          {
          fprintf(stderr, "Wafe(scSet): StripChart widget %s unknown\n", XtName(sCWidget));
          return;
          }

     DBUG_PRINT("sc",("Gefunden = %s\n", countPtr->name));

     countPtr->value = value;
     }


void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;
     char        name[30];

     DBUG_ENTER("Query");

     strcpy(name, XtName(w));
     
     for (countPtr = scbegin; strcmp(countPtr->name, name);
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = %s, value = %lf\n", countPtr->name,
             countPtr->value));

     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

void
scInit(w, name)
Widget      w;
char        *name;
     {
     scInfoPtr  countPtr;

     if (!scbegin)                   /* Erstes SC-Widget dieser App. */
          {
          scbegin = countPtr = (scInfoPtr) XtNew(scInfo);
          scbegin->next = NULL;
          }
     else                            /* Es gibt schon SC-Widgets */
          {               
          for (countPtr = scbegin; countPtr->next != NULL; 
                                                                countPtr = countPtr->next);

          countPtr->next =  (scInfoPtr) XtNew(scInfo);
          countPtr = countPtr->next;
          countPtr->next = NULL;
          }

     strcpy(countPtr->name, name);
     countPtr->value = (double) 0;         /* Default-Wert = 0 !!! */               

     XtAddCallback(w, "getValue", scQueryProc, NULL);  
     return;
     }



