/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>

#include "wafe.h"

char *selected = NULL;
char *loseSelectionCommand = NULL;
char *selectionDoneCommand = NULL;

char     one[] = "1";
char     zero[] = "0";
char     empty[] = "";

Boolean
convertProc(owner, selection, target, typeReturn, valueReturn, 
            lengthReturn, formatReturn)
Widget          owner;
Atom           *selection;
Atom           *target;
Atom           *typeReturn;
XtPointer      *valueReturn;
unsigned long  *lengthReturn;
int            *formatReturn;
     {
     DBUG_ENTER("ConvertProc");

     if (*target != XA_STRING)
          {
          fprintf(stderr, "Requested target-type is unsupported!\n");
          DBUG_RETURN(False);
          }
     else
          {
          *valueReturn = (XtPointer) selected;
          *typeReturn = XA_STRING;
          *formatReturn = 8;
          *lengthReturn = strlen(selected);
          DBUG_RETURN(True);
          }
     }
           
void
loseSelectionProc(w, selection)
Widget     w;
Atom      *selection;
     {
     DBUG_ENTER("loseSelectionProc");

     DBUG_PRINT("selection",("Executing %s", loseSelectionCommand));
     if (Tcl_Eval(interpreter, loseSelectionCommand, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "loseSelectionProc: Error in executing command\n");
          
     DBUG_VOID_RETURN;
     }

void
selectionDoneProc(w, selection, target)
Widget     w;
Atom      *selection;
Atom      *target;
     {
     DBUG_ENTER("selectionDoneProc");

     DBUG_PRINT("selection",("Executing %s", selectionDoneCommand));
     if (Tcl_Eval(interpreter, selectionDoneCommand, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "selectionDoneProc: Error in executing command\n");
          
     DBUG_VOID_RETURN;
     }

void
getSelectionValueProc(w, clientData, selection, type, value, length, format)
Widget         w;
XtPointer      clientData;
Atom          *selection;
Atom          *type;
XtPointer      value;
unsigned long *length;
int           *format;
     {
     char *command = (char *) clientData;
     char *primary;

     DBUG_ENTER("getSelectionValueProc");

     DBUG_PRINT("selection", ("Received:>>%s<<", value));
     DBUG_PRINT("selection", ("Command:>>%s<<", command));

     if (value == NULL)
          primary = empty;
     else
          primary = (char *)value;
    
     Tcl_SetVar(interpreter, "PRIMARY", primary, TCL_GLOBAL_ONLY);

     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "%s\n", interpreter->result);

     DBUG_VOID_RETURN;
     }
    
int
com_ownSelection(client_data, comInterpreter, argc, argv)
ClientData   client_data;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
     {
     int   i;
     XtLoseSelectionProc    loseProc = NULL;
     XtSelectionDoneProc   doneProc = NULL;

     DBUG_ENTER("ownSelection");

     if ((argc < 2) || (argc > 6))
          {
          fprintf(stderr, "ownSelection: Wrong # of Args");
          DBUG_RETURN (TCL_ERROR);
          }

     if (selected)
          XtFree(selected);

     if (loseSelectionCommand)
          XtFree(loseSelectionCommand);

     if (selectionDoneCommand)
          XtFree(selectionDoneCommand);

     selected = XtNewString(argv[1]);

     if (argc == 2)
          {
          if (XtOwnSelection(topLevel, XA_PRIMARY, CurrentTime, 
                             convertProc, NULL, NULL))
                Tcl_SetResult(comInterpreter, one, TCL_STATIC);
          else  
                {
                Tcl_SetResult(comInterpreter, zero, TCL_STATIC);
                fprintf(stderr, "Wafe(OwnSelection): Couldn't get PRIMARY Buffer\n");
                }
           }
     else
           {
           for(i = 2; i < argc; i+=2)
	        {
                if (!strcmp(argv[i], "lost"))
                     {
                     loseProc = loseSelectionProc;
                     loseSelectionCommand = XtNewString(argv[i+1]);
                     }
                else
                if (!strcmp(argv[i], "done"))
                     {
                     doneProc = selectionDoneProc;
                     selectionDoneCommand = XtNewString(argv[i+1]);
                     }
                else
                     {
                     fprintf(stderr, "Wafe(ownSelection): Unknown type: %s\n", argv[i]);
                     DBUG_RETURN(TCL_ERROR);
                     }
	        }
	  }

     if (XtOwnSelection(topLevel, XA_PRIMARY,  CurrentTime,
                                                                   convertProc, loseProc, doneProc))
          Tcl_SetResult(comInterpreter, one, TCL_STATIC);
     else  
          {
          Tcl_SetResult(comInterpreter, zero, TCL_STATIC);
          fprintf(stderr, "Wafe(OwnSelection): Couldn't get PRIMARY Buffer\n");
          }      

     DBUG_RETURN(TCL_OK);
     }
