/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

#include<stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <tcl.h>
#include<dbug.h>

#include "wafe.h"

#include "rdd.h"

char              *clientStderrHandlerCommand = NULL;
char              *clientStdinHandlerCommand = NULL;
char              *clientStdoutHandlerCommand = NULL;

char              *communicationHandlerVarname = NULL;
char              *communicationHandlerCommand = NULL;
int                communicationHandlerLength = 0;
int                communicationCount = 0;

char               inputBuffer[BUF_SIZE+1];
int                leftBytes = 0;      


void
getInput(client_data, fid, xid)
XtPointer   client_data;          /* PromptMode True oder False  */
int         *fid;
XtInputId   *xid;
     {
     char   *bufferPtr = inputBuffer + leftBytes;
     char   *firstPtr = inputBuffer;
     char   *secondPtr = inputBuffer;
     int     readBytes;
     Boolean overFlowFlag = True;

     DBUG_ENTER("getInput");

     if ((readBytes = read(*fid, bufferPtr, BUF_SIZE - leftBytes)) == -1)
           perror("Wafe: Communication error: ");

     *(bufferPtr + readBytes) = '\0';
     leftBytes = 0;

     DBUG_PRINT("socketAll", 
               ("BufferContents are:\n>>%s<<", bufferPtr));     

     if (!readBytes)
          {
          fprintf(stderr, "Wafe: EOF-Condition on fromClient - Channel\n");
          exit(1);
          }    
 
     do
          {
          while ((*firstPtr != '\n') && (*firstPtr != '\0'))
               *firstPtr++;

          if (*firstPtr == '\n')
               {
               *firstPtr = '\0';     /* One tcl-command is ready */

               overFlowFlag = False;

               DBUG_PRINT("socket", 
                         ("Parsed Command >%s<", secondPtr));

               if (client_data)      /* Standard Mode - prompt character is checked */
                    {               
                    if (*secondPtr == promptChar) 
                         {
    	                 if(Tcl_Eval(interpreter, secondPtr+1, 0, NULL) == TCL_ERROR)
	                      fprintf(stderr, "%s\n", interpreter->result);
                         }
                    else 
		         {
                         if (clientStdoutHandlerCommand)
                              {                    
                              Tcl_SetVar(interpreter, "STDOUT", secondPtr, 
                                         TCL_GLOBAL_ONLY);

                              if (Tcl_Eval(interpreter, clientStdoutHandlerCommand, 
                                           0, NULL) == TCL_ERROR)
                                       fprintf(stderr, "%s\n", interpreter->result);
	                      }
                         else
	                      fprintf(stdout, "%s\n", secondPtr);	 
                         }
                    } 
               else                  /* Don't look for Prompt character */  
                    {                 
                    if (Tcl_Eval(interpreter, secondPtr, 0, NULL) == TCL_ERROR)
                          fprintf(stderr, "%s\n", interpreter->result);
                    }

                firstPtr++;

                if (*firstPtr == '\0')      
		     {
                     DBUG_VOID_RETURN;
		     }
                else
                     secondPtr = firstPtr;                  
	        }
     	  } while (*firstPtr != '\0');

     if (overFlowFlag)
          {
          fprintf(stderr, "Wafe(main): Uncomplete command or communication buffer overflow, >%s<\n", secondPtr);
          exit(-1);
	  }

     /* if this one is the last command in the buffer and
      * it is not terminated with a \n => do buffering 
      */

     DBUG_PRINT("socket", ("uncomplete command : %s", secondPtr)); 

     strcpy(inputBuffer, secondPtr);
     leftBytes = strlen(secondPtr);

     DBUG_VOID_RETURN;
     }


void
stdinHandlerProc(client_data, fid, xid)
XtPointer   client_data; /* Prompt-Mode: True oder False */
int         *fid;
XtInputId   *xid;
     {
     int     readBytes;
     char    stdinBuffer[STDIN_BUF_SIZE];

     DBUG_ENTER("getInputFromStdin");

     if ((readBytes = read(*fid, stdinBuffer, STDIN_BUF_SIZE)) == -1)
           perror("getInput");

     if (!readBytes)
          {
          DBUG_PRINT("handler",
                    ("EOF - condition on stdin"));
          DBUG_VOID_RETURN;
	  }

     if (clientStdinHandlerCommand)
          {
          Tcl_SetVar(interpreter, "STDIN", stdinBuffer, TCL_GLOBAL_ONLY);

          if (Tcl_Eval(interpreter, clientStdinHandlerCommand,
                                                0, NULL) == TCL_ERROR)
               fprintf(stderr, "%s\n", interpreter->result);
	  }
     else
          write(toClient, stdinBuffer, strlen(stdinBuffer));

     DBUG_VOID_RETURN;
     }


int 
com_stdinHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     DBUG_ENTER("stdinHandler");

     if (argc != 2)
           {
           fprintf(stderr, "stdinHandler: Wrong # of Args\n");
           DBUG_RETURN(TCL_ERROR);
           }

     if (directMode)
           {
           fprintf(stderr, "Warning: No input-handler in this mode!");
           DBUG_RETURN(TCL_ERROR);
	   }

     if (clientStdinHandlerCommand)
           XtFree(clientStdinHandlerCommand);

     clientStdinHandlerCommand = (XtPointer)XtNewString (argv[1]);

     DBUG_RETURN(TCL_OK); 
     } 

int 
com_stdoutHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     DBUG_ENTER("stdoutHandler");

     if (argc != 2)
           {
           fprintf(stderr, "stdoutHandler: Wrong # of Args\n");
           DBUG_RETURN(TCL_ERROR);
           }

     if (directMode)
           {
           fprintf(stderr, "Warning: No input-handler in this mode!");
           DBUG_RETURN(TCL_ERROR);
	   }

     if (clientStdoutHandlerCommand)
           XtFree(clientStdoutHandlerCommand);

     clientStdoutHandlerCommand = (XtPointer)XtNewString (argv[1]);

     DBUG_RETURN(TCL_OK); 
     } 


int
com_unregisterStdinHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     DBUG_ENTER("unregisterStdinHandler");
   
     if (!clientStdinHandlerCommand)
          fprintf(stderr, "Warning, no input handler registered!\n");
     else
          {
          XtFree(clientStdinHandlerCommand);
          clientStdinHandlerCommand = NULL;
	  }
     
     DBUG_RETURN(TCL_OK); 
     } 


int
com_unregisterStdoutHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     DBUG_ENTER("unregisterStdoutHandler");
   
     if (!clientStdoutHandlerCommand)
          fprintf(stderr, "Warning, no output handler registered!\n");
     else
          {
          XtFree(clientStdoutHandlerCommand);
          clientStdoutHandlerCommand = NULL;
	  }
     
     DBUG_RETURN(TCL_OK); 
     } 


void
stderrHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
     {   
     int     readBytes;
     char    stderrBuffer[STDERR_BUF_SIZE];

     DBUG_ENTER("stderrHandlerProc");

     if ((readBytes = read(*fid, stderrBuffer, STDERR_BUF_SIZE)) == -1)
           perror("stderrHandlerProc");

     *(stderrBuffer + readBytes) = '\0';

     if (!readBytes)
          {
          DBUG_PRINT("handler",
                    ("EOF - condition on stderr"));
          DBUG_VOID_RETURN;
	  }

     if (clientStderrHandlerCommand)
          {
          Tcl_SetVar(interpreter, "STDERR", stderrBuffer, TCL_GLOBAL_ONLY);

          if (Tcl_Eval(interpreter, clientStderrHandlerCommand,
                                                0, NULL) == TCL_ERROR)
               fprintf(stderr, "%s\n", interpreter->result);
	  }
     else
          fprintf(stderr, "%s", stderrBuffer);

     DBUG_VOID_RETURN;
     }


int 
com_stderrHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtPointer   command;

     DBUG_ENTER("stderrHandler");

     if (argc != 2)
           {
           fprintf(stderr, "stderrHandler: Wrong # of Args\n");
           DBUG_RETURN(TCL_ERROR);
           }

     if ((directMode) || (fileMode))
           {
           fprintf(stderr, "Warning: No error-handler in this mode!");
           DBUG_RETURN(TCL_ERROR);
	   }

     if (clientStderrHandlerCommand)
           XtFree(clientStderrHandlerCommand);

     clientStderrHandlerCommand = (XtPointer)XtNewString (argv[1]);

     DBUG_RETURN(TCL_OK); 
     } 

int
com_unregisterStderrHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     DBUG_ENTER("unregisterStderrHandler");
   
     if (!clientStderrHandlerCommand)
          fprintf(stderr, "Warning, no error-handler registered!\n");
     else
          {
          XtFree(clientStderrHandlerCommand);
          clientStderrHandlerCommand = NULL;
	  }
     
     DBUG_RETURN(TCL_OK); 
     }      


void
communicationHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
     {   
     int     readBytes;
     char    localComBuffer[COMBUFSIZE+1];

     DBUG_ENTER("communicationHandlerProc");

     if ((readBytes = read(*fid, localComBuffer, COMBUFSIZE)) == -1)
           perror("communicationHandlerProc");

#ifdef TUNNELDEBUG
     fprintf(stderr, "HandlerProc: I read %d Bytes\n", readBytes); 
#endif

    *(localComBuffer + readBytes) = '\0';

     communicationCount += readBytes;

#ifdef TUNNELDEBUG
     fprintf(stderr, "HandlerProc: This makes now %d Bytes total\n", communicationCount); 
#endif

     if (!readBytes)
          {
          DBUG_PRINT("handler",
                    ("EOF - condition on communication channel"));
          DBUG_VOID_RETURN;
	  }

     if (!comBuffer)
          {
          comBuffer = XtNewString(localComBuffer);
          }
     else
          {
          comBuffer = XtRealloc(comBuffer, strlen(comBuffer) + readBytes + 1);
          strcat(comBuffer, localComBuffer);
          }

     if ((communicationHandlerCommand) && (communicationHandlerLength <= communicationCount))
          {
#ifdef TUNNELDEBUG
          fprintf(stderr, "HandlerProc: we got it %d <= %d, executing %s\n", 
		communicationHandlerLength, communicationCount,
		communicationHandlerCommand); 
#endif
          if (!comBuffer)
               Tcl_SetVar(interpreter, communicationHandlerVarname, "", TCL_GLOBAL_ONLY);
          else
               {
               (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
               Tcl_SetVar(interpreter, communicationHandlerVarname, comBuffer, 
                                                                          TCL_GLOBAL_ONLY);
               XtFree(comBuffer);
               comBuffer = NULL;
	       }

          if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) == TCL_ERROR)
               fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", interpreter->result);
          
          XtFree(communicationHandlerVarname);
          XtFree(communicationHandlerCommand);
          communicationCount = 0;
          communicationHandlerLength = 0;
          communicationHandlerCommand = NULL;
	}
     else
       {
#ifdef TUNNELDEBUG
       fprintf(stderr, "HandlerProc: I do nothing, Data is not complete %d <= %d!\n",
		communicationHandlerLength,communicationCount);
#endif
       }
     DBUG_VOID_RETURN;
     }


void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
     {
     DBUG_ENTER("timerProc");

     if (Tcl_Eval(interpreter, (char *)command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "%s\n", interpreter->result);     

     XtFree((char *)command);
     DBUG_VOID_RETURN;
     }


int
com_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     unsigned long   timeoutVal;

     DBUG_ENTER("addTimeOut");

     if (argc != 3)
          {
          fprintf(stderr, "Wafe(addTimeOut): Wrong # of Args");
          DBUG_RETURN(TCL_ERROR);
          }

     sscanf(argv[1],"%ld", &timeoutVal);
     (void)XtAppAddTimeOut(appContext, timeoutVal, timerProc, 
                                      (XtPointer)XtNewString(argv[2]));

     DBUG_RETURN(TCL_OK);
     }
      
int
com_getChannel(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int        i;
     char       buffer[20];       

     DBUG_ENTER("getChannel");
     
     if (argc != 1)
          {
          fprintf(stderr, "getChannel: Wrong # of args");
          DBUG_RETURN (TCL_ERROR);
	  }

     sprintf(buffer, "%d", comClient);

     Tcl_SetResult(comInterpreter, buffer, TCL_VOLATILE);
     DBUG_RETURN(TCL_OK);
     }


int
com_setCommunicationVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char       buffer[20];       

     DBUG_ENTER("setCommunicationVariable");
     
     if (argc != 4)
          {
          fprintf(stderr, "setCommunicationVariable: Wrong # of args");
          DBUG_RETURN (TCL_ERROR);
	  }

     communicationHandlerCommand = XtNewString(argv[3]);
     sscanf(argv[2], "%ld", &communicationHandlerLength);
     communicationHandlerVarname = XtNewString(argv[1]);

#ifdef TUNNELDEBUG
fprintf(stderr, "Command: setting communicationHandlerLength = %d\n",
	communicationHandlerLength);

fprintf(stderr, "Command: communicationHandlerLength %d <= communicationCount(global): %d\n", 
 	communicationHandlerLength, communicationCount);
#endif

     if (communicationHandlerLength <= communicationCount)
          { 
#ifdef TUNNELDEBUG
          fprintf(stderr, "Command: data available, executing <%s>\n", 
		communicationHandlerCommand); 
#endif
          if (!comBuffer)
               Tcl_SetVar(interpreter, communicationHandlerVarname, "", TCL_GLOBAL_ONLY);
          else
               {
               (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
		if (communicationHandlerLength < communicationCount) 
 			{
			char saveChar;

			saveChar = comBuffer[communicationHandlerLength+1];
#ifdef TUNNELDEBUG
fprintf(stderr, "Command: MORE THAN WE NEED! c=<%d>\n",(int)saveChar);
#endif
			comBuffer[communicationHandlerLength+1] = '\0';
               		Tcl_SetVar(interpreter, communicationHandlerVarname, comBuffer, 
                                                                          TCL_GLOBAL_ONLY);
			comBuffer[communicationHandlerLength+1] = saveChar;

			memcpy(comBuffer,&comBuffer[communicationHandlerLength],
				communicationCount-communicationHandlerLength);
          		communicationCount = communicationCount-communicationHandlerLength;
			} 
		else 
			{
               		Tcl_SetVar(interpreter, communicationHandlerVarname, comBuffer, 
                                                                          TCL_GLOBAL_ONLY);
			communicationCount = 0;
               		XtFree(comBuffer);
               		comBuffer = NULL;
			}
		}  

          if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) == TCL_ERROR)
               fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", interpreter->result);
          
          XtFree(communicationHandlerVarname);
          XtFree(communicationHandlerCommand);
          communicationHandlerLength = 0;
          communicationHandlerCommand = NULL;
#ifdef TUNNELDEBUG
          fprintf(stderr, "Command: setting command and length to NULL\n"); 
#endif
	}
     else
       {
#ifdef TUNNELDEBUG
       fprintf(stderr, "Command: I do nothing, because Data is not yet complete!\n");
#endif
       }
     DBUG_RETURN(TCL_OK);
     }


/*
 *  The following command is used to access the Drag'n Drop library 
 */

void
rddDropCallbackProc(w, command, info)
Widget   w;
char     *command;
RddCallbackStruct   *info;
     {
     char *message;

     message = (char *)XtMalloc(info->len + 1);
     strncpy(message, info->data, info->len);
     *(message + info->len) = '\0';

     Tcl_SetVar(interpreter, "DROP", message, TCL_GLOBAL_ONLY);
     XtFree(message);

     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "Wafe(rddDropCallback): %s\n", interpreter->result);
    }
     

