/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

#include "athenaW.h"

int
tclWidgetCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
     {
     int            i = 0;
     WidgetClass   *wClass = (WidgetClass *)clientData;
     Widget         father, new;
     char          *name;
     char          *widgetTyp;
     ArgList        args;
     int            numArgs;

     DBUG_ENTER("tclWidgetCommand");


     widgetTyp = *argv;
     name = *(++argv);

     if (!(father = name2Widget(*(++argv))))
          DBUG_RETURN(TCL_ERROR);
        
     argc-=3;    
     argv++;

     if (argc)
       {
       if (!strcmp(*argv, "unmanaged"))
          {
          argv++; argc--;

          if (argc % 2)
               {
               fprintf(stderr, "%s: Wrong # of args, widget %s (unmanaged)\n", 
                       widgetTyp, name);
               DBUG_RETURN (TCL_ERROR);
               } 

          if (convert(father, *wClass, argv, argc, &args, &numArgs))
               {
               if ((wClass == &simpleMenuWidgetClass) ||
                   (wClass == &overrideShellWidgetClass) ||
                   (wClass == &transientShellWidgetClass))
		    {
                    fprintf(stderr, 
                         "Warning: Can't create unmanaged shell-widget\n");
                    XtFree((char*)args);
                    DBUG_RETURN(TCL_OK);
		    }
               else 
                    {                    
                    new = XtCreateWidget(name, *wClass, father, args, numArgs);
                    if (*wClass == stripChartWidgetClass)
		         scInit(new, name);
                         
                    checkArgs4String(new, args, numArgs); 

                    DBUG_PRINT("widgets", ("Created unmanaged %s widget <%s>", 
                                widgetTyp, name));

                    XtFree((char*)args);
                    DBUG_RETURN(TCL_OK);
                    }
	       }
           }
        }

        /* assuming unmanaged was not specified, argc must be even  */
        if (argc % 2)
             {
             fprintf(stderr, "%s: Wrong # of args, widget %s\n", widgetTyp, name);
             DBUG_RETURN (TCL_ERROR);
             } 
        /* 
         * we have 2 ways: 
         *   a) convert the arguments first, and if successful, do a 
         *      new = XtCreateManagedWidget(name, *wClass, father, args, numArgs)
         *   b) create first the widget using
         *      new = XtCreateManagedWidget(name, *wClass, father, NULL, 0)
	 *      and convert then the arguments and add it finally using
         *      XtSetValues(new, args, numArgs)
         *      if onversion fails, destroy widget
         *
         *   (a) would be better, but since our 
         */

        if (convert(father, *wClass, argv, argc, &args, &numArgs))
             {
             if ((wClass == &simpleMenuWidgetClass) ||
                (wClass == &overrideShellWidgetClass) ||
                (wClass == &transientShellWidgetClass)) {
                  new = XtCreatePopupShell(name, *wClass, father, args, numArgs);
		}
             else 
                  {                    
                  new = XtCreateManagedWidget(name, *wClass, father, args, numArgs);
                  if (*wClass == stripChartWidgetClass)
		       scInit(new, name);
		  }

             checkArgs4String(new, args, numArgs); 
             DBUG_PRINT("widgets", ("Created %s widget <%s>", widgetTyp, name));
	     XtFree((char*)args);
             DBUG_RETURN(TCL_OK);
             }

     fprintf(stderr, "Couldn't create %s widget named <%s>\n", widgetTyp, name);
     XtFree((char*)args);
     DBUG_RETURN(TCL_OK);
     }

void createR4WidgetCommands()
     {
     int  i = 0;

     DBUG_ENTER("createR4WidgetCommands");

     XtInitializeWidgetClass(asciiSrcObjectClass);
     XtInitializeWidgetClass(asciiSinkObjectClass);

     while (widgetsR4[i].name != NULL)
          {
          Tcl_CreateCommand(interpreter, widgetsR4[i].name, 
                       tclWidgetCommand, (ClientData)widgetsR4[i].wClass, NULL);

          XtInitializeWidgetClass(*(widgetsR4[i].wClass)); 

          DBUG_PRINT("widgets",("Command %s created", 
                                     widgetsR4[i].name));
          i++;
          }
     DBUG_VOID_RETURN;
     }
       
#ifndef PRER5
void createR5WidgetCommands()
     {
     int  i = 0;

     DBUG_ENTER("createR5WidgetCommands");
  
     while (widgetsR5[i].name != NULL)
          {
          Tcl_CreateCommand(interpreter, widgetsR5[i].name, 
                       tclWidgetCommand, (ClientData)widgetsR5[i].wClass, NULL);

          XtInitializeWidgetClass(*(widgetsR5[i].wClass));
       
          DBUG_PRINT("widgets",("Command %s created", 
                                                      widgetsR5[i].name));
          i++; 
          }
     DBUG_VOID_RETURN;
     }

#else

int
r5WarningCommand(clientData, comInterpreter, argc, argv)
ClientData   clientData;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
     {
     DBUG_ENTER("r5WarningCommand");

     fprintf(stderr, 
        "Wafe(%s): Widget %s not availaible under X11R4 compilation, aborting!\n", 
         argv[0], argv[0]);
     exit(-1);
     }

void 
createR5WarningCommands()
     {
     DBUG_ENTER("createR5WarningCommands");

     Tcl_CreateCommand(interpreter, "tree", r5WarningCommand, NULL, NULL);
     Tcl_CreateCommand(interpreter, "panner", r5WarningCommand, NULL, NULL);
     Tcl_CreateCommand(interpreter, "porthole", r5WarningCommand, NULL, NULL);
     Tcl_CreateCommand(interpreter, "repeater", r5WarningCommand, NULL, NULL);

     DBUG_VOID_RETURN;
     }

#endif

