/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sat Aug  1 15:24:00 MET DST 1992 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.9
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

/* 
 * void
 * XtPopdown
 *         in: Widget
 */

int 
com_popdown(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popdown");  

     if (argc != 2) 
	 {
	 argcError("popdown","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popdown","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopdown(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopupSpringLoaded
 *         in: Widget
 */

int 
com_popupSpringLoaded(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("popupSpringLoaded");  

     if (argc != 2) 
	 {
	 argcError("popupSpringLoaded","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popupSpringLoaded","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtPopupSpringLoaded(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtPopup
 *         in: Widget
 *         in: XtGrabKind
 */

int 
com_popup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtGrabKind localVar2;

     DBUG_ENTER("popup");  

     if (argc != 3) 
	 {
	 argcError("popup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("popup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "none")) 
         localVar2 = XtGrabNone;
     else
     if (!strcmp(argv[2], "nonexclusive")) 
         localVar2 = XtGrabNonexclusive;
     else
     if (!strcmp(argv[2], "exclusive")) 
         localVar2 = XtGrabExclusive;
     else
         {
         convError("popup","2",argv[2],"XtGrabKind");
         DBUG_RETURN (TCL_ERROR);
        }


     XtPopup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtDestroyWidget
 * 	callmultiple
 * 		in: freeGarbageMM(Widget)
 */

int 
com_destroyWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("destroyWidget");  

     if (argc < 2) 
	 {
	 argcError("destroyWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("destroyWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtDestroyWidget(freeGarbageMM(localVar1));
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUnrealizeWidget
 * 	callmultiple
 * 		in: Widget
 */

int 
com_unrealizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("unrealizeWidget");  

     if (argc < 2) 
	 {
	 argcError("unrealizeWidget","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("unrealizeWidget","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtUnrealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtManageChild
 * 	callmultiple
 * 		in: Widget
 */

int 
com_manageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER("manageChild");  

     if (argc < 2) 
	 {
	 argcError("manageChild","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
              {
              convError("manageChild","count",argv[count],"Widget");
              DBUG_RETURN (TCL_ERROR);
              }

         XtManageChild(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtSetKeyboardFocus
 * 	in: Widget
 * 	in: Widget
 */

int 
com_setKeyboardFocus(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("setKeyboardFocus");  

     if (argc != 3) 
	 {
	 argcError("setKeyboardFocus","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("setKeyboardFocus","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("setKeyboardFocus","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtSetKeyboardFocus(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabPointer
 * 	in: Widget
 * 	in: Boolean
 *         const: NoEventMask
 * 	in: (int) SyncAsync
 * 	in: (int) SyncAsync
 * 	in: XtWindow(Widget)
 * 	const: None
 * 	const: CurrentTime
 */

int 
com_grabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     Widget localVar5;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabPointer");  

     if (argc != 6) 
	 {
	 argcError("grabPointer","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabPointer","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabPointer","4",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabPointer","5",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("grabPointer","6",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XtGrabPointer(localVar1,localVar2,NoEventMask,localVar3,localVar4,XtWindow(localVar5),None,CurrentTime);

     if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabPointer
 * 	in: Widget
 * 	const: CurrentTime
 */

int 
com_ungrabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabPointer");  

     if (argc != 2) 
	 {
	 argcError("ungrabPointer","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabPointer","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabPointer(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) GrabReturns
 * XtGrabKeyboard
 * 	in: Widget
 * 	in: Boolean
 * 	in: (int) SyncAsync
 * 	in: (int) SyncAsync
 * 	const: CurrentTime
 */

int 
com_grabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("grabKeyboard");  

     if (argc != 5) 
	 {
	 argcError("grabKeyboard","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("grabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("grabKeyboard","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "sync")) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], "async")) 
         localVar3 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","3",argv[3],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "sync")) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], "async")) 
         localVar4 = GrabModeAsync;
     else
         {
         convError("grabKeyboard","4",argv[4],"SyncAsync");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XtGrabKeyboard(localVar1,localVar2,localVar3,localVar4,CurrentTime);

     if (returnVar == GrabSuccess) 
          strcpy(conversionBuffer, "success");
     else
     if (returnVar == AlreadyGrabbed) 
          strcpy(conversionBuffer, "alreadyGrabbed");
     else
     if (returnVar == GrabNotViewable) 
          strcpy(conversionBuffer, "notViewable");
     else
     if (returnVar == GrabFrozen) 
          strcpy(conversionBuffer, "frozen");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtUngrabKeyboard
 * 	in: Widget
 * 	const: CurrentTime
 */

int 
com_ungrabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("ungrabKeyboard");  

     if (argc != 2) 
	 {
	 argcError("ungrabKeyboard","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("ungrabKeyboard","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XtUngrabKeyboard(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRealizeWidget vulgo realize
 * 	const: topLevel
 */

int 
com_realize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("realize");  

     if (argc != 1) 
	 {
	 argcError("realize","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     XtRealizeWidget(topLevel);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * char *
 * getTypeOfAttribute
 * 	in: XtClass(Widget)
 * 	const: ParentWidget(localVar1)
 * 	in: char *
 */

int 
com_getTypeOfAttribute(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;
     char * returnVar;

     DBUG_ENTER("getTypeOfAttribute");  

     if (argc != 3) 
	 {
	 argcError("getTypeOfAttribute","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getTypeOfAttribute","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     returnVar = getTypeOfAttribute(XtClass(localVar1),ParentWidget(localVar1),localVar2);


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

/* 
 * char *
 * getClass
 * 	in: Widget
 */

int 
com_getClass(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * returnVar;

     DBUG_ENTER("getClass");  

     if (argc != 2) 
	 {
	 argcError("getClass","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("getClass","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = getClass(localVar1);


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <signal.h>

/* 
 * void 
 * kill vulgo quit 
 * 	const: pid
 * 	const: SIGTERM
 * 	pre: if (pid)
 * 	post: exit(0);
 */

int 
com_quit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("quit");  

     if (argc != 1) 
	 {
	 argcError("quit","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (pid)
     kill(pid,SIGTERM);
     exit(0);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xatom.h>
#include <X11/StringDefs.h>

/* 
 * void
 * XtDisownSelection
 * 	const: topLevel
 * 	const: XA_PRIMARY
 * 	const: CurrentTime
 */

int 
com_disownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER("disownSelection");  

     if (argc != 1) 
	 {
	 argcError("disownSelection","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     XtDisownSelection(topLevel,XA_PRIMARY,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


extern void getSelectionValueProc();

/* 
 * void
 * XtGetSelectionValue
 * 	const: topLevel
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	const: getSelectionValueProc
 * 	in: XtNewString(char *)
 * 	const: CurrentTime
 */

int 
com_getSelectionValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;

     DBUG_ENTER("getSelectionValue");  

     if (argc != 2) 
	 {
	 argcError("getSelectionValue","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     localVar1 = argv[1];
     XtGetSelectionValue(topLevel,XA_PRIMARY,XA_STRING,getSelectionValueProc,XtNewString(localVar1),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


#define installAccelerators(destination,source,table) { XtVaSetValues(source, XtNaccelerators, table, NULL); XtInstallAccelerators(destination, source);}

/* 
 * void
 * installAccelerators
 * 	in: Widget
 * 	in: Widget
 * 	in: XtAccelerators
 */

int 
com_installAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     XtAccelerators localVar3;

     DBUG_ENTER("installAccelerators");  

     if (argc != 4) 
	 {
	 argcError("installAccelerators","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("installAccelerators","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("installAccelerators","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = (XtAccelerators) XtParseAcceleratorTable(argv[3])))
          {
          convError("installAccelerators","3",argv[3],"XtAccelerators");
          DBUG_RETURN (TCL_ERROR);
          }

     installAccelerators(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtRemoveAllCallbacks
 * 	in: Widget
 * 	in: char *
 */

int 
com_removeAllCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;

     DBUG_ENTER("removeAllCallbacks");  

     if (argc != 3) 
	 {
	 argcError("removeAllCallbacks","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("removeAllCallbacks","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     XtRemoveAllCallbacks(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * hint: prototype
 * void
 * action
 * 	in: Widget
 * 	in: (int)TranslationModifier
 *         in: XtTranslations
 */
extern void action(
#if NeedFunctionPrototypes
     Widget, int, XtTranslations
#endif
);

int 
com_action(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     XtTranslations localVar3;

     DBUG_ENTER("action");  

     if (argc != 4) 
	 {
	 argcError("action","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("action","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "override")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "augment")) 
         localVar2 = 2;
     else
     if (!strcmp(argv[2], "replace")) 
         localVar2 = 3;
     else
         {
         convError("action","2",argv[2],"TranslationModifier");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(localVar3 = (XtTranslations) XtParseTranslationTable(argv[3])))
          {
          convError("action","3",argv[3],"XtTranslations");
          DBUG_RETURN (TCL_ERROR);
          }

     action(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


extern execCallbackProc();
extern positionCallbackProc();
extern positionCursorCallbackProc();

/* 
 * hint: prototype
 * void
 * callback
 * 	in: Widget
 * 	in: char *
 *         in: XtCallbackProc
 *         in: XtNewString(char *)
 */
extern void callback(
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

int 
com_callback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;
     XtCallbackProc localVar3;
     char * localVar4;

     DBUG_ENTER("callback");  

     if (argc != 5) 
	 {
	 argcError("callback","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("callback","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     if (!strcmp(argv[3], "exec")) 
         localVar3 = (XtCallbackProc)execCallbackProc;
     else
     if (!strcmp(argv[3], "none")) 
         localVar3 = XtCallbackNone;
     else
     if (!strcmp(argv[3], "exclusive")) 
         localVar3 = XtCallbackExclusive;
     else
     if (!strcmp(argv[3], "nonexclusive")) 
         localVar3 = XtCallbackNonexclusive;
     else
     if (!strcmp(argv[3], "popdown")) 
         localVar3 = XtCallbackPopdown;
     else
     if (!strcmp(argv[3], "position")) 
         localVar3 = (XtCallbackProc)positionCallbackProc;
     else
     if (!strcmp(argv[3], "positionCursor")) 
         localVar3 = (XtCallbackProc)positionCursorCallbackProc;
     else
         {
         convError("callback","3",argv[3],"XtCallbackProc");
         DBUG_RETURN (TCL_ERROR);
        }


     localVar4 = argv[4];
     callback(localVar1,localVar2,localVar3,XtNewString(localVar4));

     DBUG_RETURN (TCL_OK);
     }     


#define echo(x) {write(toClient,x,strlen(x)); if (count+1 != argc) write(toClient," ",1);}

/* 
 * void
 * echo
 * 	callmultiple
 * 	in: char *
 * 	post: write(toClient, "\n",1);
 */

int 
com_echo(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;
     int count;

     DBUG_ENTER("echo");  

     if (argc < 2) 
	 {
	 argcError("echo","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     for (count = 1; count < argc; count++)
         {
         localVar1 = argv[count];
         echo(localVar1);
          }
     write(toClient, "\n",1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * char *
 * XFetchBytes
 * 	pre: { int bytes; XConvertSelection(XtDisplay(topLevel), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(topLevel)), CurrentTime); 
 * 	const: XtDisplay(topLevel)
 *         const:  &bytes
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBytes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * returnVar;

     DBUG_ENTER("fetchBytes");  

     if (argc != 1) 
	 {
	 argcError("fetchBytes","",0,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     { int bytes; XConvertSelection(XtDisplay(topLevel), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(topLevel)), CurrentTime);
     returnVar = XFetchBytes(XtDisplay(topLevel),&bytes);
     }


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XConvertSelection
 * 	const: XtDisplay(topLevel)
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	in: Atom
 * 	const: DefaultRootWindow(XtDisplay(topLevel))
 * 	const: CurrentTime
 */

int 
com_convertSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Atom localVar1;

     DBUG_ENTER("convertSelection");  

     if (argc != 2) 
	 {
	 argcError("convertSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "0")) 
         localVar1 = XA_CUT_BUFFER0;
     else
     if (!strcmp(argv[1], "1")) 
         localVar1 = XA_CUT_BUFFER1;
     else
     if (!strcmp(argv[1], "2")) 
         localVar1 = XA_CUT_BUFFER2;
     else
     if (!strcmp(argv[1], "3")) 
         localVar1 = XA_CUT_BUFFER3;
     else
     if (!strcmp(argv[1], "4")) 
         localVar1 = XA_CUT_BUFFER4;
     else
     if (!strcmp(argv[1], "5")) 
         localVar1 = XA_CUT_BUFFER5;
     else
     if (!strcmp(argv[1], "6")) 
         localVar1 = XA_CUT_BUFFER6;
     else
         {
         convError("convertSelection","4",argv[1],"Atom");
         DBUG_RETURN (TCL_ERROR);
        }


     XConvertSelection(XtDisplay(topLevel),XA_PRIMARY,XA_STRING,localVar1,DefaultRootWindow(XtDisplay(topLevel)),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XStoreBuffer
 * 	const: XtDisplay(topLevel)
 * 	in: char *
 * 	const: strlen(argv[1])
 * 	in: int
 */

int 
com_storeBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;
     int localVar2;

     DBUG_ENTER("storeBuffer");  

     if (argc != 3) 
	 {
	 argcError("storeBuffer","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     localVar1 = argv[1];
     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("storeBuffer","4",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XStoreBuffer(XtDisplay(topLevel),localVar1,strlen(argv[1]),localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * char *
 * XFetchBuffer
 * 	const: XtDisplay(topLevel)
 * 	const: &nbytes
 * 	in: int
 * 	pre: {int nbytes;
 * 	post: }
 * 	end: XtFree(returnVar);
 */

int 
com_fetchBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     char * returnVar;

     DBUG_ENTER("fetchBuffer");  

     if (argc != 2) 
	 {
	 argcError("fetchBuffer","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%d", &localVar1)))
          {
          convError("fetchBuffer","3",argv[1],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     {int nbytes;
     returnVar = XFetchBuffer(XtDisplay(topLevel),&nbytes,localVar1);
     }


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XtTranslateCoords
 * 	in: Widget
 * 	in: Position    # x
 * 	in: Position    # y
 * 	out: Position   # root x
 * 	out: Position   # root y
 */

int 
com_translateCoords(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("translateCoords");  

     if (argc != 6) 
	 {
	 argcError("translateCoords","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("translateCoords","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("translateCoords","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("translateCoords","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XtTranslateCoords(localVar1,localVar2,localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(interpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);
     Tcl_SetVar(interpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


