#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"
#include <At/Plot.h>
#include <At/Plotter.h>
#include <At/XYLinePlot.h>
#include <At/LinePlot.h>
#include <At/BarPlot.h>
#include <At/Axis.h>


int 
com_XYLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;
     float *x,*xarray, *y,*yarray;

     DBUG_ENTER("XYLinePlotAttachData");  

     if (argc < 2) 
	 {
	 argcError("xyLinePlotAttachData","at least ",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
         {
         convError("xyLinePlotAttachData","1",argv[1],"Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     x = xarray = (float *)XtMalloc(sizeof(float)*(argc-2));
     y = yarray = (float *)XtMalloc(sizeof(float)*(argc-2));

     for (count = 2; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              {
              convError("barPlotAttachData","in array", argv[count],"x/y");
              DBUG_RETURN (TCL_ERROR);
              }
          }

     AtXYLinePlotAttachData(localVar1,
		(XtPointer)xarray, AtFloat, sizeof(float),
		(XtPointer)yarray, AtFloat, sizeof(float),
		1,argc-2);

     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("LinePlotXData"),(char*)xarray);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("LinePlotYData"),(char*)yarray);
     DBUG_RETURN (TCL_OK);
     }     

