/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sat Aug  1 23:37:49 MET DST 1992 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.9
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"
#include <At/Plot.h>
#include <At/Plotter.h>
#include <At/XYLinePlot.h>
#include <At/LinePlot.h>
#include <At/BarPlot.h>
#include <At/Axis.h>

/* 
 * void
 * AtLabelAxisAttachData vulgo labelAxisAttachData
 *         in: Widget
 * 	in: [char *]
 * 	const: sizeof(String)
 * 	const: 1
 * 	const: argc-1
 */

int 
com_labelAxisAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * * localVar2;

     DBUG_ENTER("labelAxisAttachData");  

     if (argc < 3) 
	 {
	 argcError("labelAxisAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("labelAxisAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    char * *ptr;
          argv += 2;
          localVar2 = ptr =
             (char * *)XtMalloc((argc-2)*sizeof(char *));

          while (*argv)
             {
             *ptr = XtNewString(*argv);
          ptr ++; argv++;
          }
     }
     AtLabelAxisAttachData(localVar1,localVar2,sizeof(String),1,argc-1);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("labelAxisAttachData"),(char*)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#define castXtPointer(x) (XtPointer)(x)

/* 
 * void
 * AtLinePlotAttachData vulgo linePlotAttachData
 *         in: Widget
 * 	in: castXtPointer([float])
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_linePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("linePlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("linePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("linePlotAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("linePlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtLinePlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("linePlotAttachData"),(char*)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtBarPlotAttachData vulgo barPlotAttachData
 *         in: Widget
 * 	in: castXtPointer([float])
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_barPlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("barPlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("barPlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("barPlotAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("barPlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtBarPlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("barPlotAttachData"),(char*)localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtPlotterGeneratePostscript vulgo plotterGeneratePostscript
 *         in: char *            # file name
 *         in: (AtPlotterWidget)Widget            # plotter widget
 * 	in: char *            # title
 * 	in: int               # bounding box: x1
 * 	in: int               # bounding box: y1
 * 	in: int               # bounding box: x2
 * 	in: int               # bounding box: y2
 * 	in: Boolean           # landscape
 */

int 
com_plotterGeneratePostscript(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;
     AtPlotterWidget localVar2;
     char * localVar3;
     int localVar4;
     int localVar5;
     int localVar6;
     int localVar7;
     Boolean localVar8;

     DBUG_ENTER("plotterGeneratePostscript");  

     if (argc != 9) 
	 {
	 argcError("plotterGeneratePostscript","",8,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     localVar1 = argv[1];
     if (!(localVar2 = (AtPlotterWidget) name2Widget(argv[2])))
          {
          convError("plotterGeneratePostscript","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar3 = argv[3];
     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("plotterGeneratePostscript","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("plotterGeneratePostscript","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[6], "%d", &localVar6)))
          {
          convError("plotterGeneratePostscript","6",argv[6],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[7], "%d", &localVar7)))
          {
          convError("plotterGeneratePostscript","7",argv[7],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[8], "true")) 
         localVar8 = 1;
     else
     if (!strcmp(argv[8], "false")) 
         localVar8 = 0;
     else
         {
         convError("plotterGeneratePostscript","8",argv[8],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     AtPlotterGeneratePostscript(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6,localVar7,localVar8);

     DBUG_RETURN (TCL_OK);
     }     


