.\"
.\"  SCCSID = @(#) AtXYAxis.man (V6.0) Tue Aug  4 13:07:42 1992
.\"
.\"  Copyright (C) 1992 by University of Paderborn
.\"
.TH AtXYAxis 3X
.SH NAME
.B AtXYAxis -- the XY Axis widget class
.SH SYNOPSIS
.B #include <At/XYAxis.h>

.SH DESCRIPTION

The AtXYAxis widget is designed for numeric axes
as part of the AtPlotter widget.
It provides linear and logarithmic spacing of tics and subtics
and simple \fIprintf()\fP-like tic labeling.
This class is only concerned with the user-space details
of tic positions and tic labels.
The superclass AtAxisCore supplied the logic and
resources for actually drawing the axis.

.SH CLASSES
The class pointer is atXYAxisWidgetClass,
and the class name is AtXYAxis.
It is a subclass of AtAxisCore and relies on the superclass
code and resources for most of the functionality.

.SH RESOURCES

The AtXYAxis widget inherits all the resources from the AtAxisCore,
AtPlot and Object widget classes.
In addition, it has the following new resources:

.TS
center tab(#);
cB s s
lI lI lI lI
l l l l.
AtXYAxis Resources
Name#Class#Type#Default
.sp
XtNautoScale#XtCAutoScale#XtRBoolean#True
XtNautoTics#XtCAutoTics#XtRBoolean#True
XtNaxisTransform#XtCAxisTransform#XtRTransform#AtTransformLINEAR
XtNlinTicFormat#XtCLinTicFormat#XtRString#"%g"
XtNlogTicFormat#XtCLogTicFormat#XtRString#"%g"
XtNroundEndpoints#XtCRoundEndpoints#XtRBoolean#True
.TE

.IP XtNautoScale
If this is True, then the XtNmin and XtNmax resources
(inherited from the AtAxisCore superclass)
will be set automatically from the bounds of the parent AtPlotter widget,
resp. the attached data,
possibly rounded to a multiple of XtNticInterval
The XtNticInterval resource will be calculated automatically.
If XtNautoScale is False, the XtNmin, XtNmax and XtNticInterval
resources are not changed and the axis is forced to these bounds,
possibly rounded.

.IP XtNautoTics
If this is True, then the XtNticInterval resource inherited
from the AtAxisCore class will always be ignored and
the tic interval is calculated automatically.
If this is False, then the tic interval as set with XtNticInterval
will be used.
For a logarithmic axis the tic interval will always be 1.0
which means a full decade.

.IP XtNaxisTransform
This resource sets the transformation of the axis.
XtNaxisTransform may be AtTransformLINEAR for a linear axis
or AtTransformLOGARITHMIC for a logarithmic axis.
The axis transformation can be changed every time in
respect to the min/max values, resp. the XtNmin and XtNmax resources
which may not be <= 0.0 for logarithmic axes.
If XtNautoScale is True, and the XtNmin value is 0.0
then XtNmin is automatically set to 0.1 for a logarithmic axis
at creation or at life time of the axis.

.IP XtNroundEndpoints
If this is True, then the XtNmin and XtNmax resources will be rounded
down and up respectively to be a multiple of the XtNticInterval.
For a logarithmic axis the min and max values of the axis
are always rounded down and up to the boundary of a full decade.

.IP XtNlinTicFormat
The tic label for a linear axis is generated by using the
XtNlinTicFormat resource as the string argument to \fIsprintf()\fP,
with a single double argument which is the tic value.

.IP XtNlogTicFormat
The tic label for a logarithmic axis is generated by using the
XtNlogTicFormat resource as the string argument to \fIsprintf()\fP,
with a single double argument which is the tic value.

.SH USAGE
.nf
\fIaxis\fP = XtCreateWidget(\fIaxis_name\fP, atXYAxisWidgetClass, \fIparent\fP, \fIargs\fP, \fInum_args\fP)
	String \fIaxis_name\fP;
	WidgetClass atXYAxisWidgetClass;
	Widget \fIparent\fP;
	ArgList \fIargs\fP;
	Cardinal \fInum_args\fP;
.fi

The parent widget should be of the AtPlotter widget class,
or a fatal error will result.

.SH "SEE ALSO"
AtPlotter(3X), AtAxisCore(3X), AtPlot(3X)
.br
``Using The AthenaTools Plotter Widget Set''

.SH AUTHORS
Peter Klingebiel,
University of Paderborn,
using some code from the AtAxis class.

.SH COPYRIGHT

Copyright 1992 University of Paderborn

All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the firms, institutes
or employers of the authors not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.

THE AUTHORS AND THEIR FIRMS, INSTITUTES OR EMPLOYERS DISCLAIM ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHORS AND THEIR FIRMS,
INSTITUTES OR EMPLOYERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
