.\"
.\"  SCCSID = @(#) AtAxis.man (V6.0) Wed Jul  1 17:12:37 1992
.\"
.\"  Copyright (C) 1990 by the Massachusetts Institute of Technology
.\"  Copyright (C) 1991 by Burdett, Buckeridge and Young Ltd.
.\"
.TH AtAxis 3X
.SH NAME
.B AtAxis -- the Axis widget class
.SH SYNOPSIS
.B #include <At/Axis.h>

.SH DESCRIPTION

The AtAxis widget is designed for numeric axes
as part of the AtPlotter widget.
It provides simple linear spacing of tics and subtics
and simple \fIprintf()\fP-like tic labeling.
This class is only concerned with the user-space details
of tic positions and tic labels.
The superclass AtAxisCore supplied the logic and
resources for actually drawing the axis.

.SH CLASSES
The class pointer is atAxisWidgetClass,
and the class name is AtAxis.
It is a subclass of AtAxisCore and relies on the superclass
code and resources for most of the functionality.

.SH RESOURCES

The AtAxis widget inherits all the resources from the AtAxisCore,
AtPlot and Object widget classes.
In addition, it has the following new resources:

.TS
center tab(#);
cB s s
lI lI lI lI
l l l l.
AtAxis Resources
Name#Class#Type#Default
.sp
XtNautoScale#XtCAutoScale#XtRBoolean#True
XtNroundEndpoints#XtCRoundEndpoints#XtRBoolean#True
XtNticDensity#XtCTicDensity#XtRInt#0
XtNsubticDensity#XtCTicDensity#XtRInt#0
XtNticMultiplier#XtCTicMultiplier#XtRDouble#1.0
XtNticFormat#XtCTicFormat#XtRString#"%.1f"
.TE

.IP XtNautoScale
If this is True, then the XtNmin and XtNmax resources
(inherited from the AtAxisCore superclass)
will be set automatically from the bounds of the parent AtPlotter widget,
possibly rounded to a multiple of XtNticInterval.
The XtNticInterval resource will be calculated automatically.
If XtNautoScale is False, the XtNmin, XtNmax and XtNticInterval
resources are not changed and the axis is forced to these bounds,
possibly rounded.

.IP XtNroundEndpoints
If this is True, then the XtNmin and XtNmax resources will be rounded
down and up respectively to be a multiple of the XtNticInterval.

.IP XtNticDensity
If XtNautoScale is True,
this provides a hint to the code that calculates the XtNticInterval
how many tics are desirable.
The default is 0.
Values from -1 through -5 will result in fewer tics
(and hence larger XtNticInterval);
values from 1 to 5 fill produce more tics
(and hence smaller XtNticInterval.
If XtNautoScale is False, this is ignored.

.IP XtNsubticDensity
Provides a hint to the subtic calculation about
how many subtics per tic is desirable.
The default is 0.
Values from -1 through -5 will result in fewer subtics;
values from 1 to 5 will produce more subtics.
As subtics are always automatically calculated,
this resource is unaffected by the XtNautoScale resource.

.IP XtNticMultiplier
The value of each tic is multiplied by this factor before being used
to generate the tic label.

.IP XtNticFormat
The tic label is generated by using the XtNticFormat resource
as the string argument to \fIsprintf()\fP,
with a single double argument
which is the tic value times the XtNticMultiplier resource.

.SH USAGE

.nf
axis = XtCreateWidget(\fIaxis_name\fP, atAxisWidgetClass, \fIparent\fP, \fIargs\fP, \fInum_args\fP)
	String \fIaxis_name\fP;
	WidgetClass atAxisWidgetClass;
	Widget \fIparent\fP;
	ArgList \fIargs\fP;
	Cardinal \fInum_args\fP;
.fi

The parent widget should be of the AtPlotter widget class,
or a fatal error will result.

.SH "SEE ALSO"
AtPlotter(3X), AtAxisCore(3X), AtPlot(3X)
.br
``Using The AthenaTools Plotter Widget Set''

.SH AUTHORS
David Flanagan (MIT Project Athena)
and Chris Craig (MIT Project Athena)
wrote the code for version V4.
The version V5-beta was completely re-written using some code
and many algorithms from that version by Gregory Bond,
Burdett, Buckeridge & Young Ltd. (gnb@bby.oz.au).
No changes for version V6.0.

.SH COPYRIGHT

Copyright 1990,1991 by the Massachusetts Institute of Technology
.br
Copyright 1991 by Burdett, Buckeridge and Young Ltd.

All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the firms, institutes
or employers of the authors not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.

THE AUTHORS AND THEIR FIRMS, INSTITUTES OR EMPLOYERS DISCLAIM ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHORS AND THEIR FIRMS,
INSTITUTES OR EMPLOYERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
