.TH wafeapp 5
.SH NAME
wafeapp \- how to use and configure wafe perl written wafe applications
.SH DESCRIPTION
.PP
A typical Wafe application consists of two parts: the front-end "\fIwafe\fP"
and an application program which can be
implemented in an arbitrary programming language which talks to the
front-end via stdio. Since wafe was developed using the extensible tcl
shell (cite John Ousterhout), an application program can dynamically
submit requests to the front-end to build up the graphical user
interface; the application can even down-load application specific
procedures into the front-end.
.PP
The contributed perl written application programs load the "\fIwafe.pl\fP"
package, which allows a uniform configuration for various
applications. Per default wafe.pl tries to load during the  startup of an
application the configuration files "\fI$WafeLib/system.waferc\fP" and
".\fIwaferc\fP" in the home directory of the current user. Note that in
cases where the latter files exists it can be used to redefine
variables defined in in the application program or in
"\fI$WafeLib/system.waferc\fP". The standard configuration file
"\fIsystem.waferc\fP" is situated in the wafe library, which is
usually '\fI/usr/lib/X11/wafe\fP".

.PP
The configuration files are written in Perl syntax (cite Larry Wall) with the
restriction that a compound statement (between curly brackets) must 
NOT contain empty lines.
.PP
The same startup files are loaded from several applications to achieve
similar configurations and colors. The startup files may also be used
to pass variables to a specific application. For this
purpose \fIwafe.pl\fP sets the Perl variable \fI$appName\fP according
to the filename of the executed program.  If a users wants to start
the "\fIxwafemail\fP" application always with the option "\fI-F\fP" he
might add the following line into his/her ".\fIwaferc\fP":
.EX 0
	$opt_F = 1 if $appName eq "wafemail";
.EE
.SH "COLORS AND FONTS"
.PP
If an wafe application "xapp" starts it is registered as an toolkit
application with the name "xapp" in the class "XApp" and the according
resources are loaded.  In addition to the standard X resource
management using app-defaults and .Xdefaults, wafe offers an
additional instrument to give applications a similar appearance.  Each
wafe application loading "\fIwafe.pl\fP" accepts the command line
option "\fI-c <color mode>\fP", where color mode is one of
\fIblueish\fP, \fIgrayish\fP, \fIgreenish\fP and \fImono\fP or of the
form \fI<color string>-ish\fP where \fIcolor string>\fP is a
colorname defined in rgb.txt, available as \fIcolorname1\fP to
\fIcolorname4\fP.  If a user wants to give an application an wheat-ish
appearance he can use the command line argument "\fI-c wheat-ish\fP"
to use the colors wheat1 to wheat4. 
.PP
If  the  command line argument "\fI-c mono\fP" is specified  no colors are
set in system.waferc, only the standard X resource management is
used. 
.PP
The variables for color setting are defined in \fIsystem.waferc\fP.
If the -c option is used, appropriate Perl variables are set which
might be used in all application programs for background, emphasized
text, information and so on. The system.waferc
configuration file below sets besides the color options described above
variables for font settings, configurations of widgets that should
be configured the same way in various wafe applications. Finally some
parameters for certain applications follow, which will differ from
site to site.
.PP
The supplied sample \fIsystem.waferc\fP has the following content:
.EX 0
;# -*-perl-*-
;# the following fonts are used by 
;# xwafeftp, xwafenews, xwafemail, xwafecf, xwafemc, wafecf, wafetel, wafeora

$boldFont = 'font -b&h-lucida-bold-r-*-*-14-*-*-*-p-*-iso8859-*';
$normalFont = 'font -b&h-lucida-medium-r-*-*-14-*-*-*-p-*-iso8859-*';
$buttonFont = 'font -b&h-*-medium-r-*-*-12-*-*-*-p-*-iso8859-*';
$textFont = 'font -b&h-*-medium-r-*-*-12-*-*-*-m-*-*-*';

$opt_c = $opt_c || "grayish";  # default color mode

COLOR: {
    if ($opt_c eq "blueish") {
	$buttonColors = "background steelblue foreground white";
	$backGround = "background PowderBlue";
	$highLight = "background cyan";
        $roColors = "background aliceblue foreground black";
        $sbColors = "foreground black background steelblue";
        $infoColors = "foreground black background lightsteelblue";
	last COLOR;
    } 
    if ($opt_c eq "greenish") {
	$buttonColors = "background SeaGreen foreground white";
	$backGround = "background MediumSeaGreen";
	$infoColors = "background DarkSeaGreen2 foreground black";
        $roColors = "background DarkSeaGreen1 foreground black";
        $sbColors = "foreground black background DarkSeaGreen4";
	$highLight = "background mediumSpringGreen";
	last COLOR;
    } 
    if ($opt_c =~ /^(.*)-ish/) {
	$buttonColors = "background ${1}4 foreground white";
	$backGround = "background ${1}3";
	$highLight = "background ${1}2";
        $roColors = "background ${1}1 foreground black";
        $sbColors = "foreground black background ${1}4";
        $infoColors = "foreground black background ${1}2";
	last COLOR;
    } 
    if ($opt_c =~ /gr[ae]yish/) {
	$buttonColors = "background gray55 foreground white";
	$backGround = "background gainsboro";
	$highLight = "background mediumSpringGreen";
	$roColors = "background gray95 foreground black";
	$sbColors = "foreground black background gray55";
	$infoColors = "foreground black background gray75";
	last COLOR;
    }
    print "no such colormode <$opt_c>, using mono\n" if $opt_c ne 'mono';
    if ($opt_c eq "mono") {
	$highLightTextFont = 'font -b&h-*-bold-*-*-*-12-*-*-*-m-*-*-*';
	last COLOR;
    } 
}

;# subject colors for mail
%subjColors = (
	   'Ordinary-UnRead', 'foreground black background white', 
	   'Ordinary-Read', 'foreground gray60 background white', 
	   'Urgent-UnRead', 'foreground red background white', 
	   'Urgent-Read', 'foreground orange background white', 
	   ) if $opt_c ne "mono";

$menueAtts = $highLight;
$buttonAtts = "$buttonFont shapeStyle oval $buttonColors";

%textResources = (
	'*Text*insertFile*Form*Command', $buttonAtts,
	'*Text*insertFile*Form*Label', "$backGround $boldFont",
	'*Text*insertFile*Form*Text', $roColors,
	'*Text*insertFile*Form', $backGround,
	'*Text*search*Form*Command', $buttonAtts,
	'*Text*search*Form*Label', "$backGround $boldFont",
	'*Text*search*Form*Text', $roColors,
	'*Text*search*Form', $backGround,
	'*Scrollbar', $sbColors,
);


;# why does :Meta<Key>a not work for me?

@textActions = (
	'~Shift Meta<Key>a: insert-string()',
	'Shift Meta<Key>A: insert-string()',
	'~Shift Meta<Key>o: insert-string()',
	'Shift Meta<Key>O: insert-string()',
	'~Shift Meta<Key>u: insert-string()',
	'Shift Meta<Key>U: insert-string()',
        'Meta<Key>s: insert-string()',
	'None<Key>Prior : previous-page()',
	'None<Key>Next : next-page()',
	'Meta<Key>Prior : beginning-of-file()',
	'Meta<Key>Next : end-of-file()',
	'Meta<Key>Delete : delete-previous-word()',
	'Meta<Key>Right : forward-word()',
	'Meta<Key>Left : backward-word()',
	'Meta<Key>Down : scroll-one-line-down()',
	'Meta<Key>Up : scroll-one-line-up()',
	'<Key>apLineDel : delete-next-character()',
	'Ctrl<Key>Delete : beginning-of-line() kill-to-end-of-line()',
	'Meta<Key>d : kill-selection()',
	'<Key>Find : search(forward)',
	'<Key>Insert: insert-file()',
	'<Key>Delete: exec(backSpace %w)',
);

;# Mac like backspace

&Xui( 'proc backSpace {w} {'
         . 'textGetSelectionPos $w from to;'
         . 'if $from!=$to'
         . '    {callActionProc $w {} kill-selection; textSetSelection $w $from $from }'
         . '    {callActionProc $w {} delete-previous-character}}');

;#
;# for reply, forward and followup

$mailIncludePrefix = " |> ";

;#
;# configuration for xwafeftp
;# the following FTP servers appear in the server menu

@ftpServers = (
		  'ftp.wu-wien.ac.at',
		  'wuarchive.wustl.edu', 
		  'ftp.uu.net',
		  'gatekeeper.dec.com',
		  'prep.ai.mit.edu',
		  'export.lcs.mit.edu',
	       );

;#
;# configuration for news reader

$defaultNntpHost = "nestroy";
$defaultNntpOrganization = "WU-Wien";
$defaultNntpDistribution = "world";

;#
;# configuration for wafecf

$wafecfSearchPath = "bib-sample.db:$WafeLib/bib-sample.db";


;#
;# configuration for xwafetel

$wafetelDB = $wafetelDBalt = 'demo/demo@T:dec1.wu-wien.ac.at:wi';


;#
;# configuration for xwafeora

%wafeoraDB = (
	    'Ablage', 'demo/demo@T:dec1.wu-wien.ac.at:wi',
	    'Paper', 'demo/demo@T:dec1.wu-wien.ac.at:wi',
	    'Ordner', 'demo/demo@T:dec1.wu-wien.ac.at:wi',
	    );
.EE

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)
.TP
HOME
login directory of the current user

.SH FILES
.EX 0
     $WAFELIB/system.waferc
     $HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xiostats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
	Wirtschaftsuniversitaet Wien, 
	Abteilung fuer Wirtschaftsinformatik
	Augasse 2-6, 
	A-1090 Vienna, Austria
	neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
