'\"
'\" Copyright 1989-1991 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/SplitList.man,v 1.8 92/03/28 14:21:13 ouster Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_SplitList tcl
.BS
.SH NAME
Tcl_SplitList, Tcl_Merge, Tcl_ScanElement, Tcl_ConvertElement \- manipulate Tcl lists
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_SplitList\fR(\fIinterp, list, argcPtr, argvPtr\fR)
.sp
char *
\fBTcl_Merge\fR(\fIargc, argv\fR)
.sp
.VS
int
\fBTcl_ScanElement\fR(\fIsrc, flagsPtr\fR)
.sp
int
\fBTcl_ConvertElement\fR(\fIsrc, dst, flags\fR)
.VE
.SH ARGUMENTS
.AS Tcl_Interp ***argvPtr
.AP Tcl_Interp *interp out
Interpreter to use for error reporting.
.AP char *list in
Pointer to a string with proper list structure.
.AP int *argcPtr out
Filled in with number of elements in \fIlist\fR.
.AP char ***argvPtr out
\fI*argvPtr\fR will be filled in with the address of an array of
pointers to the strings that are the extracted elements of \fIlist\fR.
There will be \fI*argcPtr\fR valid entries in the array, followed by
a NULL entry.
.AP int argc in
Number of elements in \fIargv\fR.
.AP char **argv in
Array of strings to merge together into a single list.
Each string will become a separate element of the list.
.AP char *src in
.VS
String that is to become an element of a list.
.AP int *flagsPtr in
Pointer to word to fill in with information about \fIsrc\fR.
The value of *\fIflagsPtr\fR must be passed to \fBTcl_ConvertElement\fR.
.AP char *dst in
Place to copy converted list element.  Must contain enough characters
to hold converted string.
.AP int flags in
Information about \fIsrc\fR. Must be value returned by previous
call to \fBTcl_ScanElement\fR, possibly OR-ed
with \fBTCL_DONT_USE_BRACES\fR.
.VE
.BE

.SH DESCRIPTION
.PP
These procedures may be used to disassemble and reassemble Tcl lists.
\fBTcl_SplitList\fR breaks a list up into its constituent elements,
returning an array of pointers to the elements using
\fIargcPtr\fR and \fIargvPtr\fR.
While extracting the arguments, \fBTcl_SplitList\fR obeys the usual
rules for backslash substitutions and braces.  The area of
memory pointed to by \fI*argvPtr\fR is dynamically allocated;  in
addition to the array of pointers, it
also holds copies of all the list elements.  It is the caller's
responsibility to free up all of this storage by calling
.DS
\fBfree\fR((char *) \fI*argvPtr\fR)
.DE
when the list elements are no longer needed.
.PP
\fBTcl_SplitList\fR normally returns \fBTCL_OK\fR, which means the list was
successfully parsed.
If there was a syntax error in \fIlist\fR, then \fBTCL_ERROR\fR is returned
and \fIinterp->result\fR will point to an error message describing the
problem.
If \fBTCL_ERROR\fR is returned then no memory is allocated and \fI*argvPtr\fR
is not modified.
.PP
\fBTcl_Merge\fR is the inverse of \fBTcl_SplitList\fR:  it
takes a collection of strings given by \fIargc\fR
and \fIargv\fR and generates a result string
that has proper list structure.
This means that commands like \fBindex\fR may be used to
extract the original elements again.
In addition, if the result of \fBTcl_Merge\fR is passed to \fBTcl_Eval\fR,
it will be parsed into \fIargc\fR words whose values will
be the same as the \fIargv\fR strings passed to \fBTcl_Merge\fR.
\fBTcl_Merge\fR will modify the list elements with braces and/or
backslashes in order to produce proper Tcl list structure.
The result string is dynamically allocated
using \fBmalloc()\fR;  the caller must eventually release the space
using \fBfree()\fR.
.PP
If the result of \fBTcl_Merge\fR is passed to \fBTcl_SplitList\fR,
the elements returned by \fBTcl_SplitList\fR will be identical to
those passed into \fBTcl_Merge\fR.
However, the converse is not true:  if \fBTcl_SplitList\fR
is passed a given string, and the resulting \fIargc\fR and
\fIargv\fR are passed to \fBTcl_Merge\fR, the resulting string
may not be the same as the original string passed to \fBTcl_SplitList\fR.
This is because \fBTcl_Merge\fR may use backslashes and braces
differently than the original string.
.PP
.VS
\fBTcl_ScanElement\fR and \fBTcl_ConvertElement\fR are the
procedures that do all of the real work of \fBTcl_Merge\fR.
\fBTcl_ScanElement\fR scans its \fIsrc\fR argument
and determines how to use backslashes and braces
when converting it to a list element.
It returns an overestimate of the number of characters
required to represent \fIsrc\fR as a list element, and
it stores information in \fI*flagsPtr\fR that is needed
by \fBTcl_ConvertElement\fR.
.PP
\fBTcl_ConvertElement\fR is a companion procedure to \fBTcl_ScanElement\fR.
It does the actual work of converting a string to a list element.
Its \fIflags\fR argument must be the same as the value returned
by \fBTcl_ScanElement\fR.
\fBTcl_ConvertElement\fR writes a proper list element to memory
starting at *\fIdst\fR and returns a count of the total number
of characters written, which will be no more than the result
returned by \fBTcl_ScanElement\fR.
\fBTcl_ConvertElement\fR writes out only the actual list element
without any leading or trailing spaces: it is up to the caller to
include spaces between adjacent list elements.
.PP
\fBTcl_ConvertElement\fR uses one of two different approaches to
handle the special characters in \fIsrc\fR.  Wherever possible, it
handles special characters by surrounding the string with braces.
This produces clean-looking output, but can't be used in some situations,
such as when \fIsrc\fR contains unmatched braces.
In these situations, \fBTcl_ConvertElement\fR handles special
characters by generating backslash sequences for them.
The caller may insist on the second approach by OR-ing the
flag value returned by \fBTcl_ScanElement\fR with
\fBTCL_DONT_USE_BRACES\fR.
Although this will produce an uglier result, it is useful in some
special situations, such as when \fBTcl_ConvertElement\fR is being
used to generate a portion of an argument for a Tcl command.
In this case, surrounding \fIsrc\fR with curly braces would cause
the command not to be parsed correctly.
.VE

.SH KEYWORDS
backslash, convert, element, list, merge, split, strings
