/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

   /*
    * This file contains two new converter procedures:
    *
    * 1) A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    *
    * 2) An alternative StringToWidget Converter, which can be more 
    *    effective since it knows the application's top level Widget 
    *    (which is a global variable).
    */ 

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <X11/Shell.h>

#ifdef XPM
#include <xpm.h>
#endif

#include "wafe.h"

#define done(address, type) \
        { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }

 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual!
  * Note that setting a pixmap with setValues therefore implies loosing these 
  * colorcells for the application's lifetime!
  */

#ifdef XPM

typedef struct _PixmapInfo
     {
     Pixmap                pm;              /* Pixmap              */
     Widget                widget;          /* Widget              */
     XpmAttributes         *attribPtr;      /* Colorcells, etc     */
     char                 *pmName;          /* The filename..      */
     struct _PixmapInfo   *next;
     }  PIXMAPINFO, *PIXMAPINFOPTR;

PIXMAPINFOPTR  pixmapListHead = NULL;

int
com_changePixmap(client_data, comInterpreter, argc, argv)
ClientData    client_data;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget          w;
     Colormap        cmap;
     Pixmap          death, pixmap, dummy;
     Screen         *screen;
     Display        *dpy;
     int             screenNum;
     int             returnVal;
     unsigned int    depth;
     XpmAttributes  *attribPtr;
     PIXMAPINFOPTR   pptr, cptr;

     DBUG_ENTER("changePixmap");
     
     if (argc != 4)
          {
          fprintf(stderr, "changePixmapResource: Wrong # of args\n");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(w = name2Widget(argv[1])))
          DBUG_RETURN (TCL_ERROR);     

     dpy = XtDisplay(topLevel);
     screen = DefaultScreenOfDisplay(dpy);
     screenNum = DefaultScreen(dpy);
     depth = DefaultDepth(dpy, DefaultScreen(dpy));

     /* Get pixmap adress and colormap of the pixmap, which will be destroyed
      */

     XtVaGetValues(w, argv[2],     &death, 
                      XtNcolormap, &cmap, NULL);

     /* Search the list of pixmaps to find out wether the specified pixmap's 
      * resources are to be freed - which is the case when it was created by
      * this procedure.
      */

     if (pixmapListHead)
          {
          for (pptr = pixmapListHead; pptr != NULL; pptr = pptr->next)
	       {
               if ((pptr->pm == death) && (pptr->widget == w))
                    {
                    if (!strcmp(pptr->pmName, argv[3]))
		         {
                         DBUG_PRINT("pixmap",
                                   ("You are about to set the same pixmap, no conversion!"));
                         DBUG_RETURN(TCL_OK);
		         }

                    /* Set pixmap to "None" => destroying will be save
                     */

                    XtVaSetValues(w, argv[2], None, NULL);

                    /* Take destroyed Pixmap from pixmaplist and deallocate memory 
                     */

                    DBUG_PRINT("pixmap",
                              ("found pixmap %s of %s, %d colors are freed", argv[2], argv[1],
                               pptr->attribPtr->npixels));

                    XFreePixmap(XtDisplay(topLevel), death);
                    if (pptr->attribPtr->depth > 1) 
                         XFreeColors(XtDisplay(topLevel), cmap, pptr->attribPtr->pixels, 
                                     pptr->attribPtr->npixels, 0);

                    XpmFreeAttributes(pptr->attribPtr);

                    DBUG_PRINT("pixmap",
                              ("Managing the List"));

                    if (pptr == pixmapListHead)
                         {
                         XtFree((char *)pixmapListHead);
                         pixmapListHead = NULL;
                         }
                    else
                         {
                         for(cptr = pixmapListHead; cptr->next != pptr; cptr = cptr->next);

                         if (pptr->next == NULL)     /* last Pixmap in list */
                              cptr->next = NULL;
                         else                        /* not last Pixmap in list */
                              cptr->next = pptr->next;

                         XtFree((char *)pptr);
                         }
	            }
	       }
	}

        /* If the new pixmap's filename is None, => don't create new entry.
         */

        if (!strcmp(argv[3], "None"))
             {
             DBUG_PRINT("pixmap",
                       ("Setting %s %s to none", argv[1], argv[2]));
             XtVaSetValues(w, argv[2], None, NULL);
             DBUG_RETURN(TCL_OK);
	     }

        /* Now convert the new Pixmap-File, create a new element of the list 
         * and fill it with information.
         */


        attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
        attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
        attribPtr->depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(XtDisplay(topLevel)));;

        returnVal = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
                                        argv[3], &pixmap, NULL, attribPtr); 

        if (returnVal == XpmSuccess)
             {
             if (!pixmapListHead)   /* First Pixmap */
                  {
                  cptr = pixmapListHead = (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
                  pixmapListHead->next = NULL;
	          }
             else
	          {
                  for (cptr = pixmapListHead; cptr->next != NULL; cptr = cptr->next);
                  cptr->next = (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
                  cptr = cptr->next;
                  cptr->next = NULL;
                  }

             cptr->widget = w;
             cptr->pm = pixmap;
             cptr->pmName = XtNewString(argv[3]);
	     cptr->attribPtr = attribPtr;

             DBUG_PRINT("pixmap", 
                  ("%d colorcells are used for %s\n", cptr->attribPtr->npixels,
                  cptr->pmName));
     
             XtVaSetValues(w, argv[2], pixmap, NULL);
 
             DBUG_PRINT("pixmap",
             ("Conversion OK, new Pixmap was set"));

             DBUG_RETURN(TCL_OK);
	     }
        else
	     {
             fprintf(stderr, "Wafe(changePixmap): Couldn't convert\n");
             XpmFreeAttributes(attribPtr);
             DBUG_RETURN(TCL_ERROR);
             }
      }     
               
void
CvtStringToPixmapOrBitmap(args, num_args, fromVal, toVal)
XrmValuePtr args;
Cardinal    *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    Pixmap           dummy;
    char            *name;
    Screen          *screen;
    int              screenNum;
    Display         *dpy;
    XrmDatabase      db;
    String           fn;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    XpmAttributes   *attributePtr;
    int              returnValue;
    PIXMAPINFOPTR    pptr, cptr;



    name   = (char *)fromVal->addr;
    dpy = XtDisplay(topLevel);
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);

    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        done(&pixmap, Pixmap);
        return;
        }

    if (strcmp(name, "ParentRelative") == 0) 
        {
        pixmap = ParentRelative;
        done(&pixmap, Pixmap);
        return;
        }



    pixmap = XmuLocateBitmapFile (screen, name,
                                  NULL, 0, NULL, NULL, NULL, NULL);

#ifndef PRER5

    if (pixmap == None) 
        {
        dpy = DisplayOfScreen(screen);
        db = XrmGetDatabase(dpy);
        XrmSetDatabase(dpy, XtScreenDatabase(screen));
        fn = XtResolvePathname(dpy, "bitmaps", name, "", NULL, NULL, 0, NULL);
        if (!fn)
            fn = XtResolvePathname(dpy, "", name, ".xbm", NULL, NULL, 0, NULL);
            XrmSetDatabase(dpy, db);
            if (fn &&
                XmuReadBitmapDataFromFile (fn, &width, &height, &data,
                                           &xhot, &yhot) == BitmapSuccess) {
                pixmap = XCreatePixmapFromBitmapData (dpy,
                                                  RootWindowOfScreen(screen),
                                                  (char *) data, width, height,
                                                  1, 0, 1);
                XFree ((char *)data);
             }
        }

#endif

    if (pixmap != None) 
        {
        done (&pixmap, Pixmap);
        } 
    else 
        {
        if ((returnValue = XpmReadFileToPixmap(XtDisplay(topLevel), RootWindow(dpy, screenNum),
           name, &pixmap, &dummy, NULL)) != XpmSuccess)
           {
           XtStringConversionWarning(name, "Pixmap");
           fprintf(stderr, "XPM-Error-Code: %d\n", returnValue);
           return;
	   }
        else
           done (&pixmap, Pixmap);
        }
    }

#endif                        
    
void 
CvtStringToWidget(args, num_args, fromVal, toVal)
XrmValuePtr args;
Cardinal    *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
    {
    char      *name;
    Widget     w;

    name   = (char *)fromVal->addr;

    if (!(w = name2Widget(name)))
         {
         XtStringConversionWarning(name, "Widget");
         return;
         }
    else
         done(w, Widget);
    }

#ifdef  XPM

int
com_setIconPixmap(client_data, comInterpreter, argc, argv)
ClientData    client_data;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget          w;
     Window       iconWindow;
     Pixmap pixmap, dummy;
     int iconWidth, iconHeight;
     char *iconName;
     XpmAttributes attrib;
     Window     root;
     Screen         *screen;
     Display        *dpy;
     int             screenNum;
     Pixel        bpix;

     DBUG_ENTER("setIconPixmap");

     if (argc != 2) 
	 {
	 argcError("setIconPixmap","",1,argc);
	 DBUG_RETURN(TCL_ERROR);
         }

    dpy = XtDisplay(topLevel);
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    root = RootWindow(dpy, screenNum);
    bpix = XBlackPixelOfScreen(screen);

    iconName = argv[1];

    attrib.valuemask = XpmReturnInfos;

    if (XpmReadFileToPixmap(dpy, root, iconName, &pixmap, &dummy, &attrib) != XpmSuccess)
           {
           fprintf(stderr, "Wafe(setIconPixmap): couldn't convert\n");
	   DBUG_RETURN(TCL_OK);
	   }


     iconWidth = attrib.width;
     iconHeight = attrib.height;

     fprintf(stderr, "width %d, height %d\n", iconWidth, iconHeight);

     iconWindow = XCreateSimpleWindow(dpy, root, 0, 0, iconWidth, iconHeight, 1, bpix, bpix);

     XSetWindowBackgroundPixmap(dpy, iconWindow, pixmap);
     XtVaSetValues(topLevel, XtNiconWindow, iconWindow, NULL);
     DBUG_RETURN(TCL_OK);
   }

#endif







