
#include <dbug.h>
#include <tcl.h>


/*
  * If you are using BSD UNIX, we will use the socketpair call,
  * otherwise we have to work with streams.
  */

/* #define STREAMS */


#define SEND(x) write(toClient, x ,strlen(x)); write(toClient, "\n", 1)
#define ParentWidget(w) ((w) != topLevel ? XtParent(w) : (w))

#if NeedFunctionPrototypes
#define COM_PROTOTYPE(com_tcl) \
	extern int com_tcl(ClientData, Tcl_Interp*, int, char**);
#else
#define COM_PROTOTYPE(com_tcl) extern int com_tcl();
#endif


#define MESSAGE_COMMAND_LENGTH 200
#define INT_AS_STRING 10
#define MAX_NAME_LEN           30
#define MAX_TYPE_LEN           30
#define MESSAGE_COMMAND_LENGTH 200

#define BUF_SIZE               5000
#define COMBUFSIZE             60000
#define STDIN_BUF_SIZE         1000
#define STDERR_BUF_SIZE        1000


#define YES                    1
#define NO                     0


/* 
 * global variables 
 * 
 */

#ifdef MAIN 
#define WAFE_EXTERN
#define INITIALIZE(var,value) var = value
#else
#define WAFE_EXTERN extern
#define INITIALIZE(var, value) var
#endif



WAFE_EXTERN char INITIALIZE(ONE[],"1");
WAFE_EXTERN char INITIALIZE(ZERO[],"0");

WAFE_EXTERN char INITIALIZE(*comBuffer, NULL);

WAFE_EXTERN Tcl_Interp    *interpreter; /* tcl-interpreter for the whole app  */
WAFE_EXTERN XtAppContext   appContext;  /* application context                */
WAFE_EXTERN Widget         topLevel;    /* top level window                   */

WAFE_EXTERN int INITIALIZE(pid, 0);     /* Process-ID of child process        */

WAFE_EXTERN int            comWafe;     /* Extra communication channel        */
WAFE_EXTERN int            comClient;
WAFE_EXTERN int            toClient;    /* Standard Communication Channel     */
WAFE_EXTERN int            fromClient;  /* Standard Communication Channel     */
WAFE_EXTERN int            errorClient; /* For error messages of application  */

WAFE_EXTERN int INITIALIZE(directMode, NO); /* Flags for the different Modes  */
WAFE_EXTERN int INITIALIZE(fileMode, NO);
WAFE_EXTERN int INITIALIZE(inputMode, NO);


WAFE_EXTERN char INITIALIZE(promptChar, '%');


WAFE_EXTERN Widget name2Widget(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN Widget name2Sink(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN Widget name2Source(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN Cardinal getResOfClass(
#if NeedFunctionPrototypes
     WidgetClass, XtResourceList *
#endif
);

WAFE_EXTERN Cardinal getConOfClass(
#if NeedFunctionPrototypes
     WidgetClass, XtResourceList *
#endif
);

#ifdef MAIN

typedef struct _RESINFO
     {
     WidgetClass         wClass;
     XtResourceList      resources;
     Cardinal num;
     struct _RESINFO  *next;
     } RESINFO, *RESINFOPTR;

RESINFOPTR  resourceList = NULL;
RESINFOPTR  constraintList = NULL;

/*
 * Declare the additional application resource:
 * initCom (Class InitCom) can be used to start an interpreter
 */

typedef struct {
    String  init_com;
  }AppData, *AppDataPtr;

AppData    app_data;

static XtResource resources[] = 
     {
     "initCom",
     "InitCom",
     XtRString,
     sizeof(String),
     XtOffset(AppDataPtr, init_com),
     XtRImmediate,
     "noCom",
     };


extern void execActionProc(
#if NeedFunctionPrototypes
     Widget, XEvent *, char **, Cardinal *
#endif
);

COM_PROTOTYPE(com_mergeResources)
COM_PROTOTYPE(com_setValues)
COM_PROTOTYPE(com_getValues)
COM_PROTOTYPE(com_callback)
COM_PROTOTYPE(com_callCallbacks)
COM_PROTOTYPE(com_callActionProc)
COM_PROTOTYPE(com_setCommunicationVariable)
COM_PROTOTYPE(com_getChannel)
COM_PROTOTYPE(com_getResourceList)

/* 
 * These are the extern declarations and prototypings for all functions 
 * and tcl-commands concerning handlers.
 * The source code can be found in the file HANDLERS.C
 */

extern void getInput(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

extern void communicationHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

extern void stdinHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

COM_PROTOTYPE(com_stdinHandler)
COM_PROTOTYPE(com_unregisterStdinHandler)

extern void stderrHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

COM_PROTOTYPE(com_stderrHandler)
COM_PROTOTYPE(com_unregisterStderrHandler)
COM_PROTOTYPE(com_stdoutHandler)
COM_PROTOTYPE(com_unregisterStdoutHandler)
COM_PROTOTYPE(com_addTimeOut)

extern void timerProc(
#if NeedFunctionPrototypes
     XtPointer, XtIntervalId *
#endif
);


/*
 * Functions from file CONVERTERS.C
 */

#ifdef XPM
extern void CvtStringToPixmapOrBitmap(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);
#endif

extern void CvtStringToWidget(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);

#ifdef XPM
COM_PROTOTYPE(com_changePixmap)
COM_PROTOTYPE(com_setIconPixmap)
#endif
     
/*
 * Functions from file STRIPCHART.C
 */

COM_PROTOTYPE(com_stripChart)

/*
 * Functions from file LIST.C
 */

COM_PROTOTYPE(com_listAppend)
COM_PROTOTYPE(com_listChange)

/*
 * Functions and extern variables from file ASCIITEXT.C
 */

COM_PROTOTYPE(com_asciiTextAppend)

extern XtResource textResList[];

/*
 * Functions from file SELECTION.C
 */

COM_PROTOTYPE(com_ownSelection)

/*
 * The following functions are used to generate the different widget commands,
 * depending on your version of X11. They are located in ATHENAWIDGETS.C, 
 * TREE.C and TALK.C. 
 */

extern void createR4WidgetCommands(
#if NeedFunctionPrototypes
     void
#endif
);

#ifndef PRER5

extern void createR5WidgetCommands(
#if NeedFunctionPrototypes
     void
#endif
);

#else

/* 
 * If Release is 4 or less, dummy functions will be registered for the
 * R5 commands, which will just write a warning message and exit. Again, 
 * compare to ATHENAWIDGETS.C
 */

extern void createR5WarningCommands(
#if NeedFunctionPrototypes
     void
#endif
);

extern int r5WarningCommand(
#if NeedFunctionPrototypes
     ClientData, Tcl_Interp*, int, char**
#endif
);

#endif

/* here is still #ifdef MAIN */

#else

/* here is #ifndef MAIN */

/*************************************************************************
 * The following is for for all files eccept wafe.c                   
 *************************************************************************/ 

void
convError (
#if NeedFunctionPrototypes
	   char*, char*, char*, char*
#endif
);

extern void scSet(
#if NeedFunctionPrototypes
     Widget, double
#endif
);


void
argcError (
#if NeedFunctionPrototypes
	   char*, char*, int, int
#endif
);

void
noVarCompError (
#if NeedFunctionPrototypes
	   char*, char*, char*
#endif
);

extern int convert(
#if NeedFunctionPrototypes
     Widget, WidgetClass, char**, int, ArgList*, int*
#endif
);

extern char *getTypeOfAttribute(
#if NeedFunctionPrototypes
     WidgetClass, Widget, char *
#endif
);

#endif


