/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Thu Apr 23 18:24:59 MET DST 1992 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.9
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "wafe.h"

#include <X11/Xaw/AsciiText.h>

/* 
 * XawTextPosition
 * XawTextSourceRead 
 * 	in: (Widget)TextSource
 * 	in: XawTextPosition
 * 	out: XawTextBlock
 * 	in: int
 */

int 
com_textSourceRead(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextBlock localVar3;
     int localVar4;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSourceRead");  

     if (argc != 5) 
	 {
	 argcError("textSourceRead","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Source(argv[1])))
          {
          convError("textSourceRead","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSourceRead","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("textSourceRead","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSourceRead(localVar1,localVar2,&localVar3,localVar4);

          sprintf(conversionBuffer, "%d", localVar3.firstPos);
     Tcl_SetVar2(interpreter,argv[3],"firstPos", conversionBuffer,0);
     sprintf(conversionBuffer, "%d", localVar3.length);
     Tcl_SetVar2(interpreter,argv[3],"length", conversionBuffer,0);
     
     Tcl_SetVar2(interpreter,argv[3],"ptr", localVar3.ptr,0);


sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceScan
 * 	in: (Widget)TextSource
 * 	in: XawTextPosition
 * 	in: XawTextScanType
 * 	in: XawTextScanDirection
 * 	in: int
 * 	in: Boolean
 */

int 
com_textSourceScan(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextScanType localVar3;
     XawTextScanDirection localVar4;
     int localVar5;
     Boolean localVar6;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSourceScan");  

     if (argc != 7) 
	 {
	 argcError("textSourceScan","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Source(argv[1])))
          {
          convError("textSourceScan","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSourceScan","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "position")) 
         localVar3 = XawstPositions;
     else
     if (!strcmp(argv[3], "whiteSpace")) 
         localVar3 = XawstWhiteSpace;
     else
     if (!strcmp(argv[3], "EOL")) 
         localVar3 = XawstEOL;
     else
     if (!strcmp(argv[3], "paragraph")) 
         localVar3 = XawstParagraph;
     else
     if (!strcmp(argv[3], "all")) 
         localVar3 = XawstAll;
     else
         {
         convError("textSourceScan","3",argv[3],"XawTextScanType");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "right")) 
         localVar4 = XawsdRight;
     else
     if (!strcmp(argv[4], "Left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "Right")) 
         localVar4 = XawsdRight;
     else
         {
         convError("textSourceScan","4",argv[4],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("textSourceScan","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
         {
         convError("textSourceScan","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XawTextSourceScan(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxLines
 * 	in: (Widget)TextSink
 * 	in: Dimension
 */

int 
com_textSinkMaxLines(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSinkMaxLines");  

     if (argc != 3) 
	 {
	 argcError("textSinkMaxLines","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Sink(argv[1])))
          {
          convError("textSinkMaxLines","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSinkMaxLines","2",argv[2],"Dimension");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxLines(localVar1,localVar2);

sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxHeight
 * 	in: (Widget)TextSink
 * 	in: Dimension
 */

int 
com_textSinkMaxHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSinkMaxHeight");  

     if (argc != 3) 
	 {
	 argcError("textSinkMaxHeight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Sink(argv[1])))
          {
          convError("textSinkMaxHeight","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSinkMaxHeight","2",argv[2],"Dimension");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxHeight(localVar1,localVar2);

sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetSelectionArray
 * 	in: Widget
 * 	in: [XawTextSelectType]
 */

int 
com_textSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextSelectType * localVar2;

     DBUG_ENTER("textSetSelectionArray");  

     if (argc < 3) 
	 {
	 argcError("textSetSelectionArray","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textSetSelectionArray","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    XawTextSelectType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XawTextSelectType *)XtMalloc((argc-2)*sizeof(XawTextSelectType));

          while (*argv)
             {
             if (!strcmp(*argv, "selectAll")) 
                 *ptr = XawselectAll;
             else
             if (!strcmp(*argv, "selectChar")) 
                 *ptr = XawselectChar;
             else
             if (!strcmp(*argv, "selectLine")) 
                 *ptr = XawselectLine;
             else
             if (!strcmp(*argv, "selectNull")) 
                 *ptr = XawselectNull;
             else
             if (!strcmp(*argv, "selectParagraph")) 
                 *ptr = XawselectParagraph;
             else
             if (!strcmp(*argv, "selectPosition")) 
                 *ptr = XawselectPosition;
             else
             if (!strcmp(*argv, "selectWord")) 
                 *ptr = XawselectWord;
             else
                 {
                 convError("textSetSelectionArray","2",*argv,"XawTextSelectType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     XawTextSetSelectionArray(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSinkSetTabs
 * 	in: (Widget)TextSink
 * 	const: argc-2
 * 	in: [int]
 */

int 
com_textSinkSetTabs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int * localVar2;

     DBUG_ENTER("textSinkSetTabs");  

     if (argc < 3) 
	 {
	 argcError("textSinkSetTabs","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Sink(argv[1])))
          {
          convError("textSinkSetTabs","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     {    int *ptr;
          argv += 2;
          localVar2 = ptr =
             (int *)XtMalloc((argc-2)*sizeof(int));

          while (*argv)
             {
             if (!(sscanf(*argv, "%d", &*ptr)))
                  {
                  convError("textSinkSetTabs","2",*argv,"int");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XawTextSinkSetTabs(localVar1,argc-2,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSearch
 * 	in: Widget
 * 	in: XawTextScanDirection
 * 	in: XawTextBlock
 */

int 
com_textSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextScanDirection localVar2;
     XawTextBlock localVar3;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSearch");  

     if (argc != 4) 
	 {
	 argcError("textSearch","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textSearch","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "right")) 
         localVar2 = XawsdRight;
     else
     if (!strcmp(argv[2], "Left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "Right")) 
         localVar2 = XawsdRight;
     else
         {
         convError("textSearch","2",argv[2],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     { char *charp;
         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"firstPos", 0)))
               {
               noVarCompError("textSearch",argv[3],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.firstPos)))
              {
              convError("textSearch","3.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"length", 0)))
               {
               noVarCompError("textSearch",argv[3],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.length)))
              {
              convError("textSearch","3.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"ptr", 0)))
               {
               noVarCompError("textSearch",argv[3],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar3.ptr = charp;
     }

     returnVar = XawTextSearch(localVar1,localVar2,&localVar3);

sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextInvalidate
 * 	in: Widget
 * 	in: XawTextPosition
 * 	in: XawTextPosition
 */

int 
com_textInvalidate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("textInvalidate");  

     if (argc != 4) 
	 {
	 argcError("textInvalidate","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textInvalidate","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textInvalidate","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textInvalidate","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextInvalidate(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextEnableRedisplay
 * 	in: Widget
 */

int 
com_textEnableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textEnableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("textEnableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textEnableRedisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextEnableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisableRedisplay
 * 	in: Widget
 */

int 
com_textDisableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textDisableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("textDisableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textDisableRedisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplay
 * 	in: Widget
 */

int 
com_textDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textDisplay");  

     if (argc != 2) 
	 {
	 argcError("textDisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textDisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextTopPosition
 * 	in: Widget
 */

int 
com_textTopPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textTopPosition");  

     if (argc != 2) 
	 {
	 argcError("textTopPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textTopPosition","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextTopPosition(localVar1);

sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetInsertionPoint
 * 	in: Widget
 * 	in: XawTextPosition
 */

int 
com_textSetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;

     DBUG_ENTER("textSetInsertionPoint");  

     if (argc != 3) 
	 {
	 argcError("textSetInsertionPoint","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textSetInsertionPoint","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSetInsertionPoint","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetInsertionPoint(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextGetInsertionPoint
 * 	in: Widget
 */

int 
com_textGetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textGetInsertionPoint");  

     if (argc != 2) 
	 {
	 argcError("textGetInsertionPoint","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textGetInsertionPoint","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextGetInsertionPoint(localVar1);

sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplayCaret
 * 	in: Widget
 * 	in: Boolean
 */

int 
com_textDisplayCaret(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("textDisplayCaret");  

     if (argc != 3) 
	 {
	 argcError("textDisplayCaret","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textDisplayCaret","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("textDisplayCaret","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawTextDisplayCaret(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextGetSelectionPos
 *         in: Widget 
 *         out: XawTextPosition
 *         out: XawTextPosition
 */

int 
com_textGetSelectionPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("textGetSelectionPos");  

     if (argc != 4) 
	 {
	 argcError("textGetSelectionPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textGetSelectionPos","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextGetSelectionPos(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(interpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextSetSelection
 *         in: Widget 
 *         in: XawTextPosition
 *         in: XawTextPosition
 */

int 
com_textSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("textSetSelection");  

     if (argc != 4) 
	 {
	 argcError("textSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textSetSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSetSelection","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textSetSelection","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetSelection(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextUnsetSelection
 *         in: Widget
 */

int 
com_textUnsetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textUnsetSelection");  

     if (argc != 2) 
	 {
	 argcError("textUnsetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textUnsetSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextUnsetSelection(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) ReplaceVal 
 * XawTextReplace
 *         in: Widget 
 *         in: XawTextPosition 
 *         in: XawTextPosition 
 *         in: XawTextBlock
 */

int 
com_textReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     XawTextBlock localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textReplace");  

     if (argc != 5) 
	 {
	 argcError("textReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("textReplace","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textReplace","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textReplace","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     { char *charp;
         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"firstPos", 0)))
               {
               noVarCompError("textReplace",argv[4],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.firstPos)))
              {
              convError("textReplace","4.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"length", 0)))
               {
               noVarCompError("textReplace",argv[4],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.length)))
              {
              convError("textReplace","4.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"ptr", 0)))
               {
               noVarCompError("textReplace",argv[4],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar4.ptr = charp;
     }

     returnVar = XawTextReplace(localVar1,localVar2,localVar3,&localVar4);

     if (returnVar == XawEditDone) 
          strcpy(conversionBuffer, "editDone");
     else
     if (returnVar == XawPositionError) 
          strcpy(conversionBuffer, "positionError");
     else
     if (returnVar == XawEditError) 
          strcpy(conversionBuffer, "editError");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int 
 * XawAsciiSaveAsFile
 *         in: XawTextGetSource(Widget)
 *         in: char *
 */

int 
com_asciiSaveAsFile(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSaveAsFile");  

     if (argc != 3) 
	 {
	 argcError("asciiSaveAsFile","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("asciiSaveAsFile","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     returnVar = XawAsciiSaveAsFile(XawTextGetSource(localVar1),localVar2);

sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawAsciiSourceFreeString
 * 	in: XawTextGetSource(Widget)
 */

int 
com_asciiSourceFreeString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("asciiSourceFreeString");  

     if (argc != 2) 
	 {
	 argcError("asciiSourceFreeString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("asciiSourceFreeString","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawAsciiSourceFreeString(XawTextGetSource(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSave
 * 	in: XawTextGetSource(Widget)
 */

int 
com_asciiSave(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSave");  

     if (argc != 2) 
	 {
	 argcError("asciiSave","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("asciiSave","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSave(XawTextGetSource(localVar1));

     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSourceChanged 
 * 	in: XawTextGetSource(Widget)
 */

int 
com_asciiSourceChanged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSourceChanged");  

     if (argc != 2) 
	 {
	 argcError("asciiSourceChanged","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("asciiSourceChanged","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSourceChanged(XawTextGetSource(localVar1));

     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Form.h>

/* 
 * void
 * XawFormDoLayout
 * 	in: Widget
 * 	in: Boolean
 */

int 
com_formDoLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("formDoLayout");  

     if (argc != 3) 
	 {
	 argcError("formDoLayout","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("formDoLayout","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("formDoLayout","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawFormDoLayout(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Toggle.h>

#define toggleSetRadioData(w, string) XtVaSetValues(w, XtNradioData, string, NULL)

/* 
 * void
 * toggleSetRadioData
 * 	in: Widget
 *         in: XtNewString(char *)
 */

int 
com_toggleSetRadioData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;

     DBUG_ENTER("toggleSetRadioData");  

     if (argc != 3) 
	 {
	 argcError("toggleSetRadioData","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("toggleSetRadioData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     toggleSetRadioData(localVar1,XtNewString(localVar2));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleChangeRadioGroup
 * 	in: Widget
 * 	in: NULL | Widget
 */

int 
com_toggleChangeRadioGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("toggleChangeRadioGroup");  

     if (argc != 3) 
	 {
	 argcError("toggleChangeRadioGroup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("toggleChangeRadioGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
     if (!(localVar2 = name2Widget(argv[2])))
          {
          convError("toggleChangeRadioGroup","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleChangeRadioGroup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleSetCurrent
 * 	in: Widget
 * 	in: char *
 */

int 
com_toggleSetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;

     DBUG_ENTER("toggleSetCurrent");  

     if (argc != 3) 
	 {
	 argcError("toggleSetCurrent","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("toggleSetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     XawToggleSetCurrent(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * char *
 * XawToggleGetCurrent
 * 	in: Widget
 */

int 
com_toggleGetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * returnVar;

     DBUG_ENTER("toggleGetCurrent");  

     if (argc != 2) 
	 {
	 argcError("toggleGetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("toggleGetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawToggleGetCurrent(localVar1);


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleUnsetCurrent
 * 	in: Widget
 */

int 
com_toggleUnsetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("toggleUnsetCurrent");  

     if (argc != 2) 
	 {
	 argcError("toggleUnsetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("toggleUnsetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleUnsetCurrent(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#ifndef PRER5

#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>

extern void portholeCallbackProc();
extern void pannerCallbackProc();

#endif

#define talk(pa, po, ch) XtAddCallback(po, XtNreportCallback, portholeCallbackProc, (XtPointer) pa); XtAddCallback(pa, XtNreportCallback, pannerCallbackProc, (XtPointer) ch)

/* 
 * hint: R5
 * void
 * talk
 * 	in: Widget
 * 	in: Widget
 * 	in: Widget
 */
#ifndef PRER5

int 
com_talk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER("talk");  

     if (argc != 4) 
	 {
	 argcError("talk","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("talk","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = name2Widget(argv[2])))
          {
          convError("talk","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = name2Widget(argv[3])))
          {
          convError("talk","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     talk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     
#endif

#include <X11/Xaw/List.h>

/* 
 * void
 * XawListUnhighlight
 * 	in: Widget
 */

int 
com_listUnhighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("listUnhighlight");  

     if (argc != 2) 
	 {
	 argcError("listUnhighlight","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("listUnhighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListUnhighlight(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListHighlight
 * 	in: Widget
 * 	in: int
 */

int 
com_listHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("listHighlight");  

     if (argc != 3) 
	 {
	 argcError("listHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("listHighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("listHighlight","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawListReturnStruct *
 * XawListShowCurrent
 * 	in: Widget
 */

int 
com_listShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("listShowCurrent");  

     if (argc != 2) 
	 {
	 argcError("listShowCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("listShowCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawListShowCurrent(localVar1);

     
     Tcl_SetVar2(interpreter,"returnVar","string", returnVar->string,0);
     sprintf(conversionBuffer, "%d", returnVar->list_index);
     Tcl_SetVar2(interpreter,"returnVar","list_index", conversionBuffer,0);

     Tcl_SetResult(comInterpreter, "returnVar", TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#ifndef PRER5
#include <X11/Xaw/Tree.h>
#endif

/* 
 * hint: R5
 * void
 * XawTreeForceLayout
 * 	in: Widget
 */
#ifndef PRER5

int 
com_treeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("treeForceLayout");  

     if (argc != 2) 
	 {
	 argcError("treeForceLayout","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("treeForceLayout","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }     
#endif

#include <X11/Xaw/Scrollbar.h>

/* 
 * void
 * XawScrollbarSetThumb
 * 	in: Widget
 * 	in: float
 * 	in: float
 */

int 
com_scrollbarSetThumb(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;
     float localVar3;

     DBUG_ENTER("scrollbarSetThumb");  

     if (argc != 4) 
	 {
	 argcError("scrollbarSetThumb","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("scrollbarSetThumb","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%f", &localVar2)))
          {
          convError("scrollbarSetThumb","2",argv[2],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%f", &localVar3)))
          {
          convError("scrollbarSetThumb","3",argv[3],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     XawScrollbarSetThumb(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/StripChart.h>

/* 
 * void
 * scSet
 * 	in: Widget
 * 	in: double
 */

int 
com_scSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;

     DBUG_ENTER("scSet");  

     if (argc != 3) 
	 {
	 argcError("scSet","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("scSet","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
          {
          convError("scSet","2",argv[2],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     scSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Dialog.h>

/* 
 * char *
 * XawDialogGetValueString
 * 	in: Widget
 */

int 
com_dialogGetValueString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * returnVar;

     DBUG_ENTER("dialogGetValueString");  

     if (argc != 2) 
	 {
	 argcError("dialogGetValueString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("dialogGetValueString","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawDialogGetValueString(localVar1);


     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Paned.h>

/* 
 * void
 * XawPanedAllowResize
 * 	in: Widget
 * 	in: Boolean
 */

int 
com_panedAllowResize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("panedAllowResize");  

     if (argc != 3) 
	 {
	 argcError("panedAllowResize","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("panedAllowResize","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("panedAllowResize","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedAllowResize(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedSetMinMax
 * 	in: Widget
 * 	in: int
 * 	in: int
 */

int 
com_panedSetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("panedSetMinMax");  

     if (argc != 4) 
	 {
	 argcError("panedSetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("panedSetMinMax","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("panedSetMinMax","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("panedSetMinMax","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedSetMinMax(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedGetMinMax
 * 	in: Widget
 * 	out: int
 * 	out: int
 */

int 
com_panedGetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("panedGetMinMax");  

     if (argc != 4) 
	 {
	 argcError("panedGetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("panedGetMinMax","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedGetMinMax(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(interpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawPanedSetRefigureMode
 * 	in: Widget
 * 	in: Boolean
 */

int 
com_panedSetRefigureMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("panedSetRefigureMode");  

     if (argc != 3) 
	 {
	 argcError("panedSetRefigureMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("panedSetRefigureMode","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("panedSetRefigureMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedSetRefigureMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawPanedGetNumSub
 * 	in: Widget
 */

int 
com_panedGetNumSub(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("panedGetNumSub");  

     if (argc != 2) 
	 {
	 argcError("panedGetNumSub","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("panedGetNumSub","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawPanedGetNumSub(localVar1);

sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/SimpleMenu.h>

/* 
 * Widget
 * XawSimpleMenuGetActiveEntry
 * 	in: Widget
 */

int 
com_simpleMenuGetActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("simpleMenuGetActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("simpleMenuGetActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("simpleMenuGetActiveEntry","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawSimpleMenuGetActiveEntry(localVar1);


     Tcl_SetResult(comInterpreter, XtName(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawSimpleMenuClearActiveEntry
 * 	in: Widget
 */

int 
com_simpleMenuClearActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("simpleMenuClearActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("simpleMenuClearActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = name2Widget(argv[1])))
          {
          convError("simpleMenuClearActiveEntry","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawSimpleMenuClearActiveEntry(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


