#
# HTML (almost) definitions for the tagged program
# ================================================
#
# Each TAG is described in single line consisting of the following fields
#
#	tag:options:class:presentation:begin:line:end
#
# Each field value is a string, with leading and trailing white space
# eliminated. If special characters and white space is required, one
# can enclose the string into double quotes ("...").
#
# tag	is the name of the tag. Currently tags are compared in lower
#	case, so write them in all lower case here. An empty tag sets
#	options for the default initial state.
#
# options
#	gives processing options, each option is represented by a single
#	character. (Convention: lower case letters represent processing
#	options, uppercase letters control syntax options).
#
#	i	inclusive, if the a TAG with the same 'class' is already
#		in effect, this tag will not cause any change and can
#		be optionally ignored. Currently affects only editing and
#		prevents the creating constructs like
#			<bold><bold><bold> ... </bold></bold></bold>
#
#	a, s	add or subtract, multiple stacked TAGs of this class
#		have cumulative interpretation. The counting is based
#		on class field:
#
#		...<bigger>...<smaller>...</smaller>...</bigger>...
#		 0          1           0            1           0
#
#	o	override, the effect of the tag completely overrides the
#		effects of any previous tag that has the same class.
#
#	Options 'i', 'a', 's' and 'o' are mutually exclusive, only one of
#	them will be in effect for each TAG (currently the last specified).
#	The default value is 'i'.
#
#	E	NL (new line) interpretation is as specified in MIME
#		text/enriched: Isolated NLs are interpreted as SPACE, N
#		consecutive NLs (N > 1), will be interpreted as N-1 hard
#		NLs. On output, lines are wrapped below 80 characters, if
#		possible by mapping a SPACE into isolated NL.
#
#	H	All Newlines are assumed as "hard newlines" and interpreted
#		as such. No wrapping occurs on output.
#
# class
#	is a string to be associated with the tag and it is used in grouping
#	tags (see options for description). This string is compared as is,
#	case sensitive.
#
# presentation
#	This string describes the presentation of the content affected by
#	this tag. The string should contain control sequences from
#	ISO 6429 (the list of supported sequences depends on current
#	XeText widget implementation). At any point, the final presentation
#	control string applied will be the concatenation of the presentation
#	strings of all tags in effect at that point:
#
#	..<bold>.......<italic>..............</italic>.......<bold>...
#	 ""    "\033[1m"      "\033[1m\033[3m"       "\033[1m"    ""
#
# begin, line, end
#	Three strings that will be inserted to the layout content:
#	'begin' is used when the tag opens, 'end' is used when it closes
#	and 'line' is used at the beginning of each line that starts
#	with the tag. As with presentation, all these strings are a
#	concatenation of the all strings from the tags in effect.
#	(IMPLEMENTATION UNDER CONSTRUCTION, NOT FULLY WORKING YET)
#
# tag:options:class:rendition:	begin:		line:	end
# ============================	======		=====	===
:iE:None:"\033K\033K\033L\033[2 F\033[0m"
h1:o:Basic:"\033[200 B\033[1m\033[6 F":"\r\n"	:	:"\n\r\036"
h2:o:Basic:"\033[150 B\033[1m"	:"\r\n"		:	:"\n\r\036"
h3:o:Basic:"\033[150 B\033[3m"	:"\r\n"		:" "	:"\036"
h4:o:Basic:"\033[ B\033[1m"	:"\r\n"		:"  "	:"\036"
h5:o:Basic:"\033[ B\033[3m"	:"\r\n"		:"  "	:"\036"
h6:o:Basic:"\033[ B\033[1m"	:"\r\n"		:	:"\036"
a:o:Anchor:"\033[ B\033[1;4m"
p:o:Basic:			:		:	:"\n\r\036"
address:o:Basic:"\033[ B\033[3m"	:		:	:"\036"
br:o:LineBreak	:		:"\r\n"
blockquote:a:Basic:"\033[ B\033[3m"	:">\t"		:	:"\036"
dl:o:Basic:
dt:o:Term:			:"\r\n\036"	:	:"\t"
dd:o:Term:			:		:	:"\036"
ul:o:Basic:
ol:o:Basic:
li:a:Elem:			:"\r\n\036"-\t"
pre:oE:Basic:"\033[19m"
tt:i:Typewriter:"\033[19m"
b:i:Bold:"\033[1m"
strong:i:Bold:	"\033[1m"
i:i:Italic:"\033[3m"
u:i:Underline:"\033[4m"
em:i:Italic:"\033[3m"
dfn:i:Italic:"\033[3m"
cite:i:BoldItalic:"\033[1;3m"
var:i:Formatted:"\033[19m"
kbd:i:Formatted:"\033[19m"
code:oE:Formatted:"\033[19m"

