/*
** frame_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to XeFrame
**	resources.
*/

UI_ElementDef frame_list[] =
    {
	UI_PANE("Frame Position"),
	UI_INPUT("positioning:"),
	UI_LOAD(XtNframePosition),
	UI_INPUT("alignemnt:"),
	UI_LOAD(XtNframeAlignment),

	UI_LABEL("Frame Dimension"),
	UI_INPUT("Horizontal: "),
	UI_LOAD(XtNhorizontal),
	UI_INPUT("Vertical: "),
	UI_LOAD(XtNvertical),

	UI_PANE("Frame Offsets"),
	UI_INPUT("left:"),
	UI_LOAD(XtNleftOffset),
	UI_INPUT("right:"),
	UI_LOAD(XtNrightOffset),
	UI_INPUT("trailing:"),
	UI_LOAD(XtNtrailingOffset),
	UI_INPUT("leading:"),
	UI_LOAD(XtNleadingOffset),

	UI_LABEL("Frame separation"),
	UI_INPUT("trailing:"),
	UI_LOAD(XtNtrailingSeparation),
	UI_INPUT("leading:"),
	UI_LOAD(XtNleadingSeparation),
	UI_INPUT("center:"),
	UI_LOAD(XtNcenterSeparation),

	UI_PANE("Frame borders"),
	UI_INPUT("left: "),
	UI_LOAD(XtNleftBorder),
	UI_INPUT("right: "),
	UI_LOAD(XtNrightBorder),
	UI_INPUT("trailing: "),
	UI_LOAD(XtNtrailingBorder),
	UI_INPUT("leading: "),
	UI_LOAD(XtNleadingBorder),
	UI_END(),
    };

extern UI_PanelDef frame_resources;

static UI_ActionDef frame_actions[] =
    {
	{"set", UI_AcceptPanel, (XtPointer)&frame_resources},
	{"close"},
	{NULL},	    
    };


UI_PanelDef frame_resources = 
    {
	"resources",
	frame_list,
	frame_actions,
    };

