#!/bin/sh

tmp=/tmp/gl.$$
nm $* | egrep '(Widget|Obj|Object)Class' | \
awk '{ if ($2 == "D" || $2 == "G") print $3; }' | sed -e 's/^_//' | \
(cat - ; echo "objectClass") | sort -u | egrep -v 'ClassRec$' | \
egrep -v 'vPanedWidgetClass$' | \
egrep -v 'ascii(Disk|String)WidgetClass$' | \
awk '
{
    printf "extern WidgetClass %s;\n", $1;
    printf "{ \"%s\", &%s },\n", $1, $1;
}' | sed -e 's/WidgetClass"/"/' -e 's/ObjClass"/"/' \
	 -e 's/ObjectClass"/"/' -e 's/objectClass"/object"/' \
	 -e 's/widgetClass"/widget"/' >$tmp

cat <<EOF
/*
 * This file is generated by the genlist.sh script and contains an array of
 * all the widgets in EuroBridge widget set.
 *
 * \$XConsortium\$
 */
#include <X11/IntrinsicP.h>
#ifndef Have_XmuWidgetNode
#define Have_XmuWidgetNode ((XtVersion) > 11004)
#endif
#if Have_XmuWidgetNode
#include <X11/Xmu/WidgetNode.h>
#endif

EOF
egrep '^extern WidgetClass' $tmp
echo ""
cat <<EOF
#if Have_XmuWidgetNode
XmuWidgetNode XewWidgetArray[] = {
EOF
egrep '^{' $tmp
cat <<EOF
};

int XewWidgetCount = XtNumber(XewWidgetArray);
#endif
EOF

rm $tmp
