#ifndef _XewSupport_h
#define _XewSupport_h
/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Basic.h>

/*
** Major Content Classes (each having a matching Widget class)
*/
typedef enum
    {
	XeContentClass_UNKNOWN,
	XeContentClass_TEXT,
	XeContentClass_RASTER,
	XeContentClass_AUDIO,
	XeContentClass_VIDEO,
	XeContentClass_GEOMETRIC
    } XeContentClass;

/*
** XeFindContentFormat
**	An utility function that tries to guess the content format
**	and returns the XeContentFormat type guessed. A failure to
**	guess or any error results a value XeContentFormat_UNKNOWN
**	to be returned.
**
**	The current implementation only works for Raster Images.
**	(Enchance this later --msa)
*/
_XFUNCPROTOBEGIN
XeContentFormat XeFindContentFormat
	(
#if NeedFunctionPrototypes
	 char *
#endif
	 );
/*
** XeFindContentClass
**	Return the major content class that supports the specified
**	content format.
*/
XeContentClass XeFindContentClass
	(
#if NeedFunctionPrototypes
	 XeContentFormat
#endif
	 );
_XFUNCPROTOEND
#endif


