'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: text.n,v 1.9 2001/08/01 16:21:11 dgp Exp $
'\" 
.so man.macros
.TH text n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
text, tk_textCopy, tk_textCut, tk_textPaste \- Create and manipulate text widgets
.SH SYNOPSIS
.nf
\fBtext\fR \fIpathName \fR?\fIoptions\fR?
.VS 8.4
\fBtk_textCopy\fR \fIpathName\fR
\fBtk_textCut\fR \fIpathName\fR
\fBtk_textPaste\fR \fIpathName\fR
.VE
.SO
\-background	\-highlightthickness	\-relief
\-borderwidth	\-insertbackground	\-selectbackground
\-cursor	\-insertborderwidth	\-selectborderwidth
\-exportselection	\-insertofftime	\-selectforeground
\-font	\-insertontime	\-setgrid
\-foreground	\-insertwidth	\-takefocus
\-highlightbackground	\-padx	\-xscrollcommand
\-highlightcolor	\-pady	\-yscrollcommand
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-height height Height
Specifies the desired height for the window, in units of characters
in the font given by the \fB\-font\fR option.
Must be at least one.
.OP \-spacing1 spacing1 Spacing1
Requests additional space above each text line in the widget,
using any of the standard forms for screen distances.
If a line wraps, this option only applies to the first line
on the display.
This option may be overriden with \fB\-spacing1\fR options in
tags.
.OP \-spacing2 spacing2 Spacing2
For lines that wrap (so that they cover more than one line on the
display) this option specifies additional space to provide between
the display lines that represent a single line of text.
The value may have any of the standard forms for screen distances.
This option may be overriden with \fB\-spacing2\fR options in
tags.
.OP \-spacing3 spacing3 Spacing3
Requests additional space below each text line in the widget,
using any of the standard forms for screen distances.
If a line wraps, this option only applies to the last line
on the display.
This option may be overriden with \fB\-spacing3\fR options in
tags.
.OP \-state state State
Specifies one of two states for the text:  \fBnormal\fR or \fBdisabled\fR.
If the text is disabled then characters may not be inserted or deleted
and no insertion cursor will be displayed, even if the input focus is
in the widget.
.OP \-tabs tabs Tabs
Specifies a set of tab stops for the window.  The option's value consists
of a list of screen distances giving the positions of the tab stops.  Each
position may optionally be followed in the next list element
by one of the keywords \fBleft\fR, \fBright\fR, \fBcenter\fR,
or \fBnumeric\fR, which specifies how to justify
text relative to the tab stop.  \fBLeft\fR is the default; it causes
the text following the tab character to be positioned with its left edge
at the tab position.  \fBRight\fR means that the right edge of the text
following the tab character is positioned at the tab position, and
\fBcenter\fR means that the text is centered at the tab position.
\fBNumeric\fR means that the decimal point in the text is positioned
at the tab position;  if there is no decimal point then the least
significant digit of the number is positioned just to the left of the
tab position;  if there is no number in the text then the text is
right-justified at the tab position.
For example, \fB\-tabs {2c left 4c 6c center}\fR creates three
tab stops at two-centimeter intervals;  the first two use left
justification and the third uses center justification.
If the list of tab stops does not have enough elements to cover all
of the tabs in a text line, then Tk extrapolates new tab stops using
the spacing and alignment from the last tab stop in the list.
The value of the \fBtabs\fR option may be overridden by \fB\-tabs\fR
options in tags.
If no \fB\-tabs\fR option is specified, or if it is specified as
an empty list, then Tk uses default tabs spaced every eight
(average size) characters.
.OP \-width width Width
Specifies the desired width for the window in units of characters
in the font given by the \fB\-font\fR option.
If the font doesn't have a uniform width then the width of the
character ``0'' is used in translating from character units to
screen units.
.OP \-wrap wrap Wrap
Specifies how to handle lines in the text that are too long to be
displayed in a single line of the text's window.
The value must be \fBnone\fR or \fBchar\fR or \fBword\fR.
A wrap mode of \fBnone\fR means that each line of text appears as
exactly one line on the screen;  extra characters that don't fit
on the screen are not displayed.
In the other modes each line of text will be broken up into several
screen lines if necessary to keep all the characters visible.
In \fBchar\fR mode a screen line break may occur after any character;
in \fBword\fR mode a line break will only be made at word boundaries.
.BE

.SH DESCRIPTION
.PP
The \fBtext\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a text widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the text such as its default background color
and relief.  The \fBtext\fR command returns the
path name of the new window.
.PP
A text widget displays one or more lines of text and allows that
text to be edited.
.VS
Text widgets support four different kinds of annotations on the
text, called tags, marks, embedded windows or embedded images.
.VE
Tags allow different portions of the text
to be displayed with different fonts and colors.
In addition, Tcl commands can be associated with tags so
that scripts are invoked when particular actions such as keystrokes
and mouse button presses occur in particular ranges of the text.
See TAGS below for more details.
.PP
The second form of annotation consists of marks, which are floating
markers in the text.
Marks are used to keep track of various interesting positions in the
text as it is edited.
See MARKS below for more details.
.PP
The third form of annotation allows arbitrary windows to be
embedded in a text widget.
See EMBEDDED WINDOWS below for more details.
.PP
.VS
The fourth form of annotation allows Tk images to be embedded in a text
widget.
See EMBEDDED IMAGES below for more details.
.VE

.SH INDICES
.PP
Many of the widget commands for texts take one or more indices
as arguments.
An index is a string used to indicate a particular place within
a text, such as a place to insert characters or one endpoint of a
range of characters to delete.
Indices have the syntax
.CS
\fIbase modifier modifier modifier ...\fR
.CE
Where \fIbase\fR gives a starting point and the \fImodifier\fRs
adjust the index from the starting point (e.g. move forward or
backward one character).  Every index must contain a \fIbase\fR,
but the \fImodifier\fRs are optional.
.PP
The \fIbase\fR for an index must have one of the following forms:
.TP 12
\fIline\fB.\fIchar\fR
Indicates \fIchar\fR'th character on line \fIline\fR.
Lines are numbered from 1 for consistency with other UNIX programs
that use this numbering scheme.
Within a line, characters are numbered from 0.
If \fIchar\fR is \fBend\fR then it refers to the newline character
that ends the line.
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the character that covers the pixel whose x and y coordinates
within the text's window are \fIx\fR and \fIy\fR.
.TP 12
\fBend\fR
Indicates the end of the text (the character just after the last
newline).
.TP 12
\fImark\fR
Indicates the character just after the mark whose name is \fImark\fR.
.TP 12
\fItag\fB.first\fR
Indicates the first character in the text that has been tagged with
\fItag\fR.
This form generates an error if no characters are currently tagged
with \fItag\fR.
.TP 12
\fItag\fB.last\fR
Indicates the character just after the last one in the text that has
been tagged with \fItag\fR.
This form generates an error if no characters are currently tagged
with \fItag\fR.
.TP 12
\fIpathName\fR
Indicates the position of the embedded window whose name is
\fIpathName\fR.
This form generates an error if there is no embedded window
by the given name.
.TP 12
.VS
\fIimageName\fR
Indicates the position of the embedded image whose name is
\fIimageName\fR.
This form generates an error if there is no embedded image
by the given name.
.VE
.PP
If the \fIbase\fP could match more than one of the above forms, such
as a \fImark\fP and \fIimageName\fP both having the same value, then
the form earlier in the above list takes precedence.
If modifiers follow the base index, each one of them must have one
of the forms listed below.  Keywords such as \fBchars\fR and \fBwordend\fR
may be abbreviated as long as the abbreviation is unambiguous.
.TP
\fB+ \fIcount\fB chars\fR
Adjust the index forward by \fIcount\fR characters, moving to later
lines in the text if necessary.  If there are fewer than \fIcount\fR
characters in the text after the current index, then set the index
to the last character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB chars\fR
Adjust the index backward by \fIcount\fR characters, moving to earlier
lines in the text if necessary.  If there are fewer than \fIcount\fR
characters in the text before the current index, then set the index
to the first character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB+ \fIcount\fB lines\fR
Adjust the index forward by \fIcount\fR lines, retaining the same
character position within the line.  If there are fewer than \fIcount\fR
lines after the line containing the current index, then set the index
to refer to the same character position on the last line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline).
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB lines\fR
Adjust the index backward by \fIcount\fR lines, retaining the same
character position within the line.  If there are fewer than \fIcount\fR
lines before the line containing the current index, then set the index
to refer to the same character position on the first line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline).
Spaces on either side of \fIcount\fR are optional.
.TP
\fBlinestart\fR
Adjust the index to refer to the first character on the line.
.TP
\fBlineend\fR
Adjust the index to refer to the last character on the line (the newline).
.TP
\fBwordstart\fR
Adjust the index to refer to the first character of the word containing
the current index.  A word consists of any number of adjacent characters
that are letters, digits, or underscores, or a single character that
is not one of these.
.TP
\fBwordend\fR
Adjust the index to refer to the character just after the last one of the
word containing the current index.  If the current index refers to the last
character of the text then it is not modified.
.PP
If more than one modifier is present then they are applied in
left-to-right order.  For example, the index ``\fBend \- 1 chars\fR''
refers to the next-to-last character in the text and
``\fBinsert wordstart \- 1 c\fR'' refers to the character just before
the first one in the word containing the insertion cursor.

.SH TAGS
.PP
The first form of annotation in text widgets is a tag.
A tag is a textual string that is associated with some of the characters
in a text.
Tags may contain arbitrary characters, but it is probably best to
avoid using the the characters `` '' (space), \fB+\fR, or \fB\-\fR:
these characters have special meaning in indices, so tags containing
them can't be used as indices.
There may be any number of tags associated with characters in a
text.
Each tag may refer to a single character, a range of characters, or
several ranges of characters.
An individual character may have any number of tags associated with it.
.PP
A priority order is defined among tags, and this order is used in
implementing some of the tag-related functions described below.
When a tag is defined (by associating it with characters or setting
its display options or binding commands to it), it is given
a priority higher than any existing tag.
The priority order of tags may be redefined using the
``\fIpathName \fBtag raise\fR'' and ``\fIpathName \fBtag lower\fR''
widget commands.
.PP
Tags serve three purposes in text widgets.
First, they control the way information is displayed on the screen.
By default, characters are displayed as determined by the
\fBbackground\fR, \fBfont\fR, and \fBforeground\fR options for the
text widget.
However, display options may be associated with individual tags
using the ``\fIpathName \fBtag configure\fR'' widget command.
If a character has been tagged, then the display options associated
with the tag override the default display style.
The following options are currently supported for tags:
.TP
\fB\-background \fIcolor\fR
\fIColor\fR specifies the background color to use for characters
associated with the tag.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-bgstipple \fIbitmap\fR
\fIBitmap\fR specifies a bitmap that is used as a stipple pattern
for the background.
It may have any of the forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR hasn't been specified, or if it is specified
as an empty string, then a solid fill will be used for the
background.
.TP
\fB\-borderwidth \fIpixels\fR
\fIPixels\fR specifies the width of a 3-D border to draw around
the background.
It may have any of the forms accepted by \fBTk_GetPixels\fR.
This option is used in conjunction with the \fB\-relief\fR
option to give a 3-D appearance to the background for characters;
it is ignored unless the \fB\-background\fR option
has been set for the tag.
.TP
\fB\-elide \fIboolean\fR
\fIElide\fR specifies whether the data should be elided.
Elided data is not displayed and takes no space on screen, but further
on behaves just as normal data.
.TP
\fB\-fgstipple \fIbitmap\fR
\fIBitmap\fR specifies a bitmap that is used as a stipple pattern
when drawing text and other foreground information such as
underlines.
It may have any of the forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR hasn't been specified, or if it is specified
as an empty string, then a solid fill will be used.
.TP
\fB\-font \fIfontName\fR
\fIFontName\fR is the name of a font to use for drawing characters.
It may have any of the forms accepted by \fBTk_GetFont\fR.
.TP
\fB\-foreground \fIcolor\fR
\fIColor\fR specifies the color to use when drawing text and other
foreground information such as underlines.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-justify \fIjustify\fR
If the first character of a display line has a tag for which this
option has been specified, then \fIjustify\fR determines how to
justify the line.
It must be one of \fBleft\fR, \fBright\fR, or \fBcenter\fR.
If a line wraps, then the justification for each line on the
display is determined by the first character of that display line.
.TP
\fB\-lmargin1 \fIpixels\fR
If the first character of a text line has a tag for which this
option has been specified, then \fIpixels\fR specifies how
much the line should be indented from the left edge of the
window.
\fIPixels\fR may have any of the standard forms for screen
distances.
If a line of text wraps, this option only applies to the
first line on the display;  the \fB\-lmargin2\fR option controls
the indentation for subsequent lines.
.TP
\fB\-lmargin2 \fIpixels\fR
If the first character of a display line has a tag for which this
option has been specified, and if the display line is not the
first for its text line (i.e., the text line has wrapped), then
\fIpixels\fR specifies how much the line should be indented from
the left edge of the window.
\fIPixels\fR may have any of the standard forms for screen
distances.
This option is only used when wrapping is enabled, and it only
applies to the second and later display lines for a text line.
.TP
\fB\-offset \fIpixels\fR
\fIPixels\fR specifies an amount by which the text's baseline
should be offset vertically from the baseline of the overall
line, in pixels.
For example, a positive offset can be used for superscripts
and a negative offset can be used for subscripts.
\fIPixels\fR may have any of the standard forms for screen
distances.
.TP
\fB\-overstrike \fIboolean\fR
Specifies whether or not to draw a horizontal rule through
the middle of characters.
\fIBoolean\fR may have any of the forms accepted by \fBTk_GetBoolean\fR.
.TP
\fB\-relief \fIrelief\fR
\fIRelief\fR specifies the 3-D relief to use for drawing backgrounds,
in any of the forms accepted by \fBTk_GetRelief\fR.
This option is used in conjunction with the \fB\-borderwidth\fR
option to give a 3-D appearance to the background for characters;
it is ignored unless the \fB\-background\fR option
has been set for the tag.
.TP
\fB\-rmargin \fIpixels\fR
If the first character of a display line has a tag for which this
option has been specified, then \fIpixels\fR specifies how wide
a margin to leave between the end of the line and the right
edge of the window.
\fIPixels\fR may have any of the standard forms for screen
distances.
This option is only used when wrapping is enabled.
If a text line wraps, the right margin for each line on the
display is determined by the first character of that display
line.
.TP
\fB\-spacing1 \fIpixels\fR
\fIPixels\fR specifies how much additional space should be
left above each text line, using any of the standard forms for
screen distances.
If a line wraps, this option only applies to the first
line on the display.
.TP
\fB\-spacing2 \fIpixels\fR
For lines that wrap, this option specifies how much additional
space to leave between the display lines for a single text line.
\fIPixels\fR may have any of the standard forms for screen
distances.
.TP
\fB\-spacing3 \fIpixels\fR
\fIPixels\fR specifies how much additional space should be
left below each text line, using any of the standard forms for
screen distances.
If a line wraps, this option only applies to the last
line on the display.
.TP
\fB\-tabs \fItabList\fR
\fITabList\fR specifies a set of tab stops in the same form
as for the \fB\-tabs\fR option for the text widget.  This
option only applies to a display line if it applies to the
first character on that display line.
If this option is specified as an empty string, it cancels
the option, leaving it unspecified for the tag (the default).
If the option is specified as a non-empty string that is
an empty list, such as \fB\-tags\0{\0}\fR, then it requests
default 8-character tabs as described for the \fBtags\fR
widget option.
.TP
\fB\-underline \fIboolean\fR
\fIBoolean\fR specifies whether or not to draw an underline underneath
characters.
It may have any of the forms accepted by \fBTk_GetBoolean\fR.
.TP
\fB\-wrap \fImode\fR
\fIMode\fR specifies how to handle lines that are wider than the
text's window.
It has the same legal values as the \fB\-wrap\fR option
for the text widget:  \fBnone\fR, \fBchar\fR, or \fBword\fR.
If this tag option is specified, it overrides the \fB\-wrap\fR option
for the text widget.
.PP
If a character has several tags associated with it, and if their
display options conflict, then the options of the highest priority
tag are used.
If a particular display option hasn't been specified for a
particular tag, or if it is specified as an empty string, then
that option will never be used;  the next-highest-priority
tag's option will used instead.
If no tag specifies a particular display option, then the default
style for the widget will be used.
.PP
The second purpose for tags is event bindings.
You can associate bindings with a tag in much the same way you can
associate bindings with a widget class:  whenever particular X
events occur on characters with the given tag, a given
Tcl command will be executed.
Tag bindings can be used to give behaviors to ranges of characters;
among other things, this allows hypertext-like
features to be implemented.
For details, see the description of the \fBtag bind\fR widget
command below.
.PP
The third use for tags is in managing the selection.
See THE SELECTION below.

.SH MARKS
.PP
The second form of annotation in text widgets is a mark.
Marks are used for remembering particular places in a text.
They are something like tags, in that they have names and
they refer to places in the file, but a mark isn't associated
with particular characters.
Instead, a mark is associated with the gap between two characters.
Only a single position may be associated with a mark at any given
time.
If the characters around a mark are deleted the mark will still
remain;  it will just have new neighbor characters.
In contrast, if the characters containing a tag are deleted then
the tag will no longer have an association with characters in
the file.
Marks may be manipulated with the ``\fIpathName \fBmark\fR'' widget
command, and their current locations may be determined by using the
mark name as an index in widget commands.
.PP
Each mark also has a \fIgravity\fR, which is either \fBleft\fR or
\fBright\fR.
The gravity for a mark specifies what happens to the mark when
text is inserted at the point of the mark.
If a mark has left gravity, then the mark is treated as if it
were attached to the character on its left, so the mark will
remain to the left of any text inserted at the mark position.
If the mark has right gravity, new text inserted at the mark
position will appear to the left of the mark (so that the mark
remains rightmost).  The gravity for a mark defaults to \fBright\fR.
.PP
The name space for marks is different from that for tags:  the
same name may be used for both a mark and a tag, but they will refer
to different things.
.PP
Two marks have special significance.
First, the mark \fBinsert\fR is associated with the insertion cursor,
as described under THE INSERTION CURSOR below.
Second, the mark \fBcurrent\fR is associated with the character
closest to the mouse and is adjusted automatically to track the
mouse position and any changes to the text in the widget (one
exception:  \fBcurrent\fR is not updated in response to mouse
motions if a mouse button is down;  the update will be deferred
until all mouse buttons have been released).
Neither of these special marks may be deleted.

.SH "EMBEDDED WINDOWS"
.PP
The third form of annotation in text widgets is an embedded window.
Each embedded window annotation causes a window to be displayed
at a particular point in  the text.
There may be any number of embedded windows in a text widget,
and any widget may be used as an embedded window (subject to the
usual rules for geometry management, which require the text window
to be the parent of the embedded window or a descendant of its
parent).
The embedded window's position on the screen will be updated as the
text is modified or scrolled, and it will be mapped and unmapped as
it moves into and out of the visible area of the text widget.
Each embedded window occupies one character's worth of index space
in the text widget, and it may be referred to either by the name
of its embedded window or by its position in the widget's
index space.
If the range of text containing the embedded window is deleted then
the window is destroyed.
.PP
When an embedded window is added to a text widget with the
\fBwindow create\fR widget command, several configuration
options may be associated with it.
These options may be  modified later with the \fBwindow configure\fR
widget command.
The following options are currently supported:
.TP
\fB\-align \fIwhere\fR
If the window is not as tall as the line in which it is displayed,
this option determines where the window is displayed in the line.
\fIWhere\fR must have one of the values \fBtop\fR (align the top of the window
with the top of the line), \fBcenter\fR (center the window
within the range of the line), \fBbottom\fR (align the bottom of the
window with the bottom of the line's area),
or \fBbaseline\fR (align the bottom of the window with the baseline
of the line).
.TP
\fB\-create \fIscript\fR
Specifies a Tcl script that may be evaluated to create the window
for the annotation.
If no \fB\-window\fR option has been specified for the annotation
this script will be evaluated when the annotation is about to
be displayed on the screen.
\fIScript\fR must create a window for the annotation and return
the name of that window as its result.
If the annotation's window should ever be deleted, \fIscript\fR
will be evaluated again the next time the annotation is displayed.
.TP
\fB\-padx \fIpixels\fR
\fIPixels\fR specifies the amount of extra space to leave on
each side of the embedded window.
It may have any of the usual forms defined for a screen distance.
.TP
\fB\-pady \fIpixels\fR
\fIPixels\fR specifies the amount of extra space to leave on
the top and on the bottom of the embedded window.
It may have any of the usual forms defined for a screen distance.
.TP
\fB\-stretch \fIboolean\fR
If the requested height of the embedded window is less than the
height of the line in which it is displayed, this option can be
used to specify whether the window should be stretched vertically
to fill its line.
If the \fB\-pady\fR option has been specified as well, then the
requested padding will be retained even if the window is
stretched.
.TP
\fB\-window \fIpathName\fR
Specifies the name of a window to display in the annotation.

.VS
.SH "EMBEDDED IMAGES"
.PP
The final form of annotation in text widgets is an embedded image.
Each embedded image annotation causes an image to be displayed
at a particular point in  the text.
There may be any number of embedded images in a text widget,
and a particular image may be embedded in multiple places in the same
text widget.
The embedded image's position on the screen will be updated as the
text is modified or scrolled.
Each embedded image occupies one character's worth of index space
in the text widget, and it may be referred to either by
its position in the widget's index space, or the name it is assigned
when the image is inserted into the text widget widh \fBimage create\fP.
If the range of text containing the embedded image is deleted then
that copy of the image is removed from the screen.
.PP
When an embedded image is added to a text widget with the \fBimage
create\fR widget command, a name unique to this instance of the image
is returned.  This name may then be used to refer to this image
instance.  The name is taken to be the value of the \fB-name\fP option
(described below).  If the \fB-name\fP option is not provided, the
\fB-image\fP name is used instead.  If the \fIimageName\fP is already
in use in the text widget, then \fB#\fInn\fR is added to the end of the
\fIimageName\fP, where \fInn\fP is an arbitrary integer.  This insures
the \fIimageName\fP is unique.
Once this name is assigned to this instance of the image, it does not 
change, even though the \fB-image\fP or \fB-name\fP values can be changed
with \fBimage configure\fP.
.PP
When an embedded image is added to a text widget with the
\fBimage create\fR widget command, several configuration
options may be associated with it.
These options may be modified later with the \fBimage configure\fR
widget command.
The following options are currently supported:
.TP
\fB\-align \fIwhere\fR
If the image is not as tall as the line in which it is displayed,
this option determines where the image is displayed in the line.
\fIWhere\fR must have one of the values \fBtop\fR (align the top of the image
with the top of the line), \fBcenter\fR (center the image
within the range of the line), \fBbottom\fR (align the bottom of the
image with the bottom of the line's area),
or \fBbaseline\fR (align the bottom of the image with the baseline
of the line).
.TP
\fB\-image \fIimage\fR
Specifies the name of the Tk image to display in the annotation.
If \fIimage\fP is not a valid Tk image, then an error is returned.
.TP
\fB\-name \fIImageName\fR
Specifies the name by which this image instance may be referenced in
the text widget. If \fIImageName\fP is not supplied, then the
name of the Tk image is used instead.
If the \fIimageName\fP is already in use, \fI#nn\fP is appended to
the end of the name as described above.
.TP
\fB\-padx \fIpixels\fR
\fIPixels\fR specifies the amount of extra space to leave on
each side of the embedded image.
It may have any of the usual forms defined for a screen distance.
.TP
\fB\-pady \fIpixels\fR
\fIPixels\fR specifies the amount of extra space to leave on
the top and on the bottom of the embedded image.
It may have any of the usual forms defined for a screen distance.
.VE

.SH "THE SELECTION"
.PP
Selection support is implemented via tags.
If the \fBexportSelection\fR option for the text widget is true
then the \fBsel\fR tag will be associated with the selection:
.IP [1]
Whenever characters are tagged with \fBsel\fR the text widget
will claim ownership of the selection.
.IP [2]
Attempts to retrieve the
selection will be serviced by the text widget, returning all the
characters with the \fBsel\fR tag.
.IP [3]
If the selection is claimed away by another application or by another
window within this application, then the \fBsel\fR tag will be removed
from all characters in the text.
.PP
The \fBsel\fR tag is automatically defined when a text widget is
created, and it may not be deleted with the ``\fIpathName \fBtag delete\fR''
widget command.  Furthermore, the \fBselectBackground\fR,
\fBselectBorderWidth\fR, and \fBselectForeground\fR options for
the text widget are tied to the \fB\-background\fR,
\fB\-borderwidth\fR, and \fB\-foreground\fR options for the \fBsel\fR
tag:  changes in either will automatically be reflected in the
other.

.SH "THE INSERTION CURSOR"
.PP
The mark named \fBinsert\fR has special significance in text widgets.
It is defined automatically when a text widget is created and it
may not be unset with the ``\fIpathName \fBmark unset\fR'' widget
command.
The \fBinsert\fR mark represents the position of the insertion
cursor, and the insertion cursor will automatically be drawn at
this point whenever the text widget has the input focus.

.SH "WIDGET COMMAND"
.PP
The \fBtext\fR command creates a new Tcl command whose
name is the same as the path name of the text's window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIPathName\fR is the name of the command, which is the same as
the text widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for text widgets:
.TP
\fIpathName \fBbbox \fIindex\fR
Returns a list of four elements describing the screen area
of the character given by \fIindex\fR.
The first two elements of the list give the x and y coordinates
of the upper-left corner of the area occupied by the
character, and the last two elements give the width and height
of the area.
If the character is only partially visible on the screen, then
the return value reflects just the visible part.
If the character is not visible on the screen then the return
value is an empty list.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBtext\fR
command.
.TP
\fIpathName \fBcompare\fR \fIindex1 op index2\fR
Compares the indices given by \fIindex1\fR and \fIindex2\fR according
to the relational operator given by \fIop\fR, and returns 1 if
the relationship is satisfied and 0 if it isn't.
\fIOp\fR must be one of the operators <, <=, ==, >=, >, or !=.
If \fIop\fR is == then 1 is returned if the two indices refer to
the same character, if \fIop\fR is < then 1 is returned if \fIindex1\fR
refers to an earlier character in the text than \fIindex2\fR, and
so on.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtext\fR
command.
.TP
\fIpathName \fBdebug \fR?\fIboolean\fR?
If \fIboolean\fR is specified, then it must have one of the true or
false values accepted by Tcl_GetBoolean.
If the value is a true one then internal consistency checks will be
turned on in the B-tree code associated with text widgets.
If \fIboolean\fR has a false value then the debugging checks will
be turned off.
In either case the command returns an empty string.
If \fIboolean\fR is not specified then the command returns \fBon\fR
or \fBoff\fR to indicate whether or not debugging is turned on.
There is a single debugging switch shared by all text widgets:  turning
debugging on or off in any widget turns it on or off for all widgets.
For widgets with large amounts of text, the consistency checks may
cause a noticeable slow-down.
.PP
.VS 8.4
When debugging is turned on, the drawing routines of the text widget
set the global variables \fBtk_textRedraw\fR and \fBtk_textRelayout\fR
to the lists of indices that are redrawn.  The values of these variables
are tested by Tk's test suite.
.VE
.TP
\fIpathName \fBdelete \fIindex1 \fR?\fIindex2\fR?
Delete a range of characters from the text.
If both \fIindex1\fR and \fIindex2\fR are specified, then delete
all the characters starting with the one given by \fIindex1\fR
and stopping just before \fIindex2\fR (i.e. the character at
\fIindex2\fR is not deleted).
If \fIindex2\fR doesn't specify a position later in the text
than \fIindex1\fR then no characters are deleted.
If \fIindex2\fR isn't specified then the single character at
\fIindex1\fR is deleted.
It is not allowable to delete characters in a way that would leave
the text without a newline as the last character.
The command returns an empty string.
.TP
\fIpathName \fBdlineinfo \fIindex\fR
Returns a list with five elements describing the area occupied
by the display line containing \fIindex\fR.
The first two elements of the list give the x and y coordinates
of the upper-left corner of the area occupied by the
line, the third and fourth elements give the width and height
of the area, and the fifth element gives the position of the baseline
for the line, measured down from the top of the area.
All of this information is measured in pixels.
If the current wrap mode is \fBnone\fR and the line extends beyond
the boundaries of the window,
the area returned reflects the entire area of the line, including the
portions that are out of the window.
If the line is shorter than the full width of the window then the
area returned reflects just the portion of the line that is occupied
by characters and embedded windows.
If the display line containing \fIindex\fR is not visible on
the screen then the return value is an empty list.
.TP
\fIpathName \fBdump \fR?\fIswitches\fR? \fIindex1 \fR?\fIindex2\fR?
Return the contents of the text widget from \fIindex1\fR up to,
but not including \fIindex2\fR,
including the text and
information about marks, tags, and embedded windows.
If \fIindex2\fR is not specified, then it defaults to
one character past \fIindex1\fR.  The information is returned
in the following format:
.LP
.RS
\fIkey1 value1 index1 key2 value2 index2\fR ...
.LP
The possible \fIkey\fP values are \fBtext\fP, \fBmark\fP,
\fBtagon\fP, \fBtagoff\fP, and \fBwindow\fP.  The corresponding
\fIvalue\fP is the text, mark name, tag name, or window name.
The \fIindex\fP information is the index of the
start of the text, the mark, the tag transition, or the window.
One or more of the following switches (or abbreviations thereof)
may be specified to control the dump:
.TP
\fB\-all\fR
Return information about all elements: text, marks, tags, images and windows.
This is the default.
.TP
\fB\-command \fIcommand\fR
Instead of returning the information as the result of the dump operation,
invoke the \fIcommand\fR on each element of the text widget within the range.
The command has three arguments appended to it before it is evaluated:
the \fIkey\fP, \fIvalue\fP, and \fIindex\fP.
.TP
\fB\-image\fR
Include information about images in the dump results.
.TP
\fB\-mark\fR
Include information about marks in the dump results.
.TP
\fB\-tag\fR
Include information about tag transitions in the dump results. Tag
information is returned as \fBtagon\fP and \fBtagoff\fP elements that
indicate the begin and end of each range of each tag, respectively.
.TP
\fB\-text\fR
Include information about text in the dump results.  The value is the
text up to the next element or the end of range indicated by \fIindex2\fR.
A text element does not span newlines.  A multi-line block of text that
contains no marks or tag transitions will still be dumped as a set
of text seqments that each end with a newline.  The newline is part
of the value.
.TP
\fB\-window\fR
Include information about embedded windows in the dump results.
The value of a window is its Tk pathname, unless the window
has not been created yet.  (It must have a create script.)
In this case an empty string is returned, and you must query the
window by its index position to get more information.
.RE
.TP
\fIpathName \fBget \fIindex1 \fR?\fIindex2\fR?
Return a range of characters from the text.
The return value will be all the characters in the text starting
with the one whose index is \fIindex1\fR and ending just before
the one whose index is \fIindex2\fR (the character at \fIindex2\fR
will not be returned).
If \fIindex2\fR is omitted then the single character at \fIindex1\fR
is returned.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then an empty string is returned.
If the specified range contains embedded windows, no information
about them is included in the returned string.
.TP
\fIpathName \fBimage \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate embedded images.
The behavior of the command depends on the \fIoption\fR argument
that follows the \fBtag\fR argument.
The following forms of the command are currently supported:
.RS
.TP
\fIpathName \fBimage cget\fR \fIindex option\fR
Returns the value of a configuration option for an embedded image.
\fIIndex\fR identifies the embedded image, and \fIoption\fR
specifies a particular configuration option, which must be one of
the ones listed in the section EMBEDDED IMAGES.
.TP
\fIpathName \fBimage configure \fIindex\fR ?\fIoption value ...\fR?
Query or modify the configuration options for an embedded image.
If no \fIoption\fR is specified, returns a list describing all of
the available options for the embedded image at \fIindex\fR
(see \fBTk_ConfigureInfo\fR for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command
returns a list describing the one named option (this list will be
identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified).
If one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
See EMBEDDED IMAGES for information on the options that
are supported.
.TP
\fIpathName \fBimage create \fIindex\fR ?\fIoption value ...\fR?
This command creates a new image annotation, which will appear
in the text at the position given by \fIindex\fR.
Any number of \fIoption\-value\fR pairs may be specified to
configure the annotation.
Returns a unique identifier that may be used as an index to refer to
this image.
See EMBEDDED IMAGES for information on the options that
are supported, and a description of the identifier returned.
.TP
\fIpathName \fBimage names\fR
Returns a list whose elements are the names of all image instances currently
embedded in \fIwindow\fR.
.RE
.TP
\fIpathName \fBindex \fIindex\fR
Returns the position corresponding to \fIindex\fR in the form
\fIline.char\fR where \fIline\fR is the line number and \fIchar\fR
is the character number.
\fIIndex\fR may have any of the forms described under INDICES above.
.TP
\fIpathName \fBinsert \fIindex chars \fR?\fItagList chars tagList ...\fR?
Inserts all of the \fIchars\fR arguments just before the character at
\fIindex\fR.
If \fIindex\fR refers to the end of the text (the character after
the last newline) then the new text is inserted just before the
last newline instead.
If there is a single \fIchars\fR argument and no \fItagList\fR, then
the new text will receive any tags that are present on both the
character before and the character after the insertion point; if a tag
is present on only one of these characters then it will not be
applied to the new text.
If \fItagList\fR is specified then it consists of a list of
tag names;  the new characters will receive all of the tags in
this list and no others, regardless of the tags present around
the insertion point.
If multiple \fIchars\fR\-\fItagList\fR argument pairs are present,
they produce the same effect as if a separate \fBinsert\fR widget
command had been issued for each pair, in order.
The last \fItagList\fR argument may be omitted.
.TP
\fIpathName \fBmark \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate marks.  The exact behavior of
the command depends on the \fIoption\fR argument that follows
the \fBmark\fR argument.  The following forms of the command
are currently supported:
.RS
.TP
\fIpathName \fBmark gravity \fImarkName\fR ?\fIdirection\fR?
If \fIdirection\fR is not specified, returns \fBleft\fR or \fBright\fR
to indicate which of its adjacent characters \fImarkName\fR is attached
to.
If \fIdirection\fR is specified, it must be \fBleft\fR or \fBright\fR;
the gravity of \fImarkName\fR is set to the given value.
.TP
\fIpathName \fBmark names\fR
Returns a list whose elements are the names of all the marks that
are currently set.
.TP
\fIpathName \fBmark next \fIindex\fR
Returns the name of the next mark at or after \fIindex\fR.
If \fIindex\fR is specified in numerical form, then the search for
the next mark begins at that index.
If \fIindex\fR is the name of a mark, then the search for
the next mark begins immediately after that mark.
This can still return a mark at the same position if
there are multiple marks at the same index.
These semantics mean that the \fBmark next\fP operation can be used to
step through all the marks in a text widget in the same order
as the mark information returned by the \fBdump\fP operation.
If a mark has been set to the special \fBend\fP index,
then it appears to be \fIafter\fP \fBend\fP with respect to the \fBmark next\fP operation.
An empty string is returned if there are no marks after \fIindex\fR.
.TP
\fIpathName \fBmark previous \fIindex\fR
Returns the name of the mark at or before \fIindex\fR.
If \fIindex\fR is specified in numerical form, then the search for
the previous mark begins with the character just before that index.
If \fIindex\fR is the name of a mark, then the search for
the next mark begins immediately before that mark.
This can still return a mark at the same position if
there are multiple marks at the same index.
These semantics mean that the \fBmark previous\fP operation can be used to
step through all the marks in a text widget in the reverse order
as the mark information returned by the \fBdump\fP operation.
An empty string is returned if there are no marks before \fIindex\fR.
.TP
\fIpathName \fBmark set \fImarkName index\fR
Sets the mark named \fImarkName\fR to a position just before the
character at \fIindex\fR.
If \fImarkName\fR already exists, it is moved from its old position;
if it doesn't exist, a new mark is created.
This command returns an empty string.
.TP
\fIpathName \fBmark unset \fImarkName \fR?\fImarkName markName ...\fR?
Remove the mark corresponding to each of the \fImarkName\fR arguments.
The removed marks will not be usable in indices and will not be
returned by future calls to ``\fIpathName \fBmark names\fR''.
This command returns an empty string.
.RE
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on texts.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the text window,
for use in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the difference in coordinates.
This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the text at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBsearch \fR?\fIswitches\fR? \fIpattern index \fR?\fIstopIndex\fR?
Searches the text in \fIpathName\fR starting at \fIindex\fR for a range
of characters that matches \fIpattern\fR.
If a match is found, the index of the first character in the match is
returned as result;  otherwise an empty string is returned.
One or more of the following switches (or abbreviations thereof)
may be specified to control the search:
.RS
.TP
\fB\-forwards\fR
The search will proceed forward through the text, finding the first
matching range starting at or after the position given by \fIindex\fR.
This is the default.
.TP
\fB\-backwards\fR
The search will proceed backward through the text, finding the
matching range closest to \fIindex\fR whose first character
is before \fIindex\fR.
.TP
\fB\-exact\fR
Use exact matching:  the characters in the matching range must be
identical to those in \fIpattern\fR.
This is the default.
.TP
\fB\-regexp\fR
Treat \fIpattern\fR as a regular expression and match it against
the text using the rules for regular expressions (see the \fBregexp\fR
command for details).
.TP
\fB\-nocase\fR
Ignore case differences between the pattern and the text.
.TP
\fB\-count\fI varName\fR
The argument following \fB\-count\fR gives the name of a variable;
if a match is found, the number of index positions between beginning and
end of the matching range will be stored in the variable.  If there are no
embedded images or windows in the matching range, this is equivalent to the
number of characters matched.  In either case, the range \fImatchIdx\fR to
\fImatchIdx + $count chars\fR will return the entire matched text.
.TP
\fB\-elide\fR
Find elidden (hidden) text as well. By default only displayed text is
searched.
.TP
\fB\-\|\-\fR
This switch has no effect except to terminate the list of switches:
the next argument will be treated as \fIpattern\fR even if it starts
with \fB\-\fR.
.LP
The matching range must be entirely within a single line of text.
For regular expression matching the newlines are removed from the ends
of the lines before matching:  use the \fB$\fR feature in regular
expressions to match the end of a line.
For exact matching the newlines are retained.
If \fIstopIndex\fR is specified, the search stops at that index:
for forward searches, no match at or after \fIstopIndex\fR will
be considered;  for backward searches, no match earlier in the
text than \fIstopIndex\fR will be considered.
If \fIstopIndex\fR is omitted, the entire text will be searched:
when the beginning or end of the text is reached, the search
continues at the other end until the starting location is reached
again;  if \fIstopIndex\fR is specified, no wrap-around will occur.
.RE
.TP
\fIpathName \fBsee \fIindex\fR
Adjusts the view in the window so that the character given by \fIindex\fR
is completely visible.
If \fIindex\fR is already visible then the command does nothing.
If \fIindex\fR is a short distance out of view, the command
adjusts the view just enough to make \fIindex\fR visible at the
edge of the window.
If \fIindex\fR is far out of view, then the command centers
\fIindex\fR in the window.
.TP
\fIpathName \fBtag \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate tags.  The exact behavior of the
command depends on the \fIoption\fR argument that follows the
\fBtag\fR argument.  The following forms of the command are currently
supported:
.RS
.TP
\fIpathName \fBtag add \fItagName index1 \fR?\fIindex2 index1 index2 ...\fR?
Associate the tag \fItagName\fR with all of the characters starting
with \fIindex1\fR and ending just before
\fIindex2\fR (the character at \fIindex2\fR isn't tagged).
A single command may contain any number of \fIindex1\fR\-\fIindex2\fR
pairs.
If the last \fIindex2\fR is omitted then the single character at
\fIindex1\fR is tagged.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then the command has no effect.
.TP
\fIpathName \fBtag bind \fItagName\fR ?\fIsequence\fR? ?\fIscript\fR?
This command associates \fIscript\fR with the tag given by
\fItagName\fR.
Whenever the event sequence given by \fIsequence\fR occurs for a
character that has been tagged with \fItagName\fR,
the script will be invoked.
This widget command is similar to the \fBbind\fR command except that
it operates on characters in a text rather than entire widgets.
See the \fBbind\fR manual entry for complete details
on the syntax of \fIsequence\fR and the substitutions performed
on \fIscript\fR before invoking it.
If all arguments are specified then a new binding is created, replacing
any existing binding for the same \fIsequence\fR and \fItagName\fR
(if the first character of \fIscript\fR is ``+'' then \fIscript\fR
augments an existing binding rather than replacing it).
In this case the return value is an empty string.
If \fIscript\fR is omitted then the command returns the \fIscript\fR
associated with \fItagName\fR and \fIsequence\fR (an error occurs
if there is no such binding).
If both \fIscript\fR and \fIsequence\fR are omitted then the command
returns a list of all the sequences for which bindings have been
defined for \fItagName\fR.
.RS
.PP
.VS
The only events for which bindings may be specified are those related
to the mouse and keyboard (such as \fBEnter\fR, \fBLeave\fR, 
\fBButtonPress\fR, \fBMotion\fR, and \fBKeyPress\fR) or virtual events.
Event bindings for a text widget use the \fBcurrent\fR mark described
under MARKS above.  An \fBEnter\fR event triggers for a tag when the tag
first becomes present on the current character, and a \fBLeave\fR event
triggers for a tag when it ceases to be present on the current character.
\fBEnter\fR and \fBLeave\fR events can happen either because the
\fBcurrent\fR mark moved or because the character at that position
changed.  Note that these events are different than \fBEnter\fR and
\fBLeave\fR events for windows.  Mouse and keyboard events are directed
to the current character.  If a virtual event is used in a binding, that
binding can trigger only if the virtual event is defined by an underlying
mouse-related or keyboard-related event.
.VE
.PP
It is possible for the current character to have multiple tags,
and for each of them to have a binding for a particular event
sequence.
When this occurs, one binding is invoked for each tag, in order
from lowest-priority to highest priority.
If there are multiple matching bindings for a single tag, then
the most specific binding is chosen (see the manual entry for
the \fBbind\fR command for details).
\fBcontinue\fR and \fBbreak\fR commands within binding scripts
are processed in the same way as for bindings created with
the \fBbind\fR command.
.PP
If bindings are created for the widget as a whole using the
\fBbind\fR command, then those bindings will supplement the
tag bindings.
The tag bindings will be invoked first, followed by bindings
for the window as a whole.
.RE
.TP
\fIpathName \fBtag cget\fR \fItagName option\fR
This command returns the current value of the option named \fIoption\fR
associated with the tag given by \fItagName\fR.
\fIOption\fR may have any of the values accepted by the \fBtag configure\fR
widget command.
.TP
\fIpathName \fBtag configure \fItagName\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options associated with the tag given by \fItagName\fR
instead of modifying options for the overall text widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for \fItagName\fR (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) in \fItagName\fR;
in this case the command returns an empty string.
See TAGS above for details on the options available for tags.
.TP
\fIpathName \fBtag delete \fItagName \fR?\fItagName ...\fR?
Deletes all tag information for each of the \fItagName\fR
arguments.
The command removes the tags from all characters in the file
and also deletes any other information associated with the tags,
such as bindings and display information.
The command returns an empty string.
.TP
\fIpathName\fB tag lower \fItagName \fR?\fIbelowThis\fR?
Changes the priority of tag \fItagName\fR so that it is just lower
in priority than the tag whose name is \fIbelowThis\fR.
If \fIbelowThis\fR is omitted, then \fItagName\fR's priority
is changed to make it lowest priority of all tags.
.TP
\fIpathName \fBtag names \fR?\fIindex\fR?
Returns a list whose elements are the names of all the tags that
are active at the character position given by \fIindex\fR.
If \fIindex\fR is omitted, then the return value will describe
all of the tags that exist for the text (this includes all tags
that have been named in a ``\fIpathName \fBtag\fR'' widget
command but haven't been deleted by a ``\fIpathName \fBtag delete\fR''
widget command, even if no characters are currently marked with
the tag).
The list will be sorted in order from lowest priority to highest
priority.
.TP
\fIpathName \fBtag nextrange \fItagName index1 \fR?\fIindex2\fR?
This command searches the text for a range of characters tagged
with \fItagName\fR where the first character of the range is
no earlier than the character at \fIindex1\fR and no later than
the character just before \fIindex2\fR (a range starting at
\fIindex2\fR will not be considered).
If several matching ranges exist, the first one is chosen.
The command's return value is a list containing
two elements, which are the index of the first character of the
range and the index of the character just after the last one in
the range.
If no matching range is found then the return value is an
empty string.
If \fIindex2\fR is not given then it defaults to the end of the text.
.TP
\fIpathName \fBtag prevrange \fItagName index1 \fR?\fIindex2\fR?
This command searches the text for a range of characters tagged
with \fItagName\fR where the first character of the range is
before the character at \fIindex1\fR and no earlier than
the character at \fIindex2\fR (a range starting at
\fIindex2\fR will be considered).
If several matching ranges exist, the one closest to \fIindex1\fR is chosen.
The command's return value is a list containing
two elements, which are the index of the first character of the
range and the index of the character just after the last one in
the range.
If no matching range is found then the return value is an
empty string.
If \fIindex2\fR is not given then it defaults to the beginning of the text.
.TP
\fIpathName\fB tag raise \fItagName \fR?\fIaboveThis\fR?
Changes the priority of tag \fItagName\fR so that it is just higher
in priority than the tag whose name is \fIaboveThis\fR.
If \fIaboveThis\fR is omitted, then \fItagName\fR's priority
is changed to make it highest priority of all tags.
.TP
\fIpathName \fBtag ranges \fItagName\fR
Returns a list describing all of the ranges of text that have been
tagged with \fItagName\fR.
The first two elements of the list describe the first tagged range
in the text, the next two elements describe the second range, and
so on.
The first element of each pair contains the index of the first
character of the range, and the second element of the pair contains
the index of the character just after the last one in the
range.
If there are no characters tagged with \fItag\fR then an
empty string is returned.
.TP
\fIpathName \fBtag remove \fItagName index1 \fR?\fIindex2 index1 index2 ...\fR?
Remove the tag \fItagName\fR from all of the characters starting
at \fIindex1\fR and ending just before
\fIindex2\fR (the character at \fIindex2\fR isn't affected).
A single command may contain any number of \fIindex1\fR\-\fIindex2\fR
pairs.
If the last \fIindex2\fR is omitted then the single character at
\fIindex1\fR is tagged.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then the command has no effect.
This command returns an empty string.
.RE
.TP
\fIpathName \fBwindow \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate embedded windows.
The behavior of the command depends on the \fIoption\fR argument
that follows the \fBtag\fR argument.
The following forms of the command are currently supported:
.RS
.TP
\fIpathName \fBwindow cget\fR \fIindex option\fR
Returns the value of a configuration option for an embedded window.
\fIIndex\fR identifies the embedded window, and \fIoption\fR
specifies a particular configuration option, which must be one of
the ones listed in the section EMBEDDED WINDOWS.
.TP
\fIpathName \fBwindow configure \fIindex\fR ?\fIoption value ...\fR?
Query or modify the configuration options for an embedded window.
If no \fIoption\fR is specified, returns a list describing all of
the available options for the embedded window at \fIindex\fR
(see \fBTk_ConfigureInfo\fR for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command
returns a list describing the one named option (this list will be
identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified).
If one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
See EMBEDDED WINDOWS for information on the options that
are supported.
.TP
\fIpathName \fBwindow create \fIindex\fR ?\fIoption value ...\fR?
This command creates a new window annotation, which will appear
in the text at the position given by \fIindex\fR.
Any number of \fIoption\-value\fR pairs may be specified to
configure the annotation.
See EMBEDDED WINDOWS for information on the options that
are supported.
Returns an empty string.
.TP
\fIpathName \fBwindow names\fR
Returns a list whose elements are the names of all windows currently
embedded in \fIwindow\fR.
.RE
.TP
\fIpathName \fBxview \fIoption args\fR
This command is used to query and change the horizontal position of the
text in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the portion of the document's horizontal span that is visible in
the window.
For example, if the first element is .2 and the second element is .6,
20% of the text is off-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
The fractions refer only to the lines that are actually visible in the
window:  if the lines in the window are all very short, so that they
are entirely visible, the returned fractions will be 0 and 1,
even if there are other lines in the text that are
much wider than the window.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the horizontal
span of the text is off-screen to the left.
\fIFraction\fR is a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR average-width characters on the display;  if it is
\fBpages\fR then the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.TP
\fIpathName \fByview \fI?args\fR?
This command is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
\fIpathName \fByview\fR
Returns a list containing two elements, both of which are real fractions
between 0 and 1.
The first element gives the position of the first character in the
top line in the window, relative to the text as a whole (0.5 means
it is halfway through the text, for example).
The second element gives the position of the character just after
the last one in the bottom line of the window,
relative to the text as a whole.
These are the same values passed to scrollbars via the \fB\-yscrollcommand\fR
option.
.TP
\fIpathName \fByview moveto\fI fraction\fR
Adjusts the view in the window so that the character given by \fIfraction\fR
appears on the top line of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
character in the text, 0.33 indicates the character one-third the
way through the text, and so on.
.TP
\fIpathName \fByview scroll \fInumber what\fR
This command adjust the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down by
\fInumber\fR lines on the display;  if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier positions in the text
become visible;  if it is positive then later positions in the text
become visible.
.TP
\fIpathName \fByview \fR?\fB\-pickplace\fR? \fIindex\fR
Changes the view in the widget's window to make \fIindex\fR visible.
If the \fB\-pickplace\fR option isn't specified then \fIindex\fR will
appear at the top of the window.
If \fB\-pickplace\fR is specified then the widget chooses where
\fIindex\fR appears in the window:
.RS
.IP [1]
If \fIindex\fR is already visible somewhere in the window then the
command does nothing.
.IP [2]
If \fIindex\fR is only a few lines off-screen above the window then
it will be positioned at the top of the window.
.IP [3]
If \fIindex\fR is only a few lines off-screen below the window then
it will be positioned at the bottom of the window.
.IP [4]
Otherwise, \fIindex\fR will be centered in the window.
.LP
The \fB\-pickplace\fR option has been obsoleted by the \fBsee\fR widget
command (\fBsee\fR handles both x- and y-motion to make a location
visible, whereas \fB\-pickplace\fR only handles motion in y).
.RE
.TP
\fIpathName \fByview \fInumber\fR
This command makes the first character on the line after
the one given by \fInumber\fR visible at the top of the window.
\fINumber\fR must be an integer.
This command used to be used for scrolling, but now it is obsolete.
.RE

.SH BINDINGS
.PP
Tk automatically creates class bindings for texts that give them
the following default behavior.
In the descriptions below, ``word'' is dependent on the value of
the \fBtcl_wordchars\fR variable.  See tclvars(n).
.IP [1]
Clicking mouse button 1 positions the insertion cursor
just before the character underneath the mouse cursor, sets the
input focus to this widget, and clears any selection in the widget.
Dragging with mouse button 1 strokes out a selection between
the insertion cursor and the character under the mouse.
.IP [2]
Double-clicking with mouse button 1 selects the word under the mouse
and positions the insertion cursor at the beginning of the word.
Dragging after a double click will stroke out a selection consisting
of whole words.
.IP [3]
Triple-clicking with mouse button 1 selects the line under the mouse
and positions the insertion cursor at the beginning of the line.
Dragging after a triple click will stroke out a selection consisting
of whole lines.
.IP [4]
The ends of the selection can be adjusted by dragging with mouse
button 1 while the Shift key is down;  this will adjust the end
of the selection that was nearest to the mouse cursor when button
1 was pressed.
If the button is double-clicked before dragging then the selection
will be adjusted in units of whole words;  if it is triple-clicked
then the selection will be adjusted in units of whole lines.
.IP [5]
Clicking mouse button 1 with the Control key down will reposition the
insertion cursor without affecting the selection.
.IP [6]
If any normal printing characters are typed, they are
inserted at the point of the insertion cursor.
.IP [7]
The view in the widget can be adjusted by dragging with mouse button 2.
If mouse button 2 is clicked without moving the mouse, the selection
is copied into the text at the position of the mouse cursor.
The Insert key also inserts the selection, but at the position of
the insertion cursor.
.IP [8]
If the mouse is dragged out of the widget
while button 1 is pressed, the entry will automatically scroll to
make more text visible (if there is more text off-screen on the side
where the mouse left the window).
.IP [9]
The Left and Right keys move the insertion cursor one character to the
left or right;  they also clear any selection in the text.
If Left or Right is typed with the Shift key down, then the insertion
cursor moves and the selection is extended to include the new character.
Control-Left and Control-Right move the insertion cursor by words, and
Control-Shift-Left and Control-Shift-Right move the insertion cursor
by words and also extend the selection.
Control-b and Control-f behave the same as Left and Right, respectively.
Meta-b and Meta-f behave the same as Control-Left and Control-Right,
respectively.
.IP [10]
The Up and Down keys move the insertion cursor one line up or
down and clear any selection in the text.
If Up or Right is typed with the Shift key down, then the insertion
cursor moves and the selection is extended to include the new character.
Control-Up and Control-Down move the insertion cursor by paragraphs (groups
of lines separated by blank lines), and
Control-Shift-Up and Control-Shift-Down move the insertion cursor
by paragraphs and also extend the selection.
Control-p and Control-n behave the same as Up and Down, respectively.
.IP [11]
The Next and Prior keys move the insertion cursor forward or backwards
by one screenful and clear any selection in the text.
If the Shift key is held down while Next or Prior is typed, then
the selection is extended to include the new character.
Control-v moves the view down one screenful without moving the
insertion cursor or adjusting the selection.
.IP [12]
Control-Next and Control-Prior scroll the view right or left by one page
without moving the insertion cursor or affecting the selection.
.IP [13]
Home and Control-a move the insertion cursor to the
beginning of its line and clear any selection in the widget.
Shift-Home moves the insertion cursor to the beginning of the line
and also extends the selection to that point.
.IP [14]
End and Control-e move the insertion cursor to the
end of the line and clear any selection in the widget.
Shift-End moves the cursor to the end of the line and extends the selection
to that point.
.IP [15]
Control-Home and Meta-< move the insertion cursor to the beginning of
the text and clear any selection in the widget.
Control-Shift-Home moves the insertion cursor to the beginning of the text
and also extends the selection to that point.
.IP [16]
Control-End and Meta-> move the insertion cursor to the end of the
text and clear any selection in the widget.
Control-Shift-End moves the cursor to the end of the text and extends
the selection to that point.
.IP [17]
The Select key and Control-Space set the selection anchor to the position
of the insertion cursor.  They don't affect the current selection.
Shift-Select and Control-Shift-Space adjust the selection to the
current position of the insertion cursor, selecting from the anchor
to the insertion cursor if there was not any selection previously.
.IP [18]
Control-/ selects the entire contents of the widget.
.IP [19]
Control-\e clears any selection in the widget.
.IP [20]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is a selection.
.VS 8.4
This action is carried out by the command \fBtk_textCopy\fR.
.VE
.IP [21]
The F20 key (labelled Cut on many Sun workstations) or Control-w
copies the selection in the widget to the clipboard and deletes
the selection.
.VS 8.4
This action is carried out by the command \fBtk_textCut\fR.
.VE
If there is no selection in the widget then these keys have no effect.
.IP [22]
The F18 key (labelled Paste on many Sun workstations) or Control-y
inserts the contents of the clipboard at the position of the
insertion cursor.
.VS 8.4
This action is carried out by the command \fBtk_textPaste\fR.
.VE
.IP [23]
The Delete key deletes the selection, if there is one in the widget.
If there is no selection, it deletes the character to the right of
the insertion cursor.
.IP [24]
Backspace and Control-h delete the selection, if there is one
in the widget.
If there is no selection, they delete the character to the left of
the insertion cursor.
.IP [25]
Control-d deletes the character to the right of the insertion cursor.
.IP [26]
Meta-d deletes the word to the right of the insertion cursor.
.IP [27]
Control-k deletes from the insertion cursor to the end of its line;
if the insertion cursor is already at the end of a line, then
Control-k deletes the newline character.
.IP [28]
Control-o opens a new line by inserting a newline character in
front of the insertion cursor without moving the insertion cursor.
.IP [29]
Meta-backspace and Meta-Delete delete the word to the left of the
insertion cursor.
.IP [30]
Control-x deletes whatever is selected in the text widget.
.IP [31]
Control-t reverses the order of the two characters to the right of
the insertion cursor. 
.PP
If the widget is disabled using the \fB\-state\fR option, then its
view can still be adjusted and text can still be selected,
but no insertion cursor will be displayed and no text modifications will
take place.
.PP
The behavior of texts can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH "PERFORMANCE ISSUES"
.PP
Text widgets should run efficiently under a variety
of conditions.  The text widget uses about 2-3 bytes of
main memory for each byte of text, so texts containing a megabyte
or more should be practical on most workstations.
Text is represented internally with a modified B-tree structure
that makes operations relatively efficient even with large texts.
Tags are included in the B-tree structure in a way that allows
tags to span large ranges or have many disjoint smaller ranges
without loss of efficiency.
Marks are also implemented in a way that allows large numbers of
marks.
In most cases it is fine to have large numbers of unique tags,
or a tag that has many distinct ranges.
.PP
One performance problem can arise if you have hundreds or thousands
of different tags that all have the following characteristics:
the first and last ranges of each tag are near the beginning and
end of the text, respectively,
or a single tag range covers most of the text widget.
The cost of adding and deleting tags like this is proportional
to the number of other tags with the same properties.
In contrast, there is no problem with having thousands of distinct
tags if their overall ranges are localized and spread uniformly throughout
the text.
.PP
Very long text lines can be expensive,
especially if they have many marks and tags within them.
.PP
The display line with the insert cursor is redrawn each time the
cursor blinks, which causes a steady stream of graphics traffic.
Set the \fBinsertOffTime\fP attribute to 0 avoid this.
.SH KEYWORDS
text, widget, tkvars
