/*
 * pkgDefault.h --
 *
 *	This file defines the defaults for all options for all of
 *	the Vu widgets.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: pkgDefault.h,v 1.4 2002/09/26 01:45:05 hobbs Exp $
 */

#ifndef _VU_DEFAULT
#define _VU_DEFAULT

#ifdef LOAD_CORE_DEFAULTS
#if defined(_WIN32)
#   include "tkWinDefault.h"
#elif defined(MAC_TCL)
#   include "tkMacDefault.h"
#elif defined(MAC_OSX_TK)
#   include "tkMacOSXDefault.h"
#else
#   include "tkUnixDefault.h"
#endif
#endif

/*
 * Used by entries (spinboxes) to determine whether selection
 * should be shown even when disabled
 */
#if !(defined(_WIN32) || defined(MAC_TCL) || defined(MAC_OSX_TK))
#define ALWAYS_SHOW_SELECTION
#endif

#ifndef NORMAL_BG
#   define BLACK		"Black"
#   define WHITE		"White"
#   if defined(_WIN32)
#	define CTL_FONT		"{MS Sans Serif} 8"
#	define TEXT_FG		"SystemWindowText"
#	define NORMAL_BG	"SystemButtonFace"
#	define ACTIVE_BG	NORMAL_BG
#	define SELECT_BG	"SystemHighlight"
#	define SELECT_FG	"SystemHighlightText"
#	define DISABLED		"SystemDisabledText"
#	define HIGHLIGHT	"SystemWindowFrame"
#	define DEF_FONT		"{MS Sans Serif} 8"
#	define DEF_SMALL_FONT	"{MS Sans Serif} 6"
#   elif defined(MAC_TCL) || defined(MAC_OSX_TK)
#	define NORMAL_BG	"systemWindowBody"
#	define ACTIVE_BG	"#ececec"
#	define SELECT_BG	"systemHighlight"
#	define SELECT_FG	"systemHighlightText"
#	define DISABLED		"#a3a3a3"
#	define HIGHLIGHT	"Black"
#	define DEF_FONT		"Helvetica 12"
#	define DEF_SMALL_FONT	"Helvetica 8"
#   else
#	define NORMAL_BG	"#d9d9d9"
#	define ACTIVE_BG	"#ececec"
#	define SELECT_BG	"#c3c3c3"
#	define SELECT_FG	"Black"
#	define DISABLED		"#a3a3a3"
#	define HIGHLIGHT	"Black"
#	define DEF_FONT		"Helvetica -12"
#	define DEF_SMALL_FONT	"Helvetica -8"
#   endif
#   define HIGHLIGHT_BG		NORMAL_BG
#   define HIGHLIGHT_WIDTH	"1"
#endif /* NORMAL_BG */

/**************************************************
 * Defaults for BUTTONS:
 **************************************************
 */
#ifndef DEF_BUTTON_ACTIVE_BG_COLOR

#ifdef _WIN32

#define DEF_BUTTON_ACTIVE_BG_COLOR	NORMAL_BG
#define DEF_BUTTON_BG_COLOR		NORMAL_BG

#elif defined(MAC_TCL) || defined(MAC_OSX_TK)

#define DEF_BUTTON_ACTIVE_BG_COLOR	"systemButtonText"
#define DEF_BUTTON_BG_COLOR		"systemButtonFace"

#else

#define DEF_BUTTON_ACTIVE_BG_COLOR	ACTIVE_BG
#define DEF_BUTTON_BG_COLOR		NORMAL_BG

#endif /* platforms */

#define DEF_BUTTON_ACTIVE_BG_MONO	BLACK
#define DEF_BUTTON_CURSOR		""
#define DEF_BUTTON_BG_MONO		WHITE
#define DEF_BUTTON_RELIEF		"raised"

#endif /* DEF_BUTTON_ACTIVE_BG_COLOR */

/***************************************************
 * Defaults for COMBOBOXES:
 ***************************************************
 */
#if defined(_WIN32)

#define DEF_COMBO_BG_COLOR		"SystemWindow"
#define DEF_COMBO_FONT			CTL_FONT
#define DEF_COMBO_FG			TEXT_FG
#define DEF_COMBO_HIGHLIGHT		HIGHLIGHT
#define DEF_COMBO_HIGHLIGHT_WIDTH	"0"
#define DEF_COMBO_INSERT_BG		TEXT_FG
#define DEF_COMBO_INSERT_WIDTH		"2"
#define DEF_COMBO_RELIEF		"sunken"
#define DEF_COMBO_SELECT_BD_COLOR	"0"

#elif defined(MAC_TCL) || defined(MAC_OSX_TK)

#define DEF_COMBO_BG_COLOR		NORMAL_BG
#define DEF_COMBO_FONT			"Helvetica 12"
#define DEF_COMBO_FG			BLACK
#define DEF_COMBO_HIGHLIGHT		BLACK
#define DEF_COMBO_HIGHLIGHT_WIDTH	"0"
#define DEF_COMBO_INSERT_BG		BLACK
#define DEF_COMBO_INSERT_WIDTH		"1"
#define DEF_COMBO_RELIEF		"solid"
#define DEF_COMBO_SELECT_BD_COLOR	"1"

#else

#define DEF_COMBO_BG_COLOR		NORMAL_BG
#define DEF_COMBO_FONT			"Helvetica -12"
#define DEF_COMBO_FG			BLACK
#define DEF_COMBO_HIGHLIGHT		BLACK
#define DEF_COMBO_HIGHLIGHT_WIDTH	"1"
#define DEF_COMBO_INSERT_BG		BLACK
#define DEF_COMBO_INSERT_WIDTH		"2"
#define DEF_COMBO_RELIEF		"sunken"
#define DEF_COMBO_SELECT_BD_COLOR	"1"

#endif

#define DEF_COMBO_BG_MONO		WHITE
#define DEF_COMBO_BORDER_WIDTH		"2"	/* mac should be 1 */
#define DEF_COMBO_CURSOR		"xterm"
#define DEF_COMBO_EXPORT_SELECTION	"1"

#define DEF_COMBO_DISABLED_FG_COLOR	DISABLED
#define DEF_COMBO_DISABLED_FG_MONO	BLACK
#define DEF_COMBO_HIGHLIGHT_BG		NORMAL_BG

#define DEF_COMBO_INSERT_BD_COLOR	"0"
#define DEF_COMBO_INSERT_BD_MONO	"0"
#define DEF_COMBO_INSERT_OFF_TIME	"300"
#define DEF_COMBO_INSERT_ON_TIME	"600"
#define DEF_COMBO_JUSTIFY		"left"
#define DEF_COMBO_SCROLL_COMMAND	""
#define DEF_COMBO_SELECT_COLOR		SELECT_BG
#define DEF_COMBO_SELECT_MONO		BLACK
#define DEF_COMBO_SELECT_BD_MONO	"0"
#define DEF_COMBO_SELECT_FG_COLOR	SELECT_FG
#define DEF_COMBO_SELECT_FG_MONO	WHITE
#define DEF_COMBO_SHOW			(char *) NULL
#define DEF_COMBO_STATE			"normal"
#define DEF_COMBO_TAKE_FOCUS		(char *) NULL
#define DEF_COMBO_TEXT_VARIABLE		""
#define DEF_COMBO_WIDTH			"20"

#define DEF_COMBO_REPEAT_DELAY		"400"
#define DEF_COMBO_REPEAT_INTERVAL	"100"

#define DEF_COMBO_SPINCMD		"tkComboSpinCmd %W %S"
#define DEF_COMBO_DROPCMD		"tkComboDropCmd %W"

#define DEF_COMBO_SPINUP_CURSOR		""
#define DEF_COMBO_SPINDOWN_CURSOR	""
#define DEF_COMBO_COMBO_CURSOR		""

#define DEF_COMBO_FROM			"0"
#define DEF_COMBO_TO			"100.0"
#define DEF_COMBO_RESOLUTION		"1.0"
#define DEF_COMBO_DIGITS		"0"

#define DEF_COMBO_MODE			"range"

#define DEF_COMBO_LIST_VARIABLE		(char *) NULL

/***************************************************
 * Defaults for SPINBOXES:
 ***************************************************
 */
#ifdef _WIN32

#define DEF_SPINBOX_BG_COLOR		"SystemWindow"
#define DEF_SPINBOX_FONT		CTL_FONT
#define DEF_SPINBOX_FG			TEXT_FG
#define DEF_SPINBOX_HIGHLIGHT		HIGHLIGHT
#define DEF_SPINBOX_HIGHLIGHT_WIDTH	"0"
#define DEF_SPINBOX_INSERT_BG		TEXT_FG
#define DEF_SPINBOX_INSERT_WIDTH	"2"
#define DEF_SPINBOX_RELIEF		"sunken"
#define DEF_SPINBOX_SELECT_BD_COLOR	"0"

#elif defined(MAC_TCL) || defined(MAC_OSX_TK)

#define DEF_SPINBOX_BG_COLOR		NORMAL_BG
#define DEF_SPINBOX_FONT		"Helvetica 12"
#define DEF_SPINBOX_FG			BLACK
#define DEF_SPINBOX_HIGHLIGHT		BLACK
#define DEF_SPINBOX_HIGHLIGHT_WIDTH	"0"
#define DEF_SPINBOX_INSERT_BG		BLACK
#define DEF_SPINBOX_INSERT_WIDTH	"1"
#define DEF_SPINBOX_RELIEF		"solid"
#define DEF_SPINBOX_SELECT_BD_COLOR	"1"

#else /* UNIX */

#define DEF_SPINBOX_BG_COLOR		NORMAL_BG
#define DEF_SPINBOX_FONT		"Helvetica -12"
#define DEF_SPINBOX_FG			BLACK
#define DEF_SPINBOX_HIGHLIGHT		BLACK
#define DEF_SPINBOX_HIGHLIGHT_WIDTH	"1"
#define DEF_SPINBOX_INSERT_BG		BLACK
#define DEF_SPINBOX_INSERT_WIDTH	"2"
#define DEF_SPINBOX_RELIEF		"sunken"
#define DEF_SPINBOX_SELECT_BD_COLOR	"1"

#endif

#define DEF_SPINBOX_BG_MONO		WHITE
#define DEF_SPINBOX_BORDER_WIDTH	"2"	/* mac should be 1 */
#define DEF_SPINBOX_CURSOR		"xterm"
#define DEF_SPINBOX_EXPORT_SELECTION	"1"

#define DEF_SPINBOX_DISABLED_FG_COLOR	DISABLED
#define DEF_SPINBOX_DISABLED_FG_MONO	BLACK
#define DEF_SPINBOX_HIGHLIGHT_BG	NORMAL_BG
#define DEF_SPINBOX_DISABLED_BG_COLOR	NORMAL_BG
#define DEF_SPINBOX_DISABLED_BG_MONO	WHITE
#define DEF_SPINBOX_READONLY_BG_COLOR	NORMAL_BG
#define DEF_SPINBOX_READONLY_BG_MONO	WHITE

#define DEF_SPINBOX_INSERT_BD_COLOR	"0"
#define DEF_SPINBOX_INSERT_BD_MONO	"0"
#define DEF_SPINBOX_INSERT_OFF_TIME	"300"
#define DEF_SPINBOX_INSERT_ON_TIME	"600"
#define DEF_SPINBOX_JUSTIFY		"left"
#define DEF_SPINBOX_SCROLL_COMMAND	""
#define DEF_SPINBOX_SELECT_COLOR	SELECT_BG
#define DEF_SPINBOX_SELECT_MONO		BLACK
#define DEF_SPINBOX_SELECT_BD_MONO	"0"
#define DEF_SPINBOX_SELECT_FG_COLOR	SELECT_FG
#define DEF_SPINBOX_SELECT_FG_MONO	WHITE
#define DEF_SPINBOX_SELECT_DISABLED_FG_COLOR	(char *) NULL
#define DEF_SPINBOX_SELECT_DISABLED_FG_MONO	WHITE
#define DEF_SPINBOX_SHOW		(char *) NULL
#define DEF_SPINBOX_STATE		"normal"
#define DEF_SPINBOX_TAKE_FOCUS		(char *) NULL
#define DEF_SPINBOX_TEXT_VARIABLE	""
#define DEF_SPINBOX_WIDTH		"20"

#define DEF_SPINBOX_VALIDATE		"none"
#define DEF_SPINBOX_INVALIDCMD		""

#define DEF_SPINBOX_REPEAT_DELAY	"400"
#define DEF_SPINBOX_REPEAT_INTERVAL	"100"

#define DEF_SPINBOX_CMD			""
#define DEF_SPINBOX_BUTTON_CURSOR	""

#define DEF_SPINBOX_FROM		"0"
#define DEF_SPINBOX_TO			"0"
#define DEF_SPINBOX_INCREMENT		"1"
#define DEF_SPINBOX_FORMAT		""

#define DEF_SPINBOX_VALUES		""
#define DEF_SPINBOX_WRAP		"0"

#endif /* _VU_DEFAULT */
