# load.tcl
#
# Ensures that the vu library extension is loaded

set vu(library) vu[info sharedlibextension]
catch {source [file join [file dirname [info script]] .. lib dial.tcl]}
if {
    [string match {} [info commands dial]]
    && [catch {package require vu} err]
    && [catch {load [file join [pwd] src $vu(library)]} err]
    && [catch {load [file join [pwd] .. src $vu(library)]} err]
} {
    error $err
} else {
    puts "vu v[package provide vu] loaded"
}
