#include "tkgs.h"
#include "tkgsInt.h"


/*
 * Drawable Obj type
 */

static TkGS_FreeBaseProc FreeDrawable;

TkGS_BaseType TkGSDrawableBaseType = {
    "Drawable",
    sizeof(TkGS_Drawable_),
    1,				/* nbIntRep */

    FreeDrawable,		/* freeBaseProc */
    NULL			/* dupBaseProc */
				/* NULL means it can't be duplicated */
};

TkGS_BaseType *
TkGS_GetDrawableBaseType()
{
    return &TkGSDrawableBaseType;
}

static void
FreeDrawable(objPtr)
    TkGS_Obj *objPtr;
{
    register TkGS_GCValues *valuesPtr = &TkGSDrawable_GCValues(objPtr);

    /* Free the GC values */
    if (valuesPtr->foreground)	TkGS_FreeColor(valuesPtr->foreground);
    if (valuesPtr->background)	TkGS_FreeColor(valuesPtr->background);
    if (valuesPtr->font)	TkGS_FreeFont(valuesPtr->font);
}






TkGS_Drawable_ *
TkGSNewDrawable(device)
    TkGS_Device device;
{
    register TkGS_Drawable_ *dPtr = (TkGS_Drawable_ *) TkGSNewObj(&TkGSDrawableBaseType);
    register TkGS_GCValues *valuesPtr    = &TkGSDrawable_GCValues(dPtr);
    register unsigned long *valueMaskPtr = &TkGSDrawable_GCValueMask(dPtr);
#ifdef SET_DEFAULT_FONT
    TkGS_FontAttributes fa;
#endif

    TkGSDrawable_Device(dPtr) = device;

    /* FIXME: leave defaults undefined? */

    /* Default values */
    valuesPtr->background = NULL;
    valuesPtr->foreground = TkGS_GetRGBColor(0,0,0);
    valuesPtr->lineWidth  = 1;

#ifdef SET_DEFAULT_FONT
    /* Default font */
    fa.family = TkGS_GetFontFamily("Arial");
    fa.size = 0;
    fa.weight = TKGS_FW_NORMAL;
    fa.slant = TKGS_FS_ROMAN;
    fa.underline = 0;
    fa.overstrike = 0;

    valuesPtr->font = TkGS_GetFont(&fa);
#else
    valuesPtr->font = NULL;
#endif

    /* Fill the altered value mask */
    *valueMaskPtr = TkGS_GCAll;

    return dPtr;
}


