# square.tcl
#
# This is a test file for the TkGS square extension. You can edit it to
# reflect your setup

catch {console show}

# First argument sets the configuration
switch -- [lindex $argv 0] {
    fbonnet {
	set libp "../../build/tkgs/build/Debug"
#	set libp "../../build/tkgs/build/Unix_Debug"
	load [file join $libp TkGS.dll]  TkGS
	load [file join $libp Square.dll ] tkgs_square
    }
    fbonnet-x {
	load ../src/libtkgs.so TkGS
	load ./libtkgs_square.so tkgs_square
    }
    mo {
	#load libtkgs.dll
	#load libtkgs_square.dll

	load libtkgs.so
	load libtkgs_square.so
    }
}

# Create the main widget
proc createWindow {w args} {
    square $w
    pack $w
    if {[llength $args]} {
	eval $w config $args
    }
}

# Output the widget to a new canvas
proc outputCanvas {w c} {
    destroy $c
    set canvas [canvas $c -highlightthickness 0]
    pack $canvas
    eval [$w canvasscript]
}

# Output the widget to a PostScript file
proc outputPostscript {w file} {
    set f [open $file w]
    puts $f [$w postscript]
    close $f
}


puts "available commands:
  createWindow window
    create a TkGSSquare window

  outputCanvas window canvas
    create a canvas, pack it and output the 
    content of the window

  outputPostscript window file
    output the content of the window to a file
"

createWindow .s -bg black
