#
#	$Id: select.tcl,v 1.2 2001/02/27 06:52:38 ioilam Exp $
#
proc About {} {
    return "Testing the TixSelect widget"
}

proc Test {} {

    # Create with a normal state
    #
    #
    tixSelect .foo -allowzero 0 -radio 1 -label "Foo:" \
	-state normal
    .foo add "1" -text "One"
    .foo add "2" -text "Two"
    pack .foo

    set dis  [tixGetDefault DISABLED]
    set norm [.foo subwidget label cget -foreground]

    Assert {[.foo subwidget label cget -foreground] == $norm}
    .foo config -state normal
    .foo config -state normal
    Assert {[.foo subwidget label cget -foreground] == $norm}
    .foo config -state disabled
    Assert {[.foo subwidget label cget -foreground] == $dis}
    .foo config -state normal
    Assert {[.foo subwidget label cget -foreground] == $norm}

    update
    destroy .foo

    tixSelect .foo -allowzero 0 -radio 1 -label "Foo:" \
	-state disabled
    .foo add "1" -text "One"
    .foo add "2" -text "Two"
    pack .foo

    Assert {[.foo subwidget label cget -foreground] == $dis}
    .foo config -state normal
    Assert {[.foo subwidget label cget -foreground] == $norm}
    .foo config -state normal
    Assert {[.foo subwidget label cget -foreground] == $norm}
    .foo config -state disabled
    Assert {[.foo subwidget label cget -foreground] == $dis}
    .foo config -state normal
    Assert {[.foo subwidget label cget -foreground] == $norm}
}
