'\"
'\" $Id: tixStdButtonBox.n,v 1.2 2001/02/09 06:32:29 ioilam Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'\"----------------------------------------------------------------------
.TH tixStdButtonBox n 4.0 Tix "Tix Built-In Commands"
.BS
'\"
'\"
'\"----------------------------------------------------------------------
.SH NAME
tixStdButtonBox \- Create and manipulate Tix StdButtonBox widgets
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixStdButtonBox \fIpathName \fR?\fIoptions\fR?
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SO
\-anchor	\-background	\-cursor
\-relief	\-borderWidth
.SE
'\"
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'\"
'\"
'\"----------BEGIN
.OP -orientation orientation Orientation
\fBStatic Option\fR. Specifies the orientation of the button
subwidgets. Only the values "horizontal" and "vertical" are recognized.
'\"----------END
'\"
'\"----------BEGIN
.OP \-padx padx Pad
Specifies the horizontal padding between two neighboring button
subwidgets in the StdButtonBox widget.
'\"----------END

'\"----------BEGIN
.OP \-padx padx Pad
Specifies the vertical padding between two neighboring button
subwidgets in the StdButtonBox widget.
'\"----------END
'\"
'\"----------BEGIN
.OP \-state state State
Specifies the state of all the buttons inside the StdButtonBox widget.

\fINote\fR:
Setting this option using the \fIconfig\fR widget command will enable
or disable all the buttons subwidgets. Original states of the
individual buttons are \fInot\fR saved.
'\"----------END
'\"
'\"----------------------------------------------------------------------
.SH SUBWIDGETS
.PP
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBok\fR
Class:		\fBButton\fR
.fi
.IP
The first button subwidget. By default it displays the text string "Ok"
'\"----------END
'\"
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBapply\fR
Class:		\fBButton\fR
.fi
.IP
The second button subwidget. By default it displays the text string "Apply"
'\"----------END
'\"
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBcancel\fR
Class:		\fBButton\fR
.fi
.IP
The third button subwidget. By default it displays the text string "Cancel"
'\"----------END
'\"
'\"
'\"----------BEGIN
.LP
.nf
Name:		\fBhelp\fR
Class:		\fBButton\fR
.fi
.IP
The fourth button subwidget. By default it displays the text string "Help"
'\"----------END
'\"
'\"
'\"----------------------------------------------------------------------
.SH DESCRIPTION
'\"
.PP
'\"
The \fBtixStdButtonBox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a StdButtonBox widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the StdButtonBox
such as its cursor and relief.
'\"
.PP
The StdButtonBox widget is a group of Standard buttons for Motif-like
dialog boxes.

'\"
'\"
'\"----------------------------------------------------------------------
.SH "WIDGET COMMAND"
.PP
'\"
The \fBtixStdButtonBox\fR command creates a new Tcl command whose name is
the same as the path name of the StdButtonBox's window. This command may
be used to invoke various operations on the widget. It has the
following general form:
'\"
.RS
.CS
'\"
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
.RE
'\"
\fIPathName\fR is the name of the command, which is the same as
the StdButtonBox widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for StdButtonBox widgets:
'\"
.TP
\fIpathName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixStdButtonBox\fR command.
'\"
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list). If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may have
any of the values accepted by the \fBtixStdButtonBox\fR command.
'\"
'\"
.TP
\fIpathName \fBinvoke \fIbuttonName\fR
'\"
Invoke the button subwidget with the name \fIbuttonName\fR.
'\"
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'\"
When no additional arguments are given, returns the pathname of the
subwidget of the specified name.
.PP
When no additional arguments are given, the widget command of the
specified subwidget will be called with these parameters.
'\"
'\"----------------------------------------------------------------------
.SH BINDINGS
.PP
TixStdButtonBox widgets have no default bindings. The button subwidgets
retain their default Tk bindings.
'\"
'\"
'\"
'\"
'\"----------------------------------------------------------------------
.SH KEYWORDS
container, button box, widget



