/*****************************************************************************
 *
 *  File: main.c
 *  Package library loader/initialisation code.
 *
 *****************************************************************************
 *
 *  Copyright (c) 2000 David Cuthbert / Kanga International Group.
 *  All rights reserved.
 *
 *  Permission to use, copy, modify, distribute and sell this software
 *  and its documentation for any purpose is hereby granted without fee,
 *  provided that the above copyright notice appear in all copies and
 *  that both that copyright notice and this permission notice appear
 *  in supporting documentation.  The author(s) make no representations
 *  about the suitability of this software for any purpose.  It is 
 *  provided "as is" without express or implied warranty.
 *
 *****************************************************************************/


#include "tcl.h"
#include "kt2c.h"
#include "kt2c_platform.h"

dllexport int Kt2c_Init(Tcl_Interp *interp)
{
    Tcl_CreateObjCommand(interp, "::kt2c::Translate", Kanga_Bytecode2C, 0, 0);
    Tcl_CreateObjCommand(interp, "::kt2c::CpuTime", Kanga_CpuTime, 0, 0);
    Tcl_PkgProvide(interp, "kt2c", "0.2");
    return 0;
}

