# public access on toplevel class or interface

tcltest::test 6.6.1-1 {A class declared public is accessible from outside the package} {
    saveas AccessPublicClassInPackage.java \
{
public class AccessPublicClassInPackage {
    pkg.PublicClass ref;
}
}

    saveas pkg/PublicClass.java \
{
package pkg;

public class PublicClass {}
}

    compile AccessPublicClassInPackage.java pkg/PublicClass.java
} PASS

tcltest::test 6.6.1-2 {A class declared public is accessible from outside the package
        when the .java source is loaded from the CLASSPATH} {
    delete pkg/PublicClass.class
    saveas AccessPublicClassInPackage.java \
{
public class AccessPublicClassInPackage {
    pkg.PublicClass ref;
}
}

    compile -classpath . AccessPublicClassInPackage.java
} PASS

tcltest::test 6.6.1-3 {An class declared public is accessible from outside the package
        when the .class file is loaded from the CLASSPATH} {
    saveas AccessPublicClassInPackage.java \
{
public class AccessPublicClassInPackage {
    pkg.PublicClass ref;
}
}

    saveas pkg/PublicClass.java \
{
package pkg;

public class PublicClass {}
}

    list \
        [compile pkg/PublicClass.java] \
        [compile -classpath . AccessPublicClassInPackage.java]
} {PASS PASS}

tcltest::test 6.6.1-4 {An interface declared public is accessible from outside the package} {
    saveas AccessPublicInterfaceInPackage.java \
{
public class AccessPublicInterfaceInPackage {
    pkg.PublicInterface ref;
}
}

    saveas pkg/PublicInterface.java \
{
package pkg;

public interface PublicInterface {}
}

    compile AccessPublicInterfaceInPackage.java pkg/PublicInterface.java
} PASS

tcltest::test 6.6.1-5 {An interface declared public is accessible from outside the package
        when the .java source is loaded from the CLASSPATH} {
    delete pkg/PublicInterface.class
    compile -classpath . AccessPublicInterfaceInPackage.java
} PASS

tcltest::test 6.6.1-6 {An interface declared public is accessible from outside the package
        when the .class file is loaded from the CLASSPATH} {
    delete pkg/PublicInterface.class
    list \
        [compile pkg/PublicInterface.java] \
        [compile -classpath . AccessPublicInterfaceInPackage.java]
} {PASS PASS}

tcltest::test 6.6.1-7 {Access a public class from inside the package} {
    saveas pkg/AccessPublicClass.java \
{
package pkg;

public class AccessPublicClass {
    PublicClass ref;
}
}

    compile pkg/AccessPublicClass.java pkg/PublicClass.java
} PASS


# Default access on toplevel class or interface

tcltest::test 6.6.1-8 {A class declared with default access is inaccessible from outside the package} {
    saveas AccessDefaultClassInPackage.java \
{
public class AccessDefaultClassInPackage {
    pkg.DefaultClass ref;
}
}

    saveas pkg/DefaultClass.java \
{
package pkg;

class DefaultClass {}
}

    compile AccessDefaultClassInPackage.java pkg/DefaultClass.java
} FAIL

tcltest::test 6.6.1-9 {A class declared with default access is inaccessible
        from outside the package when the .java source is loaded from the CLASSPATH} {
    delete pkg/DefaultClass.class
    compile -classpath . AccessDefaultClassInPackage.java
} FAIL

tcltest::test 6.6.1-10 {A class declared with default access is inaccessible
        from outside the package when the .class file is loaded from the CLASSPATH} {
    delete pkg/DefaultClass.class
    list \
        [compile pkg/DefaultClass.java] \
        [compile -classpath . AccessDefaultClassInPackage.java]
} {PASS FAIL}

tcltest::test 6.6.1-11 {An interface declared with default access is inaccessible
        from outside the package} {
    saveas AccessDefaultInterfaceInPackage.java \
{
public class AccessDefaultInterfaceInPackage {
    pkg.DefaultInterface ref;
}
}

    saveas pkg/DefaultInterface.java \
{
package pkg;

interface DefaultInterface {}
}

    compile AccessDefaultInterfaceInPackage.java pkg/DefaultInterface.java
} FAIL

tcltest::test 6.6.1-12 {An interface declared with default access is inaccessible from
        outside the package when the .java source is loaded from the CLASSPATH} {
    delete pkg/DefaultInterface.class
    compile -classpath . AccessDefaultInterfaceInPackage.java
} FAIL

tcltest::test 6.6.1-13 {An interface declared with default access is inaccessible from
        outside the package when the .class file is loaded from the CLASSPATH} {
    delete pkg/DefaultInterface.class
    list \
        [compile pkg/DefaultInterface.java] \
        [compile -classpath . AccessDefaultInterfaceInPackage.java]
} {PASS FAIL}

tcltest::test 6.6.1-14 {Access a default class from inside the package} {
    saveas pkg/AccessDefaultClass.java \
{
package pkg;

public class AccessDefaultClass {
    DefaultClass ref;
}
}

    compile pkg/AccessDefaultClass.java pkg/DefaultClass.java
} PASS

# protected access should be covered in section 6.6.2
