# See related sections: 14.10 and 4.5.3

tcltest::test 16.2.8-final-1 { A blank final may be assigned in different block
        statement groups, provided it not assigned twice } {
    switch_labels T1628f1 int {
            case 0:
                final byte b = 0;
                break;
            case 1:
                b = 1;
    }
} PASS

tcltest::test 16.2.8-final-2 { A final may be assigned in different block
        statement groups, provided it not assigned twice } {
    switch_labels T1628f2 int {
            case 0:
                final int b;
                b = 0;
                break;
            case 1:
                b = 1;
    }
} PASS

tcltest::test 16.2.8-final-3 { A final may be assigned in different block
        statement groups, provided it not assigned twice. The variable
        is assigned if the case block falls through after an assignment } {
    switch_labels T1628f3 int {
            case 0:
                final byte b = 0;
                break;
            case 1:
                b = 1;
            case 2:
                byte c = b;
    }
} PASS



tcltest::test 16.2.8-unassigned-1 { A variable must have been assigned
        in each switch block if it is going to be accessed } {

    switch_labels T1628u1 int {
            case 0:
                byte b = 0;
                break;
            default:
                b++;
    }
} FAIL

tcltest::test 16.2.8-unassigned-2 { A variable that is not definitely assigned
        before entering the switch must be definitely assigned in each switch
        block if it is to be definitely assigned after the switch block } {

    compile [saveas T1628u2.java {
class T1628u2 {
    void foo(int i) {
        int j;
        switch (i) {
            case 0: j = 0; break;
            case 1: j = 1; break;
            default: j = 2; break;
        }
        j++;
    }
}
    }]
} PASS

tcltest::test 16.2.8-unassigned-3 { A variable that is not definitely assigned
        before entering the switch must be definitely assigned in each switch
        block if it is to be definitely assigned after the switch block } {

    compile [saveas T1628u3.java {
class T1628u3 {
    void foo(int i) {
        int j;
        switch (i) {
            case 0: j = 0; break;
            case 1: break;
            default: j = 2; break;
        }
        j++;
    }
}
    }]
} FAIL

tcltest::test 16.2.8-unassigned-4 { A variable that is not definitely assigned
        before entering the switch must be definitely assigned in each switch
        block (including the default block) if it is to be definitely assigned
        after the switch block } {

    compile [saveas T1628u4.java {
class T1628u4 {
    void foo(int i) {
        int j;
        switch (i) {
            case 0: j = 0; break;
            case 1: j = 0; break;
        }
        j++;
    }
}
    }]
} FAIL

tcltest::test 16.2.8-unassigned-5 { Switch blocks that fall through to default:
        that definitely assigns a variable ensures that the variable is
        definitely assigned after the switch } {

    compile [saveas T1628u5.java {
class T1628u5 {
    void foo(int i) {
        int j;
        switch (i) {
            case 0:
            case 1:
            default: j = 0;
        }
        j++;
    }
}
    }]
} PASS

tcltest::test 16.2.8-unassigned-6 { A final local variable within a
        switch statement can't be used in a switch label, since
        it must be treated as a blank final in each switch block } {
    switch_labels T1628u6 int {
            case 0:
                final byte b = 1;
                break;
            case b:
    }
} FAIL

tcltest::test 16.2.8-unassigned-7 { A final local variable scoped to the
        switch statement can't be used as a case label because it is
        unassigned when the switch statement is entered. This test
        might incorrectly pass if the compiler returns FAIL because
        of the second assignment to b. } {
    switch_labels T1628u7 int {
            case 0:
                final byte b = 1;
                break;
            case b:
                b = 0;
    }
} FAIL
