/*
 * e4xmloutputstream.cpp --
 *
 *	This file contains the implementation of the e4_XMLOutputStream
 *	class defined in e4xml.h.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 *	Copyright: JYL Software, Inc., (c) 2000-2003.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "e4xml.h"

/*
 ***************************************************************************
 *                                                                         *
 * Implementation of e4_XMLOutputStream class:                             *
 *                                                                         *
 ***************************************************************************
 */

/*
 * Default constructor. Does nothing.
 */

e4_XMLOutputStream::e4_XMLOutputStream()
{
}

/*
 * Destructor, defined virtual for proper subclassing destruction.
 */

e4_XMLOutputStream::~e4_XMLOutputStream()
{
}

/*
 * Accept a pointer to character data and append to the generating buffer of
 * xml output.
 */

e4_XMLOutputStream &
e4_XMLOutputStream::operator<< (const char *s)
{
    if ((s != NULL) && (*s != '\0')) { // there is something to append...
	ds.Append(s,-1);
    }

    return *this;
}

/*
 * Append a character to the generating buffer of xml output.
 */

e4_XMLOutputStream &
e4_XMLOutputStream::operator<< (char c)
{
    ds.Append(&c,1);
    return *this;
}

/*
 * Append an unsigned char to the generating buffer of xml output. The default
 * action is to represent the byte as a 2 digit hex string in the output.
 */

e4_XMLOutputStream &
e4_XMLOutputStream::operator<< (unsigned char uc)
{
    char num[3];

    sprintf(num, "%02x", uc);
    ds.Append(num, 2);
    return *this;
}

/*
 * Append an integer character string to the generating buffer of xml output.
 */

e4_XMLOutputStream &
e4_XMLOutputStream::operator<< (int val)
{
    char buf[32];

    sprintf(buf, "%d", val);
    ds.Append(buf, -1);

    return *this;
}

/*
 * Append a double numeric string to the generating buffer of xml output.
 */
e4_XMLOutputStream &
e4_XMLOutputStream::operator<< (double dval)
{
    char buf[32];

    sprintf(buf, "%e", dval);
    ds.Append(buf, -1);

    return *this;
}

/*
 * Reset internal state.
 */

void
e4_XMLOutputStream::Reset()
{
    ds.Reset();
}

/*
 * Return a pointer to a buffer containing the accumulated xml output.
 * If the stream cannot be accessed as a char pointer (ie: the stream
 * was redirected to a file by your subclass), this method should
 * return NULL.
 */

char *
e4_XMLOutputStream::Get()
{
   return ds.Get();
}
