###########################################################################
#                                                                         #
# Initialize the global data for the tged package.			  #
#                                                                         #
# This file is part of the tged package.                                  #
#                                                                         #
###########################################################################

# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# This file initializes the data used by the tged package, in the data
# array. The data is organized into groups of related items:
#
# gd,*				mutable global data
# gc,*				immutable global data
# i,$tgedInstance,*		mutable data for that instance
# c,$tgedInstance,*		immutable data for that instance

proc ::tged::init {} {
    variable data

    # Do only once:

    if {![info exists data(gd,initialized)]} {
	set data(gd,initialized) 1

	# Counter for creating new top-level windows:

	set data(gd,toplevelCounter) 0

	# Create all named fonts. If the named fonts already exist it will
	# throw an error, hence the catch.

	catch {createNamedFonts}

	# Create bindings for the tree part of tged:

	createTreeEditBindings

	# Create bindings for the value part of tged:

	createValueEditBindings
	createValueNoEditBindings

	# Create binding masks for value editing.

	createValueEditMasks

	# Create the vertex type indices used later for
	# translating from a combo box index to a vertex type

	createVertexTypeChoices
    }
}

# Re-initialize the tged package.
#
# WARNING: THIS DISCARDS ANY EXISTING STATE ASSOCIATED WITH TGED!!!!!!

proc ::tged::reinit {} {
    variable data

    catch {unset data}
    init
    return ""
}
