/*
 * t4version.cpp --
 *
 *	Implementation of the the "::tgraph::version" command.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "t4graphrep.h"

/*
 * T4Graph_VersionProc --
 *
 *	This procedure is called when "tgraph::version" is invoked.
 *	Syntax:
 *		tgraph::version
 *	--OR--	tgraph::version fname
 *
 * Results:
 *	A standard Tcl result. In the first form, it returns the version
 *	of the tgraph currently running. In the second form, it returns
 *	the version of tgraph that was used to write the named storage.
 *
 * Side effects:
 *	None.
 */

int
T4Graph_VersionProc(ClientData cd,
		    Tcl_Interp *interp,
		    int objc,
		    Tcl_Obj *CONST objv[])
{
    const char *v;

    if ((objc != 1) && (objc != 2)) {
	Tcl_WrongNumArgs(interp, 0, NULL,
			 (char *) "tgraph::version ?fname?");
	return TCL_ERROR;
    }

    if (objc == 1) {
	Tcl_SetStringObj(Tcl_GetObjResult(interp),
			 (char *) e4_Storage::version(),
			 -1);
	return TCL_OK;
    }

    v = e4_Storage::storage_version(Tcl_GetString(objv[1]), E4_METAKIT);
    if (v == NULL) {
	Tcl_AppendResult(interp,
			 "Could not get version info from \"",
			 objv[1],
			 "\"",
			 NULL);
	return TCL_ERROR;
    }
    Tcl_SetStringObj(Tcl_GetObjResult(interp), (char *) v, -1);
    return TCL_OK;
}


