import unittest
import e4py
import sys


DB_NAME = 'temp.db'


class InvalidStorageTest(unittest.TestCase):

	def testEmpty(self):
		s = e4py.Storage()
		self.failIf(s.valid)
		s = None
		
	def testBadEngine(self):
		s = e4py.Storage(DB_NAME, 'unknown-engine')
		self.failIf(s.valid)
		s = None


class StorageTest(unittest.TestCase):

	def setUp(self):
		self.storage = e4py.Storage(DB_NAME)
		
	def testDefaultRoot(self):
		s = self.storage
		self.assert_(s.root.valid)
		
	def testEmptyRoot(self):
		s = self.storage
		self.assert_(s.root.VertexCount() == 0)
		
	def testNewRoot(self):
		s = self.storage
		r = s.root
		n = s.CreateDetachedNode()
		self.failIf(n.isRoot)
		s.root = n
		self.failIf(r.isRoot)
		
	def testStable(self):
		s = self.storage
		s.root = s.CreateDetachedNode()
		self.failIf(s.stable)
	
	def testStableMarking(self):
		s = self.storage
		self.assert_(s.stable)
		s.MarkUnstable()
		self.failIf(s.stable)
	
	def testCopyTo(self):
		s = self.storage
		s.root['foo'] = 'bar'
		self.assert_(s.root['foo'] == 'bar')
		s1 = e4py.Storage(s.name + '.copy')
		s.CopyTo(s1, 1)
		self.assert_(s1.root['foo'] == s.root['foo'])
		try:		#delete storage, ignore if none exists
			s1.Delete()
		except:
			pass
		
	def tearDown(self):
		try:		#delete storage, ignore if none exists
			self.storage.Delete()
		except:
			pass
		self.storage = None


def makeTestSuite():
	classes = (InvalidStorageTest, StorageTest)
	suites = []
	for c in classes:
		suites.append(unittest.makeSuite(c,'test'))
	return unittest.TestSuite(suites)


if __name__=='__main__':
	runner = unittest.TextTestRunner(stream=sys.stdout)
	unittest.main(defaultTest='makeTestSuite', testRunner=runner)

