/*
 * com.e4graph.Value.java:
 *
 *	Defines a wrapper class that can contain the value of any
 *	vertex; useful for retrieving the value of a vertex without
 *	having to know its type ahead of time.
 *
 *	Valid value types are defined in Vertex.java.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.e4graph;

public final class Value
{
    /*
     * Selects which field contains the actual value:
     */

    /**
     * This field contains one of the constants defined in class Vertex
     * denoting the various possible types of vertex values.
     */
    public int type;

    /**
     * This field contains an integer value if the type field is INTEGER.
     */
    public int integerValue;

    /*
     * This field is used if the type is Vertex.DOUBLE:
     */

    /**
     * This field contains a double (64 bit floating point) value if the
     * type field is DOUBLE.
     */
    public double doubleValue;

    /**
     * This field contains a String if the type field is STRING.
     */
    public String stringValue;

    /**
     * This field contains a binary value if the type field is BYTES.
     */
    public byte [] bytesValue;

    /**
     * This field contains a Node value if the type field is NODE.
     */
    public Node nodeValue;
}
