/**
 * com.e4graph.ParentIterator:
 *
 *	This file contains the Java implementation of a class to iterate over
 *	the parent nodes of e4Graph node objects.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.e4graph;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ParentIterator implements Iterator
{
    /*
     * State variables.
     */

    private Node parent = null;
    private Node node = null;
    private int index = -1;

    /**
     * Constructor that creates an iterator that visits every parent of
     * the given node.
     */

    public ParentIterator(Node n) {
	node = n;
	try {
	    parent = node.parent();
	} catch (NoSuchNodeException e) {
	    parent = null;
	}
    }

    /**
     * Remove method -- always throws UnsupportedOperationException.
     */
    public void remove()
	throws UnsupportedOperationException
    {
	throw new UnsupportedOperationException("remove() not supported");
    }

    /**
     * Does this iterator have a next element?
     */
    public boolean hasNext() {
	if (parent == null) {
	    return false;
	}
	if (index < node.parentCount()) {
	    return true;
	}
	return false;
    }

    /**
     * Get the next parent.
     */

    public Object next()
	throws NoSuchElementException
    {
	if (parent == null) {
	    throw new NoSuchElementException("node has no parents");
	}
	if (index < node.parentCount()) {
	    index++;
	    try {
		parent = node.parent(index);
	    } catch (NoSuchNodeException e) {
		throw new NoSuchElementException("no next parent");
	    }
	    return parent;
	}
	throw new NoSuchElementException("no next parent");
    }
}
